/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.archivedfiles;

import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.download.DownloadStub;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellLightRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.utils.TableColumnSWTUtils;

public class SizeItem
extends CoreTableColumnSWT
implements TableCellLightRefreshListener {
    public SizeItem(String tableID) {
        super("size", 2, -2, 70, tableID);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"bytes"});
        info.setProficiency((byte)0);
    }

    @Override
    public void refresh(TableCell cell, boolean sortOnlyRefresh) {
        DownloadStub.DownloadStubFile fileInfo2 = (DownloadStub.DownloadStubFile)cell.getDataSource();
        long size = fileInfo2 == null ? 0L : fileInfo2.getLength();
        if (!cell.setSortValue(size) && cell.isValid()) {
            return;
        }
        if (size < 0L) {
            cell.setText("(" + DisplayFormatters.formatByteCountToKiBEtc(-size) + ")");
        } else {
            cell.setText(DisplayFormatters.formatByteCountToKiBEtc(size));
        }
        TableColumnSWTUtils.setSizeAlpha(cell, size);
    }

    @Override
    public void refresh(TableCell cell) {
        this.refresh(cell, false);
    }
}

