/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.archivedfiles;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.download.DownloadStub;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellLightRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.debug.ObfuscateCellText;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import java.io.File;

public class NameItem
extends CoreTableColumnSWT
implements TableCellLightRefreshListener,
ObfuscateCellText {
    private final ParameterListener configShowFullPathListener = new ParameterListener(){

        @Override
        public void parameterChanged(String parameterName) {
            NameItem.this.show_full_path = COConfigurationManager.getBooleanParameter("ArchivedFilesView.show.full.path");
        }
    };
    private boolean show_full_path;

    public NameItem(String tableID) {
        super("name", 1, -2, 400, tableID);
        COConfigurationManager.addWeakParameterListener(this.configShowFullPathListener, true, "ArchivedFilesView.show.full.path");
        this.setType(1);
    }

    @Override
    public void remove() {
        super.remove();
        COConfigurationManager.removeWeakParameterListener(this.configShowFullPathListener, "ArchivedFilesView.show.full.path");
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)0);
    }

    @Override
    public void refresh(TableCell cell, boolean sortOnlyRefresh) {
        String name;
        DownloadStub.DownloadStubFile fileInfo2 = (DownloadStub.DownloadStubFile)cell.getDataSource();
        if (fileInfo2 == null) {
            name = "";
        } else {
            File f = fileInfo2.getFile();
            name = this.show_full_path ? f.getAbsolutePath() : f.getName();
        }
        cell.setText(name);
    }

    @Override
    public void refresh(TableCell cell) {
        this.refresh(cell, false);
    }

    @Override
    public String getObfuscatedText(TableCell cell) {
        DownloadStub.DownloadStubFile fileInfo2 = (DownloadStub.DownloadStubFile)cell.getDataSource();
        String name = fileInfo2 == null ? "" : Debug.secretFileName(fileInfo2.getFile().getName());
        return name;
    }
}

