/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagUtils;
import com.biglybt.core.tag.Taggable;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellAddedListener;
import com.biglybt.pif.ui.tables.TableCellMenuEvent;
import com.biglybt.pif.ui.tables.TableCellMenuListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableCellToolTipListener;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.utils.FontUtils;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import com.biglybt.ui.swt.views.utils.TagUIUtils;
import com.biglybt.ui.swt.widgets.TagPainter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public interface TagsColumnHelper
extends TableCellRefreshListener,
TableCellToolTipListener,
TableCellSWTPaintListener,
TableCellAddedListener,
TableCellMenuListener {
    public static final Font[] fontOneLine = new Font[1];
    public static final Font[] fontMultiLine = new Font[1];

    public List<Tag> getTags(TableCell var1);

    @Override
    default public void cellAdded(TableCell cell) {
        cell.setMarginHeight(1);
        cell.setMarginHeight(1);
    }

    @Override
    default public void refresh(TableCell cell) {
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        try {
            List<Tag> tags = this.getTags(cell);
            if (tags.isEmpty()) {
                return;
            }
            tags = TagUtils.sortTags(tags);
            for (Tag tag : tags) {
                if (sb1.length() > 0) {
                    sb1.append(",");
                }
                sb1.append(tag.getTagName(true));
                sb2.append(tag.getTagUID());
            }
        }
        finally {
            cell.setTextEquivalent(sb1.toString());
            sb1.append(",");
            sb1.append((CharSequence)sb2);
            cell.setSortValue((Comparable)((Object)sb1.toString()));
        }
    }

    @Override
    default public void menuEventOccurred(TableCellMenuEvent e) {
        Object data;
        TableCell _cell = e.cell;
        if (!(_cell instanceof TableCellSWT)) {
            return;
        }
        TableCellSWT cell = (TableCellSWT)_cell;
        List layouts = (List)cell.getData(TagsColumnHelper.class);
        if (layouts == null) {
            return;
        }
        Object ev = e.baseEvent;
        if (ev instanceof MenuDetectEvent && (data = ((MenuDetectEvent)ev).getSource()) instanceof Control) {
            Point pt = new Point(e.x, e.y);
            Tag target = null;
            for (TagLayout entry : layouts) {
                if (!entry.clip.contains(pt)) continue;
                target = entry.painter.getTag();
                break;
            }
            if (target != null) {
                final Menu menu = new Menu((Control)data);
                menu.addMenuListener((MenuListener)new MenuAdapter(){

                    public void menuHidden(MenuEvent e) {
                        Utils.execSWTThreadLater(100, () -> menu.dispose());
                    }
                });
                MenuItem mi = new MenuItem(menu, 8);
                mi.setText(String.valueOf(MessageText.getString("label.tag")) + ": " + target.getTagName(true));
                mi.setEnabled(false);
                new MenuItem(menu, 2);
                TagUIUtils.createSideBarMenuItems(menu, target);
                menu.setVisible(true);
                e.skipCoreFunctionality = true;
            }
        }
    }

    @Override
    default public void cellHover(TableCell cell) {
        List<Tag> tags = this.getTags(cell);
        tags = TagUtils.sortTags(tags);
        String group = null;
        boolean firstInGroup = true;
        StringBuilder sb = new StringBuilder();
        for (Tag tag : tags) {
            String newGroup = tag.getGroup();
            if (!Objects.equals(group, newGroup)) {
                group = newGroup;
                if (sb.length() > 0) {
                    sb.append('\n');
                    if (group == null) {
                        sb.append('\n');
                    }
                }
                if (group != null) {
                    sb.append(group).append(": ");
                }
                firstInGroup = true;
            }
            if (firstInGroup) {
                firstInGroup = false;
            } else {
                sb.append(", ");
            }
            sb.append(tag.getTagName(true));
        }
        cell.setToolTip(sb.toString());
    }

    @Override
    default public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    default public void cellPaint(GC gc, TableCellSWT cell) {
        ds = PluginCoreUtils.convert(cell.getDataSource(), true);
        taggable = ds instanceof Taggable != false ? (Taggable)ds : null;
        cellSize = cell.getSize();
        bounds = cell.getBounds();
        cellSize.x -= 3;
        ++bounds.x;
        oldFont = gc.getFont();
        maxCellLines = cell.getMaxLines();
        if (maxCellLines <= 1) {
            if (TagsColumnHelper.fontOneLine[0] == null) {
                TagsColumnHelper.fontOneLine[0] = FontUtils.getFontWithHeight(oldFont, FontUtils.getFontHeightInPX(oldFont) - 2, -1);
            }
            gc.setFont(TagsColumnHelper.fontOneLine[0]);
        } else {
            if (TagsColumnHelper.fontMultiLine[0] == null) {
                TagsColumnHelper.fontMultiLine[0] = FontUtils.getFontWithHeight(gc.getFont(), (cellSize.y - 2) / maxCellLines, -1);
            }
            gc.setFont(TagsColumnHelper.fontMultiLine[0]);
        }
        tags = this.getTags(cell);
        tags = TagUtils.sortTags(tags);
        x = 0;
        y = 0;
        lineHeight = 0;
        layouts = new ArrayList<Object>(tags.size());
        cell.setData(TagsColumnHelper.class, layouts);
        try {
            maxLines = 1;
            for (Tag tag : tags) {
                painter = new TagPainter(tag);
                painter.setCompact(true, false);
                painter.alwaysDrawBorder = true;
                painter.paddingContentY = 1;
                painter.paddingContentX0 = 2;
                painter.paddingContentX1 = 4;
                painter.setMinWidth(16);
                size = painter.getSize(gc);
                if (size == null || size.x == 0 || size.y == 0) {
                    painter.dispose();
                    continue;
                }
                layout = new TagLayout();
                layouts.add(layout);
                layout.painter = painter;
                layout.clip = new Rectangle(-1, -1, size.x, size.y);
                endX = x + size.x;
                if (endX >= cellSize.x) {
                    if (x == 0) {
                        lineHeight = size.y;
                    } else {
                        if ((y += lineHeight + 1) + size.y > cellSize.y) {
                            layout.truncated = true;
                            break;
                        }
                        ++maxLines;
                        lineHeight = size.y;
                    }
                    x = size.x + 1;
                    continue;
                }
                lineHeight = Math.max(lineHeight, size.y);
                x = endX + 1;
            }
            x = 0;
            y = 0;
            lineHeight = 0;
            lineNumber = 1;
            forceNextLine = false;
            prevLayout = null;
            for (TagLayout layout : layouts) {
                clip = layout.clip;
                endX = x + clip.width;
                if (endX >= cellSize.x || forceNextLine) {
                    if (!(x != 0 && lineNumber != maxLines || forceNextLine)) {
                        lineHeight = Math.max(lineHeight, clip.height);
                        if (lineNumber < maxLines) {
                            forceNextLine = true;
                        }
                    } else {
                        forceNextLine = false;
                        if (++lineNumber > maxLines) break;
                        y += lineHeight + 1;
                        x = 0;
                        endX = clip.width;
                        lineHeight = clip.height;
                    }
                } else {
                    lineHeight = Math.max(lineHeight, clip.height);
                }
                clipW = endX > cellSize.x ? cellSize.x - x : clip.width;
                v0 = clipH = y + clip.height > cellSize.y ? cellSize.y - y : clip.height;
                if (x > 0 && clipW < clip.width) {
                    layout.truncated = true;
                    if (prevLayout != null && clipW < 5) {
                        prevLayout.truncated = true;
                    }
                }
                clip.x = bounds.x + x;
                clip.y = bounds.y + y;
                clip.width = clipW;
                clip.height = clipH;
                x = endX + 1;
                prevLayout = layout;
            }
            clipping = gc.getClipping();
            try {
                endY = y + lineHeight;
                yOfs = (cellSize.y - endY) / 2;
                if (yOfs < 0) {
                    yOfs = 0;
                }
                for (TagLayout layout : layouts) {
                    clip = layout.clip;
                    painter = layout.painter;
                    clip.y += yOfs;
                    gc.setClipping(clip);
                    if (layout.truncated) {
                        painter.setAlpha(100);
                    }
                    painter.paint(taggable, gc, clip.x, clip.y);
                }
            }
            catch (Throwable var25_34) {
                gc.setClipping(clipping);
                throw var25_34;
            }
            gc.setClipping(clipping);
        }
        finally {
            gc.setFont(oldFont);
            ** for (layout : layouts)
        }
lbl-1000:
        // 1 sources

        {
            if (layout.painter == null) continue;
            layout.painter.dispose();
            continue;
        }
lbl124:
        // 1 sources

    }

    public static class TagLayout {
        TagPainter painter;
        Rectangle clip;
        boolean truncated;
    }
}

