/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.table.painted;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableStructureEventDispatcher;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import com.biglybt.ui.swt.utils.DragDropUtils;
import com.biglybt.ui.swt.utils.FontUtils;
import com.biglybt.ui.swt.views.table.impl.TableTooltips;
import com.biglybt.ui.swt.views.table.painted.TablePaintedUtils;
import com.biglybt.ui.swt.views.table.painted.TableViewPainted;
import java.util.Arrays;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;

public class TableHeaderPainted
implements ParameterListener {
    private static final int DEFAULT_HEADER_HEIGHT = 27;
    private static boolean gradientHeader;
    private final TableViewPainted tv;
    private final Canvas cHeaderArea;
    private int headerHeight;
    private TableColumnCore draggingHeader;
    private TableColumnCore droppingOnHeader;
    private boolean droppingAfterHeader = false;
    private Font fontHeaderSmall;
    private Font fontHeader;

    static {
        COConfigurationManager.addAndFireParameterListener("Table Header Gradient Fill", n -> {
            gradientHeader = COConfigurationManager.getBooleanParameter("Table Header Gradient Fill");
        });
    }

    public TableHeaderPainted(TableViewPainted tv, Canvas cHeaderArea) {
        Object layoutData;
        this.tv = tv;
        this.cHeaderArea = cHeaderArea;
        if (cHeaderArea.isDisposed()) {
            return;
        }
        this.fontHeader = FontUtils.cache(FontUtils.getFontPercentOf(cHeaderArea.getFont(), 0.9f));
        this.fontHeaderSmall = FontUtils.cache(FontUtils.getFontPercentOf(this.fontHeader, 0.8f));
        cHeaderArea.setFont(this.fontHeader);
        COConfigurationManager.addParameterListener("Table.headerHeight", (ParameterListener)this);
        this.headerHeight = COConfigurationManager.getIntParameter("Table.headerHeight");
        if (this.headerHeight <= 0) {
            this.headerHeight = 27;
        }
        if ((layoutData = cHeaderArea.getLayoutData()) instanceof GridData) {
            ((GridData)layoutData).heightHint = this.headerHeight;
        }
        cHeaderArea.addPaintListener(this::paintHeader);
        MouseListeners l = new MouseListeners(cHeaderArea, tv);
        cHeaderArea.addListener(3, (Listener)l);
        cHeaderArea.addListener(4, (Listener)l);
        cHeaderArea.addListener(5, (Listener)l);
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        DragSource ds = DragDropUtils.createDragSource((Control)cHeaderArea, 2);
        ds.setTransfer(types);
        ds.addDragListener((DragSourceListener)new HeaderDragSourceListener());
        DropTarget dt = new DropTarget((Control)cHeaderArea, 2);
        dt.setTransfer(types);
        dt.addDropListener((DropTargetListener)new HeaderDropTargetListener());
        cHeaderArea.addDisposeListener(e -> {
            FontUtils.uncache(this.fontHeader, this.fontHeaderSmall);
            this.fontHeaderSmall = null;
            this.fontHeader = null;
            Utils.disposeSWTObjects(ds, dt);
        });
    }

    private void paintHeader(PaintEvent e) {
        Pattern patternDown;
        Pattern patternUp;
        Color vline;
        Color hline;
        Color fg;
        Color c2;
        Color c1;
        if (this.cHeaderArea.isDisposed() || e.gc == null) {
            return;
        }
        Rectangle clientArea = this.tv.getClientArea();
        Rectangle ca = this.cHeaderArea.getClientArea();
        if (this.tv.isEnabled()) {
            c1 = TablePaintedUtils.getColour((Device)e.display, 25);
            c2 = TablePaintedUtils.getColour((Device)e.display, 22);
            fg = TablePaintedUtils.getColour((Device)e.display, 24);
        } else {
            c1 = TablePaintedUtils.getColour((Device)e.display, 22);
            c2 = TablePaintedUtils.getColour((Device)e.display, 19);
            fg = TablePaintedUtils.getColour((Device)e.display, 18);
        }
        if (gradientHeader) {
            hline = c2;
            vline = c2;
            patternUp = new Pattern((Device)e.display, 0.0f, 0.0f, 0.0f, (float)ca.height, c1, c2);
            patternDown = new Pattern((Device)e.display, 0.0f, (float)(-ca.height), 0.0f, 0.0f, c2, c1);
        } else {
            hline = c2;
            vline = c1;
            patternUp = new Pattern((Device)e.display, 0.0f, 0.0f, 0.0f, (float)ca.height, c2, c2);
            patternDown = new Pattern((Device)e.display, 0.0f, (float)(-ca.height), 0.0f, 0.0f, c1, c1);
        }
        e.gc.setForeground(hline);
        e.gc.drawLine(0, this.headerHeight - 1, clientArea.width, this.headerHeight - 1);
        TableColumnCore[] visibleColumns = this.tv.getVisibleColumns();
        TableColumnCore[] sortColumns = this.tv.getSortColumns();
        int x = -clientArea.x;
        TableColumnCore[] tableColumnCoreArray = visibleColumns;
        int n = visibleColumns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumnCore column = tableColumnCoreArray[n2];
            int w = column.getWidth();
            if (x + w > ca.width && (w = ca.width - x) <= 16) break;
            int sortColumnPos = -1;
            int i = 0;
            while (i < sortColumns.length) {
                if (column.equals(sortColumns[i])) {
                    sortColumnPos = i;
                    break;
                }
                ++i;
            }
            e.gc.setBackgroundPattern(sortColumnPos >= 0 ? patternDown : patternUp);
            e.gc.fillRectangle(x, 1, w, this.headerHeight - 2);
            e.gc.setForeground(vline);
            boolean doingDrop = column.equals(this.droppingOnHeader);
            if (doingDrop && this.droppingAfterHeader) {
                e.gc.setForeground(fg);
                e.gc.setLineWidth(2);
            } else {
                e.gc.setForeground(vline);
            }
            e.gc.drawLine(x + w - 1, 1, x + w - 1, this.headerHeight - 1);
            if (doingDrop && !this.droppingAfterHeader) {
                e.gc.setLineWidth(2);
                e.gc.setForeground(fg);
                e.gc.drawLine(x, 0, x, this.headerHeight - 1);
            }
            e.gc.setLineWidth(1);
            e.gc.setForeground(fg);
            int yOfs = 0;
            int wText = w;
            if (sortColumnPos >= 0) {
                int y1;
                int y2;
                int arrowHeight = 6;
                int arrowY = this.headerHeight / 2 - arrowHeight / 2;
                int arrowHalfW = 4;
                int middle = w - arrowHalfW - 4;
                wText = w - arrowHalfW * 2 - 5;
                if (column.isSortAscending()) {
                    y2 = arrowY;
                    y1 = y2 + arrowHeight;
                } else {
                    y1 = arrowY;
                    y2 = y1 + arrowHeight;
                }
                e.gc.setAntialias(1);
                e.gc.setBackground(fg);
                if (sortColumnPos > 0) {
                    e.gc.setAlpha((sortColumns.length - sortColumnPos + 1) * 140 / sortColumns.length);
                }
                e.gc.fillPolygon(new int[]{x + middle - arrowHalfW, y1, x + middle + arrowHalfW, y1, x + middle, y2});
                if (sortColumnPos > 0) {
                    e.gc.setAlpha(255);
                }
            }
            int xOfs = x + 2;
            boolean onlyShowImage = column.showOnlyImage();
            String text = "";
            if (!onlyShowImage) {
                text = MessageText.getString(column.getTitleLanguageKey());
            }
            int style = 0x1000040;
            Image image = null;
            String imageID = column.getIconReference();
            if (imageID != null) {
                image = ImageLoader.getInstance().getImage(imageID);
                if (ImageLoader.isRealImage(image)) {
                    if (onlyShowImage) {
                        text = null;
                        Rectangle imageBounds = image.getBounds();
                        e.gc.drawImage(image, (int)((double)x + (double)w / 2.0 - (double)imageBounds.width / 2.0 + 0.5), this.headerHeight / 2 - imageBounds.height / 2);
                    } else {
                        text = "%0 " + text;
                    }
                } else {
                    image = null;
                }
            }
            if (text != null) {
                GCStringPrinter sp = new GCStringPrinter(e.gc, text, new Rectangle(xOfs, yOfs - 1, wText - 4, this.headerHeight - yOfs + 2), true, false, style);
                if (image != null) {
                    sp.setImages(new Image[]{image});
                }
                sp.calculateMetrics();
                if (sp.isWordCut() || sp.isCutoff()) {
                    Font font = e.gc.getFont();
                    e.gc.setFont(this.fontHeaderSmall);
                    sp.printString();
                    e.gc.setFont(font);
                } else {
                    sp.printString();
                }
            }
            if (imageID != null) {
                ImageLoader.getInstance().releaseImage(imageID);
            }
            x += w;
            ++n2;
        }
        e.gc.setBackgroundPattern(patternUp);
        e.gc.fillRectangle(x, 1, clientArea.width - x, this.headerHeight - 2);
        patternUp.dispose();
        patternDown.dispose();
        e.gc.setBackgroundPattern(null);
    }

    public void setHeaderVisible(boolean visible) {
        Utils.execSWTThread(() -> {
            if (this.cHeaderArea.isDisposed()) {
                return;
            }
            this.cHeaderArea.setVisible(visible);
            Object ld = this.cHeaderArea.getLayoutData();
            if (ld instanceof FormData) {
                FormData fd = Utils.getFilledFormData();
                fd.height = visible ? this.headerHeight : 1;
                fd.bottom = null;
                this.cHeaderArea.setLayoutData((Object)fd);
            } else {
                GridData gd = (GridData)ld;
                gd.heightHint = visible ? this.headerHeight : 1;
            }
            Composite parent = this.cHeaderArea.getParent();
            if (parent != null) {
                parent.layout(true);
            }
        });
    }

    public void delete() {
        COConfigurationManager.removeParameterListener("Table.headerHeight", this);
    }

    public TableColumnCore getTableColumnByOffset(int mouseX, Point outRelativePos) {
        TableColumnCore[] visibleColumns;
        Rectangle clientArea = this.tv.getClientArea();
        int x = -clientArea.x;
        TableColumnCore[] tableColumnCoreArray = visibleColumns = this.tv.getVisibleColumns();
        int n = visibleColumns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumnCore column = tableColumnCoreArray[n2];
            int w = column.getWidth();
            if (mouseX >= x && mouseX < x + w) {
                outRelativePos.x = mouseX - x;
                return column;
            }
            x += w;
            ++n2;
        }
        return null;
    }

    @Override
    public void parameterChanged(String parameterName) {
        if (parameterName == null || parameterName.equals("Table.headerHeight")) {
            this.headerHeight = COConfigurationManager.getIntParameter("Table.headerHeight");
            if (this.headerHeight == 0) {
                this.headerHeight = 27;
            }
            this.tv.setHeaderVisible(this.tv.getHeaderVisible());
        }
    }

    public void setEnabled(boolean enable) {
        if (this.cHeaderArea.isDisposed()) {
            return;
        }
        this.cHeaderArea.setEnabled(enable);
        this.cHeaderArea.redraw();
    }

    public void redraw() {
        if (this.cHeaderArea.isDisposed()) {
            return;
        }
        this.cHeaderArea.redraw();
    }

    public Composite getHeaderArea() {
        return this.cHeaderArea;
    }

    public void createMenu(Menu menu) {
        this.cHeaderArea.addListener(35, event2 -> {
            menu.setData("inBlankArea", (Object)false);
            menu.setData("isHeader", (Object)true);
            Point pt = this.cHeaderArea.toControl(event2.x, event2.y);
            menu.setData("table-view", (Object)this.tv);
            menu.setData("column", (Object)this.tv.getTableColumnByOffset(pt.x));
        });
        this.cHeaderArea.setMenu(menu);
    }

    private class HeaderDragSourceListener
    implements DragSourceListener {
        private String eventData;

        private HeaderDragSourceListener() {
        }

        public void dragStart(DragSourceEvent event2) {
            if (TableHeaderPainted.this.cHeaderArea.isDisposed() || event2.display == null) {
                return;
            }
            Cursor cursor = TableHeaderPainted.this.cHeaderArea.getCursor();
            if (cursor != null && cursor.equals((Object)event2.display.getSystemCursor(9))) {
                event2.doit = false;
                return;
            }
            TableHeaderPainted.this.cHeaderArea.setCursor(null);
            TableColumnCore tc = TableHeaderPainted.this.tv.getTableColumnByOffset(event2.x);
            if (tc != null) {
                TableHeaderPainted.this.draggingHeader = tc;
                this.eventData = tc.getName();
            } else {
                this.eventData = null;
                TableHeaderPainted.this.draggingHeader = null;
            }
        }

        public void dragSetData(DragSourceEvent event2) {
            event2.data = this.eventData;
        }

        public void dragFinished(DragSourceEvent event2) {
            TableHeaderPainted.this.draggingHeader = null;
            this.eventData = null;
        }
    }

    private class HeaderDropTargetListener
    implements DropTargetListener {
        private DropTargetEvent lastDropTargetEvent;

        private HeaderDropTargetListener() {
        }

        public void dropAccept(DropTargetEvent event2) {
        }

        public void drop(DropTargetEvent event2) {
            try {
                boolean columnAdded;
                TableColumnCore tcOrig;
                if (TableHeaderPainted.this.droppingOnHeader == null) {
                    return;
                }
                TableColumn tableColumn = tcOrig = TableHeaderPainted.this.draggingHeader == null ? TableHeaderPainted.this.tv.getTableColumn((String)DragDropUtils.getLastDraggedObject()) : TableHeaderPainted.this.draggingHeader;
                if (tcOrig == null) {
                    return;
                }
                int origPos = tcOrig.getPosition();
                int destPos = TableHeaderPainted.this.droppingOnHeader.getPosition();
                if (TableHeaderPainted.this.droppingAfterHeader) {
                    ++destPos;
                }
                boolean bl = columnAdded = !tcOrig.isVisible();
                if (columnAdded) {
                    tcOrig.setVisible(true);
                }
                if (origPos == destPos && !columnAdded) {
                    return;
                }
                TableColumnCore[] visibleColumns = TableHeaderPainted.this.tv.getVisibleColumns();
                if (columnAdded) {
                    TableColumnCore[] tmp = new TableColumnCore[visibleColumns.length + 1];
                    System.arraycopy(visibleColumns, 0, tmp, 0, visibleColumns.length);
                    tmp[visibleColumns.length] = tcOrig;
                    visibleColumns = tmp;
                }
                tcOrig.setPositionNoShift(destPos);
                Arrays.sort(visibleColumns, (o1, o2) -> {
                    if (o1 == o2) {
                        return 0;
                    }
                    int diff = o1.getPosition() - o2.getPosition();
                    return diff != 0 ? diff : (o2 == tcOrig ? 1 : -1);
                });
                int i = 0;
                while (i < visibleColumns.length) {
                    TableColumnCore tc = visibleColumns[i];
                    tc.setPositionNoShift(i);
                    ++i;
                }
                TableHeaderPainted.this.tv.setColumnsOrdered(visibleColumns);
                TableStructureEventDispatcher.getInstance(TableHeaderPainted.this.tv.getTableID()).tableStructureChanged(columnAdded, TableHeaderPainted.this.tv.getDataSourceType());
            }
            finally {
                TableHeaderPainted.this.draggingHeader = null;
                TableHeaderPainted.this.droppingOnHeader = null;
                this.lastDropTargetEvent = null;
                TableHeaderPainted.this.redraw();
            }
        }

        public void dragOver(DropTargetEvent event2) {
            TableColumnCore tcOrig;
            TableColumn tableColumn = tcOrig = TableHeaderPainted.this.draggingHeader == null ? TableHeaderPainted.this.tv.getTableColumn((String)DragDropUtils.getLastDraggedObject()) : TableHeaderPainted.this.draggingHeader;
            if (tcOrig == null) {
                return;
            }
            if (this.lastDropTargetEvent != null && this.lastDropTargetEvent.x == event2.x && this.lastDropTargetEvent.y == event2.y && this.lastDropTargetEvent.detail == event2.detail && this.lastDropTargetEvent.operations == event2.operations) {
                return;
            }
            this.lastDropTargetEvent = event2;
            Point offset = new Point(0, 0);
            Point relativeMousePos = TableHeaderPainted.this.cHeaderArea.toControl(event2.x, event2.y);
            TableHeaderPainted.this.droppingOnHeader = TableHeaderPainted.this.getTableColumnByOffset(relativeMousePos.x, offset);
            if (TableHeaderPainted.this.droppingOnHeader != null) {
                int ourPos;
                int dropPos = TableHeaderPainted.this.droppingOnHeader.getPosition();
                int n = ourPos = tcOrig.isVisible() ? tcOrig.getPosition() : -2;
                if (dropPos == ourPos) {
                    TableHeaderPainted.this.droppingOnHeader = null;
                } else if (dropPos == ourPos + 1) {
                    TableHeaderPainted.this.droppingAfterHeader = true;
                } else if (dropPos == ourPos - 1) {
                    TableHeaderPainted.this.droppingAfterHeader = false;
                } else {
                    TableHeaderPainted.this.droppingAfterHeader = offset.x > TableHeaderPainted.this.droppingOnHeader.getWidth() / 2;
                }
            }
            TableHeaderPainted.this.redraw();
        }

        public void dragOperationChanged(DropTargetEvent event2) {
        }

        public void dragLeave(DropTargetEvent event2) {
            TableHeaderPainted.this.redraw();
        }

        public void dragEnter(DropTargetEvent event2) {
            TableHeaderPainted.this.redraw();
        }
    }

    private static class MouseListeners
    implements Listener {
        private final Canvas cHeaderArea;
        private final TableViewPainted tv;
        boolean mouseDown;
        TableColumnCore columnSizing;
        int columnSizingStart;

        public MouseListeners(Canvas cHeaderArea, TableViewPainted tv) {
            this.cHeaderArea = cHeaderArea;
            this.tv = tv;
            this.mouseDown = false;
            this.columnSizingStart = 0;
        }

        public void handleEvent(Event e) {
            if (this.cHeaderArea.isDisposed()) {
                return;
            }
            block0 : switch (e.type) {
                case 3: {
                    TableColumnCore[] visibleColumns;
                    if (e.button != 1) {
                        return;
                    }
                    this.mouseDown = true;
                    this.columnSizing = null;
                    Rectangle clientArea = this.tv.getClientArea();
                    int x = -clientArea.x;
                    TableColumnCore[] tableColumnCoreArray = visibleColumns = this.tv.getVisibleColumns();
                    int n = visibleColumns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableColumnCore column = tableColumnCoreArray[n2];
                        int w = column.getWidth();
                        if (e.x >= (x += w) - 3 && e.x <= x + 3) {
                            this.columnSizing = column;
                            this.columnSizingStart = e.x;
                            break block0;
                        }
                        ++n2;
                    }
                    break;
                }
                case 4: {
                    if (e.button != 1) {
                        return;
                    }
                    if (this.mouseDown) {
                        if (this.columnSizing == null) {
                            TableColumnCore column = this.tv.getTableColumnByOffset(e.x);
                            if (column != null) {
                                boolean addColumn;
                                boolean bl = addColumn = (e.stateMask & SWT.MOD1) > 0;
                                if (addColumn) {
                                    this.tv.addSortColumn(column);
                                } else {
                                    this.tv.setSortColumns(new TableColumnCore[]{column}, true);
                                }
                            }
                        } else {
                            int diff = e.x - this.columnSizingStart;
                            this.columnSizing.setWidthPX(this.columnSizing.getWidth() + diff);
                        }
                    }
                    this.columnSizing = null;
                    this.mouseDown = false;
                    break;
                }
                case 5: {
                    TableColumnCore column;
                    TableColumnCore[] visibleColumns;
                    if (this.columnSizing != null) {
                        int diff = e.x - this.columnSizingStart;
                        this.columnSizing.setWidthPX(this.columnSizing.getWidth() + diff);
                        this.columnSizingStart = e.x;
                        break;
                    }
                    int cursorID = 21;
                    Rectangle clientArea = this.tv.getClientArea();
                    int x = -clientArea.x;
                    TableColumnCore[] tableColumnCoreArray = visibleColumns = this.tv.getVisibleColumns();
                    int n = visibleColumns.length;
                    int n3 = 0;
                    while (n3 < n) {
                        column = tableColumnCoreArray[n3];
                        int w = column.getWidth();
                        if (e.x >= (x += w) - 3 && e.x <= x + 3) {
                            cursorID = 9;
                            break;
                        }
                        ++n3;
                    }
                    if (e.display != null) {
                        this.cHeaderArea.setCursor(e.display.getSystemCursor(cursorID));
                    }
                    if ((column = this.tv.getTableColumnByOffset(e.x)) == null || TableTooltips.tooltips_disabled && !column.doesAutoTooltip()) {
                        Utils.setTT((Control)this.cHeaderArea, null);
                        break;
                    }
                    String info = MessageText.getString(String.valueOf(column.getTitleLanguageKey()) + ".info", null);
                    if (column.showOnlyImage()) {
                        String tt = MessageText.getString(column.getTitleLanguageKey());
                        if (info != null) {
                            tt = String.valueOf(tt) + "\n" + info;
                        }
                        Utils.setTT((Control)this.cHeaderArea, tt);
                        break;
                    }
                    Utils.setTT((Control)this.cHeaderArea, info);
                }
            }
        }
    }
}

