/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.stats;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.stats.CoreStats;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BufferedLabel;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.views.IViewRequiresPeriodicUpdates;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class CountersView
implements UISWTViewCoreEventListener,
IViewRequiresPeriodicUpdates {
    public static final String MSGID_PREFIX = "CountersView";
    private Composite panel;
    private ScrolledComposite counters_panel_sc;
    private Composite counters_panel;
    private Map<String, BufferedLabel> label_map = new HashMap<String, BufferedLabel>();

    private void initialize(Composite composite) {
        this.panel = new Composite(composite, 0);
        this.panel.setLayout((Layout)new GridLayout());
        this.counters_panel_sc = new ScrolledComposite(this.panel, 512);
        this.counters_panel_sc.setExpandHorizontal(true);
        this.counters_panel_sc.setExpandVertical(true);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.counters_panel_sc.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        this.counters_panel_sc.setLayoutData((Object)gridData);
        this.counters_panel = new Composite((Composite)this.counters_panel_sc, 0);
        this.counters_panel.setLayoutData((Object)new GridData(1808));
        this.counters_panel.setLayout((Layout)new GridLayout(2, false));
        this.counters_panel_sc.setContent((Control)this.counters_panel);
        this.counters_panel_sc.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                CountersView.this.counters_panel_sc.setMinSize(CountersView.this.counters_panel.computeSize(-1, -1));
            }
        });
        this.build();
    }

    private void build() {
        if (this.counters_panel == null || this.counters_panel.isDisposed()) {
            return;
        }
        Control[] controlArray = this.counters_panel.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        this.label_map.clear();
        HashSet<String> types = new HashSet<String>();
        types.add(".*");
        Map<String, Object> reply = CoreStats.getStats(types);
        ArrayList<String> keys = new ArrayList<String>(reply.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            Label label = new Label(this.counters_panel, 0);
            label.setText(key);
            BufferedLabel bl = new BufferedLabel(this.counters_panel, 0x20000000);
            bl.setLayoutData(new GridData(768));
            this.label_map.put(key, bl);
        }
        this.counters_panel_sc.setMinSize(this.counters_panel.computeSize(-1, -1));
        this.panel.layout(true, true);
    }

    public void periodicUpdate() {
    }

    private void delete() {
        Utils.disposeComposite(this.panel);
    }

    private Composite getComposite() {
        return this.panel;
    }

    private void refresh() {
        HashSet<String> types = new HashSet<String>();
        types.add(".*");
        Map<String, Object> reply = CoreStats.getStats(types);
        for (Map.Entry<String, Object> entry : reply.entrySet()) {
            Object val;
            BufferedLabel lab = this.label_map.get(entry.getKey());
            if (lab == null || !((val = entry.getValue()) instanceof Number)) continue;
            lab.setText(String.valueOf(val));
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                UISWTView swtView = (UISWTView)event2.getData();
                swtView.setTitle(MessageText.getString("CountersView.title.full"));
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                this.refresh();
                break;
            }
            case 256: {
                this.periodicUpdate();
            }
        }
        return true;
    }
}

