/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.stats;

import com.biglybt.core.disk.DiskManagerFactory;
import com.biglybt.core.diskmanager.access.DiskAccessControllerStats;
import com.biglybt.core.diskmanager.cache.CacheFileManagerFactory;
import com.biglybt.core.diskmanager.cache.CacheFileManagerStats;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BufferedLabel;
import com.biglybt.ui.swt.components.graphics.SpeedGraphic;
import com.biglybt.ui.swt.components.graphics.ValueFormater;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.views.IViewRequiresPeriodicUpdates;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Widget;

public class CacheView
implements UISWTViewCoreEventListener,
IViewRequiresPeriodicUpdates {
    public static final String MSGID_PREFIX = "CacheView";
    CacheFileManagerStats cfmStats;
    DiskAccessControllerStats dacStats;
    Composite panel;
    BufferedLabel lblInUse;
    BufferedLabel lblSize;
    BufferedLabel lblPercentUsed;
    ProgressBar pbInUse;
    BufferedLabel lblReadsFromCache;
    BufferedLabel lblNumberReadsFromCache;
    BufferedLabel lblAvgSizeFromCache;
    BufferedLabel lblReadsFromFile;
    BufferedLabel lblNumberReadsFromFile;
    BufferedLabel lblAvgSizeFromFile;
    BufferedLabel lblPercentReads1;
    BufferedLabel lblPercentReads2;
    ProgressBar pbReads1;
    ProgressBar pbReads2;
    BufferedLabel lblWritesToCache;
    BufferedLabel lblNumberWritesToCache;
    BufferedLabel lblAvgSizeToCache;
    BufferedLabel lblWritesToFile;
    BufferedLabel lblNumberWritesToFile;
    BufferedLabel lblAvgSizeToFile;
    BufferedLabel lblPercentWrites;
    ProgressBar pbWrites;
    Canvas readsFromFile;
    Canvas readsFromCache;
    Canvas writesToCache;
    Canvas writesToFile;
    SpeedGraphic rffGraph;
    SpeedGraphic rfcGraph;
    SpeedGraphic wtcGraph;
    SpeedGraphic wtfGraph;
    Canvas diskReadsQueued;
    Canvas diskWritesQueued;
    SpeedGraphic drqGraph;
    SpeedGraphic dwqGraph;

    public CacheView() {
        try {
            this.cfmStats = CacheFileManagerFactory.getSingleton().getStats();
            this.dacStats = DiskManagerFactory.getDiskAccessController().getStats();
            this.rfcGraph = SpeedGraphic.getInstance();
            this.wtcGraph = SpeedGraphic.getInstance();
            this.rffGraph = SpeedGraphic.getInstance();
            this.wtfGraph = SpeedGraphic.getInstance();
            this.drqGraph = SpeedGraphic.getInstance(new ValueFormater(){

                @Override
                public String format(int value) {
                    return DisplayFormatters.formatByteCountToKiBEtc((long)value * (long)DisplayFormatters.getKinB());
                }
            });
            this.dwqGraph = SpeedGraphic.getInstance(new ValueFormater(){

                @Override
                public String format(int value) {
                    return DisplayFormatters.formatByteCountToKiBEtc((long)value * (long)DisplayFormatters.getKinB());
                }
            });
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    private void initialize(Composite composite) {
        this.panel = new Composite(composite, 0);
        this.panel.setLayout((Layout)new GridLayout());
        this.generateGeneralGroup();
        this.generateReadsGroup();
        this.generateWritesGroup();
        this.generateSpeedGroup();
    }

    private void generateGeneralGroup() {
        Group gCacheGeneral = Utils.createSkinnedGroup(this.panel, 0);
        Messages.setLanguageText((Widget)gCacheGeneral, "CacheView.general.title");
        gCacheGeneral.setLayoutData((Object)new GridData(768));
        GridLayout layoutGeneral = new GridLayout();
        layoutGeneral.numColumns = 4;
        gCacheGeneral.setLayout((Layout)layoutGeneral);
        Label lbl = new Label((Composite)gCacheGeneral, 0);
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        lbl.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)lbl, "CacheView.general.inUse");
        this.lblInUse = new BufferedLabel((Composite)gCacheGeneral, 0x20000000);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblInUse.setLayoutData(gridData);
        this.pbInUse = new ProgressBar((Composite)gCacheGeneral, 256);
        gridData = new GridData(768);
        gridData.verticalSpan = 2;
        this.pbInUse.setLayoutData((Object)gridData);
        this.pbInUse.setMinimum(0);
        this.pbInUse.setMaximum(1000);
        if (Constants.isWindows) {
            this.pbInUse.setState(4);
        }
        this.lblPercentUsed = new BufferedLabel((Composite)gCacheGeneral, 0x20000000);
        gridData = new GridData();
        gridData.verticalSpan = 2;
        gridData.widthHint = 120;
        this.lblPercentUsed.setLayoutData(gridData);
        lbl = new Label((Composite)gCacheGeneral, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        lbl.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)lbl, "CacheView.general.size");
        this.lblSize = new BufferedLabel((Composite)gCacheGeneral, 0x20000000);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblSize.setLayoutData(gridData);
    }

    private void generateReadsGroup() {
        Group gCacheReads = Utils.createSkinnedGroup(this.panel, 0);
        Messages.setLanguageText((Widget)gCacheReads, "CacheView.reads.title");
        gCacheReads.setLayoutData((Object)new GridData(768));
        GridLayout layoutGeneral = new GridLayout();
        layoutGeneral.numColumns = 6;
        gCacheReads.setLayout((Layout)layoutGeneral);
        Label lbl = new Label((Composite)gCacheReads, 0);
        lbl = new Label((Composite)gCacheReads, 0);
        Messages.setLanguageText((Widget)lbl, "CacheView.reads.#");
        lbl = new Label((Composite)gCacheReads, 0);
        Messages.setLanguageText((Widget)lbl, "CacheView.reads.amount");
        lbl = new Label((Composite)gCacheReads, 0);
        Messages.setLanguageText((Widget)lbl, "CacheView.reads.avgsize");
        lbl = new Label((Composite)gCacheReads, 0);
        lbl = new Label((Composite)gCacheReads, 0);
        lbl = new Label((Composite)gCacheReads, 0);
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        lbl.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)lbl, "CacheView.reads.fromCache");
        this.lblNumberReadsFromCache = new BufferedLabel((Composite)gCacheReads, 0x20000000);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblNumberReadsFromCache.setLayoutData(gridData);
        this.lblReadsFromCache = new BufferedLabel((Composite)gCacheReads, 0x20000000);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblReadsFromCache.setLayoutData(gridData);
        this.lblAvgSizeFromCache = new BufferedLabel((Composite)gCacheReads, 0x20000000);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblAvgSizeFromCache.setLayoutData(gridData);
        this.pbReads1 = new ProgressBar((Composite)gCacheReads, 256);
        gridData = new GridData(768);
        this.pbReads1.setLayoutData((Object)gridData);
        this.pbReads1.setMinimum(0);
        this.pbReads1.setMaximum(1000);
        if (Constants.isWindows) {
            this.pbReads1.setState(4);
        }
        this.lblPercentReads1 = new BufferedLabel((Composite)gCacheReads, 0x20000000);
        gridData = new GridData(1040);
        gridData.widthHint = 120;
        this.lblPercentReads1.setLayoutData(gridData);
        lbl = new Label((Composite)gCacheReads, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        lbl.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)lbl, "CacheView.reads.fromFile");
        this.lblNumberReadsFromFile = new BufferedLabel((Composite)gCacheReads, 0x20000000);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblNumberReadsFromFile.setLayoutData(gridData);
        this.lblReadsFromFile = new BufferedLabel((Composite)gCacheReads, 0x20000000);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblReadsFromFile.setLayoutData(gridData);
        this.lblAvgSizeFromFile = new BufferedLabel((Composite)gCacheReads, 0x20000000);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblAvgSizeFromFile.setLayoutData(gridData);
        this.pbReads2 = new ProgressBar((Composite)gCacheReads, 256);
        gridData = new GridData(768);
        this.pbReads2.setLayoutData((Object)gridData);
        this.pbReads2.setMinimum(0);
        this.pbReads2.setMaximum(1000);
        if (Constants.isWindows) {
            this.pbReads2.setState(4);
        }
        this.lblPercentReads2 = new BufferedLabel((Composite)gCacheReads, 0x20000000);
        gridData = new GridData(1040);
        gridData.widthHint = 120;
        this.lblPercentReads2.setLayoutData(gridData);
    }

    private void generateSpeedGroup() {
        Group gCacheSpeeds = Utils.createSkinnedGroup(this.panel, 0);
        Messages.setLanguageText((Widget)gCacheSpeeds, "CacheView.speeds.title");
        gCacheSpeeds.setLayoutData((Object)new GridData(1808));
        GridLayout layoutGeneral = new GridLayout();
        layoutGeneral.numColumns = 3;
        gCacheSpeeds.setLayout((Layout)layoutGeneral);
        Label lbl = new Label((Composite)gCacheSpeeds, 0);
        lbl = new Label((Composite)gCacheSpeeds, 0);
        GridData gridData = new GridData(64);
        lbl.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)lbl, "CacheView.speeds.reads");
        lbl = new Label((Composite)gCacheSpeeds, 0);
        gridData = new GridData(64);
        lbl.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)lbl, "CacheView.speeds.writes");
        lbl = new Label((Composite)gCacheSpeeds, 0);
        Messages.setLanguageText((Widget)lbl, "CacheView.speeds.fromCache");
        this.readsFromCache = new Canvas((Composite)gCacheSpeeds, 262144);
        gridData = new GridData(1808);
        this.readsFromCache.setLayoutData((Object)gridData);
        this.rfcGraph.initialize(this.readsFromCache);
        this.writesToCache = new Canvas((Composite)gCacheSpeeds, 262144);
        gridData = new GridData(1808);
        this.writesToCache.setLayoutData((Object)gridData);
        this.wtcGraph.initialize(this.writesToCache);
        lbl = new Label((Composite)gCacheSpeeds, 0);
        Messages.setLanguageText((Widget)lbl, "CacheView.speeds.fromFile");
        this.readsFromFile = new Canvas((Composite)gCacheSpeeds, 262144);
        gridData = new GridData(1808);
        this.readsFromFile.setLayoutData((Object)gridData);
        this.rffGraph.initialize(this.readsFromFile);
        this.writesToFile = new Canvas((Composite)gCacheSpeeds, 262144);
        gridData = new GridData(1808);
        this.writesToFile.setLayoutData((Object)gridData);
        this.wtfGraph.initialize(this.writesToFile);
        lbl = new Label((Composite)gCacheSpeeds, 0);
        Messages.setLanguageText((Widget)lbl, "CacheView.disk.queues");
        this.diskReadsQueued = new Canvas((Composite)gCacheSpeeds, 262144);
        gridData = new GridData(1808);
        this.diskReadsQueued.setLayoutData((Object)gridData);
        this.drqGraph.initialize(this.diskReadsQueued);
        this.diskWritesQueued = new Canvas((Composite)gCacheSpeeds, 262144);
        gridData = new GridData(1808);
        this.diskWritesQueued.setLayoutData((Object)gridData);
        this.dwqGraph.initialize(this.diskWritesQueued);
    }

    public void periodicUpdate() {
        this.rfcGraph.addIntValue((int)this.cfmStats.getAverageBytesReadFromCache());
        this.rffGraph.addIntValue((int)this.cfmStats.getAverageBytesReadFromFile());
        this.wtcGraph.addIntValue((int)this.cfmStats.getAverageBytesWrittenToCache());
        this.wtfGraph.addIntValue((int)this.cfmStats.getAverageBytesWrittenToFile());
        this.drqGraph.addIntValue((int)(this.dacStats.getReadBytesQueued() / (long)DisplayFormatters.getKinB()));
        this.dwqGraph.addIntValue((int)(this.dacStats.getWriteBytesQueued() / (long)DisplayFormatters.getKinB()));
    }

    private void generateWritesGroup() {
        Group gCacheWrites = Utils.createSkinnedGroup(this.panel, 0);
        Messages.setLanguageText((Widget)gCacheWrites, "CacheView.writes.title");
        gCacheWrites.setLayoutData((Object)new GridData(768));
        GridLayout layoutGeneral = new GridLayout();
        layoutGeneral.numColumns = 6;
        gCacheWrites.setLayout((Layout)layoutGeneral);
        Label lbl = new Label((Composite)gCacheWrites, 0);
        lbl = new Label((Composite)gCacheWrites, 0);
        Messages.setLanguageText((Widget)lbl, "CacheView.reads.#");
        lbl = new Label((Composite)gCacheWrites, 0);
        Messages.setLanguageText((Widget)lbl, "CacheView.reads.amount");
        lbl = new Label((Composite)gCacheWrites, 0);
        Messages.setLanguageText((Widget)lbl, "CacheView.reads.avgsize");
        lbl = new Label((Composite)gCacheWrites, 0);
        lbl = new Label((Composite)gCacheWrites, 0);
        lbl = new Label((Composite)gCacheWrites, 0);
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        lbl.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)lbl, "CacheView.writes.toCache");
        this.lblNumberWritesToCache = new BufferedLabel((Composite)gCacheWrites, 0x20000000);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblNumberWritesToCache.setLayoutData(gridData);
        this.lblWritesToCache = new BufferedLabel((Composite)gCacheWrites, 0x20000000);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblWritesToCache.setLayoutData(gridData);
        this.lblAvgSizeToCache = new BufferedLabel((Composite)gCacheWrites, 0x20000000);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblAvgSizeToCache.setLayoutData(gridData);
        this.pbWrites = new ProgressBar((Composite)gCacheWrites, 256);
        gridData = new GridData(768);
        gridData.verticalSpan = 2;
        this.pbWrites.setLayoutData((Object)gridData);
        this.pbWrites.setMinimum(0);
        this.pbWrites.setMaximum(1000);
        if (Constants.isWindows) {
            this.pbWrites.setState(4);
        }
        this.lblPercentWrites = new BufferedLabel((Composite)gCacheWrites, 0x20000000);
        gridData = new GridData();
        gridData.verticalSpan = 2;
        gridData.widthHint = 120;
        this.lblPercentWrites.setLayoutData(gridData);
        lbl = new Label((Composite)gCacheWrites, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        lbl.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)lbl, "CacheView.writes.toFile");
        this.lblNumberWritesToFile = new BufferedLabel((Composite)gCacheWrites, 0x20000000);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblNumberWritesToFile.setLayoutData(gridData);
        this.lblWritesToFile = new BufferedLabel((Composite)gCacheWrites, 0x20000000);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblWritesToFile.setLayoutData(gridData);
        this.lblAvgSizeToFile = new BufferedLabel((Composite)gCacheWrites, 0x20000000);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblAvgSizeToFile.setLayoutData(gridData);
    }

    private void delete() {
        Utils.disposeComposite(this.panel);
        this.rfcGraph.dispose();
        this.rffGraph.dispose();
        this.wtcGraph.dispose();
        this.wtfGraph.dispose();
        this.drqGraph.dispose();
        this.dwqGraph.dispose();
    }

    private Composite getComposite() {
        return this.panel;
    }

    private void refresh() {
        if (this.lblSize == null || this.lblSize.isDisposed()) {
            return;
        }
        this.lblSize.setText(DisplayFormatters.formatByteCountToKiBEtc(this.cfmStats.getSize()));
        this.lblInUse.setText(DisplayFormatters.formatByteCountToKiBEtc(this.cfmStats.getUsedSize()));
        int perThousands = (int)(1000L * this.cfmStats.getUsedSize() / this.cfmStats.getSize());
        this.lblPercentUsed.setText(DisplayFormatters.formatPercentFromThousands(perThousands));
        this.pbInUse.setSelection(perThousands);
        this.refrehReads();
        this.refreshWrites();
        this.rfcGraph.refresh(false);
        this.rffGraph.refresh(false);
        this.wtcGraph.refresh(false);
        this.wtfGraph.refresh(false);
        this.drqGraph.refresh(false);
        this.dwqGraph.refresh(false);
    }

    private void refrehReads() {
        int perThousands;
        long readsFromCache = this.cfmStats.getBytesReadFromCache();
        long readsFromFile = this.cfmStats.getBytesReadFromFile();
        long nbReadsFromCache = this.cfmStats.getCacheReadCount();
        long nbReadsFromFile = this.cfmStats.getFileReadCount();
        this.lblNumberReadsFromCache.setText("" + nbReadsFromCache);
        this.lblNumberReadsFromFile.setText("" + nbReadsFromFile);
        if (nbReadsFromCache != 0L) {
            long avgReadFromCache = readsFromCache / nbReadsFromCache;
            this.lblAvgSizeFromCache.setText(DisplayFormatters.formatByteCountToKiBEtc(avgReadFromCache));
        } else {
            this.lblAvgSizeFromCache.setText("--");
        }
        if (nbReadsFromFile != 0L) {
            long avgReadFromFile = readsFromFile / nbReadsFromFile;
            this.lblAvgSizeFromFile.setText(DisplayFormatters.formatByteCountToKiBEtc(avgReadFromFile));
        } else {
            this.lblAvgSizeFromFile.setText("--");
        }
        this.lblReadsFromCache.setText(DisplayFormatters.formatByteCountToKiBEtc(readsFromCache));
        this.lblReadsFromFile.setText(DisplayFormatters.formatByteCountToKiBEtc(readsFromFile));
        if (nbReadsFromFile > 0L) {
            perThousands = (int)(1000L * nbReadsFromCache / (nbReadsFromCache + nbReadsFromFile));
            this.lblPercentReads1.setText(String.valueOf(DisplayFormatters.formatPercentFromThousands(perThousands)) + "  " + MessageText.getString("label.hits"));
            this.pbReads1.setSelection(perThousands);
        } else {
            this.lblPercentReads1.setText(MessageText.getString("label.hit.ratio"));
        }
        if (readsFromFile > 0L) {
            perThousands = (int)(1000L * readsFromCache / readsFromFile);
            this.lblPercentReads2.setText(String.valueOf(DisplayFormatters.formatPercentFromThousands(perThousands)) + " " + MessageText.getString("label.efficiency"));
            this.pbReads2.setSelection(perThousands);
        } else {
            this.lblPercentReads2.setText(MessageText.getString("label.efficiency"));
        }
    }

    private void refreshWrites() {
        long writesToCache = this.cfmStats.getBytesWrittenToCache();
        long writesToFile = this.cfmStats.getBytesWrittenToFile();
        long nbWritesToCache = this.cfmStats.getCacheWriteCount();
        long nbWritesToFile = this.cfmStats.getFileWriteCount();
        this.lblNumberWritesToCache.setText("" + nbWritesToCache);
        this.lblNumberWritesToFile.setText("" + nbWritesToFile);
        if (nbWritesToCache != 0L) {
            long avgReadToCache = writesToCache / nbWritesToCache;
            this.lblAvgSizeToCache.setText(DisplayFormatters.formatByteCountToKiBEtc(avgReadToCache));
        } else {
            this.lblAvgSizeToCache.setText("--");
        }
        if (nbWritesToFile != 0L) {
            long avgReadToFile = writesToFile / nbWritesToFile;
            this.lblAvgSizeToFile.setText(DisplayFormatters.formatByteCountToKiBEtc(avgReadToFile));
        } else {
            this.lblAvgSizeToFile.setText("--");
        }
        this.lblWritesToCache.setText(DisplayFormatters.formatByteCountToKiBEtc(writesToCache));
        this.lblWritesToFile.setText(DisplayFormatters.formatByteCountToKiBEtc(writesToFile));
        long totalNbWrites = nbWritesToCache + nbWritesToFile;
        if (totalNbWrites > 0L) {
            int perThousands = (int)(1000L * nbWritesToCache / totalNbWrites);
            this.lblPercentWrites.setText(String.valueOf(DisplayFormatters.formatPercentFromThousands(perThousands)) + " " + MessageText.getString("CacheView.writes.hits"));
            this.pbWrites.setSelection(perThousands);
        } else {
            this.lblPercentWrites.setText(MessageText.getString("CacheView.writes.hits"));
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                UISWTView swtView = (UISWTView)event2.getData();
                swtView.setTitle(MessageText.getString("CacheView.title.full"));
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                this.refresh();
                break;
            }
            case 256: {
                this.periodicUpdate();
            }
        }
        return true;
    }
}

