/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.skin.sidebar;

import com.biglybt.ui.common.updater.UIUpdatable;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.mdi.BaseMdiEntry;
import com.biglybt.ui.swt.mdi.MdiEntryVitalityImageSWT;
import com.biglybt.ui.swt.uiupdater.UIUpdaterSWT;
import com.biglybt.ui.swt.views.skin.sidebar.SideBar;
import java.util.List;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class SideBarToolTips
implements Listener,
UIUpdatable {
    Shell toolTipShell = null;
    Shell mainShell = null;
    CLabel toolTipLabel = null;
    private final Tree tree;
    private BaseMdiEntry mdiEntry;
    private Point lastRelMouseHoverPos;

    public SideBarToolTips(SideBar sidebar, Tree tree) {
        this.tree = tree;
        this.mainShell = tree.getShell();
        tree.addListener(12, (Listener)this);
        tree.addListener(1, (Listener)this);
        tree.addListener(5, (Listener)this);
        tree.addListener(7, (Listener)this);
        tree.addListener(32, (Listener)this);
        this.mainShell.addListener(27, (Listener)this);
        tree.addListener(27, (Listener)this);
    }

    public void handleEvent(Event event2) {
        switch (event2.type) {
            case 32: {
                this.handleHover(new Point(event2.x, event2.y));
                break;
            }
            case 12: {
                if (this.mainShell != null && !this.mainShell.isDisposed()) {
                    this.mainShell.removeListener(27, (Listener)this);
                }
            }
            default: {
                if (this.toolTipShell == null) break;
                this.toolTipShell.dispose();
                this.toolTipShell = null;
                this.toolTipLabel = null;
            }
        }
    }

    private void handleHover(Point mousePos) {
        Rectangle displayRect;
        if (this.toolTipShell != null && !this.toolTipShell.isDisposed()) {
            this.toolTipShell.dispose();
        }
        if (!Utils.getTTEnabled()) {
            return;
        }
        if (this.tree.getItemCount() == 0) {
            return;
        }
        int indent = SideBar.END_INDENT ? this.tree.getClientArea().width - 1 : 0;
        TreeItem treeItem = this.tree.getItem(new Point(indent, mousePos.y));
        if (treeItem == null) {
            return;
        }
        this.mdiEntry = (BaseMdiEntry)treeItem.getData("MdiEntry");
        if (this.mdiEntry == null) {
            return;
        }
        Rectangle itemBounds = treeItem.getBounds();
        Point relPos = new Point(mousePos.x, mousePos.y - itemBounds.y);
        String sToolTip = this.getToolTip(relPos);
        if (sToolTip == null || sToolTip.length() == 0) {
            return;
        }
        this.lastRelMouseHoverPos = relPos;
        Display d = this.tree.getDisplay();
        if (d == null) {
            return;
        }
        this.toolTipShell = new Shell(this.tree.getShell(), 16384);
        UIUpdaterSWT.getInstance().addUpdater(this);
        this.toolTipShell.addListener(12, new Listener(){

            public void handleEvent(Event event2) {
                UIUpdaterSWT.getInstance().removeUpdater(SideBarToolTips.this);
            }
        });
        FillLayout f = new FillLayout();
        try {
            f.marginWidth = 3;
            f.marginHeight = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        this.toolTipShell.setLayout((Layout)f);
        this.toolTipShell.setBackground(Colors.getSystemColor((Device)d, 29));
        this.toolTipLabel = new CLabel((Composite)this.toolTipShell, 64);
        this.toolTipLabel.setForeground(Colors.getSystemColor((Device)d, 28));
        this.toolTipLabel.setBackground(Colors.getSystemColor((Device)d, 29));
        this.toolTipLabel.setText(sToolTip.replaceAll("&", "&&"));
        Point size = this.toolTipLabel.computeSize(-1, -1);
        if (size.x > 600) {
            size = this.toolTipLabel.computeSize(600, -1, true);
        }
        size.x += this.toolTipShell.getBorderWidth() * 2 + 2;
        size.y += this.toolTipShell.getBorderWidth() * 2;
        try {
            size.x += this.toolTipShell.getBorderWidth() * 2 + f.marginWidth * 2;
            size.y += this.toolTipShell.getBorderWidth() * 2 + f.marginHeight * 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        Point pt = this.tree.toDisplay(mousePos.x, mousePos.y);
        try {
            displayRect = this.tree.getMonitor().getClientArea();
        }
        catch (NoSuchMethodError e) {
            displayRect = this.tree.getDisplay().getClientArea();
        }
        if (pt.x + size.x > displayRect.x + displayRect.width) {
            pt.x = displayRect.x + displayRect.width - size.x;
        }
        pt.y = pt.y + size.y > displayRect.y + displayRect.height ? (pt.y -= size.y + 2) : (pt.y += 21);
        if (pt.y < displayRect.y) {
            pt.y = displayRect.y;
        }
        this.toolTipShell.setBounds(pt.x, pt.y, size.x, size.y);
        this.toolTipShell.setVisible(true);
    }

    private String getToolTip(Point mousePos_RelativeToItem) {
        List<MdiEntryVitalityImageSWT> vitalityImages = this.mdiEntry.getVitalityImages();
        for (MdiEntryVitalityImageSWT vitalityImage : vitalityImages) {
            Rectangle hitArea;
            String indicatorToolTip;
            if (vitalityImage == null || (indicatorToolTip = vitalityImage.getToolTip()) == null || !vitalityImage.isVisible() || (hitArea = vitalityImage.getHitArea()) == null || !hitArea.contains(mousePos_RelativeToItem)) continue;
            return indicatorToolTip;
        }
        if (this.mdiEntry.getViewTitleInfo() != null) {
            String tt = (String)this.mdiEntry.getViewTitleInfo().getTitleInfoProperty(1);
            return tt;
        }
        return null;
    }

    @Override
    public String getUpdateUIName() {
        return "SideBarToolTips";
    }

    @Override
    public void updateUI() {
        if (this.toolTipLabel == null || this.toolTipLabel.isDisposed()) {
            return;
        }
        if (this.mdiEntry == null || this.mdiEntry.getViewTitleInfo() == null) {
            return;
        }
        String sToolTip = this.getToolTip(this.lastRelMouseHoverPos);
        if (sToolTip == null) {
            return;
        }
        this.toolTipLabel.setText(sToolTip.replaceAll("&", "&&"));
    }
}

