/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.skin.sidebar;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MdiEntryVitalityImage;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.debug.ObfuscateImage;
import com.biglybt.ui.swt.debug.ObfuscateTab;
import com.biglybt.ui.swt.debug.UIDebugGenerator;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.mdi.BaseMdiEntry;
import com.biglybt.ui.swt.mdi.MdiEntryVitalityImageSWT;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import com.biglybt.ui.swt.skin.SWTSkinProperties;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.utils.SWTRunnable;
import com.biglybt.ui.swt.views.skin.InfoBarUtil;
import com.biglybt.ui.swt.views.skin.sidebar.SideBar;
import com.biglybt.util.MapUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class SideBarEntrySWT
extends BaseMdiEntry {
    private static final boolean DARK_MODE = Utils.isDarkAppearanceNative();
    private static final boolean PAINT_BG = !Constants.isUnix;
    private static final boolean DO_OUR_OWN_TREE_INDENT = true;
    private static final int EXPANDO_WIDTH = 12;
    private static int EXPANDO_INDENT;
    private static boolean DO_EXPANDO_INDENT;
    private static boolean COMPACT_SIDEBAR;
    private static int EXPANDO_LEFT_INDENT;
    private static int EXPANDO_INDENT_INITIAL;
    private static boolean IMAGELEFT_HIDDEN;
    private static final int SIDEBAR_SPACING = 2;
    private int IMAGELEFT_SIZE = 20;
    private int IMAGELEFT_GAP = 5;
    private static final boolean ALWAYS_IMAGE_GAP = true;
    private static int CLOSE_IMAGE_POSITION;
    private static final String SO_ID_TOOLBAR = "mdientry.toolbar.full";
    private TreeItem swtItem;
    private final SideBar sidebar;
    private int maxIndicatorWidth;
    private Image imgClose;
    private Image imgCloseSelected;
    private Color bg;
    private Color fg;
    private Color bgSel;
    private Color fgSel;
    private boolean showonSWTItemSet;
    private SWTSkinObjectContainer soParent;
    private boolean buildonSWTItemSet;
    private boolean selectable = true;
    private boolean neverPainted = true;
    private long attention_start = -1L;
    private boolean attention_flash_on;
    boolean isRedrawQueued = false;
    private InfoBarUtil toolBarInfoBar;

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Side Bar Indent Expanders", "Side Bar Compact View", "Side Bar Hide Left Icon"}, new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                boolean osx_standard;
                DO_EXPANDO_INDENT = COConfigurationManager.getBooleanParameter("Side Bar Indent Expanders");
                COMPACT_SIDEBAR = COConfigurationManager.getBooleanParameter("Side Bar Compact View");
                boolean bl = osx_standard = Constants.isOSX && !COMPACT_SIDEBAR;
                if (osx_standard) {
                    EXPANDO_INDENT = 15;
                } else {
                    EXPANDO_INDENT = 10;
                }
                EXPANDO_LEFT_INDENT = COMPACT_SIDEBAR ? 4 : (osx_standard ? 8 : 10);
                EXPANDO_INDENT_INITIAL = 12 + EXPANDO_LEFT_INDENT;
                IMAGELEFT_HIDDEN = COConfigurationManager.getBooleanParameter("Side Bar Hide Left Icon");
            }
        });
        CLOSE_IMAGE_POSITION = 0;
        COConfigurationManager.addAndFireParameterListener("Side Bar Close Position", new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                CLOSE_IMAGE_POSITION = COConfigurationManager.getIntParameter(name);
            }
        });
    }

    public SideBarEntrySWT(SideBar sidebar, SWTSkin _skin, String id) {
        super(sidebar, id);
        this.skin = _skin;
        this.sidebar = sidebar;
        this.updateColors();
    }

    protected void updateColors() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                SWTSkinProperties skinProperties = SideBarEntrySWT.this.skin.getSkinProperties();
                SideBarEntrySWT.this.bg = SideBarEntrySWT.this.sidebar.getBackground();
                SideBarEntrySWT.this.fg = skinProperties.getColor("color.sidebar." + (SideBarEntrySWT.this.isSelectable() ? "text" : "header"));
                SideBarEntrySWT.this.bgSel = skinProperties.getColor("color.sidebar.selected.bg");
                SideBarEntrySWT.this.fgSel = skinProperties.getColor("color.sidebar.selected.fg");
            }
        });
    }

    public TreeItem getTreeItem() {
        return this.swtItem;
    }

    public void setTreeItem(TreeItem treeItem) {
        if (this.swtItem != null && treeItem != null) {
            Debug.out("Warning: Sidebar " + this.id + " already has a treeitem");
            return;
        }
        this.swtItem = treeItem;
        if (treeItem != null) {
            MdiEntry parentEntry;
            ImageLoader imageLoader = ImageLoader.getInstance();
            this.imgClose = imageLoader.getImage("image.sidebar.closeitem");
            this.imgCloseSelected = imageLoader.getImage("image.sidebar.closeitem.selected");
            treeItem.addDisposeListener(e -> this.closeView());
            treeItem.getParent().addTreeListener(new TreeListener(){

                public void treeExpanded(TreeEvent e) {
                    if (e.item == SideBarEntrySWT.this.swtItem) {
                        SideBarEntrySWT.super.setExpanded(true);
                    }
                }

                public void treeCollapsed(TreeEvent e) {
                    if (e.item == SideBarEntrySWT.this.swtItem) {
                        SideBarEntrySWT.super.setExpanded(false);
                    }
                }
            });
            TreeItem parentItem = treeItem.getParentItem();
            if (parentItem != null && (parentEntry = (MdiEntry)parentItem.getData("MdiEntry")).isExpanded()) {
                parentItem.setExpanded(true);
            }
            this.setExpanded(this.isExpanded());
        }
        if (this.buildonSWTItemSet) {
            this.build();
        }
        if (this.showonSWTItemSet) {
            this.show();
        }
    }

    public MdiEntryVitalityImage getVitalityImage(int hitX, int hitY) {
        List<MdiEntryVitalityImageSWT> vitalityImages = this.getVitalityImages();
        for (MdiEntryVitalityImageSWT vitalityImage : vitalityImages) {
            Rectangle hitArea;
            if (!vitalityImage.isVisible() || (hitArea = vitalityImage.getHitArea()) == null || !hitArea.contains(hitX, hitY)) continue;
            return vitalityImage;
        }
        return null;
    }

    @Override
    public void requestAttention() {
        this.attention_start = SystemTime.getMonotonousTime();
        this.sidebar.requestAttention(this);
    }

    protected boolean attentionUpdate(int ticks) {
        if (this.attention_start == -1L || SystemTime.getMonotonousTime() - this.attention_start > 5000L) {
            this.attention_start = -1L;
            return false;
        }
        this.attention_flash_on = ticks % 2 == 0;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redraw() {
        if (this.neverPainted) {
            return;
        }
        SideBarEntrySWT sideBarEntrySWT = this;
        synchronized (sideBarEntrySWT) {
            if (this.isRedrawQueued) {
                return;
            }
            this.isRedrawQueued = true;
        }
        Utils.execSWTThreadLater(0, new SWTRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runWithDisplay(Display display) {
                SideBarEntrySWT sideBarEntrySWT = SideBarEntrySWT.this;
                synchronized (sideBarEntrySWT) {
                    SideBarEntrySWT.this.isRedrawQueued = false;
                }
                if (SideBarEntrySWT.this.swtItem == null || SideBarEntrySWT.this.swtItem.isDisposed()) {
                    return;
                }
                Tree tree = SideBarEntrySWT.this.swtItem.getParent();
                if (!tree.isVisible()) {
                    return;
                }
                if (Utils.isGTK3) {
                    try {
                        Method m = SideBarEntrySWT.this.swtItem.getClass().getDeclaredMethod("clear", new Class[0]);
                        m.setAccessible(true);
                        m.invoke((Object)SideBarEntrySWT.this.swtItem, new Object[0]);
                    }
                    catch (Throwable m) {}
                } else {
                    try {
                        Rectangle bounds = SideBarEntrySWT.this.swtItem.getBounds();
                        Rectangle treeBounds = tree.getBounds();
                        tree.redraw(0, bounds.y, treeBounds.width, bounds.height, true);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    protected Rectangle swt_getBounds() {
        if (this.swtItem == null || this.swtItem.isDisposed()) {
            return null;
        }
        try {
            Tree tree = this.swtItem.getParent();
            Rectangle bounds = this.swtItem.getBounds();
            Rectangle treeBounds = tree.getClientArea();
            return new Rectangle(0, bounds.y, treeBounds.width, bounds.height);
        }
        catch (NullPointerException e) {
            Debug.outNoStack("NPE @ " + Debug.getCompressedStackTrace(), true);
        }
        catch (Exception e) {
            Debug.out(e);
        }
        return null;
    }

    @Override
    public void setExpanded(final boolean expanded) {
        super.setExpanded(expanded);
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SideBarEntrySWT.this.swtItem != null && !SideBarEntrySWT.this.isEntryDisposed()) {
                    SideBarEntrySWT.this.swtItem.setExpanded(expanded);
                }
            }
        });
    }

    @Override
    protected void destroyEntry(boolean userInitiated) {
        if (Utils.runIfNotSWTThread(() -> this.destroyEntry(userInitiated))) {
            return;
        }
        if (this.swtItem == null) {
            this.destroyEntryAlways();
            return;
        }
        TreeItem item = this.swtItem;
        this.swtItem = null;
        super.destroyEntry(userInitiated);
        try {
            if (!item.isDisposed()) {
                item.dispose();
            }
            ImageLoader imageLoader = ImageLoader.getInstance();
            imageLoader.releaseImage("image.sidebar.closeitem");
            imageLoader.releaseImage("image.sidebar.closeitem-selected");
        }
        catch (Exception e) {
            Debug.outNoStack("Warning on SidebarEntry dispose: " + e.toString(), false);
        }
    }

    @Override
    public void build() {
        Utils.execSWTThread(this::swt_build);
    }

    public boolean swt_build() {
        if (this.swtItem == null) {
            this.buildonSWTItemSet = true;
            return true;
        }
        this.buildonSWTItemSet = false;
        SWTSkinObject so = this.getSkinObject();
        if (so != null && !so.isDisposed()) {
            return true;
        }
        Control control = null;
        Shell parent = this.soParent == null ? Utils.findAnyShell() : this.soParent.getComposite();
        String skinRef = this.getSkinRef();
        if (skinRef != null) {
            Shell shell = parent.getShell();
            Cursor cursor = shell.getCursor();
            try {
                shell.setCursor(shell.getDisplay().getSystemCursor(1));
                SWTSkinObjectContainer soContents = (SWTSkinObjectContainer)this.skin.createSkinObject("MdiContents." + uniqueNumber++, "mdi.content.item", this.getParentSkinObject(), null);
                SWTSkinObject skinObject = this.skin.createSkinObject(this.id, skinRef, soContents, this.getDatasourceCore());
                control = skinObject.getControl();
                control.setLayoutData((Object)Utils.getFilledFormData());
                control.getParent().layout(true, true);
                this.setPluginSkinObject(skinObject);
                this.initialize((Composite)control);
                this.setSkinObjectMaster(soContents);
            }
            finally {
                shell.setCursor(cursor);
            }
        }
        try {
            SWTSkinObjectContainer soContents = (SWTSkinObjectContainer)this.skin.createSkinObject("MdiIView." + uniqueNumber++, "mdi.content.item", this.getParentSkinObject());
            parent.setBackgroundMode(0);
            Composite viewComposite = soContents.getComposite();
            boolean doGridLayout = true;
            if (this.getControlType() == 257) {
                doGridLayout = false;
            }
            if (doGridLayout) {
                GridLayout gridLayout = new GridLayout();
                gridLayout.marginWidth = 0;
                gridLayout.marginHeight = 0;
                gridLayout.verticalSpacing = 0;
                gridLayout.horizontalSpacing = 0;
                viewComposite.setLayout((Layout)gridLayout);
                viewComposite.setLayoutData((Object)Utils.getFilledFormData());
            }
            this.setPluginSkinObject(soContents);
            this.initialize(viewComposite);
            String fullTitle = this.getFullTitle();
            if (fullTitle != null && PAINT_BG) {
                this.swtItem.setText(this.getFullTitle());
            }
            Composite iviewComposite = this.getComposite();
            control = iviewComposite;
            if (doGridLayout) {
                Object existingLayoutData = iviewComposite.getLayoutData();
                Object existingParentLayoutData = iviewComposite.getParent().getLayoutData();
                if (existingLayoutData == null || !(existingLayoutData instanceof GridData) && existingParentLayoutData instanceof GridLayout) {
                    GridData gridData = new GridData(1808);
                    iviewComposite.setLayoutData((Object)gridData);
                }
            }
            parent.layout(true, true);
            this.setSkinObjectMaster(soContents);
        }
        catch (Exception e) {
            Debug.out("Error creating sidebar content area for " + this.id, e);
            this.closeView();
        }
        if (control == null || control.isDisposed()) {
            return false;
        }
        control.setData("BaseMDIEntry", (Object)this);
        return true;
    }

    @Override
    public boolean isEntryDisposed() {
        return this.swtItem == null || this.swtItem.isDisposed();
    }

    @Override
    public void show() {
        Utils.execSWTThreadLater(0, new AERunnable(){

            @Override
            public void runSupport() {
                SideBarEntrySWT.this.swt_show();
            }
        });
    }

    private void swt_show() {
        if (this.swtItem == null) {
            this.showonSWTItemSet = true;
            return;
        }
        this.showonSWTItemSet = false;
        if (!this.swt_build()) {
            return;
        }
        this.triggerOpenListeners();
        Tree tree = this.swtItem.getParent();
        tree.showItem(this.swtItem);
        tree.select(this.swtItem);
        if (Constants.isOSX) {
            tree.redraw();
        }
        super.show();
    }

    @Override
    public void hide() {
        Utils.execSWTThreadLater(0, new AERunnable(){

            @Override
            public void runSupport() {
                SideBarEntrySWT.super.hide();
            }
        });
    }

    protected void swt_paintSideBar(Event event2) {
        Rectangle clipping;
        String suffix;
        Image imageLeft;
        Object active_state;
        Rectangle closeArea;
        Image img;
        int x1IndicatorOfs;
        String text;
        this.neverPainted = false;
        TreeItem treeItem = (TreeItem)event2.item;
        if (treeItem.isDisposed() || this.isEntryDisposed()) {
            return;
        }
        Rectangle itemBounds = treeItem.getBounds();
        Rectangle drawBounds = event2.gc.getClipping();
        if (drawBounds.isEmpty()) {
            drawBounds = event2.getBounds();
        }
        Rectangle treeArea = treeItem.getParent().getClientArea();
        if (Utils.isGTK3) {
            if (treeArea.width > itemBounds.width) {
                itemBounds.width = treeArea.width;
            }
            if (treeArea.x < itemBounds.x) {
                itemBounds.x = treeArea.x;
            }
            drawBounds = itemBounds;
        }
        if ((text = this.getTitle()) == null) {
            text = "";
        }
        GC gc = event2.gc;
        gc.setAntialias(1);
        gc.setAdvanced(true);
        Utils.setClipping(gc, null);
        boolean selected = (event2.detail & 2) > 0;
        Color fgText = this.swt_paintEntryBG(event2.detail, gc, drawBounds);
        Color entryBG = gc.getBackground();
        Tree tree = (Tree)event2.widget;
        Font font = tree.getFont();
        if (font != null && !font.isDisposed()) {
            gc.setFont(font);
        }
        if (SideBar.USE_NATIVE_EXPANDER && Utils.isGTK3) {
            itemBounds.x = treeItem.getBounds().x;
        } else {
            TreeItem tempItem = treeItem.getParentItem();
            int indent = tempItem == null && !Utils.isGTK ? EXPANDO_INDENT_INITIAL : (DO_EXPANDO_INDENT ? EXPANDO_INDENT_INITIAL : EXPANDO_LEFT_INDENT);
            while (tempItem != null) {
                indent += EXPANDO_INDENT;
                tempItem = tempItem.getParentItem();
            }
            if (SideBar.USE_NATIVE_EXPANDER && Utils.isGTK) {
                indent += 5;
            }
            if ((treeItem.getItemCount() <= 0 || SideBar.USE_NATIVE_EXPANDER) && COMPACT_SIDEBAR) {
                indent -= EXPANDO_INDENT / 2;
            }
            itemBounds.x = indent;
        }
        int x0IndicatorOfs = itemBounds.x;
        if (CLOSE_IMAGE_POSITION == 2) {
            x1IndicatorOfs = 0;
        } else if (CLOSE_IMAGE_POSITION == 1) {
            x1IndicatorOfs = 0;
            if (this.isCloseable()) {
                img = selected ? this.imgCloseSelected : this.imgClose;
                closeArea = img.getBounds();
                closeArea.x = treeArea.width - closeArea.width - 2 - x1IndicatorOfs;
                closeArea.y = itemBounds.y + (itemBounds.height - closeArea.height) / 2;
                x1IndicatorOfs += closeArea.width + 2;
                gc.drawImage(img, closeArea.x, closeArea.y);
                treeItem.setData("closeArea", (Object)closeArea);
            } else {
                x1IndicatorOfs += this.imgClose.getBounds().width + 2;
            }
        } else {
            x1IndicatorOfs = 2;
        }
        if (this.viewTitleInfo != null) {
            String textIndicator = null;
            try {
                textIndicator = (String)this.viewTitleInfo.getTitleInfoProperty(0);
            }
            catch (Exception e) {
                Debug.out(e);
            }
            if (textIndicator != null) {
                Point textSize = gc.textExtent(textIndicator);
                int width = textSize.x + 10;
                int startX = treeArea.width - (x1IndicatorOfs += width + 2);
                int textOffsetY = 0;
                int height = textSize.y + 1;
                int startY = itemBounds.y + (itemBounds.height - height) / 2;
                Color default_color = ColorCache.getSchemedColor(gc.getDevice(), "#5b6e87");
                Object color = this.viewTitleInfo.getTitleInfoProperty(8);
                if (color instanceof int[]) {
                    default_color = ColorCache.getColor(gc.getDevice(), (int[])color);
                }
                gc.setBackground(default_color);
                Color text_color = Colors.white;
                gc.fillRoundRectangle(startX, startY, width, height, textSize.y * 2 / 3, height * 2 / 3);
                if (color != null) {
                    boolean useBlack = Colors.isBlackTextReadable(gc.getBackground());
                    if (useBlack) {
                        text_color = Colors.black;
                        gc.setForeground(text_color);
                    } else {
                        gc.setForeground(default_color);
                    }
                    gc.drawRoundRectangle(startX, startY, width, height, textSize.y * 2 / 3, height * 2 / 3);
                }
                if (this.maxIndicatorWidth > width) {
                    this.maxIndicatorWidth = width;
                }
                gc.setForeground(text_color);
                if (Constants.isOSX) {
                    textIndicator = "\u200b" + textIndicator;
                }
                GCStringPrinter.printString(gc, textIndicator, new Rectangle(startX, startY + textOffsetY, width, height), true, false, 0x1000000);
            }
        }
        if (CLOSE_IMAGE_POSITION == 0 && this.isCloseable()) {
            img = selected ? this.imgCloseSelected : this.imgClose;
            closeArea = img.getBounds();
            closeArea.x = treeArea.width - closeArea.width - 2 - x1IndicatorOfs;
            closeArea.y = itemBounds.y + (itemBounds.height - closeArea.height) / 2;
            x1IndicatorOfs += closeArea.width + 2;
            gc.drawImage(img, closeArea.x, closeArea.y);
            treeItem.setData("closeArea", (Object)closeArea);
        }
        List<MdiEntryVitalityImageSWT> vitalityImages = this.getVitalityImages();
        for (MdiEntryVitalityImageSWT vitalityImage : vitalityImages) {
            if (vitalityImage == null || !vitalityImage.isVisible() || vitalityImage.getAlignment() != 131072) continue;
            vitalityImage.switchSuffix(selected ? "-selected" : "");
            Image image = vitalityImage.getImage();
            if (image == null || image.isDisposed()) continue;
            Rectangle bounds = image.getBounds();
            bounds.x = treeArea.width - bounds.width - 2 - x1IndicatorOfs;
            bounds.y = itemBounds.y + (itemBounds.height - bounds.height) / 2;
            x1IndicatorOfs += bounds.width + 2;
            gc.drawImage(image, bounds.x, bounds.y);
            bounds.y -= itemBounds.y;
            vitalityImage.setHitArea(bounds);
        }
        boolean greyScale = false;
        if (this.viewTitleInfo != null && (active_state = this.viewTitleInfo.getTitleInfoProperty(9)) instanceof Long) {
            greyScale = (Long)active_state == 2L;
        }
        if ((imageLeft = this.getImageLeft(suffix = selected ? "-selected" : null)) == null && selected) {
            this.releaseImageLeft(suffix);
            suffix = null;
            imageLeft = this.getImageLeft(null);
        }
        treeItem.setData("contentStartOffset", (Object)x0IndicatorOfs);
        if (!IMAGELEFT_HIDDEN) {
            if (imageLeft != null) {
                Rectangle clipping2 = gc.getClipping();
                Utils.setClipping(gc, new Rectangle(x0IndicatorOfs, itemBounds.y, this.IMAGELEFT_SIZE, itemBounds.height));
                if (greyScale) {
                    Image grey;
                    greyScale = false;
                    String imageLeftID = this.getImageLeftID();
                    if (imageLeftID != null && (grey = ImageLoader.getInstance().getImage(String.valueOf(imageLeftID) + "-gray")) != null) {
                        imageLeft = grey;
                        gc.setAlpha(160);
                        greyScale = true;
                    }
                }
                Rectangle bounds = imageLeft.getBounds();
                int w = bounds.width;
                int h = bounds.height;
                if (w > this.IMAGELEFT_SIZE) {
                    float pct = (float)this.IMAGELEFT_SIZE / (float)w;
                    w = this.IMAGELEFT_SIZE;
                    h = (int)((float)h * pct);
                }
                int x = x0IndicatorOfs + (this.IMAGELEFT_SIZE - w) / 2;
                int y = itemBounds.y + (itemBounds.height - h) / 2;
                gc.setAdvanced(true);
                gc.setInterpolation(2);
                gc.drawImage(imageLeft, 0, 0, bounds.width, bounds.height, x, y, w, h);
                if (greyScale) {
                    String imageLeftID = this.getImageLeftID();
                    gc.setAlpha(255);
                    ImageLoader.getInstance().releaseImage(String.valueOf(imageLeftID) + "-gray");
                }
                Utils.setClipping(gc, clipping2);
                x0IndicatorOfs += this.IMAGELEFT_SIZE + this.IMAGELEFT_GAP;
                this.releaseImageLeft(suffix);
            } else if (this.isSelectable()) {
                x0IndicatorOfs += this.IMAGELEFT_SIZE + this.IMAGELEFT_GAP;
            }
        }
        if (drawBounds.intersects(clipping = new Rectangle(x0IndicatorOfs, itemBounds.y, treeArea.width - x1IndicatorOfs - 2 - x0IndicatorOfs, itemBounds.height))) {
            int style;
            if (DARK_MODE) {
                Font headerFont;
                style = 0;
                if (!this.isSelectable()) {
                    Font headerFont2 = this.sidebar.getHeaderFont();
                    if (headerFont2 != null && !headerFont2.isDisposed()) {
                        gc.setFont(headerFont2);
                    }
                } else if ((treeItem.getItemCount() > 0 || this.id.equals("header.dashboard")) && (headerFont = this.sidebar.getHeaderFont()) != null && !headerFont.isDisposed()) {
                    gc.setFont(headerFont);
                }
                gc.setForeground(Colors.white);
                GCStringPrinter sp = new GCStringPrinter(gc, text, clipping, true, false, style);
                sp.printString();
                clipping.x += sp.getCalculatedSize().x + 5;
            } else {
                Font headerFont;
                boolean forceWhite;
                style = 0;
                boolean bl = forceWhite = !Colors.isBlackTextReadable(entryBG);
                if (forceWhite) {
                    fgText = Colors.white;
                }
                if (!this.isSelectable()) {
                    Font headerFont3 = this.sidebar.getHeaderFont();
                    if (headerFont3 != null && !headerFont3.isDisposed()) {
                        gc.setFont(headerFont3);
                    }
                    if (!forceWhite) {
                        gc.setForeground(ColorCache.getColor(gc.getDevice(), 255, 255, 255));
                        gc.setAlpha(100);
                        ++clipping.x;
                        ++clipping.y;
                        GCStringPrinter sp = new GCStringPrinter(gc, text, clipping, true, false, style);
                        sp.printString();
                        gc.setAlpha(255);
                        --clipping.x;
                        --clipping.y;
                    }
                } else if ((treeItem.getItemCount() > 0 || this.id.equals("header.dashboard")) && (headerFont = this.sidebar.getHeaderFont()) != null && !headerFont.isDisposed()) {
                    gc.setFont(headerFont);
                }
                gc.setForeground(fgText);
                GCStringPrinter sp = new GCStringPrinter(gc, text, clipping, true, false, style);
                sp.printString();
                clipping.x += sp.getCalculatedSize().x + 5;
            }
        }
        for (MdiEntryVitalityImageSWT vitalityImage : vitalityImages) {
            if (!vitalityImage.isVisible() || vitalityImage.getAlignment() != 16384) continue;
            vitalityImage.switchSuffix(selected ? "-selected" : "");
            Image image = vitalityImage.getImage();
            if (image == null || image.isDisposed()) continue;
            Rectangle bounds = image.getBounds();
            bounds.x = clipping.x;
            bounds.y = itemBounds.y + (itemBounds.height - bounds.height) / 2;
            clipping.x += bounds.width + 2;
            if (clipping.x > treeArea.width - x1IndicatorOfs) {
                vitalityImage.setHitArea(null);
                continue;
            }
            gc.drawImage(image, bounds.x, bounds.y);
            vitalityImage.setHitArea(bounds);
        }
        if (treeItem.getItemCount() > 0 && !SideBar.USE_NATIVE_EXPANDER) {
            gc.setAntialias(1);
            Color oldBG = gc.getBackground();
            gc.setBackground(Colors.getSystemColor((Device)event2.display, 24));
            int baseX = DO_EXPANDO_INDENT ? itemBounds.x : EXPANDO_INDENT_INITIAL;
            int xStart = 12;
            int arrowSize = 8;
            int yStart = itemBounds.height - (itemBounds.height + arrowSize) / 2;
            treeItem.setData("expandoRHS", (Object)(baseX - xStart + arrowSize));
            if (treeItem.getExpanded()) {
                gc.fillPolygon(new int[]{baseX - xStart, itemBounds.y + yStart, baseX - xStart + arrowSize, itemBounds.y + yStart, baseX - xStart + arrowSize / 2, itemBounds.y + yStart + arrowSize});
            } else {
                gc.fillPolygon(new int[]{baseX - xStart, itemBounds.y + yStart, baseX - xStart + arrowSize, itemBounds.y + yStart + 4, baseX - xStart, itemBounds.y + yStart + 8});
            }
            gc.setBackground(oldBG);
            Font headerFont = this.sidebar.getHeaderFont();
            if (headerFont != null && !headerFont.isDisposed()) {
                gc.setFont(headerFont);
            }
        }
    }

    protected Color swt_paintEntryBG(int detail, GC gc, Rectangle drawBounds) {
        boolean hot;
        this.neverPainted = false;
        Color fgText = Colors.black;
        boolean selected = (detail & 2) > 0;
        boolean bl = hot = (detail & 0x20) > 0;
        if (selected) {
            this.attention_start = -1L;
        } else if (this.attention_start != -1L && this.attention_flash_on) {
            selected = true;
        }
        if (selected) {
            if (!PAINT_BG) {
                fgText = gc.getForeground();
            } else {
                Utils.setClipping(gc, null);
                if (this.fgSel != null) {
                    fgText = this.fgSel;
                }
                if (this.bgSel != null) {
                    gc.setBackground(this.bgSel);
                }
                if (Utils.isDarkAppearanceNativeWindows()) {
                    if (this.sidebar.getTree().isFocusControl()) {
                        gc.setBackground(Colors.getSystemColor(gc.getDevice(), 20));
                    } else {
                        gc.setBackground(Colors.getSystemColor(gc.getDevice(), 19));
                    }
                    gc.fillRectangle(drawBounds.x, drawBounds.y, drawBounds.width, drawBounds.height);
                } else {
                    Color color2;
                    Color color1;
                    if (this.sidebar.getTree().isFocusControl()) {
                        color1 = ColorCache.getSchemedColor(gc.getDevice(), "#166688");
                        color2 = ColorCache.getSchemedColor(gc.getDevice(), "#1c2458");
                    } else {
                        color1 = ColorCache.getSchemedColor(gc.getDevice(), "#447281");
                        color2 = ColorCache.getSchemedColor(gc.getDevice(), "#393e58");
                    }
                    gc.setBackground(color1);
                    gc.fillRectangle(drawBounds.x, drawBounds.y, drawBounds.width, 4);
                    Rectangle itemBounds = this.swt_getBounds();
                    if (itemBounds == null) {
                        return fgText;
                    }
                    if (Utils.gradientFillSelection()) {
                        gc.setForeground(color1);
                        gc.setBackground(color2);
                        gc.fillGradientRectangle(drawBounds.x, itemBounds.y + 3, drawBounds.width, itemBounds.height - 3, true);
                    } else {
                        gc.fillRectangle(drawBounds.x, itemBounds.y + 3, drawBounds.width, itemBounds.height - 3);
                    }
                }
            }
        } else {
            Color c;
            if (this.fg != null) {
                fgText = this.fg;
            }
            if (this.bg != null) {
                gc.setBackground(this.bg);
            }
            if (this == this.sidebar.draggingOver || hot) {
                if (Utils.isDarkAppearanceNativeWindows()) {
                    gc.setBackground(Colors.getSystemColor(gc.getDevice(), 18));
                } else {
                    c = this.skin.getSkinProperties().getColor("color.sidebar.drag.bg");
                    gc.setBackground(c);
                }
            }
            if (PAINT_BG) {
                gc.fillRectangle(drawBounds);
            }
            if (this == this.sidebar.draggingOver) {
                c = this.skin.getSkinProperties().getColor("color.sidebar.drag.fg");
                gc.setForeground(c);
                int line_width = 2;
                gc.setLineWidth(2);
                Rectangle temp = new Rectangle(drawBounds.x + 2, drawBounds.y + 2, drawBounds.width - 4, drawBounds.height - 4);
                gc.drawRectangle(temp);
            }
        }
        return fgText;
    }

    public void setParentSkinObject(SWTSkinObjectContainer soParent) {
        this.soParent = soParent;
    }

    public SWTSkinObjectContainer getParentSkinObject() {
        return this.soParent;
    }

    @Override
    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
        this.updateColors();
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    public boolean swt_isVisible() {
        MdiEntry parentEntry;
        TreeItem parentItem = this.swtItem.getParentItem();
        return parentItem == null || (parentEntry = (MdiEntry)parentItem.getData("MdiEntry")).isExpanded();
    }

    @Override
    public Image obfuscatedImage(Image image) {
        Rectangle bounds = this.swt_getBounds();
        if (bounds != null) {
            String header;
            TreeItem treeItem = this.getTreeItem();
            Point location = Utils.getLocationRelativeToShell((Control)treeItem.getParent());
            bounds.x += location.x;
            bounds.y += location.y;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("image", image);
            map.put("obfuscateTitle", false);
            this.triggerEvent(9, map);
            if (this.viewTitleInfo instanceof ObfuscateImage) {
                ((ObfuscateImage)((Object)this.viewTitleInfo)).obfuscatedImage(image);
            }
            int ofs = this.IMAGELEFT_GAP + this.IMAGELEFT_SIZE;
            if (treeItem.getParentItem() != null) {
                ofs += 12;
            }
            bounds.x += ofs;
            bounds.width -= ofs + 2 + 1;
            --bounds.height;
            if (this.viewTitleInfo instanceof ObfuscateTab && (header = ((ObfuscateTab)((Object)this.viewTitleInfo)).getObfuscatedHeader()) != null) {
                UIDebugGenerator.obfuscateArea(image, bounds, header);
            }
            if (MapUtils.getMapBoolean(map, "obfuscateTitle", false)) {
                UIDebugGenerator.obfuscateArea(image, bounds);
            }
        }
        return image;
    }

    @Override
    protected void setToolbarVisibility(boolean visible) {
        if (this.toolBarInfoBar != null && !this.toolBarInfoBar.getParentSkinObject().isDisposed()) {
            if (visible) {
                this.toolBarInfoBar.show();
            } else {
                this.toolBarInfoBar.hide(false);
            }
            return;
        }
        SWTSkinObject soMaster = this.getSkinObjectMaster();
        if (soMaster == null) {
            return;
        }
        SWTSkinObject so = this.getSkinObject();
        if (so == null) {
            return;
        }
        SWTSkinObject soToolbar = this.skin.getSkinObject("view-toolbar", soMaster);
        if (soToolbar == null && visible) {
            this.toolBarInfoBar = new InfoBarUtil(so, SO_ID_TOOLBAR, true, "", ""){

                @Override
                public boolean allowShow() {
                    return true;
                }
            };
        } else if (soToolbar != null) {
            soToolbar.setVisible(visible);
        }
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        this.refreshTitle();
    }

    @Override
    protected void refreshTitle() {
        if (!PAINT_BG) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SideBarEntrySWT.this.swtItem == null || SideBarEntrySWT.this.swtItem.isDisposed()) {
                    return;
                }
                String title = SideBarEntrySWT.this.getTitle();
                if (!SideBarEntrySWT.this.swtItem.getText().equals(title)) {
                    SideBarEntrySWT.this.swtItem.setText(title);
                    SideBarEntrySWT.this.redraw();
                }
            }
        });
    }

    @Override
    public void redraw(Rectangle hitArea) {
        if (Utils.runIfNotSWTThread(() -> this.redraw(hitArea))) {
            return;
        }
        if (this.swtItem == null || this.swtItem.isDisposed() || !this.swt_isVisible()) {
            return;
        }
        if (Utils.isGTK3) {
            try {
                Method m = this.swtItem.getClass().getDeclaredMethod("clear", new Class[0]);
                m.setAccessible(true);
                m.invoke((Object)this.swtItem, new Object[0]);
            }
            catch (Throwable m) {}
        } else {
            Tree parent = this.swtItem.getParent();
            parent.redraw(hitArea.x, hitArea.y + this.swtItem.getBounds().y, hitArea.width, hitArea.height, true);
            parent.update();
        }
    }
}

