/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.skin;

import com.biglybt.activities.ActivitiesEntry;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerEnhancer;
import com.biglybt.core.download.EnhancedDownloadManager;
import com.biglybt.core.download.StreamManager;
import com.biglybt.core.download.StreamManagerDownload;
import com.biglybt.core.download.StreamManagerDownloadListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.torrent.PlatformTorrentUtils;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.LaunchManager;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.core.vuzefile.VuzeFile;
import com.biglybt.core.vuzefile.VuzeFileHandler;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.ui.UserPrompterResultListener;
import com.biglybt.ui.selectedcontent.DownloadUrlInfo;
import com.biglybt.ui.selectedcontent.ISelectedContent;
import com.biglybt.ui.swt.TextViewerWindow;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.player.PlayerInstallWindow;
import com.biglybt.ui.swt.player.PlayerInstaller;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import com.biglybt.ui.swt.utils.TorrentUIUtilsV3;
import com.biglybt.ui.swt.views.skin.VuzeMessageBox;
import com.biglybt.ui.swt.views.skin.VuzeMessageBoxListener;
import com.biglybt.util.DataSourceUtils;
import com.biglybt.util.PlayUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TorrentListViewsUtils {
    private static StreamManagerDownload current_stream;
    private static TextViewerWindow stream_viewer;
    private static boolean emp_installing;

    public static void playOrStreamDataSource(Object ds, boolean launch_already_checked) {
        String referal = "unknown";
        if (ds instanceof ActivitiesEntry) {
            referal = "playdashboardactivity";
        } else if (ds instanceof DownloadManager) {
            referal = "playdownloadmanager";
        } else if (ds instanceof ISelectedContent) {
            referal = "selectedcontent";
        }
        TorrentListViewsUtils.playOrStreamDataSource(ds, referal, launch_already_checked, true);
    }

    public static void playOrStreamDataSource(Object ds, String referal, boolean launch_already_checked, boolean complete_only) {
        com.biglybt.core.disk.DiskManagerFileInfo fileInfo2 = DataSourceUtils.getFileInfo(ds);
        if (fileInfo2 != null) {
            TorrentListViewsUtils.playOrStream(fileInfo2.getDownloadManager(), fileInfo2.getIndex(), complete_only, launch_already_checked, referal);
        } else {
            DownloadManager dm = DataSourceUtils.getDM(ds);
            if (dm == null) {
                TorrentListViewsUtils.downloadDataSource(ds, true, referal);
            } else {
                TorrentListViewsUtils.playOrStream(dm, -1, complete_only, launch_already_checked, referal);
            }
        }
    }

    public static void downloadDataSource(Object ds, boolean playNow, String referal) {
        TOTorrent torrent = DataSourceUtils.getTorrent(ds);
        if (torrent != null) {
            try {
                Map torrent_map = torrent.serialiseToMap();
                torrent_map.remove("info");
                VuzeFile vf = VuzeFileHandler.getSingleton().loadVuzeFile(torrent_map);
                if (vf != null) {
                    VuzeFileHandler.getSingleton().handleFiles(new VuzeFile[]{vf}, 0);
                    return;
                }
            }
            catch (Throwable torrent_map) {
                // empty catch block
            }
        }
        if (torrent != null) {
            TorrentUIUtilsV3.addTorrentToGM(torrent);
        } else {
            DownloadUrlInfo dlInfo = DataSourceUtils.getDownloadInfo(ds);
            if (dlInfo != null) {
                TorrentUIUtilsV3.loadTorrent(dlInfo, playNow, false, true);
                return;
            }
            String hash = DataSourceUtils.getHash(ds);
            if (hash != null) {
                dlInfo = new DownloadUrlInfo(UrlUtils.parseTextForMagnets(hash));
                dlInfo.setReferer(referal);
                TorrentUIUtilsV3.loadTorrent(dlInfo, playNow, false, true);
                return;
            }
        }
    }

    public static void playOrStream(DownloadManager dm, int file_index, boolean complete_only, boolean launch_already_checked) {
        TorrentListViewsUtils.playOrStream(dm, file_index, complete_only, launch_already_checked, null);
    }

    private static void playOrStream(final DownloadManager dm, final int file_index, final boolean complete_only, boolean launch_already_checked, final String referal) {
        if (dm == null) {
            return;
        }
        if (launch_already_checked) {
            TorrentListViewsUtils._playOrStream(dm, file_index, complete_only, referal);
        } else {
            LaunchManager launch_manager = LaunchManager.getManager();
            LaunchManager.LaunchTarget target = launch_manager.createTarget(dm);
            launch_manager.launchRequest(target, new LaunchManager.LaunchAction(){

                @Override
                public void actionAllowed() {
                    Utils.execSWTThread(new Runnable(){

                        @Override
                        public void run() {
                            TorrentListViewsUtils._playOrStream(dm, file_index, complete_only, referal);
                        }
                    });
                }

                @Override
                public void actionDenied(Throwable reason) {
                    Debug.out("Launch request denied", reason);
                }
            });
        }
    }

    private static void _playOrStream(final DownloadManager dm, int file_index, final boolean complete_only, final String referal) {
        if (dm == null) {
            return;
        }
        TOTorrent torrent = dm.getTorrent();
        if (torrent == null) {
            return;
        }
        if (file_index == -1) {
            final int[] playableFileIndexes = PlayUtils.getExternallyPlayableFileIndexes(PluginCoreUtils.wrap(dm), complete_only);
            if (playableFileIndexes.length == 1) {
                int open_result = TorrentListViewsUtils.openInEMP(dm, file_index, complete_only, referal);
                if (open_result == 0) {
                    PlatformTorrentUtils.setHasBeenOpened(dm, true);
                }
            } else if (playableFileIndexes.length > 1) {
                VuzeMessageBox mb = new VuzeMessageBox(MessageText.getString("ConfigView.option.dm.dblclick.play"), null, new String[]{MessageText.getString("iconBar.play"), MessageText.getString("Button.cancel")}, 0);
                final HashMap mapPositionToFileInfo = new HashMap();
                final int[] selectedIndex = new int[1];
                mb.setSubTitle(MessageText.getString("play.select.content"));
                mb.setListener(new VuzeMessageBoxListener(){

                    @Override
                    public void shellReady(Shell shell, SWTSkinObjectContainer soExtra) {
                        SWTSkin skin = soExtra.getSkin();
                        Composite composite = soExtra.getComposite();
                        final Table table = new Table(composite, 66308);
                        table.setBackground(composite.getBackground());
                        table.addSelectionListener(new SelectionListener(){

                            public void widgetSelected(SelectionEvent e) {
                                selectedIndex[0] = table.getSelectionIndex();
                            }

                            public void widgetDefaultSelected(SelectionEvent e) {
                            }
                        });
                        FormData formData = Utils.getFilledFormData();
                        formData.bottom.offset = -20;
                        table.setLayoutData((Object)formData);
                        table.setHeaderVisible(false);
                        table.addListener(41, new Listener(){

                            public void handleEvent(Event event2) {
                                int w = table.getClientArea().width - 5;
                                if (w == 0) {
                                    return;
                                }
                                if (event2.width < w) {
                                    event2.width = w;
                                }
                            }
                        });
                        String prefix = dm.getSaveLocation().toString();
                        int i = 0;
                        com.biglybt.core.disk.DiskManagerFileInfo[] fileInfos = dm.getDiskManagerFileInfoSet().getFiles();
                        int[] nArray = playableFileIndexes;
                        int n = playableFileIndexes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int fileIndex = nArray[n2];
                            if (fileIndex >= 0 && fileIndex < fileInfos.length) {
                                File f = fileInfos[fileIndex].getFile(true);
                                String path = f.getParent();
                                if (path.startsWith(prefix)) {
                                    path = path.length() > prefix.length() ? path.substring(prefix.length() + 1) : "";
                                }
                                String s = f.getName();
                                if (path.length() > 0) {
                                    s = String.valueOf(s) + " in " + path;
                                }
                                TableItem item = new TableItem(table, 0);
                                item.setText(s);
                                mapPositionToFileInfo.put(i++, fileIndex);
                            }
                            ++n2;
                        }
                        Image alphaImage = Utils.createAlphaImage((Device)table.getDisplay(), 1, 25, (byte)-1);
                        TableItem item = table.getItem(0);
                        item.setImage(alphaImage);
                        item.setImage(null);
                        alphaImage.dispose();
                        table.setSelection(0);
                    }
                });
                mb.open(new UserPrompterResultListener(){

                    @Override
                    public void prompterClosed(int result) {
                        int open_result;
                        if (result != 0 || selectedIndex[0] < 0) {
                            return;
                        }
                        Integer file_index = (Integer)mapPositionToFileInfo.get(selectedIndex[0]);
                        if (file_index != null && (open_result = TorrentListViewsUtils.openInEMP(dm, file_index, complete_only, referal)) == 0) {
                            PlatformTorrentUtils.setHasBeenOpened(dm, file_index, true);
                        }
                    }
                });
            }
            return;
        }
        if (PlayUtils.canUseEMP(torrent, file_index, complete_only)) {
            TorrentListViewsUtils.debug("Can use EMP");
            int open_result = TorrentListViewsUtils.openInEMP(dm, file_index, complete_only, referal);
            if (open_result == 0) {
                PlatformTorrentUtils.setHasBeenOpened(dm, file_index, true);
                return;
            }
            if (open_result == 2) {
                TorrentListViewsUtils.debug("Open in EMP abandoned");
                return;
            }
            TorrentListViewsUtils.debug("Open EMP Failed");
        } else {
            TorrentListViewsUtils.debug("Can't use EMP.");
        }
    }

    private static void debug(String string) {
        if (Constants.isCVSVersion()) {
            System.out.println(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int installEMP(String name, final Runnable target) {
        Class<TorrentListViewsUtils> clazz = TorrentListViewsUtils.class;
        synchronized (TorrentListViewsUtils.class) {
            block17: {
                if (!emp_installing) break block17;
                Debug.out("EMP is already being installed, secondary launch for " + name + " ignored");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return 2;
            }
            emp_installing = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            boolean running = false;
            try {
                final PlayerInstaller installer = new PlayerInstaller();
                PlayerInstallWindow window = new PlayerInstallWindow(installer);
                window.open();
                AEThread2 installerThread = new AEThread2("player installer", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            if (installer.install()) {
                                Utils.execSWTThread(new AERunnable(){

                                    @Override
                                    public void runSupport() {
                                        target.run();
                                    }
                                });
                            }
                        }
                        catch (Throwable throwable) {
                            Class<TorrentListViewsUtils> clazz = TorrentListViewsUtils.class;
                            synchronized (TorrentListViewsUtils.class) {
                                emp_installing = false;
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                throw throwable;
                            }
                        }
                        Class<TorrentListViewsUtils> clazz = TorrentListViewsUtils.class;
                        synchronized (TorrentListViewsUtils.class) {
                            emp_installing = false;
                            // ** MonitorExit[var2_3] (shouldn't be in output)
                            return;
                        }
                    }
                };
                installerThread.start();
                return 0;
            }
            catch (Throwable e) {
                try {
                    Debug.out(e);
                    if (running) return 1;
                    Class<TorrentListViewsUtils> clazz2 = TorrentListViewsUtils.class;
                }
                catch (Throwable throwable) {
                    if (running) throw throwable;
                    Class<TorrentListViewsUtils> clazz3 = TorrentListViewsUtils.class;
                    synchronized (TorrentListViewsUtils.class) {
                        emp_installing = false;
                        // ** MonitorExit[var7_10] (shouldn't be in output)
                        throw throwable;
                    }
                }
                synchronized (TorrentListViewsUtils.class) {
                    emp_installing = false;
                    // ** MonitorExit[var7_9] (shouldn't be in output)
                    return 1;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static int openInEMP(final DownloadManager dm, int _file_index, final boolean complete_only, final String referal) {
        int file_index = -1;
        if (_file_index == -1) {
            EnhancedDownloadManager edm = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(dm);
            if (edm != null) {
                file_index = edm.getPrimaryFileIndex();
            }
        } else {
            file_index = _file_index;
        }
        if (file_index == -1) {
            return 1;
        }
        final int f_file_index = file_index;
        DiskManagerFileInfo file = PluginCoreUtils.wrap(dm).getDiskManagerFileInfo()[file_index];
        final URL url = !complete_only && file.getDownloaded() != file.getLength() ? PlayUtils.getMediaServerContentURL(file) : null;
        if (url != null) {
            if (!PlayUtils.isStreamPermitted()) return 0;
            boolean show_debug_window = false;
            new AEThread2("stream:async"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    StreamManager sm = StreamManager.getSingleton();
                    Class<TorrentListViewsUtils> clazz = TorrentListViewsUtils.class;
                    synchronized (TorrentListViewsUtils.class) {
                        if (current_stream != null && !current_stream.isCancelled()) {
                            if (current_stream.getURL().equals(url)) {
                                current_stream.setPreviewMode(!current_stream.getPreviewMode());
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                return;
                            }
                            current_stream.cancel();
                            current_stream = null;
                        }
                        current_stream = sm.stream(dm, f_file_index, url, false, new StreamManagerDownloadListener(){
                            private long last_log = 0L;

                            @Override
                            public void updateActivity(String str) {
                                this.append("Activity: " + str);
                            }

                            @Override
                            public void updateStats(int secs_until_playable, int buffer_secs, long buffer_bytes, int target_secs) {
                                long now = SystemTime.getMonotonousTime();
                                if (now - this.last_log >= 1000L) {
                                    this.last_log = now;
                                    this.append("stats: play in " + secs_until_playable + " sec, buffer=" + DisplayFormatters.formatByteCountToKiBEtc(buffer_bytes) + "/" + buffer_secs + " sec - target=" + target_secs + " sec");
                                }
                            }

                            @Override
                            public void ready() {
                                this.append("ready");
                            }

                            @Override
                            public void failed(Throwable error) {
                                this.append("failed: " + Debug.getNestedExceptionMessage(error));
                                Debug.out(error);
                            }

                            private void append(final String str) {
                                if (stream_viewer != null) {
                                    Utils.execSWTThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (stream_viewer != null && !stream_viewer.isDisposed()) {
                                                stream_viewer.append(String.valueOf(str) + "\r\n");
                                            }
                                        }
                                    });
                                }
                            }
                        });
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            }.start();
            return 0;
        }
        Class<TorrentListViewsUtils> show_debug_window = TorrentListViewsUtils.class;
        // MONITORENTER : com.biglybt.ui.swt.views.skin.TorrentListViewsUtils.class
        if (current_stream != null && !current_stream.isCancelled()) {
            current_stream.cancel();
            current_stream = null;
        }
        // MONITOREXIT : show_debug_window
        Class<?> epwClass = null;
        try {
            PluginInterface pi = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azemp", false);
            if (pi == null) {
                return TorrentListViewsUtils.installEMP(dm.getDisplayName(), new Runnable(){

                    @Override
                    public void run() {
                        TorrentListViewsUtils.openInEMP(dm, f_file_index, complete_only, referal);
                    }
                });
            }
            if (!pi.getPluginState().isOperational()) {
                return 1;
            }
            epwClass = pi.getPlugin().getClass().getClassLoader().loadClass("com.azureus.plugins.azemp.ui.swt.emp.EmbeddedPlayerWindowSWT");
        }
        catch (ClassNotFoundException e1) {
            return 1;
        }
        {
            catch (Throwable e) {
                e.printStackTrace();
                if (e.getMessage() != null) {
                    if (e.getMessage().toLowerCase().endsWith("only")) return 1;
                }
                Debug.out(e);
                return 1;
            }
        }
        try {
            Method method = epwClass.getMethod("openWindow", File.class, String.class);
            File f = file.getFile(true);
            method.invoke(null, f, f.getName());
            return 0;
        }
        catch (Throwable e) {
            TorrentListViewsUtils.debug("file/name open method missing");
            Method method = epwClass.getMethod("openWindow", DownloadManager.class);
            method.invoke(null, dm);
            return 0;
        }
    }

    public static int openInEMP(final String name, final URL url) {
        PluginInterface pi;
        Class<?> epwClass;
        block6: {
            epwClass = null;
            try {
                pi = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azemp", false);
                if (pi == null) {
                    return TorrentListViewsUtils.installEMP(name, new Runnable(){

                        @Override
                        public void run() {
                            TorrentListViewsUtils.openInEMP(name, url);
                        }
                    });
                }
                if (pi.getPluginState().isOperational()) break block6;
                return 1;
            }
            catch (ClassNotFoundException e1) {
                return 1;
            }
        }
        epwClass = pi.getPlugin().getClass().getClassLoader().loadClass("com.azureus.plugins.azemp.ui.swt.emp.EmbeddedPlayerWindowSWT");
        try {
            Method method = epwClass.getMethod("openWindow", URL.class, String.class);
            method.invoke(null, url, name);
            return 0;
        }
        catch (Throwable e) {
            TorrentListViewsUtils.debug("URL/name open method missing");
            return 1;
        }
    }

    public static void playOrStream(DownloadManager dm, int file_index) {
        TorrentListViewsUtils.playOrStream(dm, file_index, true, false, null);
    }
}

