/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.skin;

import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Constants;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BufferedLabel;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public abstract class StandardButtonsArea {
    private Button def_button;
    private Button[] buttons;
    private BufferedLabel label;
    private Map<Integer, Boolean> buttonsEnabled = new HashMap<Integer, Boolean>();
    private static final int BUTTON_PADDING = 2;
    private static final int MIN_BUTTON_WIDTH = 75;
    private String[] buttonIDs;
    private Integer[] buttonVals;
    private int defaultButtonPos;

    public void setButtonIDs(String[] buttons) {
        this.buttonIDs = buttons == null ? new String[]{} : buttons;
    }

    public void setButtonVals(Integer[] buttonVals) {
        this.buttonVals = buttonVals;
        int cancelPos = -1;
        int i = 0;
        while (i < buttonVals.length) {
            Integer val = buttonVals[i];
            if (val == 256) {
                cancelPos = i;
                break;
            }
            ++i;
        }
        if (cancelPos >= 0 && Constants.isOSX && cancelPos != 0) {
            String cancelButton = this.buttonIDs[cancelPos];
            int i2 = cancelPos;
            while (i2 > 0) {
                if (this.defaultButtonPos == i2) {
                    this.defaultButtonPos = i2 - 1;
                }
                this.buttonIDs[i2] = this.buttonIDs[i2 - 1];
                this.buttonVals[i2] = this.buttonVals[i2 - 1];
                --i2;
            }
            if (this.defaultButtonPos == 0) {
                this.defaultButtonPos = 1;
            }
            this.buttonIDs[0] = cancelButton;
            buttonVals[0] = 256;
        }
    }

    public void setDefaultButtonPos(int defaultOption) {
        this.defaultButtonPos = defaultOption;
    }

    public int getButtonVal(int buttonPos) {
        if (this.buttonVals == null) {
            return buttonPos;
        }
        if (buttonPos < 0 || buttonPos >= this.buttonVals.length) {
            return 256;
        }
        return this.buttonVals[buttonPos];
    }

    public int getButtonCount() {
        return this.buttonIDs.length;
    }

    public int getButtonPosFromVal(int buttonVal) {
        int pos = buttonVal;
        if (this.buttonVals != null) {
            int i = 0;
            while (i < this.buttonVals.length) {
                int val = this.buttonVals[i];
                if (buttonVal == val) {
                    pos = i;
                    break;
                }
                ++i;
            }
        }
        return pos;
    }

    public void swt_createButtons(Composite cBottomArea) {
        Composite cCenterH = new Composite(cBottomArea, 0);
        FormData fd = new FormData();
        fd.height = 1;
        fd.width = 1;
        fd.left = new FormAttachment(100);
        fd.right = new FormAttachment(0);
        cCenterH.setLayoutData((Object)fd);
        Composite cCenterV = new Composite(cBottomArea, 0);
        fd = new FormData();
        fd.width = 1;
        fd.height = 1;
        fd.top = new FormAttachment(0);
        fd.bottom = new FormAttachment(100);
        cCenterV.setLayoutData((Object)fd);
        Composite cButtonArea = new Composite(cBottomArea, 0);
        fd = new FormData();
        fd.top = new FormAttachment((Control)cCenterV, 0, 0x1000000);
        fd.right = new FormAttachment((Control)cCenterH, 0, 16384);
        cButtonArea.setLayoutData((Object)fd);
        Composite cLabelArea = new Composite(cBottomArea, 0);
        fd = new FormData();
        fd.top = new FormAttachment((Control)cButtonArea, 0, 128);
        fd.bottom = new FormAttachment((Control)cButtonArea, 0, 1024);
        fd.right = new FormAttachment((Control)cButtonArea, 0, 16384);
        fd.left = new FormAttachment(0, 0);
        cLabelArea.setLayoutData((Object)fd);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginRight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        cLabelArea.setLayout((Layout)gridLayout);
        this.label = new BufferedLabel(cLabelArea, 0x20000000);
        GridData gridData = new GridData(1808);
        gridData.verticalAlignment = 0x1000000;
        this.label.setLayoutData(gridData);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.center = true;
        rowLayout.spacing = 8;
        rowLayout.pack = false;
        cButtonArea.setLayout((Layout)rowLayout);
        this.buttons = new Button[this.buttonIDs.length];
        int i = 0;
        while (i < this.buttonIDs.length) {
            String buttonText = this.buttonIDs[i];
            if (buttonText != null) {
                Button button = this.buttons[i] = new Button(cButtonArea, 8);
                int buttonVal = this.buttonVals == null || i >= this.buttonVals.length ? i : this.buttonVals[i];
                Boolean b = this.buttonsEnabled.get(buttonVal);
                if (b == null) {
                    b = Boolean.TRUE;
                }
                button.setEnabled(b.booleanValue());
                button.setText(buttonText);
                RowData rowData = new RowData();
                Point size = button.computeSize(-1, -1);
                size.x += 2;
                int minButtonWidth = 75;
                if (size.x < minButtonWidth) {
                    size.x = minButtonWidth;
                }
                rowData.width = size.x;
                button.setLayoutData((Object)rowData);
                if (this.defaultButtonPos == i) {
                    this.def_button = button;
                }
                button.setData("ButtonNo", (Object)new Integer(i));
                button.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        int intValue = ((Number)event2.widget.getData("ButtonNo")).intValue();
                        StandardButtonsArea.this.clicked(StandardButtonsArea.this.getButtonVal(intValue));
                    }
                });
            }
            ++i;
        }
        cBottomArea.getParent().layout(true, true);
        cBottomArea.getShell().addShellListener(new ShellListener(){

            public void shellIconified(ShellEvent e) {
            }

            public void shellDeiconified(ShellEvent e) {
            }

            public void shellDeactivated(ShellEvent e) {
            }

            public void shellClosed(ShellEvent e) {
            }

            public void shellActivated(ShellEvent e) {
                if (StandardButtonsArea.this.def_button != null) {
                    StandardButtonsArea.this.def_button.getShell().setDefaultButton(StandardButtonsArea.this.def_button);
                }
            }
        });
    }

    protected abstract void clicked(int var1);

    public void setButtonEnabled(final int buttonVal, final boolean enable) {
        this.buttonsEnabled.put(buttonVal, enable);
        if (this.buttons == null) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                Button button;
                if (StandardButtonsArea.this.buttons == null) {
                    return;
                }
                int pos = StandardButtonsArea.this.getButtonPosFromVal(buttonVal);
                if (pos >= 0 && pos < StandardButtonsArea.this.buttons.length && (button = StandardButtonsArea.this.buttons[pos]) != null && !button.isDisposed()) {
                    button.setEnabled(enable);
                }
            }
        });
    }

    public Button[] getButtons() {
        return this.buttons;
    }

    public BufferedLabel getLabel() {
        return this.label;
    }
}

