/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.skin;

import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.views.skin.SkinView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SkinViewManager {
    private static Map<Class<?>, List<SkinView>> mapSkinViews = new HashMap();
    private static AEMonitor mon_skinViews = new AEMonitor("skinViews");
    private static Map<String, SkinView> skinIDs = new HashMap<String, SkinView>();
    private static Map<String, SkinView> skinViewIDs = new HashMap<String, SkinView>();
    private static List listeners = new ArrayList();

    public static void add(SkinView skinView) {
        mon_skinViews.enter();
        try {
            List<SkinView> list = mapSkinViews.get(skinView.getClass());
            if (list == null) {
                list = new ArrayList<SkinView>(1);
                mapSkinViews.put(skinView.getClass(), list);
            }
            list.add(skinView);
        }
        finally {
            mon_skinViews.exit();
        }
        SWTSkinObject mainSkinObject = skinView.getMainSkinObject();
        if (mainSkinObject != null) {
            skinIDs.put(mainSkinObject.getSkinObjectID(), skinView);
            String viewID = mainSkinObject.getViewID();
            if (viewID != null && viewID.length() > 0) {
                skinViewIDs.put(viewID, skinView);
            }
        }
        SkinViewManager.triggerViewAddedListeners(skinView);
    }

    public static void remove(SkinView skinView) {
        if (skinView == null) {
            return;
        }
        mon_skinViews.enter();
        try {
            List<SkinView> list = mapSkinViews.get(skinView.getClass());
            if (list != null) {
                list.remove(skinView);
                if (list.isEmpty()) {
                    mapSkinViews.remove(skinView.getClass());
                }
            }
        }
        finally {
            mon_skinViews.exit();
        }
        SWTSkinObject mainSkinObject = skinView.getMainSkinObject();
        if (mainSkinObject != null) {
            skinIDs.remove(mainSkinObject.getSkinObjectID());
            skinViewIDs.remove(mainSkinObject.getViewID());
        }
    }

    public static SkinView getByClass(Class<?> cla) {
        List<SkinView> list = mapSkinViews.get(cla);
        if (list == null) {
            return null;
        }
        Object[] skinViews = list.toArray();
        int i = 0;
        while (i < skinViews.length) {
            SkinView sv = (SkinView)skinViews[i];
            SWTSkinObject so = sv.getMainSkinObject();
            if (so != null) {
                if (!so.isDisposed()) {
                    return sv;
                }
                SkinViewManager.remove(sv);
            }
            ++i;
        }
        return null;
    }

    public static SkinView[] getMultiByClass(Class<?> cla) {
        List<SkinView> list = mapSkinViews.get(cla);
        if (list == null) {
            return new SkinView[0];
        }
        return list.toArray(new SkinView[0]);
    }

    public static SkinView getBySkinObjectID(String id) {
        SWTSkinObject so;
        SkinView sv = skinIDs.get(id);
        if (sv != null && (so = sv.getMainSkinObject()) != null && so.isDisposed()) {
            SkinViewManager.remove(sv);
            return null;
        }
        return sv;
    }

    public static SkinView getByViewID(String viewID) {
        SWTSkinObject so;
        SkinView sv = skinViewIDs.get(viewID);
        if (sv != null && (so = sv.getMainSkinObject()) != null && so.isDisposed()) {
            SkinViewManager.remove(sv);
            return null;
        }
        return sv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(SkinViewManagerListener l) {
        Class<SkinViewManager> clazz = SkinViewManager.class;
        synchronized (SkinViewManager.class) {
            if (!listeners.contains(l)) {
                listeners.add(l);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(Class cla, SkinViewManagerListener l) {
        Class<SkinViewManager> clazz = SkinViewManager.class;
        synchronized (SkinViewManager.class) {
            if (!listeners.contains(l)) {
                listeners.add(l);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            SkinView[] svs = SkinViewManager.getMultiByClass(cla);
            if (svs != null) {
                SkinView[] skinViewArray = svs;
                int n = svs.length;
                int n2 = 0;
                while (n2 < n) {
                    SkinView skinView = skinViewArray[n2];
                    l.skinViewAdded(skinView);
                    ++n2;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void RemoveListener(SkinViewManagerListener l) {
        Class<SkinViewManager> clazz = SkinViewManager.class;
        synchronized (SkinViewManager.class) {
            listeners.remove(l);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void triggerViewAddedListeners(SkinView skinView) {
        Class<SkinViewManager> clazz = SkinViewManager.class;
        synchronized (SkinViewManager.class) {
            Object[] array = listeners.toArray();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            int i = 0;
            while (i < array.length) {
                SkinViewManagerListener l = (SkinViewManagerListener)array[i];
                try {
                    l.skinViewAdded(skinView);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
                ++i;
            }
            return;
        }
    }

    public static interface SkinViewManagerListener {
        public void skinViewAdded(SkinView var1);
    }
}

