/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.skin;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.category.Category;
import com.biglybt.core.category.CategoryListener;
import com.biglybt.core.category.CategoryManager;
import com.biglybt.core.category.CategoryManagerListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerListener;
import com.biglybt.core.download.impl.DownloadManagerAdapter;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerAdapter;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.stats.transfer.OverallStats;
import com.biglybt.core.stats.transfer.StatsFactory;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagGroup;
import com.biglybt.core.tag.TagGroupListener;
import com.biglybt.core.tag.TagListener;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagManagerListener;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.tag.TagTypeListener;
import com.biglybt.core.tag.TagUtils;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.torrent.HasBeenOpenedListener;
import com.biglybt.core.torrent.PlatformTorrentUtils;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FrequencyLimitedDispatcher;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.RegExUtil;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.menus.MenuItemFillListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.menus.MenuManager;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.utils.FormattersImpl;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.biglybt.ui.mdi.MdiChildCloseListener;
import com.biglybt.ui.mdi.MdiCloseListener;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MdiEntryCreationListener;
import com.biglybt.ui.mdi.MdiEntryDropListener;
import com.biglybt.ui.mdi.MdiEntryVitalityImage;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.swt.TorrentUtil;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mdi.MdiEntrySWT;
import com.biglybt.ui.swt.mdi.MdiSWTMenuHackListener;
import com.biglybt.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.biglybt.ui.swt.pifimpl.UISWTViewBuilderCore;
import com.biglybt.ui.swt.shells.CoreWaiterSWT;
import com.biglybt.ui.swt.utils.DragDropUtils;
import com.biglybt.ui.swt.views.MyTorrentsView;
import com.biglybt.ui.swt.views.PeersGeneralView;
import com.biglybt.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import com.biglybt.ui.swt.views.utils.CategoryUIUtils;
import com.biglybt.ui.swt.views.utils.TagUIUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class SB_Transfers {
    private static final Object AUTO_CLOSE_KEY = new Object();
    private static final Object TAG_TAG_OR_GROUP_KEY = new Object();
    private static final Object TAG_DATA_KEY = new Object();
    private static final Object TAG_INDICATOR_KEY = new Object();
    private static final Object TAG_IMAGE_KEY = new Object();
    private static final Object CAT_KEY = new Object();
    private static final String ID_VITALITY_ACTIVE = "image.sidebar.vitality.dl";
    private static final String ID_VITALITY_ALERT = "image.sidebar.vitality.alert";
    private final HasBeenOpenedListener hasBeenOpenedListener;
    private CategoryListener categoryListener;
    private DownloadManagerListener dmListener;
    private GlobalManagerAdapter gmListener;
    private TimerEventPeriodic timerEventPeriodic;
    private CategoryManagerListener categoryManagerListener;
    private TagManagerListener tagManagerListener;
    private TagTypeListener tagTypeListener;
    private TagListener tagListener;
    private final Object tag_listener_lock = new Object();
    private ParameterListener paramTagsInSidebarListener;
    private ParameterListener paramTagGroupsInSidebarListener;
    private ParameterListener paramCatInSidebarListener;
    private long last_dl_entry_load;
    private Set<MdiEntry> redraw_pending = new HashSet<MdiEntry>();
    private FrequencyLimitedDispatcher redraw_disp = new FrequencyLimitedDispatcher(new AERunnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runSupport() {
            ArrayList to_do;
            Set set = SB_Transfers.this.redraw_pending;
            synchronized (set) {
                to_do = new ArrayList(SB_Transfers.this.redraw_pending);
                SB_Transfers.this.redraw_pending.clear();
            }
            for (MdiEntry e : to_do) {
                e.redraw();
            }
        }
    }, 2500);
    private final Object statsLock = new Object();
    private stats statsWithLowNoise;
    private stats statsNoLowNoise;
    private final CopyOnWriteList<countRefreshListener> listeners = new CopyOnWriteList();
    private boolean first = true;
    private Core core;
    private long coreCreateTime;
    private FrequencyLimitedDispatcher refresh_limiter;
    private TimerEventPeriodic timerEventShowUptime;
    private ParameterListener configListenerShow;
    protected boolean header_show_uptime;
    protected boolean header_show_rates;
    protected volatile OverallStats totalStats;
    private boolean show_tag_groups;
    private boolean show_tag_tab_views;
    private static final Object tag_setup_lock = new Object();
    private static boolean TABLE_SUBCONFIG_ENABLE = COConfigurationManager.getBooleanParameter("Library.EnableSepColConfig");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestRedraw(MdiEntry entry) {
        Set<MdiEntry> set = this.redraw_pending;
        synchronized (set) {
            if (!this.redraw_pending.contains(entry)) {
                this.redraw_pending.add(entry);
                this.redraw_disp.dispatch();
            }
        }
    }

    public SB_Transfers(final MultipleDocumentInterfaceSWT mdi, final boolean vuze_ui) {
        this.statsNoLowNoise = new stats();
        this.statsNoLowNoise.includeLowNoise = false;
        this.statsWithLowNoise = new stats();
        this.statsWithLowNoise.includeLowNoise = true;
        this.refresh_limiter = new FrequencyLimitedDispatcher(new AERunnable(){

            @Override
            public void runSupport() {
                SB_Transfers.this.refreshAllLibrariesSupport(vuze_ui);
            }
        }, 250);
        this.refresh_limiter.setSingleThreaded();
        if (vuze_ui) {
            MyMdiEntryCreationListener libraryCreator = new MyMdiEntryCreationListener(mdi);
            mdi.registerEntry("Library", libraryCreator);
            mdi.registerEntry("library", libraryCreator);
            mdi.registerEntry("LibraryDL", new MdiEntryCreationListener(){

                @Override
                public MdiEntry createMDiEntry(String id) {
                    return SB_Transfers.this.createDownloadingEntry(mdi);
                }
            });
            mdi.registerEntry("LibraryCD", new MdiEntryCreationListener(){

                @Override
                public MdiEntry createMDiEntry(String id) {
                    return SB_Transfers.this.createSeedingEntry(mdi);
                }
            });
            mdi.registerEntry("LibraryUnopened", new MdiEntryCreationListener(){

                @Override
                public MdiEntry createMDiEntry(String id) {
                    return SB_Transfers.this.createUnopenedEntry(mdi);
                }
            });
            CoreFactory.addCoreRunningListener(new CoreRunningListener(){

                @Override
                public void coreRunning(Core core) {
                    SB_Transfers.this.totalStats = StatsFactory.getStats();
                    SB_Transfers.this.setupViewTitleWithCore(core);
                }
            });
            this.hasBeenOpenedListener = new HasBeenOpenedListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void hasBeenOpenedChanged(DownloadManager dm, boolean opened) {
                    Object object = SB_Transfers.this.statsLock;
                    synchronized (object) {
                        SB_Transfers.this.recountItems();
                        SB_Transfers.this.refreshAllLibraries();
                    }
                }
            };
            PlatformTorrentUtils.addHasBeenOpenedListener(this.hasBeenOpenedListener);
            mdi.addListener(entry -> {
                if ("header.transfers".equals(entry.getViewID())) {
                    this.addHeaderMenu();
                }
            });
        } else {
            CoreFactory.addCoreRunningListener(new CoreRunningListener(){

                @Override
                public void coreRunning(Core core) {
                    SB_Transfers.this.totalStats = StatsFactory.getStats();
                    SB_Transfers.this.setupViewTitleWithCore(core);
                }
            });
            this.hasBeenOpenedListener = null;
        }
        this.timerEventShowUptime = SimpleTimer.addPeriodicEvent("SBLV:updater", 60000L, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent event2) {
                if (SB_Transfers.this.header_show_uptime) {
                    SB_Transfers.this.triggerCountRefreshListeners();
                }
            }
        });
        this.configListenerShow = new ParameterListener(){
            private TimerEventPeriodic rate_event;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void parameterChanged(String name) {
                SB_Transfers.this.header_show_uptime = COConfigurationManager.getBooleanParameter("MyTorrentsView.showuptime");
                SB_Transfers.this.header_show_rates = COConfigurationManager.getBooleanParameter("MyTorrentsView.showrates");
                SB_Transfers.this.triggerCountRefreshListeners();
                SB_Transfers.this.refreshAllLibraries();
                10 var2_2 = this;
                synchronized (var2_2) {
                    if (SB_Transfers.this.header_show_rates) {
                        if (this.rate_event == null) {
                            this.rate_event = SimpleTimer.addPeriodicEvent("SBLV:rate-updater", 1000L, new TimerEventPerformer(){

                                @Override
                                public void perform(TimerEvent event2) {
                                    SB_Transfers.this.triggerCountRefreshListeners();
                                }
                            });
                        }
                    } else if (this.rate_event != null) {
                        this.rate_event.cancel();
                        this.rate_event = null;
                    }
                }
            }
        };
        COConfigurationManager.addAndFireParameterListeners(new String[]{"MyTorrentsView.showuptime", "MyTorrentsView.showrates", "Library.viewmode"}, this.configListenerShow);
    }

    protected void addHeaderMenu() {
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        UIManager uim = pi.getUIManager();
        assert (uim != null);
        MenuManager menuManager = uim.getMenuManager();
        com.biglybt.pif.ui.menus.MenuItem menuItem = menuManager.addMenuItem("sidebar.header.transfers", "MyTorrentsView.menu.setCategory.add");
        menuItem.setDisposeWithUIDetach("swt");
        menuItem.addListener(new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                CategoryUIUtils.showCreateCategoryDialog(null);
            }
        });
        menuItem.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                menu.setVisible(COConfigurationManager.getBooleanParameter("Library.CatInSideBar"));
            }
        });
        menuItem = menuManager.addMenuItem("sidebar.header.transfers", "ConfigView.section.style.CatInSidebar");
        menuItem.setDisposeWithUIDetach("swt");
        menuItem.setStyle(2);
        menuItem.addListener(new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                boolean b = COConfigurationManager.getBooleanParameter("Library.CatInSideBar");
                COConfigurationManager.setParameter("Library.CatInSideBar", !b);
            }
        });
        menuItem.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                menu.setVisible(CategoryManager.getCategories().length > 0);
                menu.setData(COConfigurationManager.getBooleanParameter("Library.CatInSideBar"));
            }
        });
        TagUIUtils.setupSideBarMenus(menuManager);
    }

    protected MdiEntry createUnopenedEntry(MultipleDocumentInterface mdi) {
        MdiEntry infoLibraryUn = mdi.createEntryFromSkinRef("header.transfers", "LibraryUnopened", "library", "{sidebar.LibraryUnopened}", null, null, true, SB_Transfers.getSectionPosition(mdi, "LibraryUnopened"));
        infoLibraryUn.setImageLeftID("image.sidebar.unopened");
        SB_Transfers.addGeneralLibraryMenus(mdi, "LibraryUnopened");
        infoLibraryUn.setViewTitleInfo(new ViewTitleInfo(){

            @Override
            public Object getTitleInfoProperty(int propertyID) {
                if (propertyID == 0 && ((SB_Transfers)SB_Transfers.this).statsNoLowNoise.numUnOpened > 0) {
                    return "" + ((SB_Transfers)SB_Transfers.this).statsNoLowNoise.numUnOpened;
                }
                return null;
            }
        });
        infoLibraryUn.addListener(new MdiCloseListener(){

            @Override
            public void mdiEntryClosed(MdiEntry entry, boolean userClosed) {
                if (userClosed) {
                    if (Constants.isCVSVersion()) {
                        Debug.out("New entry closed by user");
                    }
                    COConfigurationManager.setParameter("Show New In Side Bar", false);
                }
            }
        });
        return infoLibraryUn;
    }

    private static void addGeneralLibraryMenus(MultipleDocumentInterface mdi, String id) {
        SB_Transfers.addMenuUnwatched(id);
        SB_Transfers.addMenuCollapseAll(mdi, id);
    }

    private static void addMenuUnwatched(String id) {
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        UIManager uim = pi.getUIManager();
        MenuManager menuManager = uim.getMenuManager();
        com.biglybt.pif.ui.menus.MenuItem menuItem = menuManager.addMenuItem("sidebar." + id, "v3.activity.button.watchall");
        menuItem.setDisposeWithUIDetach("swt");
        menuItem.addListener(new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.ANY_THREAD, new CoreRunningListener(){

                    @Override
                    public void coreRunning(Core core) {
                        GlobalManager gm = core.getGlobalManager();
                        List<DownloadManager> downloadManagers = gm.getDownloadManagers();
                        for (DownloadManager dm : downloadManagers) {
                            if (PlatformTorrentUtils.getHasBeenOpened(dm) || !dm.getAssumedComplete()) continue;
                            PlatformTorrentUtils.setHasBeenOpened(dm, true);
                        }
                    }
                });
            }
        });
    }

    private static void collapseAll(Composite comp2) {
        Control[] kids;
        Object obj = comp2.getData("MyTorrentsView.instance");
        if (obj != null) {
            ((MyTorrentsView)obj).collapseAll();
        }
        Control[] controlArray = kids = comp2.getChildren();
        int n = kids.length;
        int n2 = 0;
        while (n2 < n) {
            Control k = controlArray[n2];
            if (k instanceof Composite) {
                SB_Transfers.collapseAll((Composite)k);
            }
            ++n2;
        }
    }

    private static void addMenuCollapseAll(final MultipleDocumentInterface mdi, final String id) {
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        UIManager uim = pi.getUIManager();
        MenuManager menuManager = uim.getMenuManager();
        com.biglybt.pif.ui.menus.MenuItem menuItem = menuManager.addMenuItem("sidebar." + id, "menu.collapse.all");
        menuItem.setDisposeWithUIDetach("swt");
        menuItem.addListener(new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.ANY_THREAD, new CoreRunningListener(){

                    @Override
                    public void coreRunning(Core core) {
                        MdiEntrySWT entry = (MdiEntrySWT)mdi.getEntry(id);
                        SB_Transfers.collapseAll(entry.getComposite());
                    }
                });
            }
        });
    }

    private static void addMenuCollapseAll(MultipleDocumentInterface mdi, Menu menu, String group_id) {
        MenuItem item = new MenuItem(menu, 8);
        item.setText(MessageText.getString("menu.collapse.all"));
        item.addListener(13, e -> {
            MdiEntrySWT entry = (MdiEntrySWT)mdi.getEntry(group_id);
            SB_Transfers.collapseAll(entry.getComposite());
        });
    }

    protected MdiEntry createSeedingEntry(MultipleDocumentInterface mdi) {
        ViewTitleInfo titleInfoSeeding = new ViewTitleInfo(){

            @Override
            public Object getTitleInfoProperty(int propertyID) {
                if (propertyID == 0) {
                    return null;
                }
                if (propertyID == 1) {
                    return MessageText.getString("sidebar.LibraryCD.tooltip", new String[]{"" + ((SB_Transfers)SB_Transfers.this).statsNoLowNoise.numComplete, "" + ((SB_Transfers)SB_Transfers.this).statsNoLowNoise.numSeeding});
                }
                return null;
            }
        };
        MdiEntry entry = mdi.createEntryFromSkinRef("header.transfers", "LibraryCD", "library", "{sidebar.LibraryDL}", titleInfoSeeding, null, false, SB_Transfers.getSectionPosition(mdi, "LibraryCD"));
        entry.setImageLeftID("image.sidebar.downloading");
        SB_Transfers.addGeneralLibraryMenus(mdi, "LibraryCD");
        MdiEntryVitalityImage vitalityImage = entry.addVitalityImage(ID_VITALITY_ALERT);
        vitalityImage.setVisible(false);
        entry.setViewTitleInfo(titleInfoSeeding);
        return entry;
    }

    protected MdiEntry createDownloadingEntry(MultipleDocumentInterface mdi) {
        MdiEntry entry;
        final MdiEntry[] entry_holder = new MdiEntry[1];
        ViewTitleInfo titleInfoDownloading = new ViewTitleInfo(){
            private long max_incomp_dl_time;

            @Override
            public Object getTitleInfoProperty(int propertyID) {
                if (propertyID == 0) {
                    int current;
                    if (COConfigurationManager.getBooleanParameter("Request Attention On New Download") && SB_Transfers.this.coreCreateTime > 0L) {
                        MdiEntry entry;
                        if (this.max_incomp_dl_time == 0L) {
                            this.max_incomp_dl_time = SB_Transfers.this.coreCreateTime;
                        }
                        if (((SB_Transfers)SB_Transfers.this).statsNoLowNoise.newestIncompleteDownloadTime > this.max_incomp_dl_time && (entry = entry_holder[0]) != null) {
                            this.max_incomp_dl_time = ((SB_Transfers)SB_Transfers.this).statsNoLowNoise.newestIncompleteDownloadTime;
                            entry.requestAttention();
                        }
                    }
                    if ((current = ((SB_Transfers)SB_Transfers.this).statsNoLowNoise.numIncomplete) > 0) {
                        return String.valueOf(current);
                    }
                } else {
                    if (propertyID == 1) {
                        return MessageText.getString("sidebar.LibraryDL.tooltip", new String[]{"" + ((SB_Transfers)SB_Transfers.this).statsNoLowNoise.numIncomplete, "" + ((SB_Transfers)SB_Transfers.this).statsNoLowNoise.numDownloading});
                    }
                    if (propertyID == 8) {
                        if (COConfigurationManager.getBooleanParameter("LibraryDL.UseDefaultIndicatorColor")) {
                            return null;
                        }
                        if (((SB_Transfers)SB_Transfers.this).statsNoLowNoise.numDownloading > 0) {
                            return new int[]{96, 160, 96};
                        }
                        if (((SB_Transfers)SB_Transfers.this).statsNoLowNoise.numErrorInComplete > 0) {
                            return new int[]{132, 16, 58};
                        }
                        return null;
                    }
                }
                return null;
            }
        };
        entry_holder[0] = entry = mdi.createEntryFromSkinRef("header.transfers", "LibraryDL", "library", "{sidebar.LibraryDL}", titleInfoDownloading, null, true, SB_Transfers.getSectionPosition(mdi, "LibraryDL"));
        entry.setImageLeftID("image.sidebar.downloading");
        SB_Transfers.addGeneralLibraryMenus(mdi, "LibraryDL");
        entry.addListener(new MdiCloseListener(){

            @Override
            public void mdiEntryClosed(MdiEntry entry, boolean userClosed) {
                if (userClosed) {
                    if (Constants.isCVSVersion()) {
                        Debug.out("Downloading entry closed by user");
                    }
                    COConfigurationManager.setParameter("Show Downloading In Side Bar", false);
                }
            }
        });
        MdiEntryVitalityImage vitalityImage = entry.addVitalityImage(ID_VITALITY_ACTIVE);
        vitalityImage.setVisible(false);
        vitalityImage = entry.addVitalityImage(ID_VITALITY_ALERT);
        vitalityImage.setVisible(false);
        String parentID = "sidebar.LibraryDL";
        MenuManager menu_manager = PluginInitializer.getDefaultInterface().getUIManager().getMenuManager();
        com.biglybt.pif.ui.menus.MenuItem mi = menu_manager.addMenuItem(parentID, "menu.use.default.indicator.color");
        mi.setDisposeWithUIDetach("swt");
        mi.setStyle(2);
        mi.setData(COConfigurationManager.getBooleanParameter("LibraryDL.UseDefaultIndicatorColor"));
        mi.addListener(new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem mi, Object target) {
                COConfigurationManager.setParameter("LibraryDL.UseDefaultIndicatorColor", mi.isSelected());
                entry.redraw();
            }
        });
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupViewTitleWithCore(Core _core) {
        Class<SB_Transfers> clazz = SB_Transfers.class;
        synchronized (SB_Transfers.class) {
            if (!this.first) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.first = false;
            this.core = _core;
            this.coreCreateTime = this.core.getCreateTime();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.categoryListener = new CategoryListener(){

                @Override
                public void downloadManagerRemoved(Category cat, DownloadManager removed) {
                    SB_Transfers.this.RefreshCategorySideBar(cat);
                }

                @Override
                public void downloadManagerAdded(Category cat, DownloadManager manager) {
                    SB_Transfers.this.RefreshCategorySideBar(cat);
                }
            };
            this.paramCatInSidebarListener = new ParameterListener(){

                @Override
                public void parameterChanged(String parameterName) {
                    block7: {
                        Category[] categories;
                        block6: {
                            if (Utils.isAZ2UI()) {
                                return;
                            }
                            categories = CategoryManager.getCategories();
                            if (categories.length == 0) {
                                return;
                            }
                            boolean catInSidebar = COConfigurationManager.getBooleanParameter("Library.CatInSideBar");
                            if (!catInSidebar) break block6;
                            if (SB_Transfers.this.categoryManagerListener != null) {
                                return;
                            }
                            SB_Transfers.this.categoryManagerListener = new CategoryManagerListener(){

                                @Override
                                public void categoryRemoved(Category category) {
                                    SB_Transfers.this.removeCategory(category);
                                }

                                @Override
                                public void categoryChanged(Category category) {
                                    SB_Transfers.this.RefreshCategorySideBar(category);
                                }

                                @Override
                                public void categoryAdded(Category category) {
                                    Category[] categories = CategoryManager.getCategories();
                                    if (categories.length == 3) {
                                        Category[] categoryArray = categories;
                                        int n = categories.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            Category cat = categoryArray[n2];
                                            SB_Transfers.this.setupCategory(cat);
                                            ++n2;
                                        }
                                    } else {
                                        SB_Transfers.this.setupCategory(category);
                                    }
                                }
                            };
                            CategoryManager.addCategoryManagerListener(SB_Transfers.this.categoryManagerListener);
                            if (categories.length <= 2) break block7;
                            Category[] categoryArray = categories;
                            int n = categories.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Category category = categoryArray[n2];
                                SB_Transfers.this.setupCategory(category);
                                ++n2;
                            }
                            break block7;
                        }
                        if (SB_Transfers.this.categoryManagerListener != null) {
                            CategoryManager.removeCategoryManagerListener(SB_Transfers.this.categoryManagerListener);
                            SB_Transfers.this.categoryManagerListener = null;
                        }
                        Category[] categoryArray = categories;
                        int n = categories.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Category category = categoryArray[n3];
                            SB_Transfers.this.removeCategory(category);
                            ++n3;
                        }
                    }
                }
            };
            COConfigurationManager.addAndFireParameterListener("Library.CatInSideBar", this.paramCatInSidebarListener);
            this.show_tag_groups = Utils.isAZ3UI() && COConfigurationManager.getBooleanParameter("Library.TagGroupsInSideBar");
            this.paramTagsInSidebarListener = new ParameterListener(){

                @Override
                public void parameterChanged(String parameter) {
                    if (parameter == null || parameter.equals("Library.TagInTabBar")) {
                        SB_Transfers.this.show_tag_tab_views = COConfigurationManager.getBooleanParameter("Library.TagInTabBar");
                        if (parameter != null) {
                            COConfigurationManager.setParameter("Library.TagInSideBar", SB_Transfers.this.show_tag_tab_views);
                        }
                    }
                    if (parameter == null || parameter.equals("Library.TagInSideBar")) {
                        boolean tagInSidebar = COConfigurationManager.getBooleanParameter("Library.TagInSideBar");
                        if (tagInSidebar) {
                            SB_Transfers.this.addTagManagerListeners();
                        } else {
                            SB_Transfers.this.removeTagManagerListeners(true);
                        }
                    }
                }
            };
            COConfigurationManager.addAndFireParameterListeners(new String[]{"Library.TagInSideBar", "Library.TagInTabBar"}, this.paramTagsInSidebarListener);
            this.paramTagGroupsInSidebarListener = new ParameterListener(){

                @Override
                public void parameterChanged(String parameterName) {
                    SB_Transfers.this.removeTagManagerListeners(true);
                    SB_Transfers.this.show_tag_groups = Utils.isAZ3UI() && COConfigurationManager.getBooleanParameter("Library.TagGroupsInSideBar");
                    SB_Transfers.this.addTagManagerListeners();
                }
            };
            COConfigurationManager.addParameterListener("Library.TagGroupsInSideBar", this.paramTagGroupsInSidebarListener);
            final GlobalManager gm = this.core.getGlobalManager();
            this.dmListener = new DownloadManagerAdapter(){

                @Override
                public void stateChanged(DownloadManager dm, int state) {
                    this.stateChanged(dm, state, SB_Transfers.this.statsNoLowNoise);
                    this.stateChanged(dm, state, SB_Transfers.this.statsWithLowNoise);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void stateChanged(DownloadManager dm, int state, stats stats2) {
                    if (!stats2.includeLowNoise && PlatformTorrentUtils.isAdvancedViewOnly(dm)) {
                        return;
                    }
                    Object object = SB_Transfers.this.statsLock;
                    synchronized (object) {
                        boolean isErrorState;
                        SB_Transfers.this.updateDMCounts(dm);
                        boolean complete = dm.getAssumedComplete();
                        Boolean wasErrorStateB = (Boolean)dm.getUserData("wasErrorState");
                        boolean wasErrorState = wasErrorStateB != null && wasErrorStateB != false;
                        boolean bl = isErrorState = state == 100;
                        if (isErrorState != wasErrorState) {
                            int rel;
                            int n = rel = isErrorState ? 1 : -1;
                            if (complete) {
                                stats2.numErrorComplete += rel;
                            } else {
                                stats2.numErrorInComplete += rel;
                            }
                            SB_Transfers.this.updateErrorTooltip(gm, stats2);
                            dm.setUserData("wasErrorState", isErrorState);
                        }
                        SB_Transfers.this.refreshAllLibraries();
                    }
                }

                @Override
                public void completionChanged(DownloadManager dm, boolean completed) {
                    this.completionChanged(dm, completed, SB_Transfers.this.statsNoLowNoise);
                    this.completionChanged(dm, completed, SB_Transfers.this.statsWithLowNoise);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void completionChanged(DownloadManager dm, boolean completed, stats stats2) {
                    if (!stats2.includeLowNoise && PlatformTorrentUtils.isAdvancedViewOnly(dm)) {
                        return;
                    }
                    Object object = SB_Transfers.this.statsLock;
                    synchronized (object) {
                        int dm_state = SB_Transfers.this.updateDMCounts(dm);
                        if (completed) {
                            ++stats2.numComplete;
                            --stats2.numIncomplete;
                            if (dm_state == 100) {
                                ++stats2.numErrorComplete;
                                --stats2.numErrorInComplete;
                            }
                            if (dm_state == 70) {
                                --((SB_Transfers)SB_Transfers.this).statsNoLowNoise.numStoppedIncomplete;
                            }
                        } else {
                            --stats2.numComplete;
                            ++stats2.numIncomplete;
                            if (dm_state == 100) {
                                --stats2.numErrorComplete;
                                ++stats2.numErrorInComplete;
                            }
                            if (dm_state == 70) {
                                ++((SB_Transfers)SB_Transfers.this).statsNoLowNoise.numStoppedIncomplete;
                            }
                        }
                        SB_Transfers.this.updateErrorTooltip(gm, stats2);
                        SB_Transfers.this.recountItems();
                        SB_Transfers.this.refreshAllLibraries();
                    }
                }
            };
            this.gmListener = new GlobalManagerAdapter(){

                @Override
                public void downloadManagerRemoved(DownloadManager dm) {
                    this.downloadManagerRemoved(dm, SB_Transfers.this.statsNoLowNoise);
                    this.downloadManagerRemoved(dm, SB_Transfers.this.statsWithLowNoise);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void downloadManagerRemoved(DownloadManager dm, stats stats2) {
                    if (!stats2.includeLowNoise && PlatformTorrentUtils.isAdvancedViewOnly(dm)) {
                        return;
                    }
                    Object object = SB_Transfers.this.statsLock;
                    synchronized (object) {
                        Boolean wasQueuedB;
                        boolean wasQueued;
                        Boolean wasStoppedB;
                        boolean wasStopped;
                        if (dm.getAssumedComplete()) {
                            --stats2.numComplete;
                            Boolean wasDownloadingB = (Boolean)dm.getUserData("wasDownloading");
                            if (wasDownloadingB != null && wasDownloadingB.booleanValue()) {
                                --stats2.numDownloading;
                            }
                        } else {
                            --stats2.numIncomplete;
                            Boolean wasSeedingB = (Boolean)dm.getUserData("wasSeeding");
                            if (wasSeedingB != null && wasSeedingB.booleanValue()) {
                                --stats2.numSeeding;
                            }
                        }
                        boolean bl = wasStopped = (wasStoppedB = (Boolean)dm.getUserData("wasStopped")) != null && wasStoppedB != false;
                        if (wasStopped && !dm.getAssumedComplete()) {
                            --stats2.numStoppedIncomplete;
                        }
                        boolean bl2 = wasQueued = (wasQueuedB = (Boolean)dm.getUserData("wasQueued")) != null && wasQueuedB != false;
                        if (wasQueued) {
                            --stats2.numQueued;
                        }
                        SB_Transfers.this.recountItems();
                        SB_Transfers.this.refreshAllLibraries();
                    }
                    dm.removeListener(SB_Transfers.this.dmListener);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void downloadManagerAdded(DownloadManager dm) {
                    dm.addListener(SB_Transfers.this.dmListener, false);
                    Object object = SB_Transfers.this.statsLock;
                    synchronized (object) {
                        this.downloadManagerAdded(dm, SB_Transfers.this.statsNoLowNoise);
                        this.downloadManagerAdded(dm, SB_Transfers.this.statsWithLowNoise);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void downloadManagerAdded(DownloadManager dm, stats stats2) {
                    if (!stats2.includeLowNoise && PlatformTorrentUtils.isAdvancedViewOnly(dm)) {
                        return;
                    }
                    boolean assumed_complete = dm.getAssumedComplete();
                    Object object = SB_Transfers.this.statsLock;
                    synchronized (object) {
                        if (dm.isPersistent() && dm.getTorrent() != null && !assumed_complete) {
                            stats2.newestIncompleteDownloadTime = Math.max(stats2.newestIncompleteDownloadTime, dm.getCreationTime());
                        }
                        int dm_state = dm.getState();
                        if (assumed_complete) {
                            ++stats2.numComplete;
                            if (dm_state == 60) {
                                ++stats2.numSeeding;
                            }
                        } else {
                            ++stats2.numIncomplete;
                            if (dm_state == 50) {
                                dm.setUserData("wasDownloading", Boolean.TRUE);
                                ++stats2.numDownloading;
                            } else {
                                dm.setUserData("wasDownloading", Boolean.FALSE);
                            }
                        }
                        SB_Transfers.this.recountItems();
                        SB_Transfers.this.refreshAllLibraries();
                    }
                }
            };
            gm.addListener(this.gmListener, false);
            this.resetStats(gm, this.dmListener, this.statsWithLowNoise, this.statsNoLowNoise);
            this.refreshAllLibraries();
            this.timerEventPeriodic = SimpleTimer.addPeriodicEvent("header:refresh", 60000L, new TimerEventPerformer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void perform(TimerEvent event2) {
                    stats withNoise = new stats();
                    stats noNoise = new stats();
                    noNoise.includeLowNoise = false;
                    withNoise.includeLowNoise = true;
                    Object object = SB_Transfers.this.statsLock;
                    synchronized (object) {
                        SB_Transfers.this.resetStats(gm, null, withNoise, noNoise);
                        boolean fixed = false;
                        if (!withNoise.sameAs(SB_Transfers.this.statsWithLowNoise)) {
                            SB_Transfers.this.statsWithLowNoise.copyFrom(withNoise);
                            fixed = true;
                        }
                        if (!noNoise.sameAs(SB_Transfers.this.statsNoLowNoise)) {
                            SB_Transfers.this.statsNoLowNoise.copyFrom(noNoise);
                            fixed = true;
                        }
                        if (fixed) {
                            SB_Transfers.this.updateErrorTooltip(gm, SB_Transfers.this.statsWithLowNoise);
                            SB_Transfers.this.updateErrorTooltip(gm, SB_Transfers.this.statsNoLowNoise);
                            SB_Transfers.this.refreshAllLibraries();
                        }
                    }
                }
            });
            return;
        }
    }

    private void resetStats(GlobalManager gm, DownloadManagerListener listener, stats statsWithLowNoise, stats statsNoLowNoise) {
        List<DownloadManager> downloadManagers = gm.getDownloadManagers();
        for (DownloadManager dm : downloadManagers) {
            int dm_state;
            boolean lowNoise = PlatformTorrentUtils.isAdvancedViewOnly(dm);
            boolean assumed_complete = dm.getAssumedComplete();
            if (dm.isPersistent() && dm.getTorrent() != null && !assumed_complete) {
                long createTime = dm.getCreationTime();
                statsWithLowNoise.newestIncompleteDownloadTime = Math.max(statsWithLowNoise.newestIncompleteDownloadTime, createTime);
                if (!lowNoise) {
                    statsNoLowNoise.newestIncompleteDownloadTime = Math.max(statsNoLowNoise.newestIncompleteDownloadTime, createTime);
                }
            }
            if (listener != null) {
                dm.addListener(listener, false);
            }
            if ((dm_state = dm.getState()) == 70) {
                dm.setUserData("wasStopped", Boolean.TRUE);
                if (!dm.getAssumedComplete()) {
                    ++statsWithLowNoise.numStoppedIncomplete;
                }
                if (!lowNoise && !dm.getAssumedComplete()) {
                    ++statsNoLowNoise.numStoppedIncomplete;
                }
            } else {
                dm.setUserData("wasStopped", Boolean.FALSE);
            }
            if (dm_state == 75) {
                dm.setUserData("wasQueued", Boolean.TRUE);
                ++statsWithLowNoise.numQueued;
                if (!lowNoise) {
                    ++statsNoLowNoise.numQueued;
                }
            } else {
                dm.setUserData("wasQueued", Boolean.FALSE);
            }
            if (dm.getAssumedComplete()) {
                ++statsWithLowNoise.numComplete;
                if (!lowNoise) {
                    ++statsNoLowNoise.numComplete;
                }
                if (dm_state == 60) {
                    dm.setUserData("wasSeeding", Boolean.TRUE);
                    ++statsWithLowNoise.numSeeding;
                    if (!lowNoise) {
                        ++statsNoLowNoise.numSeeding;
                    }
                } else {
                    dm.setUserData("wasSeeding", Boolean.FALSE);
                }
            } else {
                ++statsWithLowNoise.numIncomplete;
                if (!lowNoise) {
                    ++statsNoLowNoise.numIncomplete;
                }
                if (dm_state == 50) {
                    ++statsWithLowNoise.numDownloading;
                    if (!lowNoise) {
                        ++statsNoLowNoise.numDownloading;
                    }
                }
            }
            if (!PlatformTorrentUtils.getHasBeenOpened(dm) && dm.getAssumedComplete()) {
                ++statsNoLowNoise.numUnOpened;
            }
            ++statsWithLowNoise.total;
            if (lowNoise) continue;
            ++statsNoLowNoise.total;
        }
        statsWithLowNoise.numUnOpened = statsNoLowNoise.numUnOpened;
    }

    private void updateErrorTooltip(GlobalManager gm, stats stats2) {
        if (stats2.numErrorComplete < 0) {
            stats2.numErrorComplete = 0;
        }
        if (stats2.numErrorInComplete < 0) {
            stats2.numErrorInComplete = 0;
        }
        if (stats2.numErrorComplete > 0 || stats2.numErrorInComplete > 0) {
            String comp_error = null;
            String incomp_error = null;
            List<DownloadManager> downloads = gm.getDownloadManagers();
            int i = 0;
            while (i < downloads.size()) {
                DownloadManager download = downloads.get(i);
                if (download.getState() == 100) {
                    if (download.getAssumedComplete()) {
                        comp_error = comp_error == null ? String.valueOf(download.getDisplayName()) + ": " + download.getErrorDetails() : String.valueOf(comp_error) + "...";
                    } else {
                        incomp_error = incomp_error == null ? String.valueOf(download.getDisplayName()) + ": " + download.getErrorDetails() : String.valueOf(incomp_error) + "...";
                    }
                }
                ++i;
            }
            stats2.errorCompleteTooltip = comp_error;
            stats2.errorInCompleteTooltip = incomp_error;
        }
    }

    private void RefreshCategorySideBar(Category category) {
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return;
        }
        MdiEntry entry = mdi.getEntry("Cat." + Base32.encode(category.getName().getBytes()));
        if (entry == null) {
            return;
        }
        this.requestRedraw(entry);
        ViewTitleInfoManager.refreshTitleInfo(entry.getViewTitleInfo());
    }

    public MdiEntry setupCategory(final Category category) {
        String prev_id;
        ViewTitleInfo viewTitleInfo;
        MdiEntry entry;
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return null;
        }
        String name = category.getName();
        String id = "Cat." + Base32.encode(name.getBytes());
        MdiEntry existing = mdi.getEntry(id);
        if (existing != null) {
            return existing;
        }
        category.addCategoryListener(this.categoryListener);
        String loc_name = name;
        if (category.getType() != 0) {
            name = "{" + name + "}";
            loc_name = MessageText.getString(loc_name);
        }
        if ((entry = mdi.createEntryFromSkinRef("header.transfers", id, "library", name, viewTitleInfo = new ViewTitleInfo(){

            @Override
            public Object getTitleInfoProperty(int propertyID) {
                if (propertyID == 0) {
                    if (category.getType() == 1) {
                        int all = SB_Transfers.this.core.getGlobalManager().getDownloadManagers().size();
                        return String.valueOf(all);
                    }
                    if (category.getType() == 2) {
                        int all = SB_Transfers.this.core.getGlobalManager().getDownloadManagers().size();
                        int num_cat = CategoryManager.getCategorisedDownloadCount();
                        return String.valueOf(all - num_cat);
                    }
                    List<DownloadManager> dms = category.getDownloadManagers(null);
                    if (dms != null) {
                        return "" + dms.size();
                    }
                } else if (propertyID == 8) {
                    TagType tag_type = category.getTagType();
                    int[] def_color = tag_type.getColorDefault();
                    int[] tag_color = category.getColor();
                    if (tag_color != def_color) {
                        return tag_color;
                    }
                } else if (propertyID == 1) {
                    return TagUtils.getTagTooltip(category);
                }
                return null;
            }
        }, category, false, prev_id = SB_Transfers.getCatPosition(mdi, "header.transfers", loc_name))) != null) {
            entry.setImageLeftID("image.sidebar.library");
            entry.setUserData(CAT_KEY, category);
            SB_Transfers.addGeneralLibraryMenus(mdi, id);
            entry.addListener(new MdiEntryDropListener(){

                @Override
                public boolean mdiEntryDrop(MdiEntry entry, Object payload) {
                    String type;
                    if (!(payload instanceof String)) {
                        return false;
                    }
                    String dropped = (String)payload;
                    String[] split = RegExUtil.PAT_SPLIT_SLASH_N.split(dropped);
                    if (split.length > 1 && (type = split[0]).startsWith("DownloadManager")) {
                        GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
                        int i = 1;
                        while (i < split.length) {
                            String hash = split[i];
                            try {
                                DownloadManager dm = gm.getDownloadManager(new HashWrapper(Base32.decode(hash)));
                                if (dm != null) {
                                    TorrentUtil.assignToCategory(new Object[]{dm}, category);
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            ++i;
                        }
                    }
                    return true;
                }
            });
        }
        if (entry instanceof SideBarEntrySWT) {
            SideBarEntrySWT entrySWT = (SideBarEntrySWT)entry;
            entrySWT.addListener(new MdiSWTMenuHackListener(){

                @Override
                public void menuWillBeShown(MdiEntry entry, Menu menuTree) {
                    CategoryUIUtils.createMenuItems(menuTree, category);
                }
            });
        }
        return entry;
    }

    private void removeCategory(Category category) {
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return;
        }
        MdiEntry entry = mdi.getEntry("Cat." + Base32.encode(category.getName().getBytes()));
        if (entry != null) {
            category.removeCategoryListener(this.categoryListener);
            mdi.closeEntry(entry, false);
        }
    }

    private void refreshTagSideBar(Tag tag) {
        boolean[] old_auto_tag;
        boolean[] auto_tag;
        String old_title;
        MultipleDocumentInterface mdi;
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        MultipleDocumentInterface multipleDocumentInterface = mdi = uiFunctions != null ? uiFunctions.getMDI() : null;
        if (mdi == null) {
            return;
        }
        String tag_id = "Tag." + tag.getTagType().getTagType() + "." + tag.getTagID();
        MdiEntry entry = mdi.getEntry(tag_id);
        if (entry == null) {
            if (tag.isVisible()) {
                this.setupTag(tag);
            }
            return;
        }
        if (!tag.isVisible()) {
            this.closeTagView(tag);
            return;
        }
        String tag_title = tag.getTagName(true);
        if (this.show_tag_groups) {
            String group = tag.getGroup();
            String parent_id = entry.getParentID();
            boolean is_group = group != null && !group.isEmpty();
            String group_prefix = "Tag." + tag.getTagType().getTagType() + ".group.";
            boolean parent_is_group = is_group ? parent_id.equals(String.valueOf(group_prefix) + group) : parent_id.startsWith(group_prefix);
            if (is_group != parent_is_group) {
                this.resetTag(tag);
            }
        }
        if (!(old_title = entry.getTitle()).equals(tag_title)) {
            entry.setTitle(tag_title);
        }
        this.setTagIcon(tag, entry, false);
        Object[] tik = (Object[])entry.getUserData(TAG_INDICATOR_KEY);
        int tag_count = tag.getTaggedCount();
        int[] tag_colour = tag.getColor();
        if (tik == null || (Integer)tik[0] != tag_count || !Arrays.equals((int[])tik[1], tag_colour)) {
            entry.setUserData(TAG_INDICATOR_KEY, new Object[]{tag_count, tag_colour});
            this.requestRedraw(entry);
        }
        ViewTitleInfoManager.refreshTitleInfo(entry.getViewTitleInfo());
        Object[] tag_data = (Object[])entry.getUserData(TAG_DATA_KEY);
        if (tag_data != null && !Arrays.equals(auto_tag = tag.isTagAuto(), old_auto_tag = (boolean[])tag_data[1])) {
            tag_data[1] = auto_tag;
            if (auto_tag[0] && auto_tag[1]) {
                entry.removeListener((MdiEntryDropListener)tag_data[0]);
            } else {
                entry.addListener((MdiEntryDropListener)tag_data[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MdiEntry setupTag(final Tag tag) {
        final MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi == null) {
            return null;
        }
        if (!this.show_tag_tab_views) {
            return null;
        }
        int tag_type = tag.getTagType().getTagType();
        Object object = tag_setup_lock;
        synchronized (object) {
            MdiEntry entry;
            String parent_id;
            String id;
            block18: {
                String tag_group;
                id = "Tag." + tag_type + "." + tag.getTagID();
                parent_id = "header.transfers";
                String group_id = null;
                if (this.show_tag_groups && (tag_group = tag.getGroup()) != null && !tag_group.isEmpty() && (tag.getTaggableTypes() == 2 || tag.getTaggableTypes() == 4)) {
                    group_id = "Tag." + tag_type + ".group." + tag_group;
                    if (mdi.getEntry(group_id) == null) {
                        MdiEntry entry2;
                        final TagGroup group = tag.getGroupContainer();
                        final String gid = group_id;
                        final ViewTitleInfo viewTitleInfo = new ViewTitleInfo(){

                            @Override
                            public Object getTitleInfoProperty(int pid) {
                                if (pid == 5) {
                                    return tag_group;
                                }
                                if (pid == 0) {
                                    MdiEntrySWT entry = mdi.getEntry(gid);
                                    if (entry != null && !entry.isExpanded()) {
                                        return String.valueOf(group.getTags().size());
                                    }
                                } else if (pid == 8) {
                                    int[] colour = group.getColor();
                                    return colour;
                                }
                                return null;
                            }
                        };
                        TagGroupListener tgl = new TagGroupListener(){

                            @Override
                            public void tagRemoved(TagGroup group2, Tag tag) {
                                this.update();
                            }

                            @Override
                            public void tagAdded(TagGroup group2, Tag tag) {
                                this.update();
                            }

                            @Override
                            public void groupChanged(TagGroup group2) {
                                this.update();
                            }

                            private void update() {
                                MdiEntrySWT entry = mdi.getEntry(gid);
                                if (entry != null) {
                                    if (entry.isEntryDisposed()) {
                                        group.removeListener(this);
                                    } else {
                                        ViewTitleInfoManager.refreshTitleInfo(viewTitleInfo);
                                        SB_Transfers.this.requestRedraw(entry);
                                    }
                                }
                            }
                        };
                        group.addListener(tgl, false);
                        String prev_id = SB_Transfers.getTagPosition(mdi, parent_id, tag_type, tag_group);
                        boolean closeable = true;
                        if (tag.getTaggableTypes() == 2) {
                            entry2 = mdi.createEntryFromSkinRef(parent_id, group_id, "library", tag_group, viewTitleInfo, group, closeable, prev_id);
                        } else {
                            UISWTViewBuilderCore builder = new UISWTViewBuilderCore(group_id, null, PeersGeneralView.class);
                            builder.setParentEntryID(parent_id);
                            builder.setPreferredAfterID(prev_id).setInitialDatasource(group);
                            entry2 = mdi.createEntry(builder, closeable);
                            entry2.setViewTitleInfo(viewTitleInfo);
                        }
                        this.setTagIcon(tag, entry2, true);
                        entry2.setUserData(TAG_TAG_OR_GROUP_KEY, group);
                        entry2.addListener((e, user) -> {
                            if (user) {
                                List<Tag> kids = group.getTags();
                                for (Tag kid : kids) {
                                    kid.setVisible(false);
                                }
                            }
                        });
                        entry2.addListener(new MdiChildCloseListener(){
                            boolean closed;

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void mdiChildEntryClosed(MdiEntry parent, MdiEntry child, boolean user) {
                                String viewID = parent.getViewID();
                                if (mdi.getChildrenOf(viewID).isEmpty()) {
                                    35 var5_5 = this;
                                    synchronized (var5_5) {
                                        if (this.closed) {
                                            return;
                                        }
                                        this.closed = true;
                                    }
                                    mdi.runWhenIdle(() -> mdi.closeEntry(parent, false));
                                }
                            }
                        });
                        if (entry2 instanceof MdiEntrySWT) {
                            MdiEntrySWT entrySWT = (MdiEntrySWT)entry2;
                            entry2.addListener((entry1, droppedObject) -> {
                                List<Tag> tags = DragDropUtils.getTagsFromDroppedData(droppedObject);
                                if (tags.isEmpty()) {
                                    return false;
                                }
                                String groupName = tag.getGroupContainer().getName();
                                for (Tag droppedTag : tags) {
                                    droppedTag.setGroup(groupName);
                                }
                                return false;
                            });
                            entrySWT.addListener(new MdiSWTMenuHackListener(){

                                @Override
                                public void menuWillBeShown(MdiEntry entry, Menu menuTree) {
                                    if (tag.getTaggableTypes() == 2) {
                                        TagGroup tg = tag.getGroupContainer();
                                        SB_Transfers.addMenuCollapseAll(mdi, menuTree, entry.getViewID());
                                        new MenuItem(menuTree, 2);
                                        TagUIUtils.createSideBarMenuItems(menuTree, tg);
                                    }
                                }
                            });
                        }
                    }
                    parent_id = group_id;
                }
                if (mdi.getEntry(id) == null) break block18;
                return null;
            }
            String prev_id = SB_Transfers.getTagPosition(mdi, parent_id, tag_type, tag.getTagName(true));
            boolean auto = tag.getTagType().isTagTypeAuto();
            ViewTitleInfo viewTitleInfo = new ViewTitleInfo(){

                @Override
                public Object getTitleInfoProperty(int pid) {
                    if (pid == 5) {
                        return tag.getTagName(true);
                    }
                    if (pid == 0) {
                        return String.valueOf(tag.getTaggedCount());
                    }
                    if (pid == 8) {
                        TagType tag_type = tag.getTagType();
                        int[] def_color = tag_type.getColorDefault();
                        int[] tag_color = tag.getColor();
                        if (tag_color != def_color) {
                            return tag_color;
                        }
                    } else if (pid == 1) {
                        return TagUtils.getTagTooltip(tag);
                    }
                    return null;
                }
            };
            boolean closable = auto;
            if (tag.getTaggableTypes() == 2) {
                closable = true;
                String name = tag.getTagName(true);
                entry = mdi.createEntryFromSkinRef(parent_id, id, "library", name, viewTitleInfo, tag, closable, prev_id);
                SB_Transfers.addGeneralLibraryMenus(mdi, id);
            } else {
                UISWTViewBuilderCore builder = new UISWTViewBuilderCore(id, null, PeersGeneralView.class);
                builder.setParentEntryID(parent_id);
                builder.setPreferredAfterID(prev_id).setInitialDatasource(tag);
                entry = mdi.createEntry(builder, closable);
                entry.setViewTitleInfo(viewTitleInfo);
            }
            entry.setUserData(TAG_TAG_OR_GROUP_KEY, tag);
            if (closable) {
                entry.addListener(new MdiCloseListener(){

                    @Override
                    public void mdiEntryClosed(MdiEntry entry, boolean userClosed) {
                        if (userClosed && entry.getUserData(AUTO_CLOSE_KEY) == null && COConfigurationManager.getBooleanParameter("Library.TagInSideBar")) {
                            tag.setVisible(false);
                        }
                    }
                });
            }
            if (entry != null) {
                this.setTagIcon(tag, entry, false);
            }
            if (entry instanceof SideBarEntrySWT) {
                SideBarEntrySWT entrySWT = (SideBarEntrySWT)entry;
                entrySWT.addListener(new MdiSWTMenuHackListener(){

                    @Override
                    public void menuWillBeShown(MdiEntry entry, Menu menuTree) {
                        TagUIUtils.createSideBarMenuItems(menuTree, tag);
                    }
                });
            }
            if (!auto && entry != null) {
                MdiEntryDropListener dl = new MdiEntryDropListener(){

                    @Override
                    public boolean mdiEntryDrop(MdiEntry entry, Object payload) {
                        if (!(payload instanceof String)) {
                            return false;
                        }
                        boolean[] auto = tag.isTagAuto();
                        if (auto[0] && auto[1]) {
                            return false;
                        }
                        final String dropped = (String)payload;
                        new AEThread2("Tagger"){

                            @Override
                            public void run() {
                                this.dropTorrentOnTag(tag, dropped);
                            }
                        }.start();
                        return true;
                    }

                    private void dropTorrentOnTag(Tag tag2, String dropped) {
                        List<DownloadManager> dms = DragDropUtils.getDownloadsFromDropData(dropped, true);
                        if (dms.isEmpty()) {
                            return;
                        }
                        boolean doAdd = false;
                        int mods = Utils.getDragDetectModifiers();
                        if ((mods & 0x10000) != 0) {
                            doAdd = (mods & 0x20000) == 0;
                        } else {
                            for (DownloadManager dm : dms) {
                                if (tag2.hasTaggable(dm)) continue;
                                doAdd = true;
                                break;
                            }
                        }
                        boolean[] auto = tag2.isTagAuto();
                        if (auto.length < 2 || doAdd && auto[0] || !doAdd && auto[0] && auto[1]) {
                            return;
                        }
                        try {
                            tag2.addTaggableBatch(true);
                            for (DownloadManager dm : dms) {
                                if (doAdd) {
                                    if (tag2.hasTaggable(dm)) continue;
                                    tag2.addTaggable(dm);
                                    continue;
                                }
                                if (!tag2.hasTaggable(dm)) continue;
                                tag2.removeTaggable(dm);
                            }
                        }
                        finally {
                            tag2.addTaggableBatch(false);
                        }
                    }
                };
                boolean[] tag_auto = tag.isTagAuto();
                entry.setUserData(TAG_DATA_KEY, new Object[]{dl, tag_auto});
                if (!tag_auto[0] || !tag_auto[1]) {
                    entry.addListener(dl);
                }
            }
            return entry;
        }
    }

    public static String getSectionPosition(MultipleDocumentInterface mdi, String section) {
        String[] order = MultipleDocumentInterface.SIDEBAR_TRANSFERS_SECTION_ORDER;
        int i = 0;
        while (i < order.length) {
            if (order[i] == section) {
                int j = i - 1;
                while (j >= 0) {
                    int existing;
                    List<MdiEntry> kids;
                    String s = order[j];
                    if (mdi.getEntry(s) != null) {
                        return order[j];
                    }
                    if (s == "Tag.") {
                        kids = mdi.getChildrenOf("header.transfers");
                        existing = SB_Transfers.sortByTag(kids);
                        if (existing > 0) {
                            String tag = null;
                            for (MdiEntry e : kids) {
                                if (e.getUserData(TAG_TAG_OR_GROUP_KEY) == null) continue;
                                tag = e.getViewID();
                            }
                            if (tag != null) {
                                return tag;
                            }
                        }
                    } else if (s == "Cat." && (existing = SB_Transfers.sortByCat(kids = mdi.getChildrenOf("header.transfers"))) > 0) {
                        String cat = null;
                        for (MdiEntry e : kids) {
                            if (e.getUserData(CAT_KEY) == null) continue;
                            cat = e.getViewID();
                        }
                        if (cat != null) {
                            return cat;
                        }
                    }
                    --j;
                }
            }
            ++i;
        }
        return order[0];
    }

    private static int sortByTag(List<MdiEntry> entries) {
        Comparator<String> comp2 = FormattersImpl.getAlphanumericComparator2(true);
        Collections.sort(entries, (m1, m2) -> {
            String n2;
            TagType tt2;
            TagGroup tg;
            String n1;
            TagType tt1;
            Tag t;
            Object o2;
            Object o1 = m1.getUserData(TAG_TAG_OR_GROUP_KEY);
            if (o1 == (o2 = m2.getUserData(TAG_TAG_OR_GROUP_KEY))) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1 instanceof Tag) {
                t = (Tag)o1;
                tt1 = t.getTagType();
                n1 = t.getTagName(true);
            } else {
                tg = (TagGroup)o1;
                tt1 = tg.getTagType();
                n1 = tg.getName();
            }
            if (o2 instanceof Tag) {
                t = (Tag)o2;
                tt2 = t.getTagType();
                n2 = t.getTagName(true);
            } else {
                tg = (TagGroup)o2;
                tt2 = tg.getTagType();
                n2 = tg.getName();
            }
            if (tt1 == tt2) {
                return comp2.compare(n1, n2);
            }
            return tt1.getTagType() - tt2.getTagType();
        });
        int num_tags = 0;
        for (MdiEntry e : entries) {
            if (e.getUserData(TAG_TAG_OR_GROUP_KEY) == null) continue;
            ++num_tags;
        }
        return num_tags;
    }

    private static String getTagPosition(MultipleDocumentInterfaceSWT mdi, String parent_id, int tag_type, String name) {
        String prev_id = null;
        List<MdiEntry> kids = mdi.getChildrenOf(parent_id);
        int existing = SB_Transfers.sortByTag(kids);
        if (existing == 0) {
            int cats = SB_Transfers.sortByCat(kids);
            if (cats == 0) {
                return SB_Transfers.getSectionPosition(mdi, "Tag.");
            }
            for (MdiEntry e : kids) {
                if (e.getUserData(CAT_KEY) == null) continue;
                prev_id = e.getViewID();
            }
            if (prev_id != null) {
                return prev_id;
            }
        }
        Comparator<String> comp2 = FormattersImpl.getAlphanumericComparator2(true);
        String tt_prefix = "Tag." + tag_type + ".";
        ArrayList<String> tt_matches = new ArrayList<String>();
        boolean tt_matched = false;
        for (MdiEntry kid : kids) {
            String kid_id = kid.getViewID();
            String title = kid.getTitle();
            if (!kid_id.startsWith(tt_prefix)) continue;
            tt_matches.add(kid_id);
            if (comp2.compare(title, name) <= 0) continue;
            tt_matched = true;
            break;
        }
        int tt_match_count = tt_matches.size();
        if (tt_match_count == 0) {
            for (MdiEntry kid : kids) {
                int tt;
                Object o = kid.getUserData(TAG_TAG_OR_GROUP_KEY);
                if (o == null) continue;
                int n = tt = o instanceof Tag ? ((Tag)o).getTagType().getTagType() : ((TagGroup)o).getTagType().getTagType();
                if (tt > tag_type) continue;
                prev_id = kid.getViewID();
            }
            if (prev_id == null) {
                prev_id = SB_Transfers.getSectionPosition(mdi, "Tag.");
            }
        } else {
            prev_id = tt_matched ? (tt_match_count == 1 ? "~" + (String)tt_matches.get(0) : (String)tt_matches.get(tt_match_count - 2)) : (String)tt_matches.get(tt_match_count - 1);
        }
        return prev_id;
    }

    private static int sortByCat(List<MdiEntry> entries) {
        Comparator<String> comp2 = FormattersImpl.getAlphanumericComparator2(true);
        Collections.sort(entries, (m1, m2) -> {
            Object o2;
            Object o1 = m1.getUserData(CAT_KEY);
            if (o1 == (o2 = m2.getUserData(CAT_KEY))) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            String s1 = m1.getTitle();
            String s2 = m2.getTitle();
            return comp2.compare(s1, s2);
        });
        int num_cats = 0;
        for (MdiEntry e : entries) {
            if (e.getUserData(CAT_KEY) == null) continue;
            ++num_cats;
        }
        return num_cats;
    }

    private static String getCatPosition(MultipleDocumentInterface mdi, String parent_id, String name) {
        String prev_id = null;
        List<MdiEntry> kids = mdi.getChildrenOf(parent_id);
        int num_cats = SB_Transfers.sortByCat(kids);
        if (num_cats == 0) {
            return SB_Transfers.getSectionPosition(mdi, "Cat.");
        }
        Comparator<String> comp2 = FormattersImpl.getAlphanumericComparator2(true);
        String prefix = "Cat.";
        ArrayList<String> matches = new ArrayList<String>();
        boolean matched = false;
        for (MdiEntry kid : kids) {
            String kid_id = kid.getViewID();
            String title = kid.getTitle();
            if (!kid_id.startsWith(prefix)) continue;
            matches.add(kid_id);
            if (comp2.compare(title, name) <= 0) continue;
            matched = true;
            break;
        }
        int match_count = matches.size();
        if (match_count != 0) {
            prev_id = matched ? (match_count == 1 ? "~" + (String)matches.get(0) : (String)matches.get(match_count - 2)) : (String)matches.get(match_count - 1);
        }
        return prev_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeTagView(Tag tag) {
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return;
        }
        int tag_type = tag.getTagType().getTagType();
        Object object = tag_setup_lock;
        synchronized (object) {
            MdiEntry entry = mdi.getEntry("Tag." + tag_type + "." + tag.getTagID());
            if (entry != null) {
                entry.setUserData(AUTO_CLOSE_KEY, "");
                mdi.closeEntry(entry, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetTag(Tag tag) {
        Object object = tag_setup_lock;
        synchronized (object) {
            this.closeTagView(tag);
            this.setupTag(tag);
        }
    }

    private void setTagIcon(Tag tag, final MdiEntry entry, boolean default_only) {
        if (!default_only) {
            String existing;
            String image_file = tag.getImageFile();
            if (image_file == null) {
                image_file = "";
            }
            if ((existing = (String)entry.getUserData(TAG_IMAGE_KEY)) == image_file || existing != null && existing.equals(image_file)) {
                return;
            }
            entry.setUserData(TAG_IMAGE_KEY, image_file);
            if (!image_file.isEmpty()) {
                final String fif = image_file;
                Utils.execSWTThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ImageLoader.getInstance().getFileImage(new File(fif), new Point(20, 14), new ImageLoader.ImageDownloaderListener(){

                                @Override
                                public void imageDownloaded(Image image, String key, boolean returnedImmediately) {
                                    ((MdiEntrySWT)entry).setImageLeftID(key);
                                }
                            });
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                });
                return;
            }
        }
        ((MdiEntrySWT)entry).setImageLeft(null);
        String image_id = tag.getImageID();
        if (image_id != null) {
            entry.setImageLeftID(image_id);
        } else if (tag.getTagType().getTagType() == 4) {
            entry.setImageLeftID("image.sidebar.tag-red");
        } else if (tag.getTagType().isTagTypePersistent()) {
            entry.setImageLeftID("image.sidebar.tag-green");
        } else {
            entry.setImageLeftID("image.sidebar.tag-blue");
        }
    }

    private int updateDMCounts(DownloadManager dm) {
        boolean isDownloading;
        boolean isSeeding;
        Boolean wasSeedingB = (Boolean)dm.getUserData("wasSeeding");
        boolean wasSeeding = wasSeedingB != null && wasSeedingB != false;
        Boolean wasDownloadingB = (Boolean)dm.getUserData("wasDownloading");
        boolean wasDownloading = wasDownloadingB != null && wasDownloadingB != false;
        Boolean wasStoppedB = (Boolean)dm.getUserData("wasStopped");
        boolean wasStopped = wasStoppedB != null && wasStoppedB != false;
        Boolean wasQueuedB = (Boolean)dm.getUserData("wasQueued");
        boolean wasQueued = wasQueuedB != null && wasQueuedB != false;
        int dm_state = dm.getState();
        if (dm.getAssumedComplete()) {
            isSeeding = dm_state == 60;
            isDownloading = false;
        } else {
            isDownloading = dm_state == 50;
            isSeeding = false;
        }
        boolean isStopped = dm_state == 70;
        boolean isQueued = dm_state == 75;
        boolean lowNoise = PlatformTorrentUtils.isAdvancedViewOnly(dm);
        if (isDownloading != wasDownloading) {
            if (isDownloading) {
                ++this.statsWithLowNoise.numDownloading;
                if (!lowNoise) {
                    ++this.statsNoLowNoise.numDownloading;
                }
            } else {
                --this.statsWithLowNoise.numDownloading;
                if (!lowNoise) {
                    --this.statsNoLowNoise.numDownloading;
                }
            }
            dm.setUserData("wasDownloading", isDownloading);
        }
        if (isSeeding != wasSeeding) {
            if (isSeeding) {
                ++this.statsWithLowNoise.numSeeding;
                if (!lowNoise) {
                    ++this.statsNoLowNoise.numSeeding;
                }
            } else {
                --this.statsWithLowNoise.numSeeding;
                if (!lowNoise) {
                    --this.statsNoLowNoise.numSeeding;
                }
            }
            dm.setUserData("wasSeeding", isSeeding);
        }
        if (isStopped != wasStopped) {
            if (isStopped) {
                if (!dm.getAssumedComplete()) {
                    ++this.statsWithLowNoise.numStoppedIncomplete;
                }
                if (!lowNoise && !dm.getAssumedComplete()) {
                    ++this.statsNoLowNoise.numStoppedIncomplete;
                }
            } else {
                if (!dm.getAssumedComplete()) {
                    --this.statsWithLowNoise.numStoppedIncomplete;
                }
                if (!lowNoise && !dm.getAssumedComplete()) {
                    --this.statsNoLowNoise.numStoppedIncomplete;
                }
            }
            dm.setUserData("wasStopped", isStopped);
        }
        if (isQueued != wasQueued) {
            if (isQueued) {
                ++this.statsWithLowNoise.numQueued;
                if (!lowNoise) {
                    ++this.statsNoLowNoise.numQueued;
                }
            } else {
                --this.statsWithLowNoise.numQueued;
                if (!lowNoise) {
                    --this.statsNoLowNoise.numQueued;
                }
            }
            dm.setUserData("wasQueued", isQueued);
        }
        return dm_state;
    }

    void recountItems() {
        if (!CoreFactory.isCoreRunning()) {
            return;
        }
        GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
        List<DownloadManager> dms = gm.getDownloadManagers();
        this.statsNoLowNoise.total = 0;
        this.statsWithLowNoise.total = 0;
        this.statsNoLowNoise.numUnOpened = 0;
        for (DownloadManager dm : dms) {
            if (!PlatformTorrentUtils.getHasBeenOpened(dm) && dm.getAssumedComplete()) {
                ++this.statsNoLowNoise.numUnOpened;
            }
            ++this.statsWithLowNoise.total;
            if (PlatformTorrentUtils.isAdvancedViewOnly(dm)) continue;
            ++this.statsNoLowNoise.total;
        }
        this.statsWithLowNoise.numUnOpened = this.statsNoLowNoise.numUnOpened;
    }

    protected void addCountRefreshListener(countRefreshListener l) {
        l.countRefreshed(this.statsWithLowNoise, this.statsNoLowNoise);
        this.listeners.add(l);
    }

    public void triggerCountRefreshListeners() {
        for (countRefreshListener l : this.listeners) {
            l.countRefreshed(this.statsWithLowNoise, this.statsNoLowNoise);
        }
    }

    void refreshAllLibraries() {
        if (this.refresh_limiter != null) {
            this.refresh_limiter.dispatch();
        }
    }

    void refreshAllLibrariesSupport(boolean vuze_ui) {
        for (countRefreshListener l : this.listeners) {
            l.countRefreshed(this.statsWithLowNoise, this.statsNoLowNoise);
        }
        if (vuze_ui) {
            String imageID;
            List<? extends MdiEntryVitalityImage> vitalityImages;
            MdiEntry entry;
            MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
            if (mdi == null) {
                return;
            }
            if (mdi.isInitialized()) {
                boolean showDownloading = COConfigurationManager.getBooleanParameter("Show Downloading In Side Bar");
                if (showDownloading && this.statsNoLowNoise.numIncomplete > 0) {
                    long l;
                    MdiEntry entry2 = mdi.getEntry("LibraryDL");
                    if (entry2 == null && (l = SystemTime.getMonotonousTime()) - this.last_dl_entry_load > 5000L) {
                        this.last_dl_entry_load = l;
                        mdi.loadEntryByID("LibraryDL", false);
                    }
                } else {
                    mdi.closeEntry(mdi.getEntry("LibraryDL"), false);
                }
            } else {
                this.refreshAllLibraries();
            }
            if ((entry = mdi.getEntry("LibraryDL")) != null) {
                vitalityImages = entry.getVitalityImages();
                for (MdiEntryVitalityImage mdiEntryVitalityImage : vitalityImages) {
                    imageID = mdiEntryVitalityImage.getImageID();
                    if (imageID == null || imageID.equals(ID_VITALITY_ACTIVE) || !imageID.equals(ID_VITALITY_ALERT)) continue;
                    mdiEntryVitalityImage.setVisible(this.statsNoLowNoise.numErrorInComplete > 0);
                    if (this.statsNoLowNoise.numErrorInComplete <= 0) continue;
                    mdiEntryVitalityImage.setToolTip(this.statsNoLowNoise.errorInCompleteTooltip);
                }
                ViewTitleInfoManager.refreshTitleInfo(entry.getViewTitleInfo());
                this.requestRedraw(entry);
            }
            if ((entry = mdi.getEntry("LibraryCD")) != null) {
                vitalityImages = entry.getVitalityImages();
                for (MdiEntryVitalityImage mdiEntryVitalityImage : vitalityImages) {
                    imageID = mdiEntryVitalityImage.getImageID();
                    if (imageID == null || !imageID.equals(ID_VITALITY_ALERT)) continue;
                    mdiEntryVitalityImage.setVisible(this.statsNoLowNoise.numErrorComplete > 0);
                    if (this.statsNoLowNoise.numErrorComplete <= 0) continue;
                    mdiEntryVitalityImage.setToolTip(this.statsNoLowNoise.errorCompleteTooltip);
                }
            }
            if ((entry = mdi.getEntry("LibraryUnopened")) != null) {
                ViewTitleInfoManager.refreshTitleInfo(entry.getViewTitleInfo());
                this.requestRedraw(entry);
            }
            if ((entry = mdi.getEntry("Library")) != null) {
                ViewTitleInfoManager.refreshTitleInfo(entry.getViewTitleInfo());
                this.requestRedraw(entry);
            }
        }
        this.RefreshCategorySideBar(CategoryManager.getCategory(1));
        this.RefreshCategorySideBar(CategoryManager.getCategory(2));
    }

    private static String getTableSubID(Object ds) {
        if (ds instanceof Tag) {
            Tag tag = (Tag)ds;
            if (tag.getTagType().getTagType() == 3) {
                return "Tag_" + ((Tag)ds).getTagUID();
            }
        } else if (ds instanceof TagGroup) {
            TagGroup tg = (TagGroup)ds;
            return "TagGroup_" + Base32.encode(tg.getName().getBytes(Constants.UTF_8));
        }
        return null;
    }

    public static String getTableIdFromFilterMode(int torrentFilterMode, boolean big, Object dataSource) {
        String baseTableID = null;
        if (torrentFilterMode == 1) {
            baseTableID = big ? "MySeeders.big" : "MySeeders";
        } else if (torrentFilterMode == 2) {
            baseTableID = big ? "MyTorrents.big" : "MyTorrents";
        } else if (torrentFilterMode == 0) {
            baseTableID = big ? "MyLibrary.big" : (COConfigurationManager.getIntParameter("Library.TorrentViewSplitMode") == 4 ? "MyLibrary.small" : "MyLibrary.big");
        } else if (torrentFilterMode == 3) {
            String string = baseTableID = big ? "Unopened.big" : "Unopened";
        }
        if (baseTableID == null) {
            return null;
        }
        if (TABLE_SUBCONFIG_ENABLE) {
            String sub = SB_Transfers.getTableSubID(dataSource);
            if (sub == null) {
                return baseTableID;
            }
            return Utils.createSubViewID(baseTableID, sub);
        }
        return baseTableID;
    }

    public static String getTableIdFromDataSource(String baseTableID, Object dataSource) {
        if (TABLE_SUBCONFIG_ENABLE) {
            String sub = SB_Transfers.getTableSubID(dataSource);
            if (sub == null) {
                return baseTableID;
            }
            return Utils.createSubViewID(baseTableID, sub);
        }
        return baseTableID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTagManagerListeners() {
        Object object = this.tag_listener_lock;
        synchronized (object) {
            if (this.tagManagerListener != null) {
                return;
            }
            this.tagListener = new TagListener(){

                @Override
                public void taggableAdded(Tag tag, Taggable tagged) {
                    SB_Transfers.this.refreshTagSideBar(tag);
                }

                @Override
                public void taggableSync(Tag tag) {
                    SB_Transfers.this.refreshTagSideBar(tag);
                }

                @Override
                public void taggableRemoved(Tag tag, Taggable tagged) {
                    SB_Transfers.this.refreshTagSideBar(tag);
                }
            };
            this.tagTypeListener = new TagTypeListener(){

                @Override
                public void tagTypeChanged(TagType tag_type) {
                    for (Tag tag : tag_type.getTags()) {
                        if (tag.isVisible()) {
                            SB_Transfers.this.setupTag(tag);
                            continue;
                        }
                        SB_Transfers.this.refreshTagSideBar(tag);
                    }
                }

                @Override
                public void tagEventOccurred(TagTypeListener.TagEvent event2) {
                    int type = event2.getEventType();
                    Tag tag = event2.getTag();
                    if (type == 0) {
                        this.tagAdded(tag);
                    } else if (type == 1 || type == 4) {
                        this.tagChanged(tag);
                    } else if (type == 2) {
                        this.tagRemoved(tag);
                    } else if (type == 3) {
                        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                        if (mdi == null) {
                            return;
                        }
                        MdiEntry entry = mdi.getEntry("Tag." + tag.getTagType().getTagType() + "." + tag.getTagID());
                        if (entry != null) {
                            mdi.showEntry(entry);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void tagAdded(Tag tag) {
                    Object object = SB_Transfers.this.tag_listener_lock;
                    synchronized (object) {
                        if (tag.isVisible() && SB_Transfers.this.tagListener != null) {
                            SB_Transfers.this.setupTag(tag);
                            tag.addTagListener(SB_Transfers.this.tagListener, false);
                        }
                    }
                }

                public void tagChanged(Tag tag) {
                    SB_Transfers.this.refreshTagSideBar(tag);
                }

                public void tagRemoved(Tag tag) {
                    SB_Transfers.this.closeTagView(tag);
                }
            };
            this.tagManagerListener = new TagManagerListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void tagTypeAdded(TagManager manager, TagType tag_type) {
                    Object object = SB_Transfers.this.tag_listener_lock;
                    synchronized (object) {
                        int tt = tag_type.getTagType();
                        if (tt != 1 && tt != 5 && tt != 7 && SB_Transfers.this.tagTypeListener != null) {
                            tag_type.addTagTypeListener(SB_Transfers.this.tagTypeListener, true);
                        }
                    }
                }

                @Override
                public void tagTypeRemoved(TagManager manager, TagType tag_type) {
                    for (Tag t : tag_type.getTags()) {
                        SB_Transfers.this.closeTagView(t);
                    }
                }
            };
            TagManagerFactory.getTagManager().addTagManagerListener(this.tagManagerListener, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTagManagerListeners(boolean removeFromSidebar) {
        Object object = this.tag_listener_lock;
        synchronized (object) {
            if (this.tagManagerListener == null) {
                return;
            }
            TagManagerFactory.getTagManager().removeTagManagerListener(this.tagManagerListener);
            List<TagType> tag_types = TagManagerFactory.getTagManager().getTagTypes();
            for (TagType tt : tag_types) {
                if (tt.getTagType() != 1) {
                    tt.removeTagTypeListener(this.tagTypeListener);
                }
                for (Tag t : tt.getTags()) {
                    t.removeTagListener(this.tagListener);
                    if (!removeFromSidebar) continue;
                    this.closeTagView(t);
                }
            }
            this.tagManagerListener = null;
            this.tagListener = null;
            this.tagTypeListener = null;
        }
    }

    public void dispose() {
        if (this.categoryListener != null) {
            Category[] categories = CategoryManager.getCategories();
            if (categories.length >= 0) {
                Category[] categoryArray = categories;
                int n = categories.length;
                int n2 = 0;
                while (n2 < n) {
                    Category cat = categoryArray[n2];
                    cat.removeCategoryListener(this.categoryListener);
                    ++n2;
                }
            }
            CategoryManager.removeCategoryManagerListener(this.categoryManagerListener);
        }
        if (this.tagManagerListener != null) {
            this.removeTagManagerListeners(false);
        }
        if (this.hasBeenOpenedListener != null) {
            PlatformTorrentUtils.removeHasBeenOpenedListener(this.hasBeenOpenedListener);
        }
        this.refresh_limiter = null;
        if (this.dmListener != null || this.gmListener != null) {
            GlobalManager gm;
            if (this.core != null && (gm = this.core.getGlobalManager()) != null) {
                if (this.gmListener != null) {
                    gm.removeListener(this.gmListener);
                }
                if (this.dmListener != null) {
                    List<DownloadManager> dms = gm.getDownloadManagers();
                    for (DownloadManager dm : dms) {
                        dm.removeListener(this.dmListener);
                    }
                }
            }
            this.gmListener = null;
            this.dmListener = null;
        }
        if (this.timerEventPeriodic != null) {
            this.timerEventPeriodic.cancel();
            this.timerEventPeriodic = null;
        }
        this.listeners.clear();
        COConfigurationManager.removeParameterListener("MyTorrentsView.showuptime", this.configListenerShow);
        COConfigurationManager.removeParameterListener("MyTorrentsView.showrates", this.configListenerShow);
        COConfigurationManager.removeParameterListener("Library.viewmode", this.configListenerShow);
        if (this.timerEventShowUptime != null) {
            this.timerEventShowUptime.cancel();
            this.timerEventShowUptime = null;
        }
        COConfigurationManager.removeParameterListener("Library.TagInSideBar", this.paramTagsInSidebarListener);
        COConfigurationManager.removeParameterListener("Library.TagGroupsInSideBar", this.paramTagGroupsInSidebarListener);
        COConfigurationManager.removeParameterListener("Library.CatInSideBar", this.paramCatInSidebarListener);
    }

    private class MyMdiEntryCreationListener
    implements MdiEntryCreationListener {
        private final MultipleDocumentInterfaceSWT mdi;

        public MyMdiEntryCreationListener(MultipleDocumentInterfaceSWT mdi) {
            this.mdi = mdi;
        }

        @Override
        public MdiEntry createMDiEntry(String id) {
            ViewTitleInfo titleInfo = new ViewTitleInfo(){

                @Override
                public Object getTitleInfoProperty(int propertyID) {
                    int total_wln = ((SB_Transfers)((MyMdiEntryCreationListener)MyMdiEntryCreationListener.this).SB_Transfers.this).statsWithLowNoise.total;
                    int total_nln = ((SB_Transfers)((MyMdiEntryCreationListener)MyMdiEntryCreationListener.this).SB_Transfers.this).statsNoLowNoise.total;
                    if (propertyID == 0) {
                        int viewmode = COConfigurationManager.getIntParameter("Library.viewmode", 0);
                        if (total_wln == total_nln || viewmode == 1 || !COConfigurationManager.getBooleanParameter("Library.EnableSimpleView")) {
                            return String.valueOf(total_wln);
                        }
                        return String.valueOf(total_nln) + " | " + total_wln;
                    }
                    if (propertyID == 1 && total_wln != total_nln) {
                        return String.valueOf(MessageText.getString("v3.MainWindow.menu.view.asSimpleList")) + "=" + total_nln + ", " + MessageText.getString("v3.MainWindow.menu.view.asAdvancedList") + "=" + total_wln;
                    }
                    return null;
                }
            };
            MdiEntry entry = this.mdi.createEntryFromSkinRef("header.transfers", "Library", "library", "{sidebar.Library}", titleInfo, null, false, "");
            entry.setImageLeftID("image.sidebar.library");
            SB_Transfers.addGeneralLibraryMenus(this.mdi, "Library");
            return entry;
        }
    }

    protected static interface countRefreshListener {
        public void countRefreshed(stats var1, stats var2);
    }

    public static class stats {
        int total = 0;
        int numSeeding = 0;
        int numDownloading = 0;
        int numQueued = 0;
        int numComplete = 0;
        int numIncomplete = 0;
        int numErrorComplete = 0;
        String errorInCompleteTooltip;
        int numErrorInComplete = 0;
        String errorCompleteTooltip;
        int numUnOpened = 0;
        int numStoppedIncomplete = 0;
        boolean includeLowNoise;
        long newestIncompleteDownloadTime = 0L;

        private boolean sameAs(stats other) {
            return this.total == other.total && this.numSeeding == other.numSeeding && this.numDownloading == other.numDownloading && this.numQueued == other.numQueued && this.numComplete == other.numComplete && this.numIncomplete == other.numIncomplete && this.numErrorComplete == other.numErrorComplete && this.numErrorInComplete == other.numErrorInComplete && this.numUnOpened == other.numUnOpened && this.numStoppedIncomplete == other.numStoppedIncomplete && this.newestIncompleteDownloadTime == other.newestIncompleteDownloadTime;
        }

        private void copyFrom(stats other) {
            this.total = other.total;
            this.numSeeding = other.numSeeding;
            this.numDownloading = other.numDownloading;
            this.numQueued = other.numQueued;
            this.numComplete = other.numComplete;
            this.numIncomplete = other.numIncomplete;
            this.numErrorComplete = other.numErrorComplete;
            this.errorInCompleteTooltip = other.errorInCompleteTooltip;
            this.numErrorInComplete = other.numErrorInComplete;
            this.errorCompleteTooltip = other.errorCompleteTooltip;
            this.numUnOpened = other.numUnOpened;
            this.numStoppedIncomplete = other.numStoppedIncomplete;
            this.includeLowNoise = other.includeLowNoise;
            this.newestIncompleteDownloadTime = other.newestIncompleteDownloadTime;
        }
    }
}

