/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.skin;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.category.Category;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerEvent;
import com.biglybt.core.global.GlobalManagerEventListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagFeatureProperties;
import com.biglybt.core.tag.TagFeatureRateLimit;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagManagerListener;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.tag.TagTypeListener;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.RegExUtil;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.ui.UIInputReceiver;
import com.biglybt.pif.ui.UIInputReceiverListener;
import com.biglybt.pif.ui.UIPluginViewToolBarListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnCreationListener;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.ToolBarItem;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableCountChangeListener;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableSelectionListener;
import com.biglybt.ui.common.table.TableViewFilterCheck;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.common.table.impl.TableViewImpl;
import com.biglybt.ui.common.updater.UIUpdatable;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.SimpleTextEntryWindow;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.columns.tag.ColumnTagAggregateSR;
import com.biglybt.ui.swt.columns.tag.ColumnTagAggregateSRMax;
import com.biglybt.ui.swt.columns.tag.ColumnTagColor;
import com.biglybt.ui.swt.columns.tag.ColumnTagCopyOnComp;
import com.biglybt.ui.swt.columns.tag.ColumnTagCount;
import com.biglybt.ui.swt.columns.tag.ColumnTagDependsOn;
import com.biglybt.ui.swt.columns.tag.ColumnTagDownLimit;
import com.biglybt.ui.swt.columns.tag.ColumnTagDownRate;
import com.biglybt.ui.swt.columns.tag.ColumnTagDownSession;
import com.biglybt.ui.swt.columns.tag.ColumnTagDownTotal;
import com.biglybt.ui.swt.columns.tag.ColumnTagEOA;
import com.biglybt.ui.swt.columns.tag.ColumnTagFilter;
import com.biglybt.ui.swt.columns.tag.ColumnTagGroup;
import com.biglybt.ui.swt.columns.tag.ColumnTagIcon;
import com.biglybt.ui.swt.columns.tag.ColumnTagIconSortOrder;
import com.biglybt.ui.swt.columns.tag.ColumnTagInitialSaveLocation;
import com.biglybt.ui.swt.columns.tag.ColumnTagLimits;
import com.biglybt.ui.swt.columns.tag.ColumnTagMaxSR;
import com.biglybt.ui.swt.columns.tag.ColumnTagMinSR;
import com.biglybt.ui.swt.columns.tag.ColumnTagMoveOnAssign;
import com.biglybt.ui.swt.columns.tag.ColumnTagMoveOnComp;
import com.biglybt.ui.swt.columns.tag.ColumnTagMoveOnRemove;
import com.biglybt.ui.swt.columns.tag.ColumnTagName;
import com.biglybt.ui.swt.columns.tag.ColumnTagProperties;
import com.biglybt.ui.swt.columns.tag.ColumnTagPublic;
import com.biglybt.ui.swt.columns.tag.ColumnTagRSSFeed;
import com.biglybt.ui.swt.columns.tag.ColumnTagStatus;
import com.biglybt.ui.swt.columns.tag.ColumnTagType;
import com.biglybt.ui.swt.columns.tag.ColumnTagUpLimit;
import com.biglybt.ui.swt.columns.tag.ColumnTagUpRate;
import com.biglybt.ui.swt.columns.tag.ColumnTagUpSession;
import com.biglybt.ui.swt.columns.tag.ColumnTagUpTotal;
import com.biglybt.ui.swt.columns.tag.ColumnTagUploadPriority;
import com.biglybt.ui.swt.columns.tag.ColumnTagVisible;
import com.biglybt.ui.swt.columns.tag.ColumnTagXCode;
import com.biglybt.ui.swt.components.BubbleTextBox;
import com.biglybt.ui.swt.mainwindow.MenuFactory;
import com.biglybt.ui.swt.mdi.MdiEntrySWT;
import com.biglybt.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.biglybt.ui.swt.pifimpl.UISWTViewBuilderCore;
import com.biglybt.ui.swt.skin.SWTSkinButtonUtility;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectButton;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import com.biglybt.ui.swt.skin.SWTSkinObjectText;
import com.biglybt.ui.swt.skin.SWTSkinObjectTextbox;
import com.biglybt.ui.swt.utils.DragDropUtils;
import com.biglybt.ui.swt.utils.TagUIUtilsV3;
import com.biglybt.ui.swt.views.FilesView;
import com.biglybt.ui.swt.views.MyTorrentsSubView;
import com.biglybt.ui.swt.views.MyTorrentsView;
import com.biglybt.ui.swt.views.TagSettingsView;
import com.biglybt.ui.swt.views.ViewManagerSWT;
import com.biglybt.ui.swt.views.skin.InfoBarUtil;
import com.biglybt.ui.swt.views.skin.SkinView;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.TableViewSWTMenuFillListener;
import com.biglybt.ui.swt.views.table.impl.TableViewFactory;
import com.biglybt.ui.swt.views.table.impl.TableViewSWT_TabsCommon;
import com.biglybt.ui.swt.views.utils.TagUIUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class SBC_TagsOverview
extends SkinView
implements UIUpdatable,
UIPluginViewToolBarListener,
TableViewFilterCheck<Tag>,
TagManagerListener,
TagTypeListener,
TableViewSWTMenuFillListener,
TableSelectionListener,
KeyListener,
ParameterListener,
GlobalManagerEventListener {
    private static final String TABLE_TAGS = "TagsView";
    public static final Class<Tag> PLUGIN_DS_TYPE = Tag.class;
    TableViewSWT<Tag> tv;
    private Composite table_parent;
    private boolean columnsAdded = false;
    private boolean tm_listener_added;
    private boolean gm_listener_added;
    private Object datasource;
    private boolean show_swarm_tags;
    private GlobalManager global_manager;

    public SBC_TagsOverview() {
        try {
            this.global_manager = CoreFactory.getSingleton().getGlobalManager();
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        COConfigurationManager.addAndFireParameterListener("Show Swarm Tags In Overview", this);
    }

    @Override
    public void parameterChanged(String parameterName) {
        this.show_swarm_tags = COConfigurationManager.getBooleanParameter(parameterName);
        if (this.tv != null) {
            this.tv.refilter();
        }
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        boolean isTableSelected = false;
        if (this.tv instanceof TableViewImpl) {
            isTableSelected = ((TableViewImpl)((Object)this.tv)).isTableSelected();
        }
        if (!isTableSelected) {
            UIPluginViewToolBarListener l;
            MdiEntrySWT active_view = this.getActiveView();
            return active_view != null && (l = active_view.getToolBarListener()) != null && l.toolBarItemActivated(item, activationType, datasource);
        }
        if (this.tv == null || !this.tv.isVisible()) {
            return false;
        }
        if ("remove".equals(item.getID())) {
            Object[] datasources = this.tv.getSelectedDataSources().toArray();
            ArrayList<Tag> tags = new ArrayList<Tag>();
            Object[] objectArray = datasources;
            int n = datasources.length;
            int n2 = 0;
            while (n2 < n) {
                Object tag = objectArray[n2];
                if (tag instanceof Tag) {
                    tags.add((Tag)tag);
                }
                ++n2;
            }
            if (tags.size() > 0) {
                return TagUIUtils.removeTags(tags);
            }
        }
        return false;
    }

    private MdiEntrySWT getActiveView() {
        TableViewSWT_TabsCommon tabsCommon = this.tv.getTabsCommon();
        if (tabsCommon != null) {
            return tabsCommon.getActiveSubView();
        }
        return null;
    }

    @Override
    public void filterSet(String filter2) {
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        if (this.tv == null || !this.tv.isVisible()) {
            return;
        }
        boolean canEnable = false;
        Object[] datasources = this.tv.getSelectedDataSources().toArray();
        if (datasources.length > 0) {
            Object[] objectArray = datasources;
            int n = datasources.length;
            int n2 = 0;
            while (n2 < n) {
                Tag tag;
                Object object = objectArray[n2];
                if (object instanceof Tag && TagUIUtils.canDeleteTag(tag = (Tag)object)) {
                    canEnable = true;
                    break;
                }
                ++n2;
            }
        }
        list.put("remove", canEnable ? 1L : 0L);
    }

    @Override
    public void updateUI() {
        if (this.tv != null) {
            this.tv.refreshTable(false);
        }
    }

    @Override
    public String getUpdateUIName() {
        return TABLE_TAGS;
    }

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        this.initColumns();
        SWTSkinObjectContainer soTopArea = (SWTSkinObjectContainer)this.getSkinObject("tag-top-area");
        SWTSkinObjectText soTitle = (SWTSkinObjectText)this.getSkinObject("title");
        Control[] controlArray = new Control[]{soTopArea.getComposite(), soTitle.getControl()};
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control comp2 = controlArray[n2];
            Menu menu = new Menu(comp2);
            comp2.setMenu(menu);
            MenuItem mi = new MenuItem(menu, 8);
            mi.setText(MessageText.getString("menu.tag.options"));
            mi.addListener(13, ev -> {
                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                if (uif != null) {
                    uif.getMDI().showEntryByID("ConfigView", "style.tags");
                }
            });
            ++n2;
        }
        SWTSkinObjectButton soAddTagButton = (SWTSkinObjectButton)this.getSkinObject("add-tag");
        if (soAddTagButton != null) {
            soAddTagButton.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                @Override
                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    TagUIUtilsV3.showCreateTagDialog(null);
                }
            });
        }
        new InfoBarUtil(skinObject, "tagsview.infobar", false, "tags.infobar", "tags.view.infobar"){

            @Override
            public boolean allowShow() {
                return true;
            }
        };
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initColumns() {
        Class<SBC_TagsOverview> clazz = SBC_TagsOverview.class;
        synchronized (SBC_TagsOverview.class) {
            if (this.columnsAdded) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.columnsAdded = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            TableColumnManager tableManager = TableColumnManager.getInstance();
            tableManager.registerColumn(Tag.class, ColumnTagCount.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagCount(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagColor.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagColor(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagName.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagName(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagType.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagType(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagPublic.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagPublic(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagUpRate.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagUpRate(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagDownRate.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagDownRate(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagUpLimit.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagUpLimit(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagDownLimit.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagDownLimit(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagUpSession.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagUpSession(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagDownSession.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagDownSession(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagUpTotal.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagUpTotal(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagDownTotal.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagDownTotal(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagRSSFeed.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagRSSFeed(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagUploadPriority.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagUploadPriority(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagMinSR.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagMinSR(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagMaxSR.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagMaxSR(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagAggregateSR.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagAggregateSR(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagAggregateSRMax.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagAggregateSRMax(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagXCode.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagXCode(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagInitialSaveLocation.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagInitialSaveLocation(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagMoveOnComp.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagMoveOnComp(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagCopyOnComp.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagCopyOnComp(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagMoveOnRemove.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagMoveOnRemove(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagMoveOnAssign.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagMoveOnAssign(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagProperties.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagProperties(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagVisible.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagVisible(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagFilter.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagFilter(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagGroup.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagGroup(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagLimits.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagLimits(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagIcon.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagIcon(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagIconSortOrder.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagIconSortOrder(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagStatus.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagStatus(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagDependsOn.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagDependsOn(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagEOA.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagEOA(column);
                }
            });
            tableManager.setDefaultColumnNames(TABLE_TAGS, new String[]{ColumnTagColor.COLUMN_ID, ColumnTagName.COLUMN_ID, ColumnTagCount.COLUMN_ID, ColumnTagType.COLUMN_ID, ColumnTagPublic.COLUMN_ID, ColumnTagUpRate.COLUMN_ID, ColumnTagDownRate.COLUMN_ID, ColumnTagUpLimit.COLUMN_ID, ColumnTagDownLimit.COLUMN_ID, ColumnTagStatus.COLUMN_ID});
            tableManager.setDefaultSortColumnName(TABLE_TAGS, ColumnTagName.COLUMN_ID);
            return;
        }
    }

    @Override
    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        if (this.tv != null) {
            this.tv.delete();
            this.tv = null;
        }
        Utils.disposeSWTObjects(this.table_parent);
        TagManager tagManager = TagManagerFactory.getTagManager();
        if (tagManager != null) {
            List<TagType> tagTypes = tagManager.getTagTypes();
            for (TagType tagType : tagTypes) {
                tagType.removeTagTypeListener(this);
            }
            tagManager.removeTagManagerListener(this);
            this.tm_listener_added = false;
        }
        if (this.global_manager != null) {
            this.global_manager.removeEventListener(this);
            this.gm_listener_added = false;
        }
        return super.skinObjectHidden(skinObject, params);
    }

    @Override
    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        super.skinObjectShown(skinObject, params);
        SWTSkinObject so_list = this.getSkinObject("tags-list");
        if (so_list == null) {
            return null;
        }
        this.initTable((Composite)so_list.getControl());
        if (this.tv == null) {
            return null;
        }
        TagManager tagManager = TagManagerFactory.getTagManager();
        if (tagManager != null && !this.tm_listener_added) {
            this.tm_listener_added = true;
            tagManager.addTagManagerListener(this, true);
        }
        if (this.global_manager != null && !this.gm_listener_added) {
            this.global_manager.addEventListener(this);
            this.gm_listener_added = true;
        }
        return null;
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        if (this.tm_listener_added) {
            this.tm_listener_added = false;
            TagManager tagManager = TagManagerFactory.getTagManager();
            tagManager.removeTagManagerListener(this);
            for (TagType tt : tagManager.getTagTypes()) {
                tt.removeTagTypeListener(this);
            }
        }
        COConfigurationManager.removeParameterListener("Show Swarm Tags In Overview", this);
        return super.skinObjectDestroyed(skinObject, params);
    }

    private void initTable(Composite control) {
        SBC_TagsOverview.registerPluginViews();
        if (this.tv == null) {
            DropTarget dropTarget;
            this.tv = TableViewFactory.createTableViewSWT(PLUGIN_DS_TYPE, TABLE_TAGS, TABLE_TAGS, new TableColumnCore[0], ColumnTagName.COLUMN_ID, 0x10010002);
            SWTSkinObjectTextbox soFilter = (SWTSkinObjectTextbox)this.getSkinObject("filterbox");
            if (soFilter != null) {
                BubbleTextBox filter2 = soFilter.getBubbleTextBox();
                this.tv.enableFilterCheck(filter2, (TableViewFilterCheck<Tag>)this);
                String tooltip = MessageText.getString("filter.tt.start");
                tooltip = String.valueOf(tooltip) + MessageText.getString("tagsoverview.filter.tt.line1");
                tooltip = String.valueOf(tooltip) + MessageText.getString("tagsoverview.filter.tt.line2");
                filter2.setTooltip(tooltip);
            }
            this.tv.setRowDefaultHeightEM(1.0f);
            this.table_parent = Utils.createSkinnedComposite(control, 2048, Utils.getFilledFormData());
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.table_parent.setLayout((Layout)layout);
            this.table_parent.addListener(26, new Listener(){

                public void handleEvent(Event event2) {
                    SBC_TagsOverview.this.updateSelectedContent();
                }
            });
            this.tv.addMenuFillListener(this);
            this.tv.addSelectionListener(this, false);
            this.tv.addKeyListener(this);
            this.tv.initialize(this.table_parent);
            this.tv.addCountChangeListener(new TableCountChangeListener(){

                @Override
                public void rowRemoved(TableRowCore row) {
                }

                @Override
                public void rowAdded(TableRowCore row) {
                    if (SBC_TagsOverview.this.datasource == row.getDataSource()) {
                        SBC_TagsOverview.this.tv.setSelectedRows(new TableRowCore[]{row});
                    }
                }
            });
            DragSource dragSource = this.tv.createDragSource(3);
            if (dragSource != null) {
                dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
                dragSource.addDragListener(new DragSourceListener(){

                    public void dragStart(DragSourceEvent event2) {
                        List<Object> dataSources = SBC_TagsOverview.this.tv.getSelectedDataSources();
                        for (Object dataSource : dataSources) {
                            if (!(dataSource instanceof Tag) || ((Tag)dataSource).getTagType().getTagType() != 3) continue;
                            return;
                        }
                        event2.doit = false;
                        event2.detail = 0;
                    }

                    public void dragSetData(DragSourceEvent event2) {
                        StringBuilder sb = new StringBuilder("TagUID");
                        boolean hasTags = false;
                        List<Object> dataSources = SBC_TagsOverview.this.tv.getSelectedDataSources();
                        for (Object dataSource : dataSources) {
                            if (!(dataSource instanceof Tag) || ((Tag)dataSource).getTagType().getTagType() != 3) continue;
                            hasTags = true;
                            sb.append('\n');
                            sb.append(((Tag)dataSource).getTagUID());
                        }
                        if (hasTags) {
                            event2.data = sb.toString();
                        }
                    }

                    public void dragFinished(DragSourceEvent event2) {
                    }
                });
            }
            if ((dropTarget = this.tv.createDropTarget(19)) != null) {
                dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance()});
                dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

                    public void dragOver(DropTargetEvent event2) {
                        List<DownloadManager> dms = DragDropUtils.getDownloadsFromDropData(event2.data == null ? DragDropUtils.getLastDraggedObject() : event2.data, true);
                        if (dms.isEmpty()) {
                            event2.detail = 0;
                            return;
                        }
                        TableRowCore row = SBC_TagsOverview.this.tv.getRow(event2);
                        if (row == null) {
                            event2.detail = 0;
                            return;
                        }
                        Object dataSource = row.getDataSource();
                        if (!(dataSource instanceof Tag)) {
                            event2.detail = 0;
                            return;
                        }
                        Tag tag = (Tag)dataSource;
                        boolean doAdd = false;
                        for (DownloadManager dm : dms) {
                            if (tag.hasTaggable(dm)) continue;
                            doAdd = true;
                            break;
                        }
                        boolean[] auto = tag.isTagAuto();
                        if (auto.length < 2 || doAdd && auto[0] || !doAdd && auto[0] && auto[1]) {
                            event2.detail = 0;
                            return;
                        }
                        event2.detail = doAdd ? 1 : 2;
                    }

                    public void drop(DropTargetEvent event2) {
                        List<DownloadManager> dms = DragDropUtils.getDownloadsFromDropData(event2.data == null ? DragDropUtils.getLastDraggedObject() : event2.data, true);
                        if (dms.isEmpty()) {
                            return;
                        }
                        TableRowCore row = SBC_TagsOverview.this.tv.getRow(event2);
                        if (row == null) {
                            return;
                        }
                        Object dataSource = row.getDataSource();
                        if (!(dataSource instanceof Tag)) {
                            return;
                        }
                        Tag tag = (Tag)dataSource;
                        boolean doAdd = false;
                        for (DownloadManager dm : dms) {
                            if (tag.hasTaggable(dm)) continue;
                            doAdd = true;
                            break;
                        }
                        boolean[] auto = tag.isTagAuto();
                        if (auto.length < 2 || doAdd && auto[0] || !doAdd && auto[0] && auto[1]) {
                            return;
                        }
                        try {
                            tag.addTaggableBatch(true);
                            for (DownloadManager dm : dms) {
                                if (doAdd) {
                                    tag.addTaggable(dm);
                                    continue;
                                }
                                tag.removeTaggable(dm);
                            }
                        }
                        finally {
                            tag.addTaggableBatch(false);
                        }
                    }
                });
            }
        }
        control.layout(true);
    }

    private static void registerPluginViews() {
        ViewManagerSWT vm = ViewManagerSWT.getInstance();
        if (vm.areCoreViewsRegistered(PLUGIN_DS_TYPE)) {
            return;
        }
        vm.registerView(PLUGIN_DS_TYPE, new UISWTViewBuilderCore("TagSettingsView", null, TagSettingsView.class));
        vm.registerView(PLUGIN_DS_TYPE, new UISWTViewBuilderCore("MyTorrentsSubView", null, MyTorrentsSubView.class));
        vm.registerView(PLUGIN_DS_TYPE, new UISWTViewBuilderCore("FilesView", null, FilesView.class));
        vm.setCoreViewsRegistered(PLUGIN_DS_TYPE);
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        List<Object> ds = this.tv.getSelectedDataSources();
        final ArrayList<Tag> tags = new ArrayList<Tag>();
        final ArrayList<TagFeatureRateLimit> tags_su = new ArrayList<TagFeatureRateLimit>();
        final ArrayList<TagFeatureRateLimit> tags_sd = new ArrayList<TagFeatureRateLimit>();
        for (Object obj : ds) {
            long[] down;
            TagFeatureRateLimit rl;
            if (!(obj instanceof Tag)) continue;
            Tag tag = (Tag)obj;
            tags.add(tag);
            if (!(tag instanceof TagFeatureRateLimit) || !(rl = (TagFeatureRateLimit)((Object)tag)).supportsTagRates()) continue;
            long[] up = rl.getTagSessionUploadTotal();
            if (up != null) {
                tags_su.add(rl);
            }
            if ((down = rl.getTagSessionDownloadTotal()) == null) continue;
            tags_sd.add(rl);
        }
        if (sColumnName != null) {
            if (sColumnName.equals(ColumnTagUpSession.COLUMN_ID) && tags_su.size() > 0 || sColumnName.equals(ColumnTagDownSession.COLUMN_ID) && tags_sd.size() > 0) {
                final boolean is_up = sColumnName.equals(ColumnTagUpSession.COLUMN_ID);
                MenuItem mi = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)mi, "menu.reset.session.stats");
                mi.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        for (TagFeatureRateLimit rl : is_up ? tags_su : tags_sd) {
                            if (is_up) {
                                rl.resetTagSessionUploadTotal();
                                continue;
                            }
                            rl.resetTagSessionDownloadTotal();
                        }
                    }
                });
                MenuFactory.addSeparatorMenuItem(menu);
            }
            if (sColumnName.equals(ColumnTagIcon.COLUMN_ID) || sColumnName.equals(ColumnTagIconSortOrder.COLUMN_ID)) {
                MenuItem mi = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)mi, "menu.set.icon.sort");
                mi.addListener(13, e -> {
                    SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("tag.sort.order.title", "tag.sort.order.text");
                    entryWindow.allowEmptyInput(true);
                    entryWindow.setWidthHint(450);
                    entryWindow.prompt(new UIInputReceiverListener(){

                        @Override
                        public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                            if (!entryWindow.hasSubmittedInput()) {
                                return;
                            }
                            String sReturn = entryWindow.getSubmittedInput().trim();
                            if (sReturn.isEmpty()) {
                                for (Tag t : tags) {
                                    t.setImageSortOrder(-1);
                                }
                            } else {
                                int start = 0;
                                try {
                                    start = Integer.valueOf(sReturn);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                for (Tag t : tags) {
                                    t.setImageSortOrder(start++);
                                }
                            }
                        }
                    });
                });
                MenuFactory.addSeparatorMenuItem(menu);
            }
        }
        if (tags.size() == 1) {
            TagUIUtils.createSideBarMenuItems(menu, (Tag)tags.get(0));
        } else {
            TagUIUtils.createSideBarMenuItems(menu, tags);
        }
    }

    @Override
    public void eventOccurred(GlobalManagerEvent event2) {
        if (this.tv != null && event2.getEventType() == 1) {
            DownloadManager dm = event2.getDownload();
            List<Object> ds = this.tv.getSelectedDataSources();
            boolean hit = false;
            for (Object obj : ds) {
                Tag tag;
                if (!(obj instanceof Tag) || !(tag = (Tag)obj).getTagged().contains(dm)) continue;
                hit = true;
                break;
            }
            if (hit) {
                MultipleDocumentInterfaceSWT tabbed_mdi = this.tv.getTabsCommon().getMDI();
                tabbed_mdi.showEntryByID("MyTorrentsSubView");
                MdiEntrySWT view = tabbed_mdi.getEntry("MyTorrentsSubView");
                if (view != null) {
                    ((MyTorrentsView)view.getEventListener()).requestAttention(dm);
                }
            }
        }
    }

    @Override
    public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
    }

    @Override
    public void selected(TableRowCore[] row) {
        this.updateSelectedContent();
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void deselected(TableRowCore[] rows) {
        this.updateSelectedContent();
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void focusChanged(TableRowCore focus) {
        this.updateSelectedContent();
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void defaultSelected(TableRowCore[] rows, int stateMask) {
        Object obj;
        if (rows.length == 1 && (obj = rows[0].getDataSource()) instanceof Tag) {
            Tag tag = (Tag)obj;
            int tt = tag.getTagType().getTagType();
            if (tt == 5 || tt == 7) {
                return;
            }
            UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
            if (uiFunctions != null) {
                if (tag instanceof Category) {
                    if (!COConfigurationManager.getBooleanParameter("Library.CatInSideBar")) {
                        COConfigurationManager.setParameter("Library.CatInSideBar", true);
                    }
                } else if (!COConfigurationManager.getBooleanParameter("Library.TagInSideBar")) {
                    COConfigurationManager.setParameter("Library.TagInSideBar", true);
                }
                if (!tag.isVisible()) {
                    tag.setVisible(true);
                }
                if (tag instanceof Category) {
                    String name = ((Category)tag).getName();
                    String id = "Cat." + Base32.encode(name.getBytes());
                    uiFunctions.getMDI().showEntryByID(id, tag);
                } else {
                    String id = "Tag." + tag.getTagType().getTagType() + "." + tag.getTagID();
                    uiFunctions.getMDI().showEntryByID(id, tag);
                }
            }
        }
    }

    public void updateSelectedContent() {
        this.updateSelectedContent(false);
    }

    public void updateSelectedContent(boolean force) {
        if (this.table_parent == null || this.table_parent.isDisposed()) {
            return;
        }
        if (!this.isVisible() && !force) {
            return;
        }
        SelectedContentManager.clearCurrentlySelectedContent();
        if (this.tv != null) {
            SelectedContentManager.changeCurrentlySelectedContent(this.tv.getTableID(), null, this.tv);
        }
    }

    @Override
    public void mouseEnter(TableRowCore row) {
    }

    @Override
    public void mouseExit(TableRowCore row) {
    }

    @Override
    public boolean filterCheck(Tag tag, String filter2, boolean regex, boolean confusable) {
        Pattern pattern;
        String name;
        if (confusable) {
            return false;
        }
        int tt = tag.getTagType().getTagType();
        if (tt == 7 && !this.show_swarm_tags) {
            return false;
        }
        if (filter2.startsWith("g:")) {
            filter2 = filter2.substring(2);
            name = tag.getGroup();
            if (name == null) {
                name = "";
            }
        } else if (filter2.startsWith("p:")) {
            filter2 = filter2.substring(2);
            name = tag instanceof TagFeatureProperties ? ((TagFeatureProperties)((Object)tag)).getPropertiesString() : "";
        } else {
            name = tag.getTagName(true);
        }
        String s = regex ? filter2 : RegExUtil.splitAndQuote(filter2, "\\s*[|;]\\s*");
        boolean match_result = true;
        if (regex && s.startsWith("!")) {
            s = s.substring(1);
            match_result = false;
        }
        return (pattern = RegExUtil.getCachedPattern("tagsoverview:search", s, 66)).matcher(name).find() == match_result;
    }

    @Override
    public void tagTypeAdded(TagManager manager, TagType tag_type) {
        if (Constants.IS_CVS_VERSION || tag_type.getTagType() != 5) {
            tag_type.addTagTypeListener(this, true);
        }
    }

    @Override
    public void tagTypeRemoved(TagManager manager, TagType tag_type) {
        tag_type.removeTagTypeListener(this);
    }

    @Override
    public void tagTypeChanged(TagType tag_type) {
        this.tv.tableInvalidate();
    }

    @Override
    public void tagEventOccurred(TagTypeListener.TagEvent event2) {
        int type = event2.getEventType();
        Tag tag = event2.getTag();
        if (type == 0) {
            this.tagAdded(tag);
        } else if (type == 1 || type == 4) {
            this.tagChanged(tag);
        } else if (type == 2) {
            this.tagRemoved(tag);
        }
    }

    public void tagAdded(Tag tag) {
        this.tv.addDataSource(tag);
        this.handleProps(tag);
    }

    public void tagChanged(Tag tag) {
        if (this.tv == null || this.tv.isDisposed()) {
            return;
        }
        TableRowCore row = this.tv.getRow(tag);
        if (row != null) {
            row.invalidate(true);
        }
        this.handleProps(tag);
    }

    private void handleProps(Tag tag) {
        Boolean b = (Boolean)tag.getTransientProperty("Settings Requested");
        if (b != null && b.booleanValue()) {
            tag.setTransientProperty("Settings Requested", null);
            this.tv.processDataSourceQueueSync();
            TableRowCore row = this.tv.getRow(tag);
            if (row == null) {
                Debug.out("Can't select settings view for " + tag.getTagName(true) + " as row not found");
            } else {
                this.tv.setSelectedRows(new TableRowCore[]{row});
                AEThread2.createAndStartDaemon("feh", () -> {
                    long start = SystemTime.getMonotonousTime();
                    while (this.tv.hasChangesPending()) {
                        if (SystemTime.getMonotonousTime() - start > 20000L) break;
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    Utils.execSWTThread(() -> {
                        this.tv.getTabsCommon().getMDI().showEntryByID("TagSettingsView");
                        this.tv.showRow(row);
                    });
                });
            }
        }
    }

    public void tagRemoved(Tag tag) {
        this.tv.removeDataSource(tag);
    }

    @Override
    public Object dataSourceChanged(SWTSkinObject skinObject, Object params) {
        TableRowCore row;
        if (params instanceof Tag && this.tv != null && (row = this.tv.getRow((Tag)params)) != null) {
            this.tv.setSelectedRows(new TableRowCore[]{row});
        }
        this.datasource = params;
        return null;
    }

    @Override
    public Object skinObjectSelected(SWTSkinObject skinObject, Object params) {
        this.updateSelectedContent();
        return super.skinObjectSelected(skinObject, params);
    }

    public void keyPressed(KeyEvent e) {
        Tag tag;
        Object[] selectedDataSources;
        if (e.keyCode == 0x100000B && (e.stateMask & SWT.MODIFIER_MASK) == 0 && (selectedDataSources = this.tv.getSelectedDataSources(true)).length == 1 && selectedDataSources[0] instanceof Tag && !(tag = (Tag)selectedDataSources[0]).getTagType().isTagTypeAuto()) {
            TagUIUtils.openRenameTagDialog(tag);
            e.doit = false;
        }
    }

    public void keyReleased(KeyEvent e) {
    }
}

