/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.skin;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.util.GeneralUtils;
import com.biglybt.core.util.RegExUtil;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pif.download.DownloadStub;
import com.biglybt.pif.download.DownloadStubEvent;
import com.biglybt.pif.download.DownloadStubListener;
import com.biglybt.pif.ui.UIPluginViewToolBarListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnCreationListener;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.ToolBarItem;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableColumnCoreCreationListener;
import com.biglybt.ui.common.table.TableCountChangeListener;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableSelectionListener;
import com.biglybt.ui.common.table.TableViewFilterCheck;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.common.updater.UIUpdatable;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.TorrentUtil;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.columns.archivedls.ColumnArchiveDLCategory;
import com.biglybt.ui.swt.columns.archivedls.ColumnArchiveDLCompDate;
import com.biglybt.ui.swt.columns.archivedls.ColumnArchiveDLDate;
import com.biglybt.ui.swt.columns.archivedls.ColumnArchiveDLFileCount;
import com.biglybt.ui.swt.columns.archivedls.ColumnArchiveDLMainTracker;
import com.biglybt.ui.swt.columns.archivedls.ColumnArchiveDLName;
import com.biglybt.ui.swt.columns.archivedls.ColumnArchiveDLSaveLocation;
import com.biglybt.ui.swt.columns.archivedls.ColumnArchiveDLSize;
import com.biglybt.ui.swt.columns.archivedls.ColumnArchiveDLTags;
import com.biglybt.ui.swt.columns.archivedls.ColumnArchiveShareRatio;
import com.biglybt.ui.swt.pifimpl.UISWTViewBuilderCore;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectTextbox;
import com.biglybt.ui.swt.views.ArchivedFilesView;
import com.biglybt.ui.swt.views.ViewManagerSWT;
import com.biglybt.ui.swt.views.skin.InfoBarUtil;
import com.biglybt.ui.swt.views.skin.SkinView;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.TableViewSWTMenuFillListener;
import com.biglybt.ui.swt.views.table.impl.TableViewFactory;
import com.biglybt.ui.swt.views.table.utils.TableColumnCreator;
import com.biglybt.ui.swt.views.tableitems.ColumnDateSizer;
import com.biglybt.ui.swt.views.utils.ManagerUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class SBC_ArchivedDownloadsView
extends SkinView
implements UIUpdatable,
UIPluginViewToolBarListener,
TableViewFilterCheck<DownloadStub>,
TableViewSWTMenuFillListener,
TableSelectionListener,
DownloadStubListener {
    private static final String TABLE_NAME = "ArchivedDownloads";
    public static final Class<DownloadStub> PLUGIN_DS_TYPE = DownloadStub.class;
    TableViewSWT<DownloadStub> tv;
    private Composite table_parent;
    private boolean columnsAdded = false;
    private boolean dm_listener_added;
    private Object datasource;

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        this.initColumns();
        new InfoBarUtil(skinObject, "archivedlsview.infobar", false, "archivedls.infobar", "archivedls.view.infobar"){

            @Override
            public boolean allowShow() {
                return true;
            }
        };
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initColumns() {
        Class<SBC_ArchivedDownloadsView> clazz = SBC_ArchivedDownloadsView.class;
        synchronized (SBC_ArchivedDownloadsView.class) {
            if (this.columnsAdded) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.columnsAdded = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            TableColumnManager tableManager = TableColumnManager.getInstance();
            tableManager.registerColumn(DownloadStub.class, ColumnArchiveDLName.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnArchiveDLName(column);
                }
            });
            tableManager.registerColumn(DownloadStub.class, ColumnArchiveDLSize.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnArchiveDLSize(column);
                }
            });
            tableManager.registerColumn(DownloadStub.class, ColumnArchiveDLFileCount.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnArchiveDLFileCount(column);
                }
            });
            tableManager.registerColumn(DownloadStub.class, ColumnArchiveDLDate.COLUMN_ID, new TableColumnCoreCreationListener(){

                @Override
                public TableColumnCore createTableColumnCore(Class<?> forDataSourceType, String tableID, String columnID) {
                    return new ColumnDateSizer(DownloadStub.class, columnID, TableColumnCreator.DATE_COLUMN_WIDTH, tableID){};
                }

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnArchiveDLDate(column);
                }
            });
            tableManager.registerColumn(DownloadStub.class, ColumnArchiveDLTags.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnArchiveDLTags(column);
                }
            });
            tableManager.registerColumn(DownloadStub.class, ColumnArchiveDLCategory.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnArchiveDLCategory(column);
                }
            });
            tableManager.registerColumn(DownloadStub.class, ColumnArchiveShareRatio.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnArchiveShareRatio(column);
                }
            });
            tableManager.registerColumn(DownloadStub.class, ColumnArchiveDLSaveLocation.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnArchiveDLSaveLocation(column);
                }
            });
            tableManager.registerColumn(DownloadStub.class, ColumnArchiveDLMainTracker.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnArchiveDLMainTracker(column);
                }
            });
            tableManager.registerColumn(DownloadStub.class, ColumnArchiveDLCompDate.COLUMN_ID, new TableColumnCoreCreationListener(){

                @Override
                public TableColumnCore createTableColumnCore(Class<?> forDataSourceType, String tableID, String columnID) {
                    return new ColumnDateSizer(DownloadStub.class, columnID, TableColumnCreator.DATE_COLUMN_WIDTH, tableID){};
                }

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnArchiveDLCompDate(column);
                }
            });
            tableManager.setDefaultColumnNames(TABLE_NAME, new String[]{ColumnArchiveDLName.COLUMN_ID, ColumnArchiveDLSize.COLUMN_ID, ColumnArchiveDLFileCount.COLUMN_ID, ColumnArchiveDLDate.COLUMN_ID, ColumnArchiveShareRatio.COLUMN_ID});
            tableManager.setDefaultSortColumnName(TABLE_NAME, ColumnArchiveDLName.COLUMN_ID);
            return;
        }
    }

    @Override
    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        if (this.tv != null) {
            this.tv.delete();
            this.tv = null;
        }
        Utils.disposeSWTObjects(this.table_parent);
        if (this.dm_listener_added) {
            PluginInitializer.getDefaultInterface().getDownloadManager().removeDownloadStubListener(this);
            this.dm_listener_added = false;
        }
        return super.skinObjectHidden(skinObject, params);
    }

    @Override
    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        super.skinObjectShown(skinObject, params);
        SWTSkinObject so_list = this.getSkinObject("archived-dls-list");
        if (so_list == null) {
            System.out.println("NO archived-dls-list");
            return null;
        }
        this.initTable((Composite)so_list.getControl());
        if (this.tv == null) {
            return null;
        }
        PluginInitializer.getDefaultInterface().getDownloadManager().addDownloadStubListener(this, true);
        this.dm_listener_added = true;
        return null;
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        if (this.dm_listener_added) {
            PluginInitializer.getDefaultInterface().getDownloadManager().removeDownloadStubListener(this);
            this.dm_listener_added = false;
        }
        return super.skinObjectDestroyed(skinObject, params);
    }

    private void initTable(Composite control) {
        SBC_ArchivedDownloadsView.registerPluginViews();
        if (this.tv == null) {
            this.tv = TableViewFactory.createTableViewSWT(PLUGIN_DS_TYPE, TABLE_NAME, TABLE_NAME, new TableColumnCore[0], ColumnArchiveDLName.COLUMN_ID, 0x10010002);
            SWTSkinObjectTextbox soFilter = (SWTSkinObjectTextbox)this.getSkinObject("filterbox");
            if (soFilter != null) {
                this.tv.enableFilterCheck(soFilter.getBubbleTextBox(), (TableViewFilterCheck<DownloadStub>)this);
            }
            this.tv.setRowDefaultHeightEM(1.0f);
            this.table_parent = Utils.createSkinnedComposite(control, 2048, Utils.getFilledFormData());
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.table_parent.setLayout((Layout)layout);
            this.tv.addMenuFillListener(this);
            this.tv.addSelectionListener(this, false);
            this.tv.initialize(this.table_parent);
            this.tv.addCountChangeListener(new TableCountChangeListener(){

                @Override
                public void rowRemoved(TableRowCore row) {
                }

                @Override
                public void rowAdded(TableRowCore row) {
                    if (SBC_ArchivedDownloadsView.this.datasource == row.getDataSource()) {
                        SBC_ArchivedDownloadsView.this.tv.setSelectedRows(new TableRowCore[]{row});
                    }
                }
            });
        }
        control.layout(true);
    }

    private static void registerPluginViews() {
        ViewManagerSWT vm = ViewManagerSWT.getInstance();
        if (vm.areCoreViewsRegistered(PLUGIN_DS_TYPE)) {
            return;
        }
        vm.registerView(PLUGIN_DS_TYPE, new UISWTViewBuilderCore("ArchivedFilesView", null, ArchivedFilesView.class));
        vm.setCoreViewsRegistered(PLUGIN_DS_TYPE);
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        if (this.tv == null || !this.tv.isVisible()) {
            return false;
        }
        List<Object> datasources = this.tv.getSelectedDataSources();
        if (datasources.size() > 0) {
            ArrayList<DownloadStub> dms = new ArrayList<DownloadStub>(datasources.size());
            for (Object o : datasources) {
                dms.add((DownloadStub)o);
            }
            String id = item.getID();
            if (id.equals("remove")) {
                TorrentUtil.removeDataSources(datasources.toArray());
            } else if (id.equals("startstop") || id.equals("start")) {
                ManagerUtils.restoreFromArchive(dms, true, null);
            }
            return true;
        }
        return false;
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        if (this.tv == null || !this.tv.isVisible()) {
            return;
        }
        boolean canEnable = false;
        Object[] datasources = this.tv.getSelectedDataSources().toArray();
        if (datasources.length > 0) {
            canEnable = true;
        }
        list.put("start", canEnable ? 1L : 0L);
        list.put("startstop", canEnable ? 1L : 0L);
        list.put("remove", canEnable ? 1L : 0L);
    }

    @Override
    public void updateUI() {
        if (this.tv != null) {
            this.tv.refreshTable(false);
        }
    }

    @Override
    public String getUpdateUIName() {
        return TABLE_NAME;
    }

    @Override
    public void addThisColumnSubMenu(String columnName, Menu menuThisColumn) {
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        List<Object> ds = this.tv.getSelectedDataSources();
        final ArrayList<DownloadStub> dms = new ArrayList<DownloadStub>(ds.size());
        for (Object o : ds) {
            dms.add((DownloadStub)o);
        }
        boolean hasSelection = dms.size() > 0;
        final boolean use_open_containing_folder = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
        MenuItem itemExplore = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemExplore, "MyTorrentsView.menu." + (use_open_containing_folder ? "open_parent_folder" : "explore"));
        itemExplore.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                for (DownloadStub download : dms) {
                    ManagerUtils.open(new File(download.getSavePath()), use_open_containing_folder);
                }
            }
        });
        itemExplore.setEnabled(hasSelection);
        new MenuItem(menu, 2);
        MenuItem itemRestore = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRestore, "MyTorrentsView.menu.restore");
        itemRestore.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                ManagerUtils.restoreFromArchive(dms, false, null);
            }
        });
        itemRestore.setEnabled(hasSelection);
        MenuItem itemRestoreAnd = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRestoreAnd, "MyTorrentsView.menu.restore.and");
        itemRestoreAnd.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                ManagerUtils.restoreFromArchive(dms, false, new ManagerUtils.ArchiveCallback(){
                    private List<DownloadManager> targets = new ArrayList<DownloadManager>();

                    @Override
                    public void success(DownloadStub source, DownloadStub target) {
                        DownloadManager dm = PluginCoreUtils.unwrap((Download)target);
                        if (dm != null) {
                            this.targets.add(dm);
                        }
                    }

                    @Override
                    public void completed() {
                        Utils.execSWTThread(new Runnable(){

                            @Override
                            public void run() {
                                if (targets.size() == 0) {
                                    return;
                                }
                                final Menu menu = new Menu((Control)SBC_ArchivedDownloadsView.this.table_parent);
                                DownloadManager[] dm_list = targets.toArray(new DownloadManager[dms.size()]);
                                TorrentUtil.fillTorrentMenu(menu, dm_list, CoreFactory.getSingleton(), true, 0, ((this).this).SBC_ArchivedDownloadsView.this.tv);
                                menu.addMenuListener(new MenuListener(){

                                    public void menuShown(MenuEvent e) {
                                    }

                                    public void menuHidden(MenuEvent e) {
                                        Utils.execSWTThreadLater(1, new Runnable(){

                                            @Override
                                            public void run() {
                                                menu.dispose();
                                            }
                                        });
                                    }
                                });
                                menu.setVisible(true);
                            }
                        });
                    }
                });
            }
        });
        itemRestoreAnd.setEnabled(hasSelection);
        new MenuItem(menu, 2);
    }

    @Override
    public void selected(TableRowCore[] row) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void deselected(TableRowCore[] rows) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void focusChanged(TableRowCore focus) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void defaultSelected(TableRowCore[] rows, int stateMask) {
        if (rows.length == 1) {
            Object object = rows[0].getDataSource();
        }
    }

    @Override
    public void downloadStubEventOccurred(DownloadStubEvent event2) throws DownloadException {
        int type = event2.getEventType();
        List<DownloadStub> dls = event2.getDownloadStubs();
        if (type == 1) {
            this.tv.addDataSources((DownloadStub[])dls.toArray(new DownloadStub[dls.size()]));
        } else if (type == 2) {
            this.tv.removeDataSources((DownloadStub[])dls.toArray(new DownloadStub[dls.size()]));
        }
    }

    @Override
    public void mouseEnter(TableRowCore row) {
    }

    @Override
    public void mouseExit(TableRowCore row) {
    }

    @Override
    public void filterSet(String filter2) {
    }

    @Override
    public boolean filterCheck(DownloadStub ds, String filter2, boolean regex, boolean confusable) {
        Pattern pattern;
        String expr;
        boolean do_files;
        if (confusable) {
            filter2 = GeneralUtils.getConfusableEquivalent(filter2, true);
        }
        if (do_files = filter2.toLowerCase(Locale.US).startsWith("f:")) {
            filter2 = filter2.substring(2).trim();
        }
        boolean match_result = true;
        if (regex) {
            expr = filter2;
            if (expr.startsWith("!")) {
                expr = expr.substring(1);
                match_result = false;
            }
        } else {
            expr = RegExUtil.convertAndOrToExpr(filter2);
        }
        if (do_files) {
            DownloadStub.DownloadStubFile[] files = ds.getStubFiles();
            Pattern pattern2 = RegExUtil.getCachedPattern("archiveview:search", expr, 66);
            boolean result = !match_result;
            boolean try_save_path = true;
            DownloadStub.DownloadStubFile[] downloadStubFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                DownloadStub.DownloadStubFile file = downloadStubFileArray[n2];
                String name = file.getFile().getName();
                if (confusable) {
                    name = GeneralUtils.getConfusableEquivalent(name, false);
                }
                if (pattern2.matcher(name).find()) {
                    result = match_result;
                    try_save_path = false;
                    break;
                }
                ++n2;
            }
            if (try_save_path && pattern2.matcher(ds.getSavePath()).find()) {
                result = match_result;
            }
            return result;
        }
        String name = ds.getName();
        if (confusable) {
            name = GeneralUtils.getConfusableEquivalent(name, false);
        }
        return (pattern = RegExUtil.getCachedPattern("archiveview:search", expr, 66)).matcher(name).find() == match_result;
    }

    @Override
    public Object dataSourceChanged(SWTSkinObject skinObject, Object params) {
        TableRowCore row;
        if (params instanceof DownloadStub && this.tv != null && (row = this.tv.getRow((DownloadStub)params)) != null) {
            this.tv.setSelectedRows(new TableRowCore[]{row});
        }
        this.datasource = params;
        return null;
    }
}

