/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.skin;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.ui.common.RememberedDecisionsManager;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinButtonUtility;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import com.biglybt.ui.swt.skin.SWTSkinObjectListener;
import com.biglybt.ui.swt.skin.SWTSkinObjectText;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Control;

public abstract class InfoBarUtil {
    private final SWTSkinObject forSO;
    private final boolean top;
    private SWTSkin skin;
    private SWTSkinObject soInfoBar;
    private final String stateConfigID;
    private final String textPrefix;
    private final String skintemplateid;
    private static int uniqueNo = 0;

    public InfoBarUtil(SWTSkinObject forSO, boolean top, String stateConfigID, String textPrefix) {
        this(forSO, "library.top.info", top, stateConfigID, textPrefix);
    }

    public InfoBarUtil(final SWTSkinObject forSO, String skintemplateid, boolean top, final String stateConfigID, String textPrefix) {
        this.forSO = forSO;
        this.skintemplateid = skintemplateid;
        this.stateConfigID = stateConfigID;
        this.textPrefix = textPrefix;
        this.skin = forSO.getSkin();
        this.top = top;
        if (COConfigurationManager.hasParameter(stateConfigID, true)) {
            RememberedDecisionsManager.setRemembered(stateConfigID, COConfigurationManager.getBooleanParameter(stateConfigID) ? 1 : 0);
            COConfigurationManager.removeParameter(stateConfigID);
        }
        forSO.addListener(new SWTSkinObjectListener(){

            @Override
            public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                if (eventType == 0) {
                    boolean show;
                    forSO.removeListener(this);
                    boolean bl = show = RememberedDecisionsManager.getRememberedDecision(stateConfigID) != 0;
                    if (show && InfoBarUtil.this.allowShow() && InfoBarUtil.this.soInfoBar == null) {
                        InfoBarUtil.this.createInfoBar();
                    }
                }
                return null;
            }
        });
    }

    public SWTSkinObject getParentSkinObject() {
        return this.forSO;
    }

    protected void createInfoBar() {
        SWTSkinObject soText2;
        Control control = this.forSO.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        Object ldForSO = control.getLayoutData();
        if (!(ldForSO instanceof FormData)) {
            return;
        }
        FormData fdForSO = (FormData)ldForSO;
        SWTSkinObjectContainer parent = (SWTSkinObjectContainer)this.forSO.getParent();
        boolean disable_skinning = Utils.isDarkAppearanceNative();
        try {
            if (disable_skinning) {
                Utils.setSkinningEnabled(false);
            }
            this.soInfoBar = this.skin.createSkinObject(String.valueOf(this.skintemplateid) + uniqueNo++, this.skintemplateid, parent);
        }
        finally {
            if (disable_skinning) {
                Utils.setSkinningEnabled(true);
            }
        }
        FormData fdInfoBar = (FormData)this.soInfoBar.getControl().getLayoutData();
        if (fdInfoBar == null) {
            fdInfoBar = Utils.getFilledFormData();
        }
        if (this.top) {
            fdInfoBar.top = fdForSO.top.control == null ? new FormAttachment(fdForSO.top.numerator, fdForSO.top.denominator, fdForSO.top.offset) : new FormAttachment(fdForSO.top.control, fdForSO.top.offset, fdForSO.top.alignment);
            fdInfoBar.bottom = null;
            this.soInfoBar.getControl().setLayoutData((Object)fdInfoBar);
            fdForSO.top = new FormAttachment(this.soInfoBar.getControl(), 0, 1024);
            this.forSO.getControl().setLayoutData((Object)fdForSO);
        } else {
            fdInfoBar.bottom = fdForSO.bottom.control == null ? new FormAttachment(fdForSO.bottom.numerator, fdForSO.bottom.denominator, fdForSO.bottom.offset) : new FormAttachment(fdForSO.bottom.control, fdForSO.bottom.offset, fdForSO.bottom.alignment);
            fdInfoBar.top = null;
            this.soInfoBar.getControl().setLayoutData((Object)fdInfoBar);
            fdForSO.bottom = new FormAttachment(this.soInfoBar.getControl(), 0, 128);
            this.forSO.getControl().setLayoutData((Object)fdForSO);
        }
        parent.getComposite().layout(true);
        SWTSkinObject soClose = this.skin.getSkinObject("close", parent);
        if (soClose != null) {
            SWTSkinButtonUtility btnClose = new SWTSkinButtonUtility(soClose);
            btnClose.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                @Override
                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    InfoBarUtil.this.soInfoBar.setVisible(false);
                    RememberedDecisionsManager.setRemembered(InfoBarUtil.this.stateConfigID, 0);
                }
            });
        }
        this.soInfoBar.addListener(new SWTSkinObjectListener(){

            @Override
            public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                if (eventType == 0) {
                    RememberedDecisionsManager.setRemembered(InfoBarUtil.this.stateConfigID, 1);
                }
                return null;
            }
        });
        SWTSkinObject soText1 = this.skin.getSkinObject("infobar-title-1", parent);
        if (soText1 instanceof SWTSkinObjectText) {
            SWTSkinObjectText soText = (SWTSkinObjectText)soText1;
            String id = String.valueOf(this.textPrefix) + ".text1";
            if (MessageText.keyExists(id)) {
                soText.setTextID(id);
            }
        }
        if ((soText2 = this.skin.getSkinObject("infobar-title-2", parent)) instanceof SWTSkinObjectText) {
            SWTSkinObjectText soText = (SWTSkinObjectText)soText2;
            String id = String.valueOf(this.textPrefix) + ".text2";
            if (MessageText.keyExists(id)) {
                soText.setTextID(id);
            }
        }
        this.created(parent);
        this.soInfoBar.setVisible(true);
        this.forSO.addListener(new SWTSkinObjectListener(){

            @Override
            public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                if (eventType == 3) {
                    InfoBarUtil.this.soInfoBar.dispose();
                    InfoBarUtil.this.skin.removeSkinObject(InfoBarUtil.this.soInfoBar);
                }
                return null;
            }
        });
    }

    protected void created(SWTSkinObject parent) {
    }

    public void hide(boolean permanently) {
        if (this.soInfoBar != null && !this.soInfoBar.isDisposed()) {
            this.soInfoBar.setVisible(false);
        }
        if (permanently) {
            RememberedDecisionsManager.setRemembered(this.stateConfigID, 0);
        }
    }

    public void show() {
        RememberedDecisionsManager.setRemembered(this.stateConfigID, 1);
        if (this.soInfoBar == null) {
            this.createInfoBar();
        } else {
            this.soInfoBar.setVisible(true);
        }
    }

    public abstract boolean allowShow();
}

