/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.peer;

import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.impl.transport.PEPeerTransportProtocol;
import com.biglybt.core.peermanager.piecepicker.util.BitFlags;
import com.biglybt.core.util.AERunnable;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.views.PieceDistributionView;
import java.util.Arrays;

public class RemotePieceDistributionView
extends PieceDistributionView {
    private PEPeer peer = null;

    @Override
    public void dataSourceChanged(Object newDataSource) {
        if (newDataSource instanceof Object[] && ((Object[])newDataSource).length > 0) {
            newDataSource = ((Object[])newDataSource)[0];
        }
        if (newDataSource instanceof PEPeer) {
            this.peer = (PEPeer)newDataSource;
            this.pem = this.peer.getManager();
        } else {
            this.peer = null;
            this.pem = null;
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                RemotePieceDistributionView.this.refresh();
            }
        });
    }

    @Override
    public void refresh() {
        if (this.pem == null) {
            return;
        }
        if (this.peer instanceof PEPeerTransportProtocol) {
            PEPeerTransportProtocol pet = (PEPeerTransportProtocol)this.peer;
            BitFlags avl = pet.getAvailable();
            this.hasPieces = (boolean[])(avl == null ? null : avl.flags);
        } else if (this.peer.isSeed()) {
            this.hasPieces = new boolean[this.pem.getPieces().length];
            Arrays.fill(this.hasPieces, true);
        } else {
            this.hasPieces = null;
        }
        super.refresh();
    }
}

