/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.peer;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.util.PeerUtils;
import com.biglybt.core.peermanager.piecepicker.util.BitFlags;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.Plugin;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.ui.swt.ImageRepository;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.Legend;
import com.biglybt.ui.swt.debug.UIDebugGenerator;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.utils.FontUtils;
import com.biglybt.util.MapUtils;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class PeerPieceMapView
implements UISWTViewCoreEventListener {
    public static final String VIEW_ID = "PeerPieceMapView";
    private static final int BLOCK_FILLSIZE = 14;
    private static final int BLOCK_SPACING = 2;
    private static final int BLOCK_SIZE = 16;
    private static final int BLOCKCOLOR_AVAIL_HAVE = 0;
    private static final int BLOCKCOLOR_AVAIL_NOHAVE = 1;
    private static final int BLOCKCOLOR_NOAVAIL_HAVE = 2;
    private static final int BLOCKCOLOR_NOAVAIL_NOHAVE = 3;
    private static final int BLOCKCOLOR_TRANSFER = 4;
    private static final int BLOCKCOLOR_NEXT = 5;
    private static final int BLOCKCOLOR_AVAILCOUNT = 6;
    private static final int MAX_PIECES_TO_SHOW = 32768;
    private Composite peerInfoComposite;
    private ScrolledComposite sc;
    protected Canvas peerInfoCanvas;
    private Color[] blockColors;
    private Label topLabel;
    private Label imageLabel;
    private int graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update") * 2;
    private int loopFactor = 0;
    private PEPeer peer;
    private Plugin countryLocator = null;
    private String sCountryImagesDir;
    private Font font = null;
    Image img = null;
    protected boolean refreshInfoCanvasQueued;
    private UISWTView swtView;

    public PeerPieceMapView() {
        this.blockColors = new Color[]{Colors.blues[9], Colors.blues[2], Colors.fadedGreen, Colors.white, Colors.red, Colors.fadedRed, Colors.black};
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                PeerPieceMapView.this.initCountryPlugin();
            }
        });
    }

    private void initCountryPlugin() {
        try {
            PluginInterface pi = PluginInitializer.getDefaultInterface().getPluginManager().getPluginInterfaceByID("CountryLocator");
            if (pi != null) {
                this.countryLocator = pi.getPlugin();
                if (!pi.getPluginState().isOperational() || pi.getUtilities().compareVersions(pi.getPluginVersion(), "1.6") < 0) {
                    this.countryLocator = null;
                }
                if (this.countryLocator != null) {
                    this.sCountryImagesDir = (String)this.countryLocator.getClass().getMethod("getImageLocation", Integer.TYPE).invoke((Object)this.countryLocator, new Integer(0));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void dataSourceChanged(Object newDataSource) {
        if (newDataSource instanceof Object[] && ((Object[])newDataSource).length > 0) {
            newDataSource = ((Object[])newDataSource)[0];
        }
        this.peer = newDataSource instanceof PEPeer ? (PEPeer)newDataSource : null;
        Utils.execSWTThreadLater(0, new AERunnable(){

            @Override
            public void runSupport() {
                PeerPieceMapView.this.swt_fillPeerInfoSection();
            }
        });
    }

    private String getFullTitle() {
        return MessageText.getString("PeersView.BlockView.title");
    }

    private void initialize(Composite composite) {
        if (this.peerInfoComposite != null && !this.peerInfoComposite.isDisposed()) {
            Logger.log(new LogEvent(LogIDs.GUI, 3, "PeerPieceMapView already initialized! Stack: " + Debug.getStackTrace(true, false)));
            this.delete();
        }
        this.createPeerInfoPanel(composite);
    }

    private Composite createPeerInfoPanel(Composite parent) {
        this.peerInfoComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.peerInfoComposite.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        this.peerInfoComposite.setLayoutData((Object)gridData);
        this.imageLabel = new Label(this.peerInfoComposite, 0);
        gridData = new GridData();
        if (ImageRepository.hasCountryFlags(false) || this.countryLocator != null) {
            gridData.widthHint = 28;
        }
        this.imageLabel.setLayoutData((Object)gridData);
        this.topLabel = new Label(this.peerInfoComposite, 0);
        gridData = new GridData(4, -1, false, false);
        this.topLabel.setLayoutData((Object)gridData);
        this.sc = new ScrolledComposite(this.peerInfoComposite, 512);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.sc.setLayout((Layout)layout);
        gridData = new GridData(4, 4, true, true, 2, 1);
        this.sc.setLayoutData((Object)gridData);
        this.sc.getVerticalBar().setIncrement(16);
        this.peerInfoCanvas = new Canvas((Composite)this.sc, 0x140000);
        gridData = new GridData(4, -1, true, false);
        this.peerInfoCanvas.setLayoutData((Object)gridData);
        this.peerInfoCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (e.width <= 0 || e.height <= 0) {
                    return;
                }
                try {
                    Rectangle bounds;
                    Rectangle rectangle = bounds = PeerPieceMapView.this.img == null ? null : PeerPieceMapView.this.img.getBounds();
                    if (bounds == null) {
                        e.gc.fillRectangle(e.x, e.y, e.width, e.height);
                    } else {
                        if (e.x + e.width > bounds.width) {
                            e.gc.fillRectangle(bounds.width, e.y, e.x + e.width - bounds.width + 1, e.height);
                        }
                        if (e.y + e.height > bounds.height) {
                            e.gc.fillRectangle(e.x, bounds.height, e.width, e.y + e.height - bounds.height + 1);
                        }
                        int width = Math.min(e.width, bounds.width - e.x);
                        int height = Math.min(e.height, bounds.height - e.y);
                        e.gc.drawImage(PeerPieceMapView.this.img, e.x, e.y, width, height, e.x, e.y, width, height);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Listener doNothingListener = new Listener(){

            public void handleEvent(Event event2) {
            }
        };
        this.peerInfoCanvas.addListener(1, doNothingListener);
        this.peerInfoCanvas.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                if (PeerPieceMapView.this.refreshInfoCanvasQueued || !PeerPieceMapView.this.peerInfoCanvas.isVisible()) {
                    return;
                }
                Utils.execSWTThreadLater(100, new AERunnable(){

                    @Override
                    public void runSupport() {
                        int iNewColCount;
                        int iOldColCount;
                        if ((this).PeerPieceMapView.this.refreshInfoCanvasQueued) {
                            return;
                        }
                        (this).PeerPieceMapView.this.refreshInfoCanvasQueued = true;
                        if ((this).PeerPieceMapView.this.img != null && (iOldColCount = (this).PeerPieceMapView.this.img.getBounds().width / 16) != (iNewColCount = (this).PeerPieceMapView.this.peerInfoCanvas.getClientArea().width / 16)) {
                            PeerPieceMapView.this.refreshInfoCanvas();
                        }
                    }
                });
            }
        });
        this.sc.setContent((Control)this.peerInfoCanvas);
        Legend.createLegendComposite(this.peerInfoComposite, this.blockColors, new String[]{"PeersView.BlockView.Avail.Have", "PeersView.BlockView.Avail.NoHave", "PeersView.BlockView.NoAvail.Have", "PeersView.BlockView.NoAvail.NoHave", "PeersView.BlockView.Transfer", "PeersView.BlockView.NextRequest", "PeersView.BlockView.AvailCount"}, new GridData(4, -1, true, false, 2, 1));
        this.font = FontUtils.getFontPercentOf(this.peerInfoCanvas.getFont(), 0.7f);
        return this.peerInfoComposite;
    }

    private void swt_fillPeerInfoSection() {
        block19: {
            if (this.peerInfoComposite == null || this.peerInfoComposite.isDisposed()) {
                return;
            }
            if (this.imageLabel.getImage() != null) {
                Image image = this.imageLabel.getImage();
                this.imageLabel.setImage(null);
                image.dispose();
            }
            if (this.peer == null) {
                this.topLabel.setText("");
            } else {
                int numPieces;
                DiskManager dm;
                String s = this.peer.getClient();
                if (s == null) {
                    s = "";
                } else if (s.length() > 0) {
                    s = String.valueOf(s) + "; ";
                }
                s = String.valueOf(s) + this.peer.getIp() + "; " + DisplayFormatters.formatPercentFromThousands(this.peer.getPercentDoneInThousandNotation());
                PEPeerManager pm = this.peer.getManager();
                DiskManager diskManager = dm = pm == null ? null : pm.getDiskManager();
                if (dm != null && (numPieces = dm.getNbPieces()) > 32768) {
                    s = String.valueOf(s) + " (" + MessageText.getString("label.truncated").toLowerCase() + ")";
                }
                this.topLabel.setText(s);
                Image flag = ImageRepository.getCountryFlag(this.peer, false);
                if (flag != null) {
                    flag = new Image(flag.getDevice(), flag.getImageData());
                    flag.setBackground(this.imageLabel.getBackground());
                    this.imageLabel.setImage(flag);
                    String[] country_details = PeerUtils.getCountryDetails(this.peer);
                    if (country_details != null && country_details.length == 2) {
                        Utils.setTT((Control)this.imageLabel, String.valueOf(country_details[0]) + "- " + country_details[1]);
                    } else {
                        Utils.setTT((Control)this.imageLabel, "");
                    }
                } else if (this.countryLocator != null) {
                    try {
                        String sCountry = (String)this.countryLocator.getClass().getMethod("getIPCountry", String.class, Locale.class).invoke((Object)this.countryLocator, this.peer.getIp(), Locale.getDefault());
                        String sCode = (String)this.countryLocator.getClass().getMethod("getIPISO3166", String.class).invoke((Object)this.countryLocator, this.peer.getIp());
                        Utils.setTT((Control)this.imageLabel, String.valueOf(sCode) + "- " + sCountry);
                        InputStream is = this.countryLocator.getClass().getClassLoader().getResourceAsStream(String.valueOf(this.sCountryImagesDir) + "/" + sCode.toLowerCase() + ".png");
                        if (is == null) break block19;
                        try {
                            Image img = new Image((Device)this.imageLabel.getDisplay(), is);
                            img.setBackground(this.imageLabel.getBackground());
                            this.imageLabel.setImage(img);
                        }
                        finally {
                            is.close();
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    Utils.setTT((Control)this.imageLabel, "");
                }
            }
        }
        this.refreshInfoCanvas();
    }

    private void refresh() {
        if (this.loopFactor++ % this.graphicsUpdate == 0) {
            this.refreshInfoCanvas();
        }
    }

    private void refreshInfoCanvas() {
        block34: {
            this.refreshInfoCanvasQueued = false;
            if (this.peerInfoComposite == null || this.peerInfoComposite.isDisposed() || !this.peerInfoComposite.isVisible()) {
                return;
            }
            this.peerInfoCanvas.layout(true);
            Rectangle bounds = this.peerInfoCanvas.getClientArea();
            if (bounds.width <= 0 || bounds.height <= 0) {
                return;
            }
            if (this.img != null && !this.img.isDisposed()) {
                this.img.dispose();
                this.img = null;
            }
            if (this.peer == null || this.peer.getPeerState() != 30) {
                GC gc = new GC((Drawable)this.peerInfoCanvas);
                gc.fillRectangle(bounds);
                gc.dispose();
                return;
            }
            PEPeerManager pm = this.peer.getManager();
            DiskManager dm = pm == null ? null : pm.getDiskManager();
            BitFlags peerHavePieces = this.peer.getAvailable();
            if (dm == null || peerHavePieces == null) {
                GC gc = new GC((Drawable)this.peerInfoCanvas);
                gc.fillRectangle(bounds);
                gc.dispose();
                return;
            }
            int numPieces = dm.getNbPieces();
            if (numPieces > 32768) {
                numPieces = 32768;
            }
            DiskManagerPiece[] dm_pieces = dm.getPieces();
            int iNumCols = bounds.width / 16;
            int iNeededHeight = ((numPieces - 1) / iNumCols + 1) * 16;
            if (this.sc.getMinHeight() != iNeededHeight) {
                this.sc.setMinHeight(iNeededHeight);
                this.sc.layout(true, true);
                bounds = this.peerInfoCanvas.getClientArea();
            }
            this.img = new Image((Device)this.peerInfoCanvas.getDisplay(), bounds.width, iNeededHeight);
            GC gcImg = new GC((Drawable)this.img);
            try {
                try {
                    int[] peerRequestedPieces;
                    gcImg.setAdvanced(true);
                    gcImg.setBackground(this.peerInfoCanvas.getBackground());
                    gcImg.fillRectangle(0, 0, bounds.width, iNeededHeight);
                    int[] availability = pm.getAvailability();
                    int iNextDLPieceID = -1;
                    int iDLPieceID = -1;
                    int[] ourRequestedPieces = this.peer.getOutgoingRequestedPieceNumbers();
                    if (ourRequestedPieces != null) {
                        if (!this.peer.isChokingMe()) {
                            if (ourRequestedPieces.length > 0) {
                                iDLPieceID = ourRequestedPieces[0];
                                if (ourRequestedPieces.length > 1) {
                                    iNextDLPieceID = ourRequestedPieces[1];
                                }
                            }
                        } else if (ourRequestedPieces.length > 0) {
                            iNextDLPieceID = ourRequestedPieces[0];
                        }
                    }
                    if ((peerRequestedPieces = this.peer.getIncomingRequestedPieceNumbers()) == null) {
                        peerRequestedPieces = new int[]{};
                    }
                    int peerNextRequestedPiece = -1;
                    if (peerRequestedPieces.length > 0) {
                        peerNextRequestedPiece = peerRequestedPieces[0];
                    }
                    Arrays.sort(peerRequestedPieces);
                    int iRow = 0;
                    int iCol = 0;
                    int i = 0;
                    while (i < numPieces) {
                        int colorIndex;
                        boolean done = dm_pieces == null ? false : dm_pieces[i].isDone();
                        int iXPos = iCol * 16;
                        int iYPos = iRow * 16;
                        if (done) {
                            colorIndex = peerHavePieces.flags[i] ? 0 : 2;
                            gcImg.setBackground(this.blockColors[colorIndex]);
                            gcImg.fillRectangle(iXPos, iYPos, 14, 14);
                        } else {
                            boolean partiallyDone = dm_pieces == null ? false : dm_pieces[i].getNbWritten() > 0;
                            int x = iXPos;
                            int width = 14;
                            if (partiallyDone) {
                                colorIndex = peerHavePieces.flags[i] ? 0 : 2;
                                gcImg.setBackground(this.blockColors[colorIndex]);
                                int iNewWidth = (int)((float)dm_pieces[i].getNbWritten() / (float)dm_pieces[i].getNbBlocks() * (float)width);
                                if (iNewWidth >= width) {
                                    iNewWidth = width - 1;
                                } else if (iNewWidth <= 0) {
                                    iNewWidth = 1;
                                }
                                gcImg.fillRectangle(x, iYPos, iNewWidth, 14);
                                width -= iNewWidth;
                                x += iNewWidth;
                            }
                            colorIndex = peerHavePieces.flags[i] ? 1 : 3;
                            gcImg.setBackground(this.blockColors[colorIndex]);
                            gcImg.fillRectangle(x, iYPos, width, 14);
                        }
                        if (i == iDLPieceID) {
                            gcImg.setBackground(this.blockColors[4]);
                            gcImg.fillPolygon(new int[]{iXPos, iYPos, iXPos + 14, iYPos, iXPos + 7, iYPos + 14});
                        }
                        if (i == iNextDLPieceID) {
                            gcImg.setBackground(this.blockColors[5]);
                            gcImg.fillPolygon(new int[]{iXPos + 2, iYPos + 2, iXPos + 14 - 1, iYPos + 2, iXPos + 7, iYPos + 14 - 1});
                        }
                        if (i == peerNextRequestedPiece) {
                            gcImg.setBackground(this.blockColors[4]);
                            gcImg.fillPolygon(new int[]{iXPos, iYPos + 14, iXPos + 14, iYPos + 14, iXPos + 7, iYPos});
                        } else if (Arrays.binarySearch(peerRequestedPieces, i) >= 0) {
                            gcImg.setBackground(this.blockColors[5]);
                            gcImg.fillPolygon(new int[]{iXPos + 1, iYPos + 14 - 2, iXPos + 14 - 2, iYPos + 14 - 2, iXPos + 7, iYPos + 2});
                        }
                        if (availability != null && availability[i] < 10) {
                            gcImg.setFont(this.font);
                            String sNumber = String.valueOf(availability[i]);
                            Point size = gcImg.stringExtent(sNumber);
                            int x = iXPos + 7 - size.x / 2;
                            int y = iYPos + 7 - size.y / 2;
                            gcImg.setForeground(this.blockColors[6]);
                            gcImg.drawText(sNumber, x, y, true);
                        }
                        if (++iCol >= iNumCols) {
                            iCol = 0;
                            ++iRow;
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    Logger.log(new LogEvent(LogIDs.GUI, "drawing piece map", e));
                    gcImg.dispose();
                    break block34;
                }
            }
            catch (Throwable throwable) {
                gcImg.dispose();
                throw throwable;
            }
            gcImg.dispose();
        }
        this.peerInfoCanvas.redraw();
    }

    private Composite getComposite() {
        return this.peerInfoComposite;
    }

    private void delete() {
        if (this.imageLabel != null && !this.imageLabel.isDisposed() && this.imageLabel.getImage() != null) {
            Image image = this.imageLabel.getImage();
            this.imageLabel.setImage(null);
            image.dispose();
        }
        if (this.img != null && !this.img.isDisposed()) {
            this.img.dispose();
            this.img = null;
        }
        if (this.font != null && !this.font.isDisposed()) {
            this.font.dispose();
            this.font = null;
        }
    }

    private Image obfuscatedImage(Image image) {
        UIDebugGenerator.obfuscateArea(image, (Control)this.topLabel, "");
        return image;
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                this.refreshInfoCanvas();
                break;
            }
            case 5: {
                this.refresh();
                break;
            }
            case 9: {
                Object data = event2.getData();
                if (!(data instanceof Map)) break;
                this.obfuscatedImage((Image)MapUtils.getMapObject((Map)data, "image", null, Image.class));
            }
        }
        return true;
    }
}

