/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.configsections;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.pif.PluginException;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.installer.PluginInstallationListener;
import com.biglybt.pif.ui.model.BasicPluginConfigModel;
import com.biglybt.pif.ui.model.PluginConfigModel;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.config.ConfigSectionPlugins;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.pif.UISWTParameterContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ConfigSectionPluginsSWT
extends ConfigSectionPlugins {
    private static final String HEADER_PREFIX = "ConfigView.pluginlist.column.";

    public ConfigSectionPluginsSWT() {
        this.init(new PluginListContext());
    }

    @Override
    public void deleteConfigSection() {
        super.deleteConfigSection();
        ImageLoader imageLoader = ImageLoader.getInstance();
        imageLoader.releaseImage("redled");
        imageLoader.releaseImage("greenled");
    }

    static class FilterComparator
    implements Comparator<PluginInterface> {
        boolean ascending = true;
        static final int FIELD_LOAD = 0;
        static final int FIELD_TYPE = 1;
        static final int FIELD_NAME = 2;
        static final int FIELD_VERSION = 3;
        static final int FIELD_DIRECTORY = 4;
        static final int FIELD_UNLOADABLE = 5;
        int field = 2;
        String sUserPluginDir;
        String sAppPluginDir;

        public FilterComparator() {
            String sep = File.separator;
            this.sUserPluginDir = FileUtil.getUserFile("plugins").toString();
            if (!this.sUserPluginDir.endsWith(sep)) {
                this.sUserPluginDir = String.valueOf(this.sUserPluginDir) + sep;
            }
            this.sAppPluginDir = FileUtil.getApplicationFile("plugins").toString();
            if (!this.sAppPluginDir.endsWith(sep)) {
                this.sAppPluginDir = String.valueOf(this.sAppPluginDir) + sep;
            }
        }

        @Override
        public int compare(PluginInterface if0, PluginInterface if1) {
            int result = 0;
            switch (this.field) {
                case 0: {
                    boolean b0 = if0.getPluginState().isLoadedAtStartup();
                    boolean b1 = if1.getPluginState().isLoadedAtStartup();
                    int n = b0 == b1 ? 0 : (result = b0 ? -1 : 1);
                    if (result != 0) break;
                    result = if0.getPluginID().compareToIgnoreCase(if1.getPluginID());
                    break;
                }
                case 1: 
                case 4: {
                    result = this.getFieldValue(this.field, if0).compareToIgnoreCase(this.getFieldValue(this.field, if1));
                    break;
                }
                case 3: {
                    String s0 = if0.getPluginVersion();
                    String s1 = if1.getPluginVersion();
                    if (s0 == null) {
                        s0 = "";
                    }
                    if (s1 == null) {
                        s1 = "";
                    }
                    result = s0.compareToIgnoreCase(s1);
                    break;
                }
                case 5: {
                    boolean b0 = if0.getPluginState().isUnloadable();
                    boolean b1 = if1.getPluginState().isUnloadable();
                    int n = b0 == b1 ? 0 : (result = b0 ? -1 : 1);
                }
            }
            if (result == 0) {
                result = if0.getPluginName().compareToIgnoreCase(if1.getPluginName());
            }
            if (!this.ascending) {
                result *= -1;
            }
            return result;
        }

        public boolean setField(int newField) {
            this.ascending = this.field == newField ? !this.ascending : true;
            this.field = newField;
            return this.ascending;
        }

        public String getFieldValue(int iField, PluginInterface pluginIF) {
            switch (iField) {
                case 0: {
                    return pluginIF.getPluginID();
                }
                case 4: {
                    String sDirName = pluginIF.getPluginDirectoryName();
                    if (sDirName.length() > this.sUserPluginDir.length() && sDirName.substring(0, this.sUserPluginDir.length()).equals(this.sUserPluginDir)) {
                        return sDirName.substring(this.sUserPluginDir.length());
                    }
                    if (sDirName.length() > this.sAppPluginDir.length() && sDirName.substring(0, this.sAppPluginDir.length()).equals(this.sAppPluginDir)) {
                        return sDirName.substring(this.sAppPluginDir.length());
                    }
                    return sDirName;
                }
                case 2: {
                    return pluginIF.getPluginName();
                }
                case 1: {
                    String sDirName = pluginIF.getPluginDirectoryName();
                    String sKey = sDirName.length() > this.sUserPluginDir.length() && sDirName.substring(0, this.sUserPluginDir.length()).equals(this.sUserPluginDir) ? "perUser" : (sDirName.length() > this.sAppPluginDir.length() && sDirName.substring(0, this.sAppPluginDir.length()).equals(this.sAppPluginDir) ? "shared" : "builtIn");
                    return MessageText.getString("ConfigView.pluginlist.column.type." + sKey);
                }
                case 3: {
                    return pluginIF.getPluginVersion();
                }
                case 5: {
                    return MessageText.getString("Button." + (pluginIF.getPluginState().isUnloadable() ? "yes" : "no")).replaceAll("&", "");
                }
            }
            return "";
        }
    }

    public static class PluginListContext
    implements UISWTParameterContext,
    ParameterListener {
        private static final String[] COLUMN_HEADERS = new String[]{"loadAtStartup", "type", "name", "version", "directory", "unloadable"};
        private static final int[] COLUMN_SIZES = new int[]{180, 70, 250, 100, 100, 50};
        private static final int[] COLUMN_ALIGNS = new int[]{0x1000000, 16384, 16384, 131072, 16384, 0x1000000};
        final FilterComparator comparator = new FilterComparator();
        List<PluginInterface> pluginIFs;
        private Table table;
        private Image imgRedLed;
        private Image imgGreenLed;

        @Override
        public void create(Composite infoGroup) {
            GridData gridData;
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            infoGroup.setLayout((Layout)gridLayout);
            Layout parentLayout = infoGroup.getParent().getLayout();
            if (parentLayout instanceof GridLayout) {
                GridLayout gridParentLayout = (GridLayout)parentLayout;
                gridData = new GridData(1808);
                gridData.horizontalSpan = gridParentLayout.numColumns;
                infoGroup.setLayoutData((Object)gridData);
            }
            ImageLoader imageLoader = ImageLoader.getInstance();
            this.imgRedLed = imageLoader.getImage("redled");
            this.imgGreenLed = imageLoader.getImage("greenled");
            this.pluginIFs = this.rebuildPluginIFs();
            this.pluginIFs.sort((o1, o2) -> o1.getPluginName().compareToIgnoreCase(o2.getPluginName()));
            this.table = new Table(infoGroup, 268503076);
            gridData = new GridData(1808);
            gridData.heightHint = 200;
            gridData.widthHint = 200;
            this.table.setLayoutData((Object)gridData);
            int i = 0;
            while (i < COLUMN_HEADERS.length) {
                final TableColumn tc = new TableColumn(this.table, COLUMN_ALIGNS[i]);
                tc.setWidth(COLUMN_SIZES[i]);
                tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean ascending = comparator.setField(table.indexOf(tc));
                        try {
                            table.setSortColumn(tc);
                            table.setSortDirection(ascending ? 128 : 1024);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            // empty catch block
                        }
                        pluginIFs.sort(comparator);
                        table.clearAll();
                    }
                });
                Messages.setLanguageText((Widget)tc, ConfigSectionPluginsSWT.HEADER_PREFIX + COLUMN_HEADERS[i]);
                ++i;
            }
            this.table.setHeaderVisible(true);
            Composite cButtons = new Composite(infoGroup, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 5;
            cButtons.setLayout((Layout)layout);
            cButtons.setLayoutData((Object)new GridData());
            final Button btnUnload = new Button(cButtons, 8);
            btnUnload.setLayoutData((Object)new GridData());
            Messages.setLanguageText((Widget)btnUnload, "ConfigView.pluginlist.unloadSelected");
            btnUnload.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    final int[] items = table.getSelectionIndices();
                    new AEThread2("unload"){

                        @Override
                        public void run() {
                            int[] nArray = items;
                            int n = items.length;
                            int n2 = 0;
                            while (n2 < n) {
                                PluginInterface pluginIF;
                                int index = nArray[n2];
                                if (index >= 0 && index < pluginIFs.size() && (pluginIF = pluginIFs.get(index)) != null) {
                                    if (pluginIF.getPluginState().isOperational() && pluginIF.getPluginState().isUnloadable()) {
                                        try {
                                            pluginIF.getPluginState().unload();
                                        }
                                        catch (PluginException e1) {
                                            e1.printStackTrace();
                                        }
                                    }
                                    Utils.execSWTThread(() -> {
                                        pluginIFs = this.rebuildPluginIFs();
                                        table.setItemCount(pluginIFs.size());
                                        pluginIFs.sort(comparator);
                                        table.clearAll();
                                    });
                                }
                                ++n2;
                            }
                        }
                    }.start();
                }
            });
            btnUnload.setEnabled(false);
            final Button btnLoad = new Button(cButtons, 8);
            btnUnload.setLayoutData((Object)new GridData());
            Messages.setLanguageText((Widget)btnLoad, "ConfigView.pluginlist.loadSelected");
            btnLoad.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    final int[] items = table.getSelectionIndices();
                    new AEThread2("load"){

                        @Override
                        public void run() {
                            int[] nArray = items;
                            int n = items.length;
                            int n2 = 0;
                            while (n2 < n) {
                                block4: {
                                    PluginInterface pluginIF;
                                    block5: {
                                        int index = nArray[n2];
                                        if (index < 0 || index >= pluginIFs.size() || (pluginIF = pluginIFs.get(index)) == null || pluginIF.getPluginState().isOperational()) break block4;
                                        if (!pluginIF.getPluginState().isDisabled()) break block5;
                                        if (pluginIF.getPluginState().hasFailed()) break block4;
                                        pluginIF.getPluginState().setDisabled(false);
                                    }
                                    try {
                                        pluginIF.getPluginState().reload();
                                    }
                                    catch (PluginException e1) {
                                        Debug.printStackTrace(e1);
                                    }
                                    Utils.execSWTThread(() -> {
                                        if (table == null || table.isDisposed()) {
                                            return;
                                        }
                                        pluginIFs = this.rebuildPluginIFs();
                                        table.setItemCount(pluginIFs.size());
                                        pluginIFs.sort(comparator);
                                        table.clearAll();
                                    });
                                }
                                ++n2;
                            }
                        }
                    }.start();
                }
            });
            btnLoad.setEnabled(false);
            Button btnScan = new Button(cButtons, 8);
            btnScan.setLayoutData((Object)new GridData());
            Messages.setLanguageText((Widget)btnScan, "ConfigView.pluginlist.scan");
            btnScan.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CoreFactory.getSingleton().getPluginManager().refreshPluginList(false);
                    pluginIFs = this.rebuildPluginIFs();
                    table.setItemCount(pluginIFs.size());
                    pluginIFs.sort(comparator);
                    table.clearAll();
                }
            });
            final Button btnUninstall = new Button(cButtons, 8);
            btnUninstall.setLayoutData((Object)new GridData());
            Messages.setLanguageText((Widget)btnUninstall, "ConfigView.pluginlist.uninstallSelected");
            btnUninstall.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    btnUninstall.setEnabled(false);
                    final int[] items = table.getSelectionIndices();
                    new AEThread2("uninstall"){

                        @Override
                        public void run() {
                            try {
                                ArrayList<PluginInterface> pis = new ArrayList<PluginInterface>();
                                int[] nArray = items;
                                int n = items.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    int index = nArray[n2];
                                    if (index >= 0 && index < pluginIFs.size()) {
                                        PluginInterface pluginIF = pluginIFs.get(index);
                                        pis.add(pluginIF);
                                    }
                                    ++n2;
                                }
                                if (pis.size() > 0) {
                                    PluginInterface[] ps = new PluginInterface[pis.size()];
                                    pis.toArray(ps);
                                    try {
                                        final AESemaphore wait_sem = new AESemaphore("unist:wait");
                                        ps[0].getPluginManager().getPluginInstaller().uninstall(ps, new PluginInstallationListener(){

                                            @Override
                                            public void completed() {
                                                wait_sem.release();
                                            }

                                            @Override
                                            public void cancelled() {
                                                wait_sem.release();
                                            }

                                            @Override
                                            public void failed(PluginException e) {
                                                wait_sem.release();
                                            }
                                        });
                                        wait_sem.reserve();
                                    }
                                    catch (Exception e) {
                                        Debug.printStackTrace(e);
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                Utils.execSWTThread(() -> {
                                    pluginIFs = this.rebuildPluginIFs();
                                    table.setItemCount(pluginIFs.size());
                                    pluginIFs.sort(comparator);
                                    table.clearAll();
                                    table.setSelection(new int[0]);
                                });
                                throw throwable;
                            }
                            Utils.execSWTThread(() -> {
                                pluginIFs = this.rebuildPluginIFs();
                                table.setItemCount(pluginIFs.size());
                                pluginIFs.sort(comparator);
                                table.clearAll();
                                table.setSelection(new int[0]);
                            });
                        }
                    }.start();
                }
            });
            btnUninstall.setEnabled(false);
            this.table.addListener(36, new Listener(){

                public void handleEvent(Event event2) {
                    TableItem item = (TableItem)event2.item;
                    int index = table.indexOf(item);
                    PluginInterface pluginIF = pluginIFs.get(index);
                    int i = 0;
                    while (i < COLUMN_HEADERS.length) {
                        String sText;
                        if (i == 2) {
                            item.setImage(i, pluginIF.getPluginState().isOperational() ? imgGreenLed : imgRedLed);
                        }
                        if ((sText = comparator.getFieldValue(i, pluginIF)) == null) {
                            sText = "";
                        }
                        item.setText(i, sText);
                        ++i;
                    }
                    item.setGrayed(pluginIF.getPluginState().isMandatory());
                    boolean bEnabled = pluginIF.getPluginState().isLoadedAtStartup();
                    Utils.setCheckedInSetData(item, bEnabled);
                    item.setData("PluginID", (Object)pluginIF.getPluginID());
                    Utils.alternateRowBackground(item);
                }
            });
            this.table.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    TableItem[] items = table.getSelection();
                    if (items.length == 1) {
                        PluginConfigModel[] models;
                        int index = table.indexOf(items[0]);
                        PluginInterface pluginIF = pluginIFs.get(index);
                        PluginConfigModel[] pluginConfigModelArray = models = pluginIF.getUIManager().getPluginConfigModels();
                        int n = models.length;
                        int n2 = 0;
                        while (n2 < n) {
                            PluginConfigModel model = pluginConfigModelArray[n2];
                            if (model.getPluginInterface() == pluginIF && model instanceof BasicPluginConfigModel) {
                                String id = ((BasicPluginConfigModel)model).getSection();
                                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                                if (uiFunctions != null) {
                                    uiFunctions.getMDI().showEntryByID("ConfigView", id);
                                }
                            }
                            ++n2;
                        }
                    }
                }
            });
            this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableItem item = (TableItem)e.item;
                    int index = table.indexOf(item);
                    PluginInterface pluginIF = pluginIFs.get(index);
                    if (pluginIF == null) {
                        return;
                    }
                    if (e.detail == 32) {
                        if (item.getGrayed()) {
                            if (!item.getChecked()) {
                                item.setChecked(true);
                            }
                            return;
                        }
                        pluginIF.getPluginState().setDisabled(!item.getChecked());
                        pluginIF.getPluginState().setLoadedAtStartup(item.getChecked());
                    }
                    btnUnload.setEnabled(pluginIF.getPluginState().isOperational() && pluginIF.getPluginState().isUnloadable());
                    btnLoad.setEnabled(!pluginIF.getPluginState().isOperational() && !pluginIF.getPluginState().hasFailed());
                    btnUninstall.setEnabled(!pluginIF.getPluginState().isBuiltIn() && !pluginIF.getPluginState().isMandatory());
                }
            });
            this.table.setItemCount(this.pluginIFs.size());
        }

        private List<PluginInterface> rebuildPluginIFs() {
            ArrayList<PluginInterface> pluginIFs = new ArrayList<PluginInterface>(Arrays.asList(CoreFactory.getSingleton().getPluginManager().getPlugins()));
            Iterator it = pluginIFs.iterator();
            while (it.hasNext()) {
                PluginInterface pi = (PluginInterface)it.next();
                Properties props = pi.getPluginProperties();
                String configurable = props.getProperty("plugin.is.configurable");
                if (configurable != null && !configurable.equals("true")) {
                    it.remove();
                    continue;
                }
                COConfigurationManager.addWeakParameterListener(this, false, "PluginInfo." + pi.getPluginID() + ".enabled");
            }
            return pluginIFs;
        }

        @Override
        public void parameterChanged(String parameterName) {
            if (this.table != null) {
                Utils.execSWTThread(() -> {
                    if (this.table != null && !this.table.isDisposed()) {
                        this.table.clearAll();
                    }
                });
            }
        }
    }
}

