/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.configsections;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.ipfilter.BannedIp;
import com.biglybt.core.ipfilter.IPFilterListener;
import com.biglybt.core.ipfilter.IpFilter;
import com.biglybt.core.ipfilter.IpFilterManager;
import com.biglybt.core.ipfilter.IpRange;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.pif.ui.config.BooleanParameter;
import com.biglybt.ui.common.updater.UIUpdatable;
import com.biglybt.ui.config.ConfigSectionIPFilter;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.config.IpFilterEditor;
import com.biglybt.ui.swt.pif.UISWTParameterContext;
import com.biglybt.ui.swt.uiupdater.UIUpdaterSWT;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ConfigSectionIPFilterSWT
extends ConfigSectionIPFilter {
    private IPEditorParameter paramContextIPEditor;

    public ConfigSectionIPFilterSWT() {
        this.init(new IPEditorParameter());
    }

    @Override
    public void saveConfigSection() {
        super.saveConfigSection();
        try {
            IpFilterManager ipFilterManager = CoreFactory.getSingleton().getIpFilterManager();
            IpFilter filter2 = ipFilterManager.getIPFilter();
            filter2.save();
        }
        catch (Exception e) {
            Logger.log(new LogAlert(false, "Save of filter file fails", e));
        }
    }

    @Override
    public void deleteConfigSection() {
        super.deleteConfigSection();
        if (this.paramContextIPEditor != null) {
            this.paramContextIPEditor.dispose();
            this.paramContextIPEditor = null;
        }
    }

    static class FilterComparator
    implements Comparator<IpRange> {
        boolean ascending = true;
        static final int FIELD_NAME = 0;
        static final int FIELD_START_IP = 1;
        static final int FIELD_END_IP = 2;
        int field = 1;

        FilterComparator() {
        }

        @Override
        public int compare(IpRange range0, IpRange range1) {
            if (this.field == 0) {
                return (this.ascending ? 1 : -1) * range0.compareDescription(range1);
            }
            if (this.field == 1) {
                return (this.ascending ? 1 : -1) * range0.compareStartIpTo(range1);
            }
            if (this.field == 2) {
                return (this.ascending ? 1 : -1) * range0.compareEndIpTo(range1);
            }
            return 0;
        }

        public void setField(int newField) {
            if (this.field == newField) {
                this.ascending = !this.ascending;
            }
            this.field = newField;
        }
    }

    public class IPEditorParameter
    implements UISWTParameterContext {
        private Table table;
        private FilterComparator comparator;
        private boolean bIsCachingDescriptions = false;
        IpRange[] ipRanges;
        IpFilter filter;
        private IPFilterListener filterListener;
        volatile boolean noChange;

        @Override
        public void create(final Composite gFilter) {
            ConfigSectionIPFilterSWT.this.paramContextIPEditor = this;
            this.comparator = new FilterComparator();
            IpFilterManager ipFilterManager = CoreFactory.getSingleton().getIpFilterManager();
            this.filter = ipFilterManager.getIPFilter();
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gFilter.setLayout((Layout)gridLayout);
            Layout parentLayout = gFilter.getParent().getLayout();
            if (parentLayout instanceof GridLayout) {
                GridLayout gridParentLayout = (GridLayout)parentLayout;
                GridData gridData = new GridData(1808);
                gridData.horizontalSpan = gridParentLayout.numColumns;
                gFilter.setLayoutData((Object)gridData);
            }
            this.table = new Table(gFilter, 268503044);
            String[] headers = new String[]{"label.description", "ConfigView.section.ipfilter.start", "ConfigView.section.ipfilter.end"};
            int[] sizes = new int[]{110, 110, 110};
            int[] aligns = new int[]{16384, 0x1000000, 0x1000000};
            int i = 0;
            while (i < headers.length) {
                TableColumn tc = new TableColumn(this.table, aligns[i]);
                tc.setText(headers[i]);
                tc.setWidth(sizes[i]);
                Messages.setLanguageText((Widget)tc, headers[i]);
                ++i;
            }
            TableColumn[] columns = this.table.getColumns();
            columns[0].setData((Object)0);
            columns[1].setData((Object)1);
            columns[2].setData((Object)2);
            Listener listener = e -> {
                TableColumn tc = (TableColumn)e.widget;
                if (tc == null || tc.isDisposed()) {
                    return;
                }
                int field = ((Number)tc.getData()).intValue();
                this.comparator.setField(field);
                if (field == 0 && !this.bIsCachingDescriptions) {
                    IpFilterManager ipFilterManager1 = CoreFactory.getSingleton().getIpFilterManager();
                    ipFilterManager1.cacheAllDescriptions();
                    this.bIsCachingDescriptions = true;
                }
                this.ipRanges = this.getSortedRanges(this.filter.getRanges());
                this.table.setItemCount(this.ipRanges.length);
                this.table.clearAll();
                this.table.redraw();
            };
            columns[0].addListener(13, listener);
            columns[1].addListener(13, listener);
            columns[2].addListener(13, listener);
            this.table.setHeaderVisible(true);
            GridData gridData = new GridData(1808);
            gridData.heightHint = this.table.getHeaderHeight() * 3;
            gridData.widthHint = 200;
            this.table.setLayoutData((Object)gridData);
            Composite cArea = new Composite(gFilter, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 4;
            cArea.setLayout((Layout)layout);
            gridData = new GridData(768);
            cArea.setLayoutData((Object)gridData);
            Button add = new Button(cArea, 8);
            gridData = new GridData(2);
            gridData.widthHint = 100;
            add.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)add, "Button.add");
            add.addListener(13, arg0 -> this.addRange());
            Button remove = new Button(cArea, 8);
            gridData = new GridData(2);
            gridData.widthHint = 100;
            remove.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)remove, "ConfigView.section.ipfilter.remove");
            remove.addListener(13, arg0 -> {
                TableItem[] selection = this.table.getSelection();
                if (selection.length == 0) {
                    return;
                }
                this.removeRange((IpRange)selection[0].getData());
                this.ipRanges = this.getSortedRanges(this.filter.getRanges());
                this.table.setItemCount(this.ipRanges.length);
                this.table.clearAll();
                this.table.redraw();
            });
            Button edit = new Button(cArea, 8);
            gridData = new GridData(2);
            gridData.widthHint = 100;
            edit.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)edit, "Button.edit");
            edit.addListener(13, arg0 -> {
                TableItem[] selection = this.table.getSelection();
                if (selection.length == 0) {
                    return;
                }
                this.editRange((IpRange)selection[0].getData());
            });
            this.table.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent arg0) {
                    TableItem[] selection = IPEditorParameter.this.table.getSelection();
                    if (selection.length == 0) {
                        return;
                    }
                    IPEditorParameter.this.editRange((IpRange)selection[0].getData());
                }
            });
            Control[] controls = new Control[]{add, remove, edit};
            BooleanParameter enabled = (BooleanParameter)((Object)ConfigSectionIPFilterSWT.this.getPluginParam("Ip Filter Enabled"));
            if (enabled != null) {
                Runnable code = () -> {
                    boolean enable = enabled.getValue();
                    Control[] controlArray2 = controls;
                    int n = controls.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray2[n2];
                        control.setEnabled(enable);
                        ++n2;
                    }
                };
                enabled.addListener(param -> {
                    boolean bl = Utils.execSWTThread(code);
                });
                code.run();
            }
            this.ipRanges = this.getSortedRanges(this.filter.getRanges());
            this.table.addListener(36, event2 -> {
                TableItem item = (TableItem)event2.item;
                int index = this.table.indexOf(item);
                if (index < 0 || index >= this.ipRanges.length) {
                    return;
                }
                IpRange range = this.ipRanges[index];
                item.setText(0, range.getDescription());
                item.setText(1, range.getStartIp());
                item.setText(2, range.getEndIp());
                item.setData((Object)range);
            });
            this.table.setItemCount(this.ipRanges.length);
            this.table.clearAll();
            this.table.redraw();
            this.table.addListener(11, e -> this.resizeTable());
            gFilter.addListener(11, e -> this.resizeTable());
            this.filterListener = new IPFilterListener(){

                @Override
                public void IPFilterEnabledChanged(boolean is_enabled) {
                }

                @Override
                public boolean canIPBeBanned(String ip) {
                    return true;
                }

                @Override
                public void IPBanned(BannedIp ip) {
                }

                @Override
                public void IPBlockedListChanged(IpFilter filter2) {
                    Utils.execSWTThread(() -> {
                        if (IPEditorParameter.this.table.isDisposed()) {
                            filter2.removeListener(IPEditorParameter.this.filterListener);
                            return;
                        }
                        IPEditorParameter.this.ipRanges = IPEditorParameter.this.getSortedRanges(filter2.getRanges());
                        IPEditorParameter.this.table.setItemCount(IPEditorParameter.this.ipRanges.length);
                        IPEditorParameter.this.table.clearAll();
                        IPEditorParameter.this.table.redraw();
                    });
                }

                @Override
                public boolean canIPBeBlocked(String ip, byte[] torrent_hash) {
                    return true;
                }
            };
            this.filter.addListener(this.filterListener);
            UIUpdaterSWT.getInstance().addUpdater(new UIUpdatable(){

                @Override
                public void updateUI() {
                    if (gFilter.isDisposed()) {
                        UIUpdaterSWT.getInstance().removeUpdater(this);
                    } else {
                        IPEditorParameter.this.refresh();
                    }
                }

                @Override
                public String getUpdateUIName() {
                    return "IPFilter ConfigView";
                }
            });
        }

        private void resizeTable() {
            int iNewWidth = this.table.getClientArea().width - this.table.getColumn(1).getWidth() - this.table.getColumn(2).getWidth() - 20;
            if (iNewWidth > 50) {
                this.table.getColumn(0).setWidth(iNewWidth);
            }
        }

        public void removeRange(IpRange range) {
            this.filter.removeRange(range);
        }

        public void editRange(IpRange range) {
            new IpFilterEditor(CoreFactory.getSingleton(), this.table.getShell(), range, () -> {
                this.noChange = false;
            });
        }

        public void addRange() {
            new IpFilterEditor(CoreFactory.getSingleton(), this.table.getShell(), null, null);
        }

        public void refresh() {
            TableItem[] items;
            if (this.table == null || this.table.isDisposed() || this.noChange) {
                return;
            }
            this.noChange = true;
            TableItem[] tableItemArray = items = this.table.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item != null && !item.isDisposed()) {
                    String tmp = item.getText(0);
                    IpRange range = (IpRange)item.getData();
                    String desc = range.getDescription();
                    if (desc != null && !desc.equals(tmp)) {
                        item.setText(0, desc);
                    }
                    tmp = item.getText(1);
                    if (range.getStartIp() != null && !range.getStartIp().equals(tmp)) {
                        item.setText(1, range.getStartIp());
                    }
                    tmp = item.getText(2);
                    if (range.getEndIp() != null && !range.getEndIp().equals(tmp)) {
                        item.setText(2, range.getEndIp());
                    }
                }
                ++n2;
            }
        }

        protected IpRange[] getSortedRanges(IpRange[] ranges) {
            Arrays.sort(ranges, this.comparator);
            return ranges;
        }

        public void dispose() {
            if (this.bIsCachingDescriptions) {
                IpFilterManager ipFilterManager = CoreFactory.getSingleton().getIpFilterManager();
                ipFilterManager.clearDescriptionCache();
                this.bIsCachingDescriptions = false;
            }
            this.filter.removeListener(this.filterListener);
        }
    }
}

