/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.configsections;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.networkmanager.admin.NetworkAdminSocksProxy;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.ui.config.ParameterListener;
import com.biglybt.pifimpl.local.ui.config.BooleanParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterImpl;
import com.biglybt.pifimpl.local.ui.config.StringParameterImpl;
import com.biglybt.ui.config.ConfigSectionConnectionProxy;
import com.biglybt.ui.swt.TextViewerWindow;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.config.BaseSwtParameter;
import com.biglybt.ui.swt.views.configsections.BaseConfigSectionSWT;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;

public class ConfigSectionConnectionProxySWT
extends ConfigSectionConnectionProxy
implements BaseConfigSectionSWT {
    final NetworkAdminSocksProxy[] test_proxy = new NetworkAdminSocksProxy[1];

    public ConfigSectionConnectionProxySWT() {
        this.init(mapPluginParams -> {
            boolean bl = Utils.execSWTThread(() -> this.proxyTest());
        });
    }

    @Override
    public void configSectionCreate(Composite parent, Map<ParameterImpl, BaseSwtParameter> mapParamToSwtParam) {
        BooleanParameterImpl enableProxy = (BooleanParameterImpl)this.getPluginParam("Enable.Proxy");
        BooleanParameterImpl enableSocks = (BooleanParameterImpl)this.getPluginParam("Enable.SOCKS");
        StringParameterImpl pHost = (StringParameterImpl)this.getPluginParam("Proxy.Host");
        IntParameterImpl pPort = (IntParameterImpl)this.getPluginParam("Proxy.Port");
        StringParameterImpl pUser = (StringParameterImpl)this.getPluginParam("Proxy.Username");
        StringParameterImpl pPass = (StringParameterImpl)this.getPluginParam("Proxy.Password");
        BooleanParameterImpl trackerDNSKill = (BooleanParameterImpl)this.getPluginParam("Proxy.SOCKS.Tracker.DNS.Disable");
        ParameterImpl paramButtonTest = this.getPluginParam("btnProxyTest");
        ParameterImpl[] socks_params = new ParameterImpl[]{enableProxy, enableSocks, pHost, pPort, pUser, pPass, trackerDNSKill};
        ParameterListener socks_adapter = param -> {
            boolean enabled = enableProxy.getValue() && enableSocks.getValue() && pHost.getValue().trim().length() > 0 && pPort.getValue() > 0;
            boolean socks_enabled = enableProxy.getValue() && enableSocks.getValue();
            trackerDNSKill.setEnabled(socks_enabled);
            if (enabled) {
                try {
                    NetworkAdminSocksProxy nasp = NetworkAdmin.getSingleton().createSocksProxy(pHost.getValue(), pPort.getValue(), pUser.getValue(), pPass.getValue());
                    NetworkAdminSocksProxy[] networkAdminSocksProxyArray = this.test_proxy;
                    // MONITORENTER : this.test_proxy
                    this.test_proxy[0] = nasp;
                    // MONITOREXIT : networkAdminSocksProxyArray
                }
                catch (Throwable e) {
                    enabled = false;
                }
            }
            if (!enabled) {
                NetworkAdminSocksProxy[] e = this.test_proxy;
                // MONITORENTER : this.test_proxy
                this.test_proxy[0] = null;
                // MONITOREXIT : e
            }
            boolean f_enabled = enabled;
            Utils.execSWTThread(() -> paramButtonTest.setEnabled(f_enabled));
        };
        ParameterImpl[] parameterImplArray = socks_params;
        int n = socks_params.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterImpl socks_param = parameterImplArray[n2];
            socks_param.addListener(socks_adapter);
            ++n2;
        }
        socks_adapter.parameterChanged(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proxyTest() {
        NetworkAdminSocksProxy[] networkAdminSocksProxyArray = this.test_proxy;
        synchronized (this.test_proxy) {
            final NetworkAdminSocksProxy target = this.test_proxy[0];
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (target == null) {
                return;
            }
            final TextViewerWindow viewer = new TextViewerWindow(MessageText.getString("ConfigView.section.proxy.testsocks.title"), null, "Testing SOCKS connection to " + target.getHost() + ":" + target.getPort(), false);
            final AESemaphore test_done = new AESemaphore("");
            new AEThread2("SOCKS test"){

                @Override
                public void run() {
                    try {
                        try {
                            String[] vers = target.getVersionsSupported();
                            String ver = "";
                            String[] stringArray = vers;
                            int n = vers.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String v = stringArray[n2];
                                ver = String.valueOf(ver) + (ver.length() == 0 ? "" : ", ") + v;
                                ++n2;
                            }
                            ConfigSectionConnectionProxySWT.appendText(viewer, "\r\nConnection OK - supported version(s): " + ver);
                        }
                        catch (Throwable e) {
                            ConfigSectionConnectionProxySWT.appendText(viewer, "\r\n" + Debug.getNestedExceptionMessage(e));
                            test_done.release();
                        }
                    }
                    finally {
                        test_done.release();
                    }
                }
            }.start();
            new AEThread2("SOCKS test dotter"){

                @Override
                public void run() {
                    while (!test_done.reserveIfAvailable()) {
                        ConfigSectionConnectionProxySWT.appendText(viewer, ".");
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Throwable e) {
                            break;
                        }
                    }
                }
            }.start();
            return;
        }
    }

    private static void appendText(TextViewerWindow viewer, String line) {
        Utils.execSWTThread(() -> {
            if (!viewer.isDisposed()) {
                viewer.append2(line);
            }
        });
    }
}

