/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.activities.ActivitiesEntry;
import com.biglybt.activities.ActivitiesManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BufferedLabel;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class ViewQuickNotifications
implements UISWTViewCoreEventListener,
ViewTitleInfo {
    private UISWTView swtView;
    private Composite composite;
    private Label notification_icon;
    private Label notification_text;
    private BufferedLabel more_text;
    private volatile ActivitiesEntry current_entry;

    private void initialize(Composite parent) {
        Control[] controls;
        parent.setLayout((Layout)Utils.getSimpleGridLayout(1));
        this.composite = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        this.composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        this.composite.setLayout((Layout)layout);
        this.notification_icon = new Label(this.composite, 0);
        gridData = new GridData();
        gridData.widthHint = 20;
        this.notification_icon.setLayoutData((Object)gridData);
        this.notification_text = new Label(this.composite, 0x20000000);
        gridData = new GridData(768);
        this.notification_text.setLayoutData((Object)gridData);
        MouseAdapter listener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                if (uif != null) {
                    uif.getMDI().showEntryByID("Activity");
                }
            }
        };
        this.more_text = new BufferedLabel(this.composite, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.more_text.setLayoutData(gridData);
        this.notification_text.setData((Object)"");
        Control[] controlArray = controls = new Control[]{this.composite, this.notification_icon, this.notification_text, this.more_text.getControl()};
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.addMouseListener((MouseListener)listener);
            Messages.setLanguageTooltip((Widget)c, "label.click.to.view.tooltip");
            ++n2;
        }
        this.notification_text.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                String text = (String)ViewQuickNotifications.this.notification_text.getData();
                int style = 16384;
                Rectangle bounds = ViewQuickNotifications.this.notification_text.getBounds();
                bounds.x = 4;
                bounds.y = 0;
                bounds.width -= 8;
                GCStringPrinter sp = new GCStringPrinter(e.gc, text, bounds, true, true, style);
                sp.calculateMetrics();
                sp.printString();
            }
        });
    }

    private void delete() {
        Utils.disposeComposite(this.composite);
    }

    private String getFullTitle() {
        return MessageText.getString("label.quick.notifications");
    }

    @Override
    public Object getTitleInfoProperty(int property) {
        if (property == 0) {
            if (this.current_entry != null) {
                return "1";
            }
        } else if (property == 8) {
            return new int[]{132, 16, 58};
        }
        return null;
    }

    private Composite getComposite() {
        return this.composite;
    }

    private void refresh() {
        ActivitiesEntry entry;
        if (this.notification_text == null || this.notification_text.isDisposed()) {
            return;
        }
        Object[] temp = ActivitiesManager.getMostRecentUnseen();
        this.current_entry = entry = (ActivitiesEntry)temp[0];
        boolean changed = false;
        String old_text = (String)this.notification_text.getData();
        if (entry == null) {
            this.notification_icon.setImage(null);
            if (old_text.length() > 0) {
                this.notification_text.setData((Object)"");
                this.notification_text.redraw();
                changed = true;
            }
            this.more_text.setText("");
        } else {
            int num;
            String icon_id;
            String cur_text = entry.getText();
            if (!old_text.equals(cur_text)) {
                this.notification_text.setData((Object)cur_text);
                this.notification_text.redraw();
                changed = true;
            }
            if ((icon_id = entry.getIconID()) != null) {
                String existing = (String)this.notification_icon.getData();
                if (existing == null || this.notification_icon.getImage() == null || !existing.equals(icon_id)) {
                    ImageLoader imageLoader = ImageLoader.getInstance();
                    if (existing != null) {
                        imageLoader.releaseImage(existing);
                    }
                    Image image = imageLoader.getImage(icon_id);
                    this.notification_icon.setImage(image);
                    this.notification_icon.setData((Object)icon_id);
                    changed = true;
                }
            } else if (this.notification_icon.getImage() != null) {
                this.notification_icon.setImage(null);
                changed = true;
            }
            if ((num = ((Integer)temp[1]).intValue()) <= 1) {
                this.more_text.setText("");
            } else {
                this.more_text.setText(MessageText.getString("popup.more.waiting", new String[]{String.valueOf(num - 1)}));
            }
        }
        if (changed) {
            ViewTitleInfoManager.refreshTitleInfo(this);
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = event2.getView();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }
}

