/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerOptionsHandler;
import com.biglybt.core.download.DownloadManagerStateAttributeListener;
import com.biglybt.core.download.DownloadManagerStats;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BufferedLabel;
import com.biglybt.ui.swt.config.BaseSwtParameter;
import com.biglybt.ui.swt.config.BooleanSwtParameter;
import com.biglybt.ui.swt.config.FloatSwtParameter;
import com.biglybt.ui.swt.config.IntSwtParameter;
import com.biglybt.ui.swt.config.actionperformer.ChangeSelectionActionPerformer;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.mdi.TabbedEntry;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.util.DataSourceUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class TorrentOptionsView
implements UISWTViewCoreEventListener,
DownloadManagerOptionsHandler.ParameterChangeListener {
    private static final String MAX_UPLOAD = "max.upload";
    private static final String MAX_DOWNLOAD = "max.download";
    public static final String MSGID_PREFIX = "TorrentOptionsView";
    private boolean multi_view;
    private DownloadManagerOptionsHandler[] managers;
    private downloadStateBooleanParameterAdapter ds_boolparam_adapter = new downloadStateBooleanParameterAdapter();
    private downloadStateIntParameterAdapter ds_intparam_adapter = new downloadStateIntParameterAdapter();
    private downloadStateFloatParameterAdapter ds_floatparam_adapter = new downloadStateFloatParameterAdapter();
    private adhocIntParameterAdapter adhoc_param_adapter = new adhocIntParameterAdapter();
    private Map<String, BaseSwtParameter<?, ?>> adhoc_parameters = new HashMap();
    private Map<String, BaseSwtParameter<?, ?>> ds_parameters = new HashMap();
    private ScrolledComposite sc;
    private Font headerFont;
    private BufferedLabel agg_size;
    private BufferedLabel agg_remaining;
    private BufferedLabel agg_uploaded;
    private BufferedLabel agg_downloaded;
    private BufferedLabel agg_share_ratio;
    private BufferedLabel agg_upload_speed;
    private BufferedLabel agg_download_speed;
    private Composite parent;
    private UISWTView swtView;

    private void initialize(Composite composite) {
        this.parent = composite;
        if (this.sc != null && !this.sc.isDisposed()) {
            this.sc.dispose();
        }
        this.sc = new ScrolledComposite(composite, 768);
        this.sc.getVerticalBar().setIncrement(16);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        this.sc.setLayoutData((Object)gridData);
        Composite panel = new Composite((Composite)this.sc, 0);
        this.sc.setContent((Control)panel);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        panel.setLayout((Layout)layout);
        Layout parentLayout = this.parent.getLayout();
        if (parentLayout instanceof FormLayout) {
            panel.setLayoutData((Object)Utils.getFilledFormData());
        } else {
            panel.setLayoutData((Object)new GridData(1808));
        }
        if (this.managers == null) {
            return;
        }
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        boolean showHeader = true;
        if (this.swtView instanceof TabbedEntry) {
            showHeader = ((TabbedEntry)this.swtView).getMDI().getAllowSubViews();
        }
        if (showHeader) {
            Composite cHeader = new Composite(panel, 2048);
            GridLayout configLayout = new GridLayout();
            configLayout.marginHeight = 3;
            configLayout.marginWidth = 0;
            cHeader.setLayout((Layout)configLayout);
            gridData = new GridData(772);
            cHeader.setLayoutData((Object)gridData);
            Display d = panel.getDisplay();
            cHeader.setBackground(Colors.getSystemColor((Device)d, 26));
            cHeader.setForeground(Colors.getSystemColor((Device)d, 27));
            Label lHeader = new Label(cHeader, 0);
            lHeader.setBackground(Colors.getSystemColor((Device)d, 26));
            lHeader.setForeground(Colors.getSystemColor((Device)d, 27));
            FontData[] fontData = lHeader.getFont().getFontData();
            fontData[0].setStyle(1);
            int fontHeight = (int)((double)fontData[0].getHeight() * 1.2);
            fontData[0].setHeight(fontHeight);
            this.headerFont = new Font((Device)d, fontData);
            lHeader.setFont(this.headerFont);
            if (this.managers.length == 1) {
                if (this.managers[0].getDownloadManager() == null) {
                    lHeader.setText(" " + this.managers[0].getName().replaceAll("&", "&&"));
                } else {
                    lHeader.setText(" " + MessageText.getString("authenticator.torrent") + " : " + this.managers[0].getName().replaceAll("&", "&&"));
                }
            } else {
                String str = "";
                int i = 0;
                while (i < Math.min(3, this.managers.length)) {
                    str = String.valueOf(str) + (i == 0 ? "" : ", ") + this.managers[i].getName().replaceAll("&", "&&");
                    ++i;
                }
                if (this.managers.length > 3) {
                    str = String.valueOf(str) + "...";
                }
                lHeader.setText(" " + this.managers.length + " " + MessageText.getString("ConfigView.section.torrents") + " : " + str);
            }
            gridData = new GridData(772);
            lHeader.setLayoutData((Object)gridData);
        }
        Group gTorrentOptions = Utils.createSkinnedGroup(panel, 0);
        Messages.setLanguageText((Widget)gTorrentOptions, "ConfigView.section.transfer");
        gridData = new GridData(272);
        gTorrentOptions.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        gTorrentOptions.setLayout((Layout)layout);
        String k_unit = DisplayFormatters.getRateUnitBase10(1).trim();
        IntSwtParameter max_upload = new IntSwtParameter((Composite)gTorrentOptions, MAX_UPLOAD, "", null, this.adhoc_param_adapter);
        max_upload.setLabelText(String.valueOf(k_unit) + " " + MessageText.getString("GeneralView.label.maxuploadspeed.tooltip"));
        this.adhoc_parameters.put(MAX_UPLOAD, max_upload);
        if (userMode > 0) {
            IntSwtParameter max_upload_when_busy = new IntSwtParameter((Composite)gTorrentOptions, "max.upload.when.busy", "TorrentOptionsView.param.max.uploads.when.busy", null, this.ds_intparam_adapter);
            this.ds_parameters.put("max.upload.when.busy", max_upload_when_busy);
        }
        IntSwtParameter max_download = new IntSwtParameter((Composite)gTorrentOptions, MAX_DOWNLOAD, "", null, this.adhoc_param_adapter);
        max_download.setLabelText(String.valueOf(k_unit) + " " + MessageText.getString("GeneralView.label.maxdownloadspeed.tooltip"));
        this.adhoc_parameters.put(MAX_DOWNLOAD, max_download);
        if (userMode > 0) {
            IntSwtParameter max_uploads = new IntSwtParameter((Composite)gTorrentOptions, "max.uploads", "TorrentOptionsView.param.max.uploads", null, this.ds_intparam_adapter);
            this.ds_parameters.put("max.uploads", max_uploads);
            max_uploads.setMinimumValue(2);
            Composite cMaxUploadsOptionsArea = new Composite((Composite)gTorrentOptions, 0);
            layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            cMaxUploadsOptionsArea.setLayout((Layout)layout);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            cMaxUploadsOptionsArea.setLayoutData((Object)gridData);
            BooleanSwtParameter max_uploads_when_seeding_enabled = new BooleanSwtParameter(cMaxUploadsOptionsArea, "max.uploads.when.seeding.enabled", "TorrentOptionsView.param.alternative.value.enable", null, this.ds_boolparam_adapter);
            max_uploads_when_seeding_enabled.setIndent(1, true);
            this.ds_parameters.put("max.uploads.when.seeding.enabled", max_uploads_when_seeding_enabled);
            IntSwtParameter max_uploads_when_seeding = new IntSwtParameter(cMaxUploadsOptionsArea, "max.uploads.when.seeding", null, null, this.ds_intparam_adapter);
            this.ds_parameters.put("max.uploads.when.seeding", max_uploads_when_seeding);
            max_uploads_when_seeding.setMinimumValue(2);
            max_uploads_when_seeding_enabled.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(max_uploads_when_seeding));
            IntSwtParameter max_peers = new IntSwtParameter((Composite)gTorrentOptions, "max.peers", "TorrentOptionsView.param.max.peers", null, this.ds_intparam_adapter);
            this.ds_parameters.put("max.peers", max_peers);
            Composite cMaxPeersOptionsArea = new Composite((Composite)gTorrentOptions, 0);
            layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            cMaxPeersOptionsArea.setLayout((Layout)layout);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            cMaxPeersOptionsArea.setLayoutData((Object)gridData);
            BooleanSwtParameter max_peers_when_seeding_enabled = new BooleanSwtParameter(cMaxPeersOptionsArea, "max.peers.when.seeding.enabled", "TorrentOptionsView.param.alternative.value.enable", null, this.ds_boolparam_adapter);
            max_peers_when_seeding_enabled.setIndent(1, true);
            this.ds_parameters.put("max.peers.when.seeding.enabled", max_peers_when_seeding_enabled);
            IntSwtParameter max_peers_when_seeding = new IntSwtParameter(cMaxPeersOptionsArea, "max.peers.when.seeding", null, null, this.ds_intparam_adapter);
            this.ds_parameters.put("max.peers.when.seeding", max_peers_when_seeding);
            max_peers_when_seeding_enabled.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(max_peers_when_seeding));
            IntSwtParameter max_seeds = new IntSwtParameter((Composite)gTorrentOptions, "max.seeds", "TorrentOptionsView.param.max.seeds", null, this.ds_intparam_adapter);
            this.ds_parameters.put("max.seeds", max_seeds);
        }
        if (userMode > 0) {
            IntSwtParameter upload_priority_enabled = new IntSwtParameter((Composite)gTorrentOptions, "up.pri", "TorrentOptionsView.param.upload.priority", null, 0, 1, this.ds_intparam_adapter);
            this.ds_parameters.put("up.pri", upload_priority_enabled);
            FloatSwtParameter min_sr = new FloatSwtParameter((Composite)gTorrentOptions, "sr.min", "TableColumn.header.min_sr", null, 0.0f, Float.MAX_VALUE, true, 3, this.ds_floatparam_adapter);
            this.ds_parameters.put("sr.min", min_sr);
            FloatSwtParameter max_sr = new FloatSwtParameter((Composite)gTorrentOptions, "sr.max", "TableColumn.header.max_sr", null, 0.0f, Float.MAX_VALUE, true, 3, this.ds_floatparam_adapter);
            this.ds_parameters.put("sr.max", max_sr);
        }
        Label reset_label = new Label((Composite)gTorrentOptions, 0);
        Messages.setLanguageText((Widget)reset_label, "TorrentOptionsView.param.reset.to.default");
        Button reset_button = new Button((Composite)gTorrentOptions, 8);
        Messages.setLanguageText((Widget)reset_button, "TorrentOptionsView.param.reset.button");
        reset_button.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                TorrentOptionsView.this.setDefaults();
            }
        });
        int i = 0;
        while (i < this.managers.length) {
            this.managers[i].addListener(this);
            ++i;
        }
        Group gTorrentInfo = Utils.createSkinnedGroup(panel, 0);
        Messages.setLanguageText((Widget)gTorrentInfo, "label.aggregate.info");
        gridData = new GridData(272);
        gTorrentInfo.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        gTorrentInfo.setLayout((Layout)layout);
        Label label = new Label((Composite)gTorrentInfo, 0);
        label.setText(String.valueOf(MessageText.getString("TableColumn.header.size")) + ": ");
        this.agg_size = new BufferedLabel((Composite)gTorrentInfo, 0x20004000);
        gridData = new GridData(768);
        this.agg_size.setLayoutData(gridData);
        label = new Label((Composite)gTorrentInfo, 0);
        label.setText(String.valueOf(MessageText.getString("TableColumn.header.remaining")) + ": ");
        this.agg_remaining = new BufferedLabel((Composite)gTorrentInfo, 0x20004000);
        gridData = new GridData(768);
        this.agg_remaining.setLayoutData(gridData);
        label = new Label((Composite)gTorrentInfo, 0);
        label.setText(String.valueOf(MessageText.getString("MyTracker.column.uploaded")) + ": ");
        this.agg_uploaded = new BufferedLabel((Composite)gTorrentInfo, 0x20004000);
        gridData = new GridData(768);
        this.agg_uploaded.setLayoutData(gridData);
        label = new Label((Composite)gTorrentInfo, 0);
        label.setText(String.valueOf(MessageText.getString("MyTracker.column.downloaded")) + ": ");
        this.agg_downloaded = new BufferedLabel((Composite)gTorrentInfo, 0x20004000);
        gridData = new GridData(768);
        this.agg_downloaded.setLayoutData(gridData);
        label = new Label((Composite)gTorrentInfo, 0);
        label.setText(String.valueOf(MessageText.getString("SpeedView.uploadSpeed.title")) + ": ");
        this.agg_upload_speed = new BufferedLabel((Composite)gTorrentInfo, 0x20004000);
        gridData = new GridData(768);
        this.agg_upload_speed.setLayoutData(gridData);
        label = new Label((Composite)gTorrentInfo, 0);
        label.setText(String.valueOf(MessageText.getString("SpeedView.downloadSpeed.title")) + ": ");
        this.agg_download_speed = new BufferedLabel((Composite)gTorrentInfo, 0x20004000);
        gridData = new GridData(768);
        this.agg_download_speed.setLayoutData(gridData);
        label = new Label((Composite)gTorrentInfo, 0);
        label.setText(String.valueOf(MessageText.getString("TableColumn.header.shareRatio")) + ": ");
        this.agg_share_ratio = new BufferedLabel((Composite)gTorrentInfo, 0x20004000);
        gridData = new GridData(768);
        this.agg_share_ratio.setLayoutData(gridData);
        Label stats_reset_label = new Label((Composite)gTorrentInfo, 0);
        Messages.setLanguageText((Widget)stats_reset_label, "TorrentOptionsView.param.reset.stats");
        Button stats_reset_button = new Button((Composite)gTorrentInfo, 8);
        Messages.setLanguageText((Widget)stats_reset_button, "TorrentOptionsView.param.reset.button");
        stats_reset_button.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                DownloadManagerOptionsHandler[] downloadManagerOptionsHandlerArray = TorrentOptionsView.this.managers;
                int n = downloadManagerOptionsHandlerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DownloadManagerOptionsHandler dm = downloadManagerOptionsHandlerArray[n2];
                    if (dm.getDownloadManager() != null) {
                        dm.getDownloadManager().getStats().resetTotalBytesSentReceived(0L, 0L);
                    }
                    ++n2;
                }
            }
        });
        this.sc.setMinSize(panel.computeSize(-1, -1));
        composite.layout();
    }

    private void refresh() {
        String share_ratio_str;
        if (this.agg_size == null || this.managers.length == 0 || this.managers[0].getDownloadManager() == null) {
            return;
        }
        long total_size = 0L;
        long total_remaining = 0L;
        long total_good_downloaded = 0L;
        long total_downloaded = 0L;
        long total_uploaded = 0L;
        long total_data_up_speed = 0L;
        long total_prot_up_speed = 0L;
        long total_data_down_speed = 0L;
        long total_prot_down_speed = 0L;
        int i = 0;
        while (i < this.managers.length) {
            DownloadManagerOptionsHandler dm = this.managers[i];
            DownloadManagerStats stats2 = dm.getDownloadManager().getStats();
            total_size += stats2.getSizeExcludingDND();
            total_remaining += stats2.getRemainingExcludingDND();
            long good_received = stats2.getTotalGoodDataBytesReceived();
            long received = stats2.getTotalDataBytesReceived();
            long sent = stats2.getTotalDataBytesSent();
            total_good_downloaded += good_received;
            total_downloaded += received;
            total_uploaded += sent;
            total_data_up_speed += stats2.getDataSendRate();
            total_prot_up_speed += stats2.getProtocolSendRate();
            total_data_down_speed += stats2.getDataReceiveRate();
            total_prot_down_speed += stats2.getProtocolReceiveRate();
            ++i;
        }
        this.agg_size.setText(DisplayFormatters.formatByteCountToKiBEtc(total_size));
        this.agg_remaining.setText(DisplayFormatters.formatByteCountToKiBEtc(total_remaining));
        this.agg_uploaded.setText(DisplayFormatters.formatByteCountToKiBEtc(total_uploaded));
        this.agg_downloaded.setText(DisplayFormatters.formatByteCountToKiBEtc(total_downloaded));
        this.agg_upload_speed.setText(DisplayFormatters.formatDataProtByteCountToKiBEtc(total_data_up_speed, total_prot_up_speed));
        this.agg_download_speed.setText(DisplayFormatters.formatDataProtByteCountToKiBEtc(total_data_down_speed, total_prot_down_speed));
        long sr = total_good_downloaded == 0L ? (total_uploaded == 0L ? 1000L : -1L) : 1000L * total_uploaded / total_good_downloaded;
        if (sr == -1L) {
            share_ratio_str = "\u221e";
        } else {
            String partial = "" + sr % 1000L;
            while (partial.length() < 3) {
                partial = "0" + partial;
            }
            share_ratio_str = String.valueOf(sr / 1000L) + "." + partial;
        }
        this.agg_share_ratio.setText(share_ratio_str);
    }

    protected void setDefaults() {
        for (Map.Entry<String, BaseSwtParameter<?, ?>> entry : this.ds_parameters.entrySet()) {
            String key = entry.getKey();
            int i = 0;
            while (i < this.managers.length) {
                this.managers[i].setParameterDefault(key);
                ++i;
            }
            entry.getValue().refreshControl();
        }
        for (Map.Entry<String, BaseSwtParameter<?, ?>> entry : this.adhoc_parameters.entrySet()) {
            BaseSwtParameter<?, ?> param = entry.getValue();
            if (param instanceof IntSwtParameter) {
                IntSwtParameter int_param = (IntSwtParameter)param;
                int_param.setValue(0);
                continue;
            }
            Debug.out("Unknown parameter type: " + param.getClass());
        }
    }

    @Override
    public void parameterChanged(final DownloadManagerOptionsHandler manager) {
        Utils.execSWTThread(new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : TorrentOptionsView.this.ds_parameters.entrySet()) {
                    String key = (String)entry.getKey();
                    Object param = entry.getValue();
                    if (param instanceof IntSwtParameter) {
                        IntSwtParameter int_param = (IntSwtParameter)param;
                        int value = manager.getIntParameter(key);
                        int_param.setValue(value);
                        continue;
                    }
                    if (param instanceof BooleanSwtParameter) {
                        BooleanSwtParameter bool_param = (BooleanSwtParameter)param;
                        boolean value = manager.getBooleanParameter(key);
                        bool_param.setSelected(value);
                        continue;
                    }
                    if (param instanceof FloatSwtParameter) {
                        FloatSwtParameter float_param = (FloatSwtParameter)param;
                        float value = (float)manager.getIntParameter(key) / 1000.0f;
                        float_param.setValue(Float.valueOf(value));
                        continue;
                    }
                    Debug.out("Unknown parameter type: " + param.getClass());
                }
            }
        }, true);
    }

    private Composite getComposite() {
        return this.sc;
    }

    private String getFullTitle() {
        return MessageText.getString(this.multi_view ? "TorrentOptionsView.multi.title.full" : "TorrentOptionsView.title.full");
    }

    private void delete() {
        if (this.headerFont != null) {
            this.headerFont.dispose();
        }
        if (this.managers != null) {
            int i = 0;
            while (i < this.managers.length) {
                this.managers[i].removeListener(this);
                ++i;
            }
        }
    }

    private void dataSourceChanged(Object newDataSource) {
        DownloadManagerOptionsHandler[] old_managers = this.managers;
        if (old_managers != null) {
            int i = 0;
            while (i < old_managers.length) {
                old_managers[i].removeListener(this);
                ++i;
            }
        }
        if (newDataSource instanceof DownloadManagerOptionsHandler) {
            this.multi_view = false;
            this.managers = new DownloadManagerOptionsHandler[]{(DownloadManagerOptionsHandler)newDataSource};
        } else {
            DownloadManager[] dms = DataSourceUtils.getDMs(newDataSource);
            this.managers = new DownloadManagerOptionsHandler[dms.length];
            int i = 0;
            int dmsLength = dms.length;
            while (i < dmsLength) {
                DownloadManager dm = dms[i];
                this.managers[i] = new DMWrapper(dm);
                ++i;
            }
            boolean bl = this.multi_view = this.managers.length > 1;
        }
        if (this.parent != null && !this.parent.isDisposed()) {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    if (!TorrentOptionsView.this.parent.isDisposed()) {
                        TorrentOptionsView.this.initialize(TorrentOptionsView.this.parent);
                    }
                }
            });
        }
        this.swtView.setTitle(this.getFullTitle());
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }

    private static class DMWrapper
    implements DownloadManagerOptionsHandler,
    DownloadManagerStateAttributeListener {
        private DownloadManager dm;
        private CopyOnWriteList<DownloadManagerOptionsHandler.ParameterChangeListener> listeners = new CopyOnWriteList();

        private DMWrapper(DownloadManager _dm) {
            this.dm = _dm;
        }

        @Override
        public String getName() {
            return this.dm.getDisplayName();
        }

        @Override
        public void setIntParameter(String name, int value) {
            this.dm.getDownloadState().setIntParameter(name, value);
        }

        @Override
        public int getIntParameter(String name) {
            return this.dm.getDownloadState().getIntParameter(name);
        }

        @Override
        public void setBooleanParameter(String name, boolean value) {
            this.dm.getDownloadState().setBooleanParameter(name, value);
        }

        @Override
        public boolean getBooleanParameter(String name) {
            return this.dm.getDownloadState().getBooleanParameter(name);
        }

        @Override
        public void setParameterDefault(String key) {
            this.dm.getDownloadState().setParameterDefault(key);
        }

        @Override
        public int getUploadRateLimitBytesPerSecond() {
            return this.dm.getStats().getUploadRateLimitBytesPerSecond();
        }

        @Override
        public void setUploadRateLimitBytesPerSecond(int limit) {
            this.dm.getStats().setUploadRateLimitBytesPerSecond(limit);
        }

        @Override
        public int getDownloadRateLimitBytesPerSecond() {
            return this.dm.getStats().getDownloadRateLimitBytesPerSecond();
        }

        @Override
        public void setDownloadRateLimitBytesPerSecond(int limit) {
            this.dm.getStats().setDownloadRateLimitBytesPerSecond(limit);
        }

        @Override
        public DownloadManager getDownloadManager() {
            return this.dm;
        }

        @Override
        public void attributeEventOccurred(DownloadManager dm, String attribute_name, int event_type) {
            for (DownloadManagerOptionsHandler.ParameterChangeListener l : this.listeners) {
                try {
                    l.parameterChanged(this);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }

        @Override
        public void addListener(DownloadManagerOptionsHandler.ParameterChangeListener listener) {
            this.listeners.add(listener);
            this.dm.getDownloadState().addListener(this, "parameters", 1);
        }

        @Override
        public void removeListener(DownloadManagerOptionsHandler.ParameterChangeListener listener) {
            this.listeners.remove(listener);
            this.dm.getDownloadState().removeListener(this, "parameters", 1);
        }
    }

    protected class adhocIntParameterAdapter
    implements IntSwtParameter.ValueProcessor {
        protected adhocIntParameterAdapter() {
        }

        @Override
        public Integer getValue(IntSwtParameter p) {
            String key = p.getParamID();
            if (TorrentOptionsView.MAX_UPLOAD.equals(key)) {
                int result = 0;
                int i = 0;
                while (i < TorrentOptionsView.this.managers.length) {
                    int val = TorrentOptionsView.this.managers[i].getUploadRateLimitBytesPerSecond() / DisplayFormatters.getKinB();
                    if (i == 0) {
                        result = val;
                    } else if (result != val) {
                        return 0;
                    }
                    ++i;
                }
                return result;
            }
            if (TorrentOptionsView.MAX_DOWNLOAD.equals(key)) {
                int result = 0;
                int i = 0;
                while (i < TorrentOptionsView.this.managers.length) {
                    int val = TorrentOptionsView.this.managers[i].getDownloadRateLimitBytesPerSecond() / DisplayFormatters.getKinB();
                    if (i == 0) {
                        result = val;
                    } else if (result != val) {
                        return 0;
                    }
                    ++i;
                }
                return result;
            }
            Debug.out("Unknown key '" + key + "'");
            return 0;
        }

        @Override
        public boolean setValue(IntSwtParameter p, Integer value) {
            boolean changed = false;
            String key = p.getParamID();
            if (key.equals(TorrentOptionsView.MAX_UPLOAD)) {
                int i = 0;
                while (i < TorrentOptionsView.this.managers.length) {
                    DownloadManagerOptionsHandler manager = TorrentOptionsView.this.managers[i];
                    if (value != manager.getUploadRateLimitBytesPerSecond() / DisplayFormatters.getKinB()) {
                        manager.setUploadRateLimitBytesPerSecond(value * DisplayFormatters.getKinB());
                        changed = true;
                    }
                    ++i;
                }
            } else if (key.equals(TorrentOptionsView.MAX_DOWNLOAD)) {
                int i = 0;
                while (i < TorrentOptionsView.this.managers.length) {
                    DownloadManagerOptionsHandler manager = TorrentOptionsView.this.managers[i];
                    if (value != manager.getDownloadRateLimitBytesPerSecond() / DisplayFormatters.getKinB()) {
                        manager.setDownloadRateLimitBytesPerSecond(value * DisplayFormatters.getKinB());
                        changed = true;
                    }
                    ++i;
                }
            } else {
                Debug.out("Unknown key '" + key + "'");
            }
            return changed;
        }
    }

    protected class downloadStateBooleanParameterAdapter
    implements BooleanSwtParameter.ValueProcessor {
        protected downloadStateBooleanParameterAdapter() {
        }

        @Override
        public Boolean getValue(BooleanSwtParameter p) {
            boolean result = false;
            String key = p.getParamID();
            int i = 0;
            while (i < TorrentOptionsView.this.managers.length) {
                boolean val = TorrentOptionsView.this.managers[i].getBooleanParameter(key);
                if (i == 0) {
                    result = val;
                } else if (result != val) {
                    return false;
                }
                ++i;
            }
            return result;
        }

        @Override
        public boolean setValue(BooleanSwtParameter p, Boolean value) {
            boolean changed = TorrentOptionsView.this.managers.length == 0;
            String key = p.getParamID();
            int i = 0;
            while (i < TorrentOptionsView.this.managers.length) {
                DownloadManagerOptionsHandler manager = TorrentOptionsView.this.managers[i];
                if (value.booleanValue() != manager.getBooleanParameter(key)) {
                    manager.setBooleanParameter(key, value);
                    changed = true;
                }
                ++i;
            }
            return changed;
        }
    }

    protected class downloadStateFloatParameterAdapter
    implements FloatSwtParameter.ValueProcessor {
        protected downloadStateFloatParameterAdapter() {
        }

        @Override
        public Float getValue(FloatSwtParameter p) {
            int result = 0;
            String key = p.getParamID();
            int i = 0;
            while (i < TorrentOptionsView.this.managers.length) {
                int val = TorrentOptionsView.this.managers[i].getIntParameter(key);
                if (i == 0) {
                    result = val;
                } else if (result != val) {
                    return Float.valueOf(0.0f);
                }
                ++i;
            }
            return Float.valueOf((float)result / 1000.0f);
        }

        @Override
        public boolean setValue(FloatSwtParameter p, Float _value) {
            boolean changed = TorrentOptionsView.this.managers.length == 0;
            int value = (int)(_value.floatValue() * 1000.0f);
            String key = p.getParamID();
            int i = 0;
            while (i < TorrentOptionsView.this.managers.length) {
                DownloadManagerOptionsHandler manager = TorrentOptionsView.this.managers[i];
                if (value != manager.getIntParameter(key)) {
                    manager.setIntParameter(key, value);
                    changed = true;
                }
                ++i;
            }
            return changed;
        }
    }

    protected class downloadStateIntParameterAdapter
    implements IntSwtParameter.ValueProcessor {
        protected downloadStateIntParameterAdapter() {
        }

        @Override
        public Integer getValue(IntSwtParameter p) {
            int result = 0;
            String key = p.getParamID();
            int i = 0;
            while (i < TorrentOptionsView.this.managers.length) {
                int val = TorrentOptionsView.this.managers[i].getIntParameter(key);
                if (i == 0) {
                    result = val;
                } else if (result != val) {
                    return 0;
                }
                ++i;
            }
            return result;
        }

        @Override
        public boolean setValue(IntSwtParameter p, Integer value) {
            boolean changed = false;
            String key = p.getParamID();
            int i = 0;
            while (i < TorrentOptionsView.this.managers.length) {
                DownloadManagerOptionsHandler manager = TorrentOptionsView.this.managers[i];
                if (value.intValue() != manager.getIntParameter(key)) {
                    manager.setIntParameter(key, value);
                    changed = true;
                }
                ++i;
            }
            return changed;
        }
    }
}

