/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.category.Category;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagFeatureProperties;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.tag.TagTypeListener;
import com.biglybt.core.tag.TagUtils;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.TextViewerWindow;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.views.utils.TagButtonsUI;
import com.biglybt.ui.swt.views.utils.TagUIUtils;
import com.biglybt.ui.swt.widgets.TagCanvas;
import com.biglybt.ui.swt.widgets.TagPainter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class TaggingView
implements UISWTViewCoreEventListener,
TagTypeListener {
    public static final String MSGID_PREFIX = "TaggingView";
    private static Set<Tag> copied_tag_assignment = new HashSet<Tag>();
    private static CopyOnWriteList<Consumer<String>> cta_listeners = new CopyOnWriteList();
    private UISWTView swtView;
    private ScrolledComposite sc;
    private List<Taggable> taggables;
    private Composite parent;
    private TagButtonsUI tagButtonsUI;
    private Button buttonCopy;
    private Button buttonPaste;
    private Button buttonClear;
    private Button buttonInvert;
    private Button buttonExplain;
    private Composite mainComposite;

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.parent = (Composite)event2.getData();
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.mainComposite);
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                Object ds = event2.getData();
                this.dataSourceChanged(ds);
                break;
            }
            case 3: {
                this.focusGained();
                this.rebuildComposite();
                if (this.taggables != null) break;
                this.dataSourceChanged(this.swtView.getDataSource());
                break;
            }
            case 4: {
                this.delete();
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }

    private void focusGained() {
        TagManager tm = TagManagerFactory.getTagManager();
        TagType tagType = tm.getTagType(1);
        tagType.addTagTypeListener(this, false);
        tagType = tm.getTagType(3);
        tagType.addTagTypeListener(this, false);
    }

    private void focusLost() {
        TagManager tm = TagManagerFactory.getTagManager();
        TagType tagType = tm.getTagType(1);
        tagType.removeTagTypeListener(this);
        tagType = tm.getTagType(3);
        tagType.removeTagTypeListener(this);
        Utils.disposeComposite((Composite)this.sc);
        this.taggables = null;
    }

    private void delete() {
        this.focusLost();
    }

    private void refresh() {
    }

    private void dataSourceChanged(Object ds) {
        if (ds instanceof Taggable) {
            this.taggables = new ArrayList<Taggable>();
            this.taggables.add((Taggable)ds);
        } else if (ds instanceof Taggable[]) {
            this.taggables = new ArrayList<Taggable>();
            this.taggables.addAll(Arrays.asList((Taggable[])ds));
        } else if (ds instanceof Object[]) {
            Object[] objects;
            this.taggables = new ArrayList<Taggable>();
            Object[] objectArray = objects = (Object[])ds;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                DownloadManager temp;
                Object o = objectArray[n2];
                if (o instanceof Taggable) {
                    Taggable taggable = (Taggable)o;
                    if (!this.taggables.contains(taggable)) {
                        this.taggables.add(taggable);
                    }
                } else if (o instanceof DiskManagerFileInfo && (temp = ((DiskManagerFileInfo)o).getDownloadManager()) != null && !this.taggables.contains(temp)) {
                    this.taggables.add(temp);
                }
                ++n2;
            }
            if (this.taggables.size() == 0) {
                this.taggables = null;
            }
        } else {
            this.taggables = null;
        }
        Utils.execSWTThread(this::swt_updateFields);
    }

    private void rebuildComposite() {
        if (this.mainComposite == null || this.mainComposite.isDisposed()) {
            if (this.parent == null || this.parent.isDisposed()) {
                return;
            }
            this.mainComposite = new Composite(this.parent, 0);
            this.mainComposite.setBackground(this.parent.getDisplay().getSystemColor(22));
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 0;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.mainComposite.setLayout((Layout)layout);
            Layout parentLayout = this.parent.getLayout();
            if (parentLayout instanceof GridLayout) {
                GridData gd = new GridData(4, 4, true, true);
                this.mainComposite.setLayoutData((Object)gd);
            } else if (parentLayout instanceof FormLayout) {
                this.mainComposite.setLayoutData((Object)Utils.getFilledFormData());
            }
        } else {
            Utils.disposeComposite(this.mainComposite, false);
        }
        this.tagButtonsUI = new TagButtonsUI();
        List<Tag> listAllTags = this.getTags();
        boolean hasGroup = false;
        for (Tag tag : listAllTags) {
            String group = tag.getGroup();
            if (group == null || group.length() <= 0) continue;
            hasGroup = true;
            break;
        }
        Composite buttonComp = new Composite(this.mainComposite, 0);
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        buttonComp.setLayoutData((Object)layoutData);
        GridLayout bcLayout = new GridLayout(hasGroup ? 7 : 6, false);
        bcLayout.marginHeight = 0;
        buttonComp.setLayout((Layout)bcLayout);
        Button buttonAdd = new Button(buttonComp, 8);
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        buttonAdd.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)buttonAdd, "label.add.tag");
        buttonAdd.addListener(13, event2 -> this.askForNewTag());
        this.buttonCopy = new Button(buttonComp, 8);
        gridData = new GridData(16384, 0x1000000, false, false);
        this.buttonCopy.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)this.buttonCopy, "label.copy");
        Messages.setLanguageTooltip((Widget)this.buttonCopy, "tags.copy.tooltip");
        this.buttonCopy.addListener(13, event2 -> {
            if (this.taggables == null) {
                return;
            }
            TagManager tm = TagManagerFactory.getTagManager();
            copied_tag_assignment.clear();
            for (Taggable taggable : this.taggables) {
                List<Tag> has_tags = tm.getTagsForTaggable(3, taggable);
                for (Tag tag : has_tags) {
                    boolean[] auto = tag.isTagAuto();
                    if (auto[0] || auto[1]) continue;
                    copied_tag_assignment.add(tag);
                }
            }
            for (Consumer consumer : cta_listeners) {
                consumer.accept("");
            }
        });
        this.buttonPaste = new Button(buttonComp, 8);
        gridData = new GridData(16384, 0x1000000, false, false);
        this.buttonPaste.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)this.buttonPaste, "label.paste");
        Messages.setLanguageTooltip((Widget)this.buttonPaste, "tags.paste.tooltip");
        this.buttonPaste.addListener(13, event2 -> {
            if (this.taggables == null) {
                return;
            }
            TagManager tm = TagManagerFactory.getTagManager();
            for (Taggable taggable : this.taggables) {
                for (Tag t : tm.getTagType(3).getTags()) {
                    boolean[] auto = t.isTagAuto();
                    if (auto[0] || auto[1] || copied_tag_assignment.contains(t) || !t.hasTaggable(taggable)) continue;
                    t.removeTaggable(taggable);
                }
                for (Tag t : copied_tag_assignment) {
                    if (t.hasTaggable(taggable)) continue;
                    t.addTaggable(taggable);
                }
            }
        });
        cta_listeners.add(new Consumer<String>(){

            @Override
            public void accept(String t) {
                if (TaggingView.this.buttonPaste.isDisposed()) {
                    cta_listeners.remove(this);
                } else {
                    TaggingView.this.buttonPaste.setEnabled(!copied_tag_assignment.isEmpty());
                }
            }
        });
        this.buttonPaste.setEnabled(!copied_tag_assignment.isEmpty());
        this.buttonClear = new Button(buttonComp, 8);
        gridData = new GridData(16384, 0x1000000, false, false);
        this.buttonClear.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)this.buttonClear, "Button.clear");
        Messages.setLanguageTooltip((Widget)this.buttonClear, "tags.clear.tooltip");
        this.buttonClear.addListener(13, event2 -> {
            if (this.taggables == null) {
                return;
            }
            TagManager tm = TagManagerFactory.getTagManager();
            for (Taggable taggable : this.taggables) {
                List<Tag> has_tags = tm.getTagsForTaggable(3, taggable);
                for (Tag tag : has_tags) {
                    boolean[] auto = tag.isTagAuto();
                    if (auto[0] || auto[1]) continue;
                    tag.removeTaggable(taggable);
                }
            }
        });
        this.buttonInvert = new Button(buttonComp, 8);
        gridData = new GridData(16384, 0x1000000, false, false);
        this.buttonInvert.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)this.buttonInvert, "label.invert");
        Messages.setLanguageTooltip((Widget)this.buttonInvert, "tags.invert.tooltip");
        this.buttonInvert.addListener(13, event2 -> {
            if (this.taggables == null) {
                return;
            }
            TagManager tm = TagManagerFactory.getTagManager();
            ArrayList<Tag> all_tags = new ArrayList<Tag>();
            for (Tag t : tm.getTagType(3).getTags()) {
                boolean[] auto = t.isTagAuto();
                if (auto[0] || auto[1]) continue;
                all_tags.add(t);
            }
            for (Taggable taggable : this.taggables) {
                List<Tag> has_tags = tm.getTagsForTaggable(3, taggable);
                HashSet tags_to_add = new HashSet(all_tags);
                for (Tag tag : has_tags) {
                    boolean[] auto = tag.isTagAuto();
                    if (auto[0] || auto[1]) continue;
                    tag.removeTaggable(taggable);
                    tags_to_add.remove(tag);
                }
                for (Tag tag : tags_to_add) {
                    tag.addTaggable(taggable);
                }
            }
        });
        this.buttonExplain = new Button(buttonComp, 8);
        gridData = new GridData(16384, 0x1000000, false, false);
        this.buttonExplain.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)this.buttonExplain, "button.explain");
        this.buttonExplain.addListener(13, event2 -> this.explain());
        Utils.makeButtonsEqualWidth(this.buttonCopy, this.buttonPaste, this.buttonClear, this.buttonInvert);
        Utils.makeButtonsEqualWidth(buttonAdd, this.buttonInvert, this.buttonExplain);
        if (hasGroup) {
            int layoutStyle = this.tagButtonsUI.getLayoutStyle();
            ToolBar toolBar = new ToolBar(buttonComp, 0);
            gridData = new GridData(131072, 0x1000000, true, false);
            toolBar.setLayoutData((Object)gridData);
            ToolItem buttonRowMode = new ToolItem(toolBar, 16);
            if (layoutStyle == 256) {
                buttonRowMode.setSelection(true);
            }
            ToolItem buttonColumnMode = new ToolItem(toolBar, 16);
            if (layoutStyle == 512) {
                buttonColumnMode.setSelection(true);
            }
            ToolItem buttonRowCompactMode = new ToolItem(toolBar, 16);
            if (layoutStyle == 260) {
                buttonRowCompactMode.setSelection(true);
            }
            ImageLoader.getInstance().setToolItemImage(buttonRowMode, "row_mode");
            buttonRowMode.addListener(13, event2 -> this.tagButtonsUI.setLayoutStyle(256));
            ImageLoader.getInstance().setToolItemImage(buttonColumnMode, "column_mode");
            buttonColumnMode.addListener(13, event2 -> this.tagButtonsUI.setLayoutStyle(512));
            ImageLoader.getInstance().setToolItemImage(buttonRowCompactMode, "row_compact_mode");
            buttonRowCompactMode.addListener(13, event2 -> this.tagButtonsUI.setLayoutStyle(260));
        }
        this.sc = new ScrolledComposite(this.mainComposite, 512);
        GridData gd = new GridData(4, 4, true, true);
        this.sc.setLayoutData((Object)gd);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.sc.getVerticalBar().setIncrement(16);
        final Composite cTagComposite = new Composite((Composite)this.sc, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        cTagComposite.setLayout((Layout)layout);
        this.sc.setContent((Control)cTagComposite);
        Composite tagArea = this.tagButtonsUI.buildTagGroup(listAllTags, cTagComposite, true, new TagCanvas.TagButtonTrigger(){

            @Override
            public void tagButtonTriggered(TagPainter painter, int stateMask, boolean longPress) {
                if (TaggingView.this.taggables == null || longPress) {
                    return;
                }
                Tag tag = painter.getTag();
                boolean doTag = !painter.isSelected() || painter.isGrayed();
                try {
                    tag.addTaggableBatch(true);
                    for (Taggable taggable : TaggingView.this.taggables) {
                        if (doTag) {
                            tag.addTaggable(taggable);
                        } else {
                            tag.removeTaggable(taggable);
                        }
                        painter.setSelected(doTag);
                    }
                }
                finally {
                    tag.addTaggableBatch(false);
                }
            }

            @Override
            public Boolean tagSelectedOverride(Tag tag) {
                return null;
            }
        });
        tagArea.setLayoutData((Object)new GridData(768));
        this.sc.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = TaggingView.this.sc.getClientArea();
                Point size = cTagComposite.computeSize(r.width, -1);
                TaggingView.this.sc.setMinSize(size);
            }
        });
        this.swt_updateFields();
        Rectangle r = this.sc.getClientArea();
        Point size = cTagComposite.computeSize(r.width, -1);
        this.sc.setMinSize(size);
    }

    private String getFullTitle() {
        return MessageText.getString("label.tags");
    }

    private void swt_updateFields() {
        if (this.mainComposite == null || this.mainComposite.isDisposed()) {
            return;
        }
        if (this.tagButtonsUI != null && this.tagButtonsUI.updateFields(this.taggables)) {
            this.parent.layout();
        }
        boolean has_constraint = false;
        if (this.taggables != null) {
            List<Tag> listAllTags = this.getTags();
            for (Tag tag : listAllTags) {
                String s;
                String[] constraint;
                TagFeatureProperties tfp = (TagFeatureProperties)((Object)tag);
                TagFeatureProperties.TagProperty tfp_constraint = tfp.getProperty("constraint");
                if (tfp_constraint == null || (constraint = tfp_constraint.getStringList()) == null || constraint.length <= 0 || (s = constraint[0]).length() <= 0) continue;
                has_constraint = true;
                break;
            }
        }
        this.buttonCopy.setEnabled(this.taggables != null);
        this.buttonPaste.setEnabled(this.taggables != null && !copied_tag_assignment.isEmpty());
        this.buttonClear.setEnabled(this.taggables != null);
        this.buttonInvert.setEnabled(this.taggables != null);
        this.buttonExplain.setEnabled(has_constraint);
    }

    private List<Tag> getTags() {
        TagManager tm = TagManagerFactory.getTagManager();
        int[] tagTypesWanted = new int[]{3, 1};
        ArrayList<Tag> listAllTags = new ArrayList<Tag>();
        int[] nArray = tagTypesWanted;
        int n = tagTypesWanted.length;
        int n2 = 0;
        while (n2 < n) {
            int tagType = nArray[n2];
            TagType tt = tm.getTagType(tagType);
            List<Tag> tags = tt.getTags();
            if (tagType == 1) {
                for (Tag tag : tags) {
                    if (((Category)tag).getType() != 0) continue;
                    listAllTags.addAll(tags);
                    break;
                }
            } else {
                listAllTags.addAll(tags);
            }
            ++n2;
        }
        return listAllTags;
    }

    @Override
    public void tagTypeChanged(TagType tag_type) {
    }

    @Override
    public void tagEventOccurred(TagTypeListener.TagEvent event2) {
        int type = event2.getEventType();
        Tag tag = event2.getTag();
        if (type == 0) {
            this.tagAdded(tag);
        } else if (type == 1 || type == 4) {
            this.tagChanged(tag);
        } else if (type == 2) {
            this.tagRemoved(tag);
        }
    }

    public void tagAdded(Tag tag) {
        Utils.execSWTThread(this::rebuildComposite);
    }

    public void tagChanged(Tag changedTag) {
        Utils.execSWTThread(() -> {
            if (this.tagButtonsUI == null || changedTag == null) {
                return;
            }
            if (this.tagButtonsUI.updateTag(changedTag, this.taggables) == 1) {
                this.rebuildComposite();
            }
        });
    }

    public void tagRemoved(Tag tag) {
        Utils.execSWTThread(this::rebuildComposite);
    }

    private void explain() {
        List<Tag> tags = this.getTags();
        tags = TagUtils.sortTags(tags);
        StringBuilder content = new StringBuilder(1024);
        int num_taggables = this.taggables.size();
        for (Taggable t : this.taggables) {
            content.append(String.valueOf(t.getTaggableName()) + "\n\n");
            String indent = "";
            String current_group = null;
            for (Tag tag : tags) {
                String s;
                String[] constraint;
                TagFeatureProperties tfp = (TagFeatureProperties)((Object)tag);
                TagFeatureProperties.TagProperty tfp_constraint = tfp.getProperty("constraint");
                if (tfp_constraint == null || (constraint = tfp_constraint.getStringList()) == null || constraint.length <= 0 || (s = constraint[0]).length() <= 0) continue;
                String group = tag.getGroup();
                if (group != null) {
                    indent = "        ";
                    if (current_group == null || !group.equals(current_group)) {
                        content.append("    Group: " + group + "\n");
                        current_group = group;
                    }
                } else {
                    indent = "    ";
                }
                String[] details = tfp_constraint.explainTaggable(t);
                content.append(String.valueOf(indent) + tag.getTagName(true) + " -> " + details[0] + "\n");
                content.append(String.valueOf(indent) + "    " + details[1] + "\n");
                content.append(String.valueOf(indent) + "    " + details[2] + "\n");
            }
            content.append("\n");
        }
        new TextViewerWindow(MessageText.getString("label.details"), null, content.toString(), false);
    }

    private void askForNewTag() {
        TagUIUtils.createManualTag(tags -> {
            if (this.taggables == null) {
                return;
            }
            Tag[] tagArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                Tag tag = tagArray[n2];
                for (Taggable taggable : this.taggables) {
                    tag.addTaggable(taggable);
                }
                ++n2;
            }
        });
    }
}

