/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.peermanager.piecepicker.PiecePicker;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public abstract class PieceDistributionView
implements UISWTViewCoreEventListener {
    private Composite comp;
    private Canvas pieceDistCanvas;
    protected PEPeerManager pem;
    protected boolean[] hasPieces;
    protected boolean isMe = false;
    private boolean initialized = false;
    private Image imgToPaint = null;
    protected UISWTView swtView;

    public abstract void dataSourceChanged(Object var1);

    private String getFullTitle() {
        return MessageText.getString("PiecesView.DistributionView.title");
    }

    private void initialize(Composite parent) {
        this.comp = new Composite(parent, 0);
        this.createPieceDistPanel();
        this.initialized = true;
        this.refresh();
    }

    private void createPieceDistPanel() {
        this.comp.setLayout((Layout)new FillLayout());
        this.pieceDistCanvas = new Canvas(this.comp, 262144);
        this.pieceDistCanvas.addListener(9, new Listener(){

            public void handleEvent(Event event2) {
                if (PieceDistributionView.this.pem == null || PieceDistributionView.this.pem.isDestroyed()) {
                    event2.gc.setBackground(Utils.isDarkAppearanceNative() ? PieceDistributionView.this.pieceDistCanvas.getBackground() : null);
                    event2.gc.fillRectangle(event2.x, event2.y, event2.width, event2.height);
                } else if (PieceDistributionView.this.imgToPaint != null && !PieceDistributionView.this.imgToPaint.isDisposed()) {
                    event2.gc.drawImage(PieceDistributionView.this.imgToPaint, 0, 0);
                }
            }
        });
    }

    private final void updateDistribution() {
        if (!this.initialized || this.pem == null || this.comp == null || this.pem.getPiecePicker() == null || this.pem.getDiskManager() == null || !this.comp.isVisible()) {
            return;
        }
        Rectangle rect = this.pieceDistCanvas.getBounds();
        if (rect.height <= 0 || rect.width <= 0) {
            return;
        }
        PiecePicker picker = this.pem.getPiecePicker();
        int seeds = this.pem.getNbSeeds() + (this.pem.isSeeding() ? 1 : 0);
        int connected = this.pem.getNbPeers() + seeds + (this.pem.isSeeding() ? 0 : 1);
        int upperBound = 1 + (1 << (int)Math.ceil(Math.log((double)connected + 0.0) / Math.log(2.0)));
        int minAvail = (int)picker.getMinAvailability();
        int nbPieces = picker.getNumberOfPieces();
        int[] availabilties = picker.getAvailability();
        DiskManagerPiece[] dmPieces = this.pem.getDiskManager().getPieces();
        PEPiece[] pePieces = this.pem.getPieces();
        int[] globalPiecesPerAvailability = new int[upperBound];
        int[] datasourcePiecesPerAvailability = new int[upperBound];
        boolean[] downloading = new boolean[upperBound];
        int avlPeak = 0;
        int i = 0;
        while (i < nbPieces) {
            if (availabilties[i] >= upperBound) {
                return;
            }
            int n = availabilties[i];
            int n2 = globalPiecesPerAvailability[n] + 1;
            globalPiecesPerAvailability[n] = n2;
            int newPeak = n2;
            if (avlPeak < n2) {
                avlPeak = newPeak;
            }
            if (this.isMe && dmPieces[i].isDone() || !this.isMe && this.hasPieces != null && this.hasPieces[i]) {
                int n3 = availabilties[i];
                datasourcePiecesPerAvailability[n3] = datasourcePiecesPerAvailability[n3] + 1;
            }
            if (this.isMe && pePieces[i] != null) {
                downloading[availabilties[i]] = true;
            }
            ++i;
        }
        Image img = new Image((Device)this.comp.getDisplay(), this.pieceDistCanvas.getBounds());
        GC gc = new GC((Drawable)img);
        if (Utils.isDarkAppearanceNative()) {
            gc.setBackground(this.pieceDistCanvas.getBackground());
            gc.fillRectangle(img.getBounds());
        }
        try {
            int stepWidthX = rect.width / upperBound;
            int barGap = 1;
            int barWidth = stepWidthX - barGap - 1;
            int barFillingWidth = barWidth - 1;
            double stepWidthY = 1.0 * (double)(rect.height - 1) / (double)avlPeak;
            int offsetY = rect.height;
            Color rarestColor = Utils.isDarkAppearanceNative() ? Colors.yellow : Colors.blue;
            gc.setForeground(Colors.green);
            int i2 = 0;
            while (i2 <= connected) {
                Color curColor = i2 == 0 ? Colors.colorError : (i2 <= seeds ? Colors.green : Colors.blues[9]);
                gc.setBackground(curColor);
                gc.setForeground(curColor);
                if (globalPiecesPerAvailability[i2] == 0) {
                    gc.setLineWidth(2);
                    gc.drawLine(stepWidthX * i2, offsetY - 1, stepWidthX * (i2 + 1) - barGap, offsetY - 1);
                } else {
                    gc.setLineWidth(1);
                    if (downloading[i2]) {
                        gc.setLineStyle(2);
                    }
                    gc.fillRectangle(stepWidthX * i2 + 1, offsetY - 1, barFillingWidth, (int)(Math.ceil(stepWidthY * (double)datasourcePiecesPerAvailability[i2] - 1.0) * -1.0));
                    gc.drawRectangle(stepWidthX * i2, offsetY, barWidth, (int)(Math.ceil(stepWidthY * (double)globalPiecesPerAvailability[i2]) + 1.0) * -1);
                }
                if (i2 == minAvail) {
                    gc.setForeground(rarestColor);
                    gc.drawRectangle(stepWidthX * i2 + 1, offsetY - 1, barWidth - 2, (int)Math.ceil(stepWidthY * (double)globalPiecesPerAvailability[i2] - 1.0) * -1);
                }
                gc.setLineStyle(1);
                ++i2;
            }
            gc.setLineWidth(1);
            String[] boxContent = new String[]{MessageText.getString("PiecesView.DistributionView.NoAvl"), MessageText.getString("PiecesView.DistributionView.SeedAvl"), MessageText.getString("PiecesView.DistributionView.PeerAvl"), MessageText.getString("PiecesView.DistributionView.RarestAvl", new String[]{String.valueOf(globalPiecesPerAvailability[minAvail]), String.valueOf(minAvail)}), MessageText.getString("PiecesView.DistributionView." + (this.isMe ? "weHave" : "theyHave")), MessageText.getString("PiecesView.DistributionView.weDownload")};
            int charHeight = gc.getFontMetrics().getHeight();
            int maxBoxOffsetY = charHeight + 2;
            int maxBoxWidth = 0;
            int maxBoxOffsetX = 0;
            int i3 = 0;
            while (i3 < boxContent.length) {
                maxBoxWidth = Math.max(maxBoxWidth, gc.stringExtent((String)boxContent[i3]).x);
                ++i3;
            }
            maxBoxOffsetX = maxBoxWidth + 20;
            int boxNum = 1;
            gc.setForeground(Colors.colorError);
            gc.setBackground(Colors.background);
            gc.drawRectangle(rect.width + maxBoxOffsetX * -1, maxBoxOffsetY * boxNum, maxBoxWidth += 10, charHeight);
            gc.drawString(boxContent[boxNum - 1], rect.width + (maxBoxOffsetX - 5) * -1, maxBoxOffsetY * boxNum, true);
            gc.setForeground(Colors.green);
            gc.setBackground(Colors.background);
            gc.drawRectangle(rect.width + maxBoxOffsetX * -1, maxBoxOffsetY * ++boxNum, maxBoxWidth, charHeight);
            gc.drawString(boxContent[boxNum - 1], rect.width + (maxBoxOffsetX - 5) * -1, maxBoxOffsetY * boxNum, true);
            gc.setForeground(Colors.blues[9]);
            gc.drawRectangle(rect.width + maxBoxOffsetX * -1, maxBoxOffsetY * ++boxNum, maxBoxWidth, charHeight);
            gc.drawString(boxContent[boxNum - 1], rect.width + (maxBoxOffsetX - 5) * -1, maxBoxOffsetY * boxNum, true);
            gc.setForeground(rarestColor);
            gc.drawRectangle(rect.width + maxBoxOffsetX * -1, maxBoxOffsetY * ++boxNum, maxBoxWidth, charHeight);
            gc.drawString(boxContent[boxNum - 1], rect.width + (maxBoxOffsetX - 5) * -1, maxBoxOffsetY * boxNum, true);
            gc.setForeground(Colors.black);
            gc.setBackground(Colors.black);
            gc.drawRectangle(rect.width + maxBoxOffsetX * -1, maxBoxOffsetY * ++boxNum, maxBoxWidth, charHeight);
            gc.fillRectangle(rect.width + maxBoxOffsetX * -1, maxBoxOffsetY * boxNum, maxBoxWidth / 2, charHeight);
            gc.setForeground(Colors.grey);
            gc.setBackground(Colors.background);
            gc.drawString(boxContent[boxNum - 1], rect.width + (maxBoxOffsetX - 5) * -1, maxBoxOffsetY * boxNum, true);
            if (this.isMe) {
                gc.setForeground(Utils.isDarkAppearanceNative() ? Colors.grey : Colors.black);
                gc.setLineStyle(2);
                gc.drawRectangle(rect.width + maxBoxOffsetX * -1, maxBoxOffsetY * ++boxNum, maxBoxWidth, charHeight);
                gc.drawString(boxContent[boxNum - 1], rect.width + (maxBoxOffsetX - 5) * -1, maxBoxOffsetY * boxNum, true);
            }
            gc.setLineStyle(1);
        }
        finally {
            gc.dispose();
        }
        if (this.imgToPaint != null) {
            this.imgToPaint.dispose();
        }
        this.imgToPaint = img;
        this.pieceDistCanvas.redraw();
    }

    public void refresh() {
        if (!this.initialized || this.pem == null) {
            return;
        }
        this.updateDistribution();
    }

    private Composite getComposite() {
        return this.comp;
    }

    private void delete() {
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        Utils.disposeSWTObjects(this.pieceDistCanvas, this.comp, this.imgToPaint);
    }

    private void viewActivated() {
        this.updateDistribution();
    }

    private void viewDeactivated() {
        Utils.disposeSWTObjects(this.imgToPaint);
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                this.viewActivated();
                break;
            }
            case 4: {
                this.viewDeactivated();
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }
}

