/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.pif.ui.UIPluginViewToolBarListener;
import com.biglybt.ui.common.ToolBarItem;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.selectedcontent.ISelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContentListener;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.DelayedListenerMultiCombiner;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BubbleTextBox;
import com.biglybt.ui.swt.mdi.MdiEntrySWT;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewBuilderCore;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.pifimpl.UISWTViewImpl;
import com.biglybt.ui.swt.views.MyTorrentsView;
import com.biglybt.ui.swt.views.skin.SB_Transfers;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.impl.TableViewSWT_TabsCommon;
import com.biglybt.ui.swt.views.table.utils.TableColumnCreator;
import com.biglybt.util.MapUtils;
import java.util.Map;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Widget;

public class MyTorrentsSuperView
implements UISWTViewCoreEventListener,
AEDiagnosticsEvidenceGenerator,
UIPluginViewToolBarListener {
    private static int SASH_WIDTH = 5;
    private static int SPLIT_MODE = 0;
    private MyTorrentsView torrentview;
    private MyTorrentsView seedingview;
    private Composite form;
    private MyTorrentsView lastSelectedView;
    private Composite child1;
    private Composite child2;
    private final BubbleTextBox filterBox;
    private final Object initialDS;
    private Object ds;
    private UISWTView swtView;
    private MyTorrentsView viewWhenDeactivated;

    static {
        COConfigurationManager.addAndFireParameterListener("Library.TorrentViewSplitMode", name -> {
            SPLIT_MODE = COConfigurationManager.getIntParameter(name);
            if (SPLIT_MODE == 4) {
                SPLIT_MODE = 0;
            }
        });
    }

    public MyTorrentsSuperView(BubbleTextBox filterBox, Object initialDS) {
        this.filterBox = filterBox;
        this.initialDS = initialDS;
        CoreFactory.addCoreRunningListener(core -> {
            boolean bl = Utils.execSWTThread(() -> {
                TableColumnManager tcManager = TableColumnManager.getInstance();
                tcManager.addColumns(this.getCompleteColumns());
                tcManager.addColumns(this.getIncompleteColumns());
            });
        });
    }

    public Composite getComposite() {
        return this.form;
    }

    public void initialize(final Composite parent, final Object dataSource) {
        if (this.form != null) {
            return;
        }
        this.form = new Composite(parent, 0);
        FormLayout flayout = new FormLayout();
        flayout.marginHeight = 0;
        flayout.marginWidth = 0;
        this.form.setLayout((Layout)flayout);
        GridData gridData = new GridData(1808);
        this.form.setLayoutData((Object)gridData);
        this.child1 = new Composite(this.form, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.child1.setLayout((Layout)layout);
        boolean split_horizontally = SPLIT_MODE == 0 || SPLIT_MODE == 2;
        final Sash sash = Utils.createSash(this.form, SASH_WIDTH, split_horizontally ? 256 : 512);
        this.child2 = new Composite(this.form, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.child2.setLayout((Layout)layout);
        int weight = (int)COConfigurationManager.getFloatParameter("MyTorrents.SplitAt");
        if (weight > 10000) {
            weight = 10000;
        } else if (weight < 100) {
            weight *= 100;
        }
        if (weight < 500) {
            weight = 500;
        } else if (weight > 9000) {
            weight = 9000;
        }
        double pct = (float)weight / 10000.0f;
        sash.setData("PCT", (Object)new Double(pct));
        if (split_horizontally) {
            FormData formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment(0, 0);
            formData.bottom = new FormAttachment((int)(pct * 100.0), 0);
            this.child1.setLayoutData((Object)formData);
            final FormData child1Data = formData;
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment((Control)this.child1);
            formData.height = SASH_WIDTH;
            sash.setLayoutData((Object)formData);
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.bottom = new FormAttachment(100, 0);
            formData.top = new FormAttachment((Control)sash);
            this.child2.setLayoutData((Object)formData);
            sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean FASTDRAG = true;
                    if (e.detail == 1) {
                        return;
                    }
                    child1Data.height = e.y + e.height - SASH_WIDTH;
                    MyTorrentsSuperView.this.form.layout();
                    Double l = new Double((double)((MyTorrentsSuperView)MyTorrentsSuperView.this).child1.getBounds().height / (double)((MyTorrentsSuperView)MyTorrentsSuperView.this).form.getBounds().height);
                    sash.setData("PCT", (Object)l);
                    if (e.detail != 1) {
                        int i = (int)(l * 10000.0);
                        COConfigurationManager.setParameter("MyTorrents.SplitAt", i);
                    }
                }
            });
            this.form.addListener(11, (Listener)new DelayedListenerMultiCombiner(){

                @Override
                public void handleDelayedEvent(Event e) {
                    if (sash.isDisposed()) {
                        return;
                    }
                    Double l = (Double)sash.getData("PCT");
                    if (l == null) {
                        return;
                    }
                    int newHeight = (int)((double)((MyTorrentsSuperView)MyTorrentsSuperView.this).form.getBounds().height * l);
                    if (child1Data.height != newHeight || child1Data.bottom != null) {
                        child1Data.bottom = null;
                        child1Data.height = newHeight;
                        MyTorrentsSuperView.this.form.layout();
                    }
                }
            });
        } else {
            FormData formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.bottom = new FormAttachment(100, 0);
            formData.top = new FormAttachment(0, 0);
            formData.right = new FormAttachment((int)(pct * 100.0), 0);
            this.child1.setLayoutData((Object)formData);
            final FormData child1Data = formData;
            formData = new FormData();
            formData.top = new FormAttachment(0, 0);
            formData.bottom = new FormAttachment(100, 0);
            formData.left = new FormAttachment((Control)this.child1);
            formData.width = SASH_WIDTH;
            sash.setLayoutData((Object)formData);
            formData = new FormData();
            formData.top = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.bottom = new FormAttachment(100, 0);
            formData.left = new FormAttachment((Control)sash);
            this.child2.setLayoutData((Object)formData);
            sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean FASTDRAG = true;
                    if (e.detail == 1) {
                        return;
                    }
                    child1Data.width = e.x + e.width - SASH_WIDTH;
                    MyTorrentsSuperView.this.form.layout();
                    Double l = new Double((double)((MyTorrentsSuperView)MyTorrentsSuperView.this).child1.getBounds().width / (double)((MyTorrentsSuperView)MyTorrentsSuperView.this).form.getBounds().width);
                    sash.setData("PCT", (Object)l);
                    if (e.detail != 1) {
                        int i = (int)(l * 10000.0);
                        COConfigurationManager.setParameter("MyTorrents.SplitAt", i);
                    }
                }
            });
            this.form.addListener(11, (Listener)new DelayedListenerMultiCombiner(){

                @Override
                public void handleDelayedEvent(Event e) {
                    if (sash.isDisposed()) {
                        return;
                    }
                    Double l = (Double)sash.getData("PCT");
                    if (l == null) {
                        return;
                    }
                    int newWidth = (int)((double)((MyTorrentsSuperView)MyTorrentsSuperView.this).form.getBounds().width * l);
                    if (child1Data.width != newWidth || child1Data.right != null) {
                        child1Data.right = null;
                        child1Data.width = newWidth;
                        MyTorrentsSuperView.this.form.layout();
                    }
                }
            });
        }
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(final Core core) {
                Utils.execSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        MyTorrentsSuperView.this.initializeWithCore(core, parent, dataSource);
                    }
                });
            }
        });
    }

    private void initializeWithCore(Core core, Composite parent, Object dataSource) {
        KeyListener keyListenerSV;
        final boolean split_horizontally = SPLIT_MODE == 0 || SPLIT_MODE == 2;
        final boolean switch_kids = SPLIT_MODE == 2 || SPLIT_MODE == 3;
        this.torrentview = this.createTorrentView(core, SB_Transfers.getTableIdFromDataSource("MyTorrents", dataSource), false, this.getIncompleteColumns(), switch_kids ? this.child2 : this.child1);
        final KeyListener keyListenerTV = this.filterBox != null ? this.filterBox.getKeyListener() : null;
        this.seedingview = this.createTorrentView(core, SB_Transfers.getTableIdFromDataSource("MySeeders", dataSource), true, this.getCompleteColumns(), switch_kids ? this.child1 : this.child2);
        KeyListener keyListener = keyListenerSV = this.filterBox != null ? this.filterBox.getKeyListener() : null;
        if (split_horizontally) {
            final MyTorrentsView topView = switch_kids ? this.seedingview : this.torrentview;
            final MyTorrentsView bottomView = switch_kids ? this.torrentview : this.seedingview;
            topView.getComposite().addListener(15, new Listener(){

                public void handleEvent(Event event2) {
                    bottomView.getTableView().getTabsCommon().setTvOverride(topView.getTableView());
                }
            });
            bottomView.getComposite().addListener(15, new Listener(){

                public void handleEvent(Event event2) {
                    bottomView.getTableView().getTabsCommon().setTvOverride(null);
                }
            });
        }
        if (this.filterBox != null) {
            this.filterBox.setKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    MyTorrentsView currentView = MyTorrentsSuperView.this.getCurrentView();
                    if (currentView == MyTorrentsSuperView.this.seedingview && keyListenerSV != null) {
                        keyListenerSV.keyPressed(e);
                    }
                    if (currentView == MyTorrentsSuperView.this.torrentview && keyListenerTV != null) {
                        keyListenerTV.keyPressed(e);
                    }
                }

                public void keyReleased(KeyEvent e) {
                    MyTorrentsView currentView = MyTorrentsSuperView.this.getCurrentView();
                    if (currentView == MyTorrentsSuperView.this.seedingview && keyListenerSV != null) {
                        keyListenerSV.keyReleased(e);
                    }
                    if (currentView == MyTorrentsSuperView.this.torrentview && keyListenerTV != null) {
                        keyListenerTV.keyReleased(e);
                    }
                }
            });
        }
        SelectedContentManager.addCurrentlySelectedContentListener(new SelectedContentListener(){

            @Override
            public void currentlySelectedContentChanged(ISelectedContent[] currentContent, String viewId) {
                if (MyTorrentsSuperView.this.form.isDisposed() || MyTorrentsSuperView.this.torrentview == null || MyTorrentsSuperView.this.seedingview == null) {
                    SelectedContentManager.removeCurrentlySelectedContentListener(this);
                    return;
                }
                TableView selected_tv = SelectedContentManager.getCurrentlySelectedTableView();
                TableViewSWT incomp_tv = MyTorrentsSuperView.this.torrentview.getTableView();
                TableViewSWT comp_tv = MyTorrentsSuperView.this.seedingview.getTableView();
                if (incomp_tv == null || comp_tv == null || selected_tv != incomp_tv && selected_tv != comp_tv) {
                    return;
                }
                TableViewSWT_TabsCommon target_tabs = split_horizontally ? (switch_kids ? incomp_tv.getTabsCommon() : comp_tv.getTabsCommon()) : ((TableViewSWT)selected_tv).getTabsCommon();
                if (target_tabs == null) {
                    return;
                }
                if (selected_tv.getSelectedRowsSize() == 0) {
                    MyTorrentsView currentView = MyTorrentsSuperView.this.getCurrentView();
                    if (currentView == MyTorrentsSuperView.this.torrentview) {
                        MyTorrentsSuperView.this.seedingview.getTableView().requestFocus(1);
                    } else {
                        MyTorrentsSuperView.this.torrentview.getTableView().requestFocus(1);
                    }
                }
                Utils.execSWTThread(() -> {
                    TableView selectedTV = SelectedContentManager.getCurrentlySelectedTableView();
                    if (selectedTV == null) {
                        return;
                    }
                    target_tabs.triggerTabViewsDataSourceChanged(selectedTV);
                });
            }
        });
        this.initializeDone();
    }

    public void initializeDone() {
    }

    public void updateLanguage() {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        if (this.seedingview != null) {
            this.seedingview.updateLanguage();
        }
        if (this.torrentview != null) {
            this.torrentview.updateLanguage();
        }
    }

    public String getFullTitle() {
        return MessageText.getString("MyTorrentsView.mytorrents");
    }

    private MyTorrentsView getCurrentView() {
        try {
            if (this.torrentview != null && this.torrentview.getTableView().isTableSelected()) {
                this.lastSelectedView = this.torrentview;
            } else if (this.seedingview != null && this.seedingview.getTableView().isTableSelected()) {
                this.lastSelectedView = this.seedingview;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.lastSelectedView;
    }

    private UIPluginViewToolBarListener getActiveToolbarListener() {
        MyTorrentsView[] viewsToCheck = new MyTorrentsView[]{this.getCurrentView(), this.torrentview, this.seedingview};
        int i = 0;
        while (i < viewsToCheck.length) {
            MyTorrentsView view = viewsToCheck[i];
            if (view != null) {
                UIPluginViewToolBarListener toolBarListener;
                MdiEntrySWT activeSubView = view.getTableView().getTabsCommon().getActiveSubView();
                if (activeSubView != null && (toolBarListener = activeSubView.getToolBarListener()) != null && toolBarListener.isActive()) {
                    return toolBarListener;
                }
                if (i == 0 && view.isTableFocus()) {
                    return view;
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        UIPluginViewToolBarListener currentView = this.getActiveToolbarListener();
        if (currentView != null) {
            currentView.refreshToolBarItems(list);
        }
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        UIPluginViewToolBarListener currentView = this.getActiveToolbarListener();
        if (currentView != null && currentView.toolBarItemActivated(item, activationType, datasource)) {
            return true;
        }
        MyTorrentsView currentView2 = this.getCurrentView();
        return currentView2 != currentView && currentView2 != null && currentView2.toolBarItemActivated(item, activationType, datasource);
    }

    public DownloadManager[] getSelectedDownloads() {
        MyTorrentsView currentView = this.getCurrentView();
        if (currentView == null) {
            return null;
        }
        return currentView.getSelectedDownloads();
    }

    @Override
    public void generate(IndentWriter writer) {
        try {
            writer.indent();
            writer.println("Downloading");
            writer.indent();
            this.torrentview.generate(writer);
        }
        finally {
            writer.exdent();
            writer.exdent();
        }
        try {
            writer.indent();
            writer.println("Seeding");
            writer.indent();
            this.seedingview.generate(writer);
        }
        finally {
            writer.exdent();
            writer.exdent();
        }
    }

    private Image obfuscatedImage(Image image) {
        if (this.torrentview != null) {
            this.torrentview.obfuscatedImage(image);
        }
        if (this.seedingview != null) {
            this.seedingview.obfuscatedImage(image);
        }
        return image;
    }

    public Menu getPrivateMenu() {
        return null;
    }

    public void viewActivated() {
        SelectedContentManager.clearCurrentlySelectedContent();
        if (this.viewWhenDeactivated != null) {
            this.viewWhenDeactivated.getComposite().setFocus();
            this.viewWhenDeactivated.updateSelectedContent(true);
        } else {
            MyTorrentsView currentView = this.getCurrentView();
            if (currentView != null) {
                currentView.updateSelectedContent();
            }
        }
    }

    public void viewDeactivated() {
        this.viewWhenDeactivated = this.getCurrentView();
    }

    protected TableColumnCore[] getIncompleteColumns() {
        return TableColumnCreator.createIncompleteDM(SB_Transfers.getTableIdFromDataSource("MyTorrents", this.initialDS));
    }

    protected TableColumnCore[] getCompleteColumns() {
        return TableColumnCreator.createCompleteDM(SB_Transfers.getTableIdFromDataSource("MySeeders", this.initialDS));
    }

    protected MyTorrentsView createTorrentView(Core _core, String tableID, boolean isSeedingView, TableColumnCore[] columns, Composite c) {
        boolean switch_kids;
        boolean split_horizontally = SPLIT_MODE == 0 || SPLIT_MODE == 2;
        boolean bl = switch_kids = SPLIT_MODE == 2 || SPLIT_MODE == 3;
        boolean support_tabs = split_horizontally ? (switch_kids ? !isSeedingView : isSeedingView) : true;
        MyTorrentsView view = new MyTorrentsView(_core, tableID, isSeedingView, columns, this.filterBox, support_tabs);
        try {
            UISWTViewBuilderCore builder = new UISWTViewBuilderCore(tableID, null, view).setInitialDatasource(this.ds);
            UISWTViewImpl swtView = new UISWTViewImpl(builder, true);
            swtView.setDestroyOnDeactivate(false);
            swtView.setDelayInitializeToFirstActivate(false);
            swtView.initialize(c);
        }
        catch (Exception e) {
            Debug.out(e);
        }
        c.layout();
        return view;
    }

    public MyTorrentsView getTorrentview() {
        return this.torrentview;
    }

    public MyTorrentsView getSeedingview() {
        return this.seedingview;
    }

    public void dataSourceChanged(Object newDataSource) {
        this.ds = newDataSource;
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setToolBarListener(this);
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData(), event2.getView().getInitialDataSource());
                return true;
            }
            case 6: {
                this.swtView.setTitle(this.getFullTitle());
                Messages.updateLanguageForControl((Widget)this.getComposite());
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 5: {
                break;
            }
            case 9: {
                Object data = event2.getData();
                if (!(data instanceof Map)) break;
                this.obfuscatedImage((Image)MapUtils.getMapObject((Map)data, "image", null, Image.class));
            }
        }
        if (this.seedingview != null) {
            try {
                this.seedingview.getSWTView().triggerEvent(event2.getType(), event2.getData());
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        if (this.torrentview != null) {
            try {
                this.torrentview.getSWTView().triggerEvent(event2.getType(), event2.getData());
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        switch (event2.getType()) {
            case 3: {
                this.viewActivated();
                break;
            }
            case 4: {
                this.viewDeactivated();
            }
        }
        return true;
    }

    public UISWTView getSWTView() {
        return this.swtView;
    }
}

