/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import com.biglybt.ui.swt.pifimpl.UISWTViewBuilderCore;
import com.biglybt.ui.swt.pifimpl.UISWTViewImpl;
import com.biglybt.ui.swt.shells.PopOutManager;
import com.biglybt.ui.swt.views.ConfigView;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ConfigShell {
    private static ConfigShell instance;
    private Shell shell;
    private UISWTViewImpl swtView;

    public static ConfigShell getInstance() {
        if (instance == null) {
            instance = new ConfigShell();
        }
        return instance;
    }

    private ConfigShell() {
    }

    public void open(final String section) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                ConfigShell.this.swt_open(section);
            }
        });
    }

    public void swt_open(String section) {
        if (this.shell != null && !this.shell.isDisposed()) {
            if (this.swtView != null) {
                this.swtView.setDatasource(section);
            }
            if (this.shell.getMinimized()) {
                this.shell.setMinimized(false);
            }
            this.shell.forceActive();
            this.shell.forceFocus();
        } else {
            this.shell = ShellFactory.createMainShell(1136);
            this.shell.setLayout((Layout)new GridLayout());
            this.shell.setText(MessageText.getString("ConfigView.title.full"));
            Utils.setShellIcon(this.shell);
            try {
                UISWTViewBuilderCore builder = new UISWTViewBuilderCore("ConfigView", null, ConfigView.class).setInitialDatasource(section);
                this.swtView = new UISWTViewImpl(builder, true);
                this.swtView.setDestroyOnDeactivate(false);
                this.swtView.initialize((Composite)this.shell);
            }
            catch (Exception e1) {
                Debug.out(e1);
            }
            if (COConfigurationManager.getStringParameter("options.rectangle", null) == null) {
                Rectangle shellBounds = this.shell.getMonitor().getBounds();
                Point size = new Point(shellBounds.width * 10 / 11, shellBounds.height * 10 / 11);
                if (size.x > 1400) {
                    size.x = 1400;
                }
                if (size.y > 700) {
                    size.y = 700;
                }
                this.shell.setSize(size);
                Utils.centerWindowRelativeTo(this.shell, (Control)Utils.findAnyShell(true));
            }
            Utils.linkShellMetricsToConfig(this.shell, "options");
            this.shell.addTraverseListener(e -> {
                if (e.detail == 2) {
                    this.shell.dispose();
                }
            });
            this.shell.addDisposeListener(arg0 -> this.close());
            PopOutManager.registerSideBarSection(this.shell, "ConfigView");
            this.shell.open();
        }
    }

    private void close() {
        if (this.swtView != null) {
            this.swtView.triggerEvent(7, null);
            this.swtView = null;
        }
        this.shell = null;
    }
}

