/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.utils;

import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class TooltipShell
implements Listener {
    Shell toolTipShell = null;
    Shell mainShell = null;
    CLabel toolTipLabel = null;
    private final Composite composite;
    private final TooltipProvider ttp;

    public TooltipShell(TooltipProvider ttp, Composite composite) {
        this.ttp = ttp;
        this.composite = composite;
        this.mainShell = composite.getShell();
        composite.addListener(12, (Listener)this);
        composite.addListener(1, (Listener)this);
        composite.addListener(5, (Listener)this);
        composite.addListener(32, (Listener)this);
        composite.addListener(7, (Listener)this);
        this.mainShell.addListener(27, (Listener)this);
    }

    public void handleEvent(Event event2) {
        switch (event2.type) {
            case 32: {
                Rectangle displayRect;
                if (this.toolTipShell != null && !this.toolTipShell.isDisposed()) {
                    this.toolTipShell.dispose();
                }
                if (!Utils.getTTEnabled()) {
                    return;
                }
                String tt = this.ttp.getTooltip(new Point(event2.x, event2.y));
                if (tt == null) {
                    return;
                }
                Display d = this.composite.getDisplay();
                if (d == null) {
                    return;
                }
                this.toolTipShell = new Shell(this.composite.getShell(), 16384);
                FillLayout f = new FillLayout();
                try {
                    f.marginWidth = 3;
                    f.marginHeight = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                this.toolTipShell.setLayout((Layout)f);
                this.toolTipShell.setBackground(Colors.getSystemColor((Device)d, 29));
                Point size = new Point(0, 0);
                this.toolTipLabel = new CLabel((Composite)this.toolTipShell, 64);
                this.toolTipLabel.setForeground(Colors.getSystemColor((Device)d, 28));
                this.toolTipLabel.setBackground(Colors.getSystemColor((Device)d, 29));
                this.toolTipLabel.setText(tt.replaceAll("&", "&&"));
                size = this.toolTipLabel.computeSize(-1, -1);
                if (size.x > 600) {
                    size = this.toolTipLabel.computeSize(600, -1, true);
                }
                size.x += this.toolTipShell.getBorderWidth() * 2 + 2;
                size.y += this.toolTipShell.getBorderWidth() * 2;
                try {
                    size.x += this.toolTipShell.getBorderWidth() * 2 + f.marginWidth * 2;
                    size.y += this.toolTipShell.getBorderWidth() * 2 + f.marginHeight * 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                Point pt = this.composite.toDisplay(event2.x, event2.y);
                try {
                    displayRect = this.composite.getMonitor().getClientArea();
                }
                catch (NoSuchMethodError e) {
                    displayRect = this.composite.getDisplay().getClientArea();
                }
                if (pt.x + size.x > displayRect.x + displayRect.width) {
                    pt.x = displayRect.x + displayRect.width - size.x;
                }
                pt.y = pt.y + size.y > displayRect.y + displayRect.height ? (pt.y -= size.y + 2) : (pt.y += 21);
                if (pt.y < displayRect.y) {
                    pt.y = displayRect.y;
                }
                this.toolTipShell.setBounds(pt.x, pt.y, size.x, size.y);
                this.toolTipShell.setVisible(true);
                break;
            }
            case 12: {
                if (this.mainShell != null && !this.mainShell.isDisposed()) {
                    this.mainShell.removeListener(27, (Listener)this);
                }
            }
            default: {
                if (this.toolTipShell == null) break;
                this.toolTipShell.dispose();
                this.toolTipShell = null;
                this.toolTipLabel = null;
            }
        }
    }

    public static interface TooltipProvider {
        public String getTooltip(Point var1);
    }
}

