/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.utils;

import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.Utils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class FontUtils {
    private static final String[] MONO_FONT_NAMES = new String[]{"Monaco", "Consolas", "Lucida Console", "Courier", "Courier New", "Monospace"};
    private static Method mFontData_SetHeight;
    private static Method mFontData_GetHeightF;
    private static Font fontBold;
    private static Font fontItalic;
    private static Font fontBoldItalic;
    private static Map<String, Object[]> fontCache;

    static {
        try {
            mFontData_SetHeight = FontData.class.getDeclaredMethod("setHeight", Float.TYPE);
            mFontData_SetHeight.setAccessible(true);
        }
        catch (Throwable e) {
            mFontData_SetHeight = null;
        }
        try {
            mFontData_GetHeightF = FontData.class.getDeclaredMethod("getHeightF", new Class[0]);
            mFontData_GetHeightF.setAccessible(true);
        }
        catch (Throwable e) {
            mFontData_GetHeightF = null;
        }
        fontCache = new HashMap<String, Object[]>();
    }

    public static Font cache(Font f) {
        String key = FontUtils.getKey(f);
        Object[] existing = fontCache.get(key);
        if (existing == null) {
            fontCache.put(key, new Object[]{f, 0});
            return f;
        }
        existing[1] = (Integer)existing[1] + 1;
        f.dispose();
        return (Font)existing[0];
    }

    public static void uncache(Font ... fonts) {
        Font[] fontArray = fonts;
        int n = fonts.length;
        int n2 = 0;
        while (n2 < n) {
            Font f = fontArray[n2];
            String key = FontUtils.getKey(f);
            Object[] existing = fontCache.get(key);
            if (existing == null) {
                Debug.out("font not cached");
            } else {
                int count = (Integer)existing[1];
                if (count > 0) {
                    existing[1] = count;
                } else {
                    fontCache.remove(key);
                    ((Font)existing[0]).dispose();
                }
            }
            ++n2;
        }
    }

    private static String getKey(Font f) {
        FontData[] ds = f.getFontData();
        StringBuilder key = new StringBuilder(32);
        FontData[] fontDataArray = ds;
        int n = ds.length;
        int n2 = 0;
        while (n2 < n) {
            FontData d = fontDataArray[n2];
            key.append(d.getName());
            key.append("/");
            key.append(d.getStyle());
            key.append("/");
            key.append(FontUtils.getHeight(d));
            ++n2;
        }
        return key.toString();
    }

    public static Font getFontWithHeight(Font baseFont, int heightInPixels, int style) {
        return FontUtils.getFontWithHeight(baseFont, heightInPixels, style, true);
    }

    private static Font getFontWithHeight(Font baseFont, int heightInPixels, int style, boolean runAgain) {
        boolean destroyBaseFont;
        boolean bl = destroyBaseFont = style != -1;
        if (destroyBaseFont) {
            baseFont = FontUtils.getFontWithStyle(baseFont, style, 1.0f);
        }
        int fontHeightPX = FontUtils.getFontHeightInPX(baseFont);
        float pct = (float)heightInPixels / (float)fontHeightPX;
        Font font = FontUtils.getFontPercentOf(baseFont, pct);
        if (destroyBaseFont) {
            baseFont.dispose();
        }
        if (runAgain) {
            Font font2 = FontUtils.getFontWithHeight(font, heightInPixels, style, false);
            font.dispose();
            return font2;
        }
        return font;
    }

    @Deprecated
    public static Font getFontWithHeight(Font baseFont, GC gc, int heightInPixels, int style) {
        return FontUtils.getFontWithHeight(baseFont, heightInPixels, style);
    }

    public static void setFontDataHeight(FontData[] fd, float fontSize) {
        if (mFontData_SetHeight != null) {
            try {
                mFontData_SetHeight.invoke((Object)fd[0], Float.valueOf(fontSize));
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        fd[0].setHeight((int)fontSize);
    }

    public static int getFontHeightInPX(FontData[] fd) {
        Font font = new Font((Device)Display.getDefault(), fd);
        try {
            int n = FontUtils.getFontHeightInPX(font);
            return n;
        }
        finally {
            font.dispose();
        }
    }

    public static int getFontHeightInPX(Font font) {
        GC gc = new GC((Drawable)font.getDevice());
        try {
            gc.setFont(font);
            gc.setTextAntialias(1);
            int n = gc.textExtent((String)"(/|,jI~`gy").y;
            return n;
        }
        finally {
            gc.dispose();
        }
    }

    public static void setFontHeight(Control control, int height, int style) {
        FontData[] fDatas;
        FontData[] fontDataArray = fDatas = control.getFont().getFontData();
        int n = fDatas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fData = fontDataArray[n2];
            fData.height = height;
            fData.setStyle(style);
            ++n2;
        }
        final Font newFont = new Font((Device)control.getDisplay(), fDatas);
        control.setFont(newFont);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!newFont.isDisposed()) {
                    newFont.dispose();
                }
            }
        });
    }

    public static float getHeight(FontData[] fd) {
        return FontUtils.getHeight(fd[0]);
    }

    public static float getHeight(FontData fd) {
        if (mFontData_GetHeightF != null) {
            try {
                return ((Number)mFontData_GetHeightF.invoke((Object)fd, new Object[0])).floatValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return fd.getHeight();
    }

    public static Font getFontWithStyle(Font baseFont, int style, float sizeByPct) {
        FontData[] fontData;
        FontData[] fontDataArray = fontData = baseFont.getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fd.setStyle(style);
            ++n2;
        }
        if (sizeByPct != 1.0f) {
            float height = FontUtils.getHeight(fontData) * sizeByPct;
            FontUtils.setFontDataHeight(fontData, height);
        }
        return new Font(baseFont.getDevice(), fontData);
    }

    public static Font getFontPercentOf(Font baseFont, float pct) {
        FontData[] fontData = baseFont.getFontData();
        float height = FontUtils.getHeight(fontData) * pct;
        FontUtils.setFontDataHeight(fontData, height);
        return new Font(baseFont.getDevice(), fontData);
    }

    public static Font getAnyFontBold(GC gc) {
        if (fontBold == null || fontBold.isDisposed()) {
            FontData[] fontData;
            FontData[] fontDataArray = fontData = gc.getFont().getFontData();
            int n = fontData.length;
            int n2 = 0;
            while (n2 < n) {
                FontData fd = fontDataArray[n2];
                fd.setStyle(1);
                ++n2;
            }
            fontBold = new Font(gc.getDevice(), fontData);
        }
        return fontBold;
    }

    public static Font getAnyFontItalic(GC gc) {
        if (fontItalic == null || fontItalic.isDisposed()) {
            FontData[] fontData;
            FontData[] fontDataArray = fontData = gc.getFont().getFontData();
            int n = fontData.length;
            int n2 = 0;
            while (n2 < n) {
                FontData fd = fontDataArray[n2];
                fd.setStyle(2);
                ++n2;
            }
            fontItalic = new Font(gc.getDevice(), fontData);
        }
        return fontItalic;
    }

    public static Font getAnyFontBoldItalic(GC gc) {
        if (fontBoldItalic == null || fontBoldItalic.isDisposed()) {
            FontData[] fontData;
            FontData[] fontDataArray = fontData = gc.getFont().getFontData();
            int n = fontData.length;
            int n2 = 0;
            while (n2 < n) {
                FontData fd = fontDataArray[n2];
                fd.setStyle(3);
                ++n2;
            }
            fontBoldItalic = new Font(gc.getDevice(), fontData);
        }
        return fontBoldItalic;
    }

    public static void dispose() {
        if (fontBold != null) {
            fontBold.dispose();
            fontBold = null;
        }
        if (fontItalic != null) {
            fontItalic.dispose();
            fontItalic = null;
        }
        if (fontBoldItalic != null) {
            fontBoldItalic.dispose();
            fontBoldItalic = null;
        }
    }

    public static void fontToWidgetHeight(Text text) {
        FontUtils.fontToWidgetHeight(text, null);
    }

    public static void fontToWidgetHeight(Text text, final Runnable runOnFontSizeChange) {
        text.addListener(11, new Listener(){
            Font lastFont = null;
            int lastHeight = -1;

            public void handleEvent(Event event2) {
                Text text = (Text)event2.widget;
                if (text == null) {
                    return;
                }
                int lineHeightPX = FontUtils.getFontHeightInPX(text.getFont());
                int h = text.getClientArea().height - text.getBorderWidth() * 2;
                if (h <= 4) {
                    return;
                }
                if (h > 10 && (Utils.isGTK3 || Constants.isOSX && Utils.isDarkAppearanceNative())) {
                    h -= 6;
                }
                if (h == this.lastHeight) {
                    return;
                }
                float pctAdjust = (float)h / (float)lineHeightPX;
                this.lastHeight = h;
                Font font = FontUtils.getFontPercentOf(text.getFont(), pctAdjust);
                font = FontUtils.cache(FontUtils.ensureFontFitsHeight(font, h));
                text.setFont(font);
                if (this.lastFont == null) {
                    text.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            Text text = (Text)e.widget;
                            if (text != null) {
                                text.setFont(null);
                            }
                            FontUtils.uncache(lastFont);
                            lastFont = null;
                        }
                    });
                } else {
                    FontUtils.uncache(this.lastFont);
                }
                if (runOnFontSizeChange != null) {
                    try {
                        runOnFontSizeChange.run();
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                this.lastFont = font;
            }
        });
    }

    private static Font ensureFontFitsHeight(Font font, int pxMaxHeight) {
        int newPX;
        int px = FontUtils.getFontHeightInPX(font);
        if (px <= pxMaxHeight) {
            return font;
        }
        Device device = font.getDevice();
        FontData[] fontData = font.getFontData();
        float height = FontUtils.getHeight(fontData);
        do {
            if ((height = (float)((double)height - 0.25)) < 4.0f) {
                return font;
            }
            FontUtils.setFontDataHeight(fontData, height);
        } while ((newPX = FontUtils.getFontHeightInPX(font = new Font(device, fontData))) > pxMaxHeight);
        return font;
    }

    public static double getCharacterWidth(Font f) {
        double d;
        GC gc = new GC((Drawable)f.getDevice());
        gc.setFont(f);
        gc.setTextAntialias(1);
        FontMetrics metrics = gc.getFontMetrics();
        try {
            d = metrics.getAverageCharacterWidth();
        }
        catch (Throwable t) {
            d = metrics.getAverageCharWidth();
        }
        gc.dispose();
        return d;
    }

    public static Font getMonospaceFont(Device device, int heightInPoints) {
        Font fontMonospace = null;
        String[] stringArray = MONO_FONT_NAMES;
        int n = MONO_FONT_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            int w2;
            int w1;
            String tryName = stringArray[n2];
            fontMonospace = new Font(device, tryName, heightInPoints, 0);
            FontData[] fontData = fontMonospace.getFontData();
            if (fontData.length > 0 && (w1 = FontUtils.getTextWidth(device, fontMonospace, "i")) == (w2 = FontUtils.getTextWidth(device, fontMonospace, "w"))) break;
            fontMonospace.dispose();
            fontMonospace = null;
            ++n2;
        }
        return fontMonospace;
    }

    public static int getTextWidth(Device device, Font font, String text) {
        int width = 0;
        try {
            GC gc = new GC((Drawable)device);
            gc.setFont(font);
            gc.setTextAntialias(1);
            width = gc.textExtent((String)text).x;
            gc.dispose();
        }
        catch (Exception ex) {
            width = text.length() * 5;
        }
        return width;
    }

    public static void setBold(Control control) {
        Font existing = control.getFont();
        if (existing == null) {
            Debug.out("no existing font");
            return;
        }
        Font f = FontUtils.cache(FontUtils.getFontWithStyle(existing, 1, 1.0f));
        control.setFont(f);
        control.addListener(12, ev -> FontUtils.uncache(f));
    }
}

