/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.update;

import com.biglybt.core.util.AEThread;
import com.biglybt.pif.update.Update;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloader;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderException;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class UpdateAutoDownloader
implements ResourceDownloaderListener {
    private final Update[] updates;
    private ArrayList downloaders;
    private Iterator iterDownloaders;
    private final cbCompletion completionCallback;

    public UpdateAutoDownloader(Update[] updates, cbCompletion completionCallback) {
        this.updates = updates;
        this.completionCallback = completionCallback;
        this.downloaders = new ArrayList();
        this.start();
    }

    private void start() {
        int i = 0;
        while (i < this.updates.length) {
            Update update = this.updates[i];
            ResourceDownloader[] rds = update.getDownloaders();
            Collections.addAll(this.downloaders, rds);
            ++i;
        }
        this.iterDownloaders = this.downloaders.iterator();
        this.nextUpdate();
    }

    private boolean nextUpdate() {
        if (this.iterDownloaders.hasNext()) {
            ResourceDownloader downloader = (ResourceDownloader)this.iterDownloaders.next();
            downloader.addListener(this);
            downloader.asyncDownload();
            return true;
        }
        return false;
    }

    private void allDownloadsComplete() {
        boolean bRequiresRestart = false;
        boolean bHadMandatoryUpdates = false;
        int i = 0;
        while (i < this.updates.length) {
            Update update = this.updates[i];
            if (update.getDownloaders().length > 0) {
                if (update.getRestartRequired() != 1) {
                    bRequiresRestart = true;
                }
                if (update.isMandatory()) {
                    bHadMandatoryUpdates = true;
                }
            }
            ++i;
        }
        this.completionCallback.allUpdatesComplete(bRequiresRestart, bHadMandatoryUpdates);
    }

    @Override
    public boolean completed(ResourceDownloader downloader, InputStream data) {
        downloader.removeListener(this);
        if (!this.nextUpdate()) {
            AEThread thread = new AEThread("AllDownloadsComplete", true){

                @Override
                public void runSupport() {
                    UpdateAutoDownloader.this.allDownloadsComplete();
                }
            };
            thread.start();
        }
        return true;
    }

    @Override
    public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
        downloader.removeListener(this);
        this.iterDownloaders.remove();
        this.nextUpdate();
    }

    @Override
    public void reportActivity(ResourceDownloader downloader, String activity) {
    }

    @Override
    public void reportAmountComplete(ResourceDownloader downloader, long amount) {
    }

    @Override
    public void reportPercentComplete(ResourceDownloader downloader, int percentage) {
    }

    public static interface cbCompletion {
        public void allUpdatesComplete(boolean var1, boolean var2);
    }
}

