/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.twistie;

import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.twistie.ITwistieConstants;
import com.biglybt.ui.swt.twistie.ITwistieListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TwistieLabel
extends Composite
implements ITwistieConstants {
    private int style = 2;
    static final int[] points_for_expanded;
    static final int[] points_for_collapsed;
    private Label titleLabel = null;
    private Color twistieColor = null;
    private boolean isCollapsed = true;
    private Label descriptionLabel = null;
    private List listeners = new ArrayList();

    static {
        int[] nArray = new int[6];
        nArray[1] = 2;
        nArray[2] = 8;
        nArray[3] = 2;
        nArray[4] = 4;
        nArray[5] = 6;
        points_for_expanded = nArray;
        points_for_collapsed = new int[]{2, -1, 2, 8, 6, 4};
    }

    public TwistieLabel(Composite parent, int style) {
        super(parent, 0);
        GridData labelData;
        this.style = style;
        GridLayout gLayout = new GridLayout();
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        gLayout.verticalSpacing = 0;
        gLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gLayout);
        this.titleLabel = new Label((Composite)this, 0);
        if ((this.style & 8) != 0) {
            Label separator = new Label((Composite)this, 258);
            GridData labelData2 = new GridData(4, 0x1000000, true, false);
            labelData2.horizontalIndent = 10;
            separator.setLayoutData((Object)labelData2);
        }
        if ((this.style & 4) != 0) {
            this.descriptionLabel = new Label((Composite)this, 64);
            labelData = new GridData(4, 4, true, false);
            labelData.horizontalIndent = 10;
            this.descriptionLabel.setLayoutData((Object)labelData);
            Font initialFont = this.descriptionLabel.getFont();
            FontData[] fontData = initialFont.getFontData();
            int i = 0;
            while (i < fontData.length) {
                fontData[i].setStyle(fontData[i].getStyle() | 2);
                ++i;
            }
            this.descriptionLabel.setFont(new Font((Device)this.getDisplay(), fontData));
        }
        if ((this.style & 0x10) != 0) {
            this.isCollapsed = false;
        }
        labelData = new GridData(4, 0x1000000, true, false);
        labelData.horizontalIndent = 10;
        this.titleLabel.setLayoutData((Object)labelData);
        MouseInterceptor interceptor = new MouseInterceptor();
        super.addMouseListener((MouseListener)interceptor);
        this.titleLabel.addMouseListener((MouseListener)interceptor);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int offsetX = ((TwistieLabel)TwistieLabel.this).titleLabel.getBounds().x - 10;
                int offsetY = ((TwistieLabel)TwistieLabel.this).titleLabel.getBounds().y + 3;
                if (TwistieLabel.this.twistieColor != null) {
                    e.gc.setBackground(TwistieLabel.this.twistieColor);
                } else {
                    e.gc.setBackground(TwistieLabel.this.getForeground());
                }
                if (TwistieLabel.this.isCollapsed) {
                    e.gc.fillPolygon(TwistieLabel.this.translate(points_for_collapsed, offsetX, offsetY));
                } else {
                    e.gc.fillPolygon(TwistieLabel.this.translate(points_for_expanded, offsetX, offsetY));
                }
            }
        });
    }

    private int[] translate(int[] data, int x, int y) {
        int[] target = new int[data.length];
        int i = 0;
        while (i < data.length) {
            target[i] = data[i] + x;
            i += 2;
        }
        i = 1;
        while (i < data.length) {
            target[i] = data[i] + y;
            i += 2;
        }
        return target;
    }

    public void addMouseListener(MouseListener listener) {
        if (this.titleLabel != null) {
            this.titleLabel.addMouseListener(listener);
        }
        super.addMouseListener(listener);
    }

    public void removeMouseListener(MouseListener listener) {
        if (this.titleLabel != null) {
            this.titleLabel.removeMouseListener(listener);
        }
        super.removeMouseListener(listener);
    }

    public void setTwistieForeground(Color color) {
        this.twistieColor = color;
    }

    public void setForeground(Color color) {
        if (this.titleLabel != null && !this.titleLabel.isDisposed()) {
            this.titleLabel.setForeground(color);
        }
        if (this.descriptionLabel != null && !this.descriptionLabel.isDisposed()) {
            this.descriptionLabel.setForeground(color);
        }
        if (this.twistieColor == null) {
            this.twistieColor = color;
        }
        super.setForeground(color);
    }

    public void setBackground(Color color) {
        if (this.titleLabel != null) {
            this.titleLabel.setBackground(color);
        }
        if (this.descriptionLabel != null) {
            this.descriptionLabel.setBackground(color);
        }
        super.setBackground(color);
    }

    public void setTitle(String string) {
        if (this.titleLabel != null) {
            this.titleLabel.setText(string);
        }
    }

    public void setDescription(String string) {
        if (this.descriptionLabel != null) {
            this.descriptionLabel.setText(string);
        }
    }

    public void setToolTipText(String string) {
        if (this.titleLabel != null) {
            Utils.setTT((Control)this.titleLabel, string);
        }
        if (this.descriptionLabel != null) {
            Utils.setTT((Control)this.descriptionLabel, string);
        }
        if (Utils.getTTEnabled()) {
            super.setToolTipText(string);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.titleLabel != null) {
            this.titleLabel.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    public boolean isCollapsed() {
        return this.isCollapsed;
    }

    public void setCollapsed(boolean c) {
        if (c != this.isCollapsed) {
            this.isCollapsed = c;
            this.redraw();
            this.notifyTwistieListeners();
        }
    }

    public void addTwistieListener(ITwistieListener listener) {
        this.listeners.add(listener);
    }

    public void removeTwistieListener(ITwistieListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyTwistieListeners() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ITwistieListener)iterator.next()).isCollapsed(this.isCollapsed());
        }
    }

    private class MouseInterceptor
    extends MouseAdapter {
        private MouseInterceptor() {
        }

        public void mouseDown(MouseEvent e) {
            TwistieLabel.this.isCollapsed = !TwistieLabel.this.isCollapsed;
            TwistieLabel.this.redraw();
            TwistieLabel.this.notifyTwistieListeners();
        }
    }
}

