/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.speedtest;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.networkmanager.admin.NetworkAdminSpeedTesterResult;
import com.biglybt.core.speedmanager.LimitToTextHelper;
import com.biglybt.core.speedmanager.SpeedManager;
import com.biglybt.core.speedmanager.SpeedManagerLimitEstimate;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.speedtest.SpeedTestData;
import com.biglybt.ui.swt.speedtest.SpeedTestFinishPanel;
import com.biglybt.ui.swt.wizard.AbstractWizardPanel;
import com.biglybt.ui.swt.wizard.IWizardPanel;
import com.biglybt.ui.swt.wizard.Wizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SpeedTestSetLimitPanel
extends AbstractWizardPanel {
    private int measuredUploadKbps;
    private int measuredDownloadKbps;
    private boolean downloadTestRan;
    private boolean uploadTestRan = true;
    private boolean downloadHitLimit;
    private boolean uploadHitLimit;
    private Button apply;
    private Combo downConfLevelCombo;
    private Combo upConfLevelCombo;
    private SpeedManager speedManager;
    private LimitToTextHelper helper;

    public SpeedTestSetLimitPanel(Wizard wizard, IWizardPanel previousPanel, int upload, long maxup, int download, long maxdown) {
        super(wizard, previousPanel);
        int kinb = DisplayFormatters.getKinB();
        this.downloadHitLimit = (long)download > maxdown - (long)(20 * kinb);
        this.uploadHitLimit = (long)upload > maxup - (long)(20 * kinb);
        this.measuredUploadKbps = upload / kinb;
        if (this.measuredUploadKbps < 5) {
            this.uploadTestRan = false;
        }
        this.measuredDownloadKbps = download / kinb;
        if (this.measuredDownloadKbps < 5) {
            this.downloadTestRan = false;
        }
        this.speedManager = CoreFactory.getSingleton().getSpeedManager();
        this.helper = new LimitToTextHelper();
    }

    @Override
    public void show() {
        this.wizard.setTitle(MessageText.getString("SpeedTestWizard.set.upload.title"));
        this.wizard.setCurrentInfo(MessageText.getString("SpeedTestWizard.set.upload.hint"));
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(768);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 4;
        panel.setLayout((Layout)layout);
        Label explain = new Label(panel, 64);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        explain.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)explain, "SpeedTestWizard.set.upload.panel.explain");
        Label spacer = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        spacer.setLayoutData((Object)gridData);
        Label spacer1 = new Label(panel, 0);
        gridData = new GridData();
        spacer1.setLayoutData((Object)gridData);
        Label bytesCol = new Label(panel, 0);
        gridData = new GridData();
        gridData.widthHint = 80;
        bytesCol.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)bytesCol, "SpeedTestWizard.set.upload.bytes.per.sec");
        Label bitsCol = new Label(panel, 0);
        gridData = new GridData();
        gridData.widthHint = 80;
        bitsCol.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)bitsCol, "SpeedTestWizard.set.upload.bits.per.sec");
        Label confLevel = new Label(panel, 0);
        gridData = new GridData();
        gridData.widthHint = 80;
        confLevel.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)confLevel, "SpeedTestWizard.set.limit.conf.level");
        Label ul = new Label(panel, 0);
        gridData = new GridData();
        ul.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)ul, "SpeedView.stats.estupcap", DisplayFormatters.getRateUnit(1));
        final Text uploadLimitSetting = new Text(panel, 2048);
        gridData = new GridData(1);
        gridData.widthHint = 80;
        uploadLimitSetting.setLayoutData((Object)gridData);
        int uploadCapacity = this.determineRateSettingEx(this.measuredUploadKbps, this.uploadTestRan, true);
        if (uploadCapacity < 20) {
            uploadCapacity = 20;
        }
        uploadLimitSetting.setText("" + uploadCapacity);
        uploadLimitSetting.addListener(25, (Listener)new NumberListener(uploadLimitSetting));
        int kinb = DisplayFormatters.getKinB();
        Label echo = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.widthHint = 80;
        echo.setLayoutData((Object)gridData);
        echo.setText(DisplayFormatters.formatByteCountToBitsPerSec2(uploadCapacity * kinb));
        uploadLimitSetting.addListener(24, (Listener)new ByteConversionListener(echo, uploadLimitSetting));
        String[] confName = this.helper.getSettableTypes();
        final String[] confValue = this.helper.getSettableTypes();
        int uploadDropIndex = this.setDefaultConfidenceLevelEx(this.measuredUploadKbps, this.uploadTestRan, true, confValue);
        this.upConfLevelCombo = new Combo(panel, 8);
        this.addDropElements(this.upConfLevelCombo, confName);
        this.upConfLevelCombo.select(uploadDropIndex);
        Label dl = new Label(panel, 0);
        gridData = new GridData();
        dl.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)dl, "SpeedView.stats.estdowncap", DisplayFormatters.getRateUnit(1));
        final Text downloadLimitSetting = new Text(panel, 2048);
        gridData = new GridData(1);
        gridData.widthHint = 80;
        downloadLimitSetting.setLayoutData((Object)gridData);
        int bestDownloadSetting = this.determineRateSettingEx(this.measuredDownloadKbps, this.downloadTestRan, false);
        downloadLimitSetting.setText("" + bestDownloadSetting);
        downloadLimitSetting.addListener(25, (Listener)new NumberListener(downloadLimitSetting));
        Label downEcho = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.widthHint = 80;
        downEcho.setLayoutData((Object)gridData);
        downEcho.setText(DisplayFormatters.formatByteCountToBitsPerSec2(bestDownloadSetting * kinb));
        downloadLimitSetting.addListener(24, (Listener)new ByteConversionListener(downEcho, downloadLimitSetting));
        int downIndex = this.setDefaultConfidenceLevelEx(this.measuredDownloadKbps, this.downloadTestRan, false, confValue);
        this.downConfLevelCombo = new Combo(panel, 8);
        this.addDropElements(this.downConfLevelCombo, confName);
        this.downConfLevelCombo.select(downIndex);
        Label c1 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.widthHint = 80;
        c1.setLayoutData((Object)gridData);
        SpeedManager sm = CoreFactory.getSingleton().getSpeedManager();
        if (this.uploadTestRan) {
            sm.setEstimatedUploadCapacityBytesPerSec(this.measuredUploadKbps * kinb, this.uploadHitLimit ? 0.0f : 0.0f);
        }
        if (this.downloadTestRan) {
            sm.setEstimatedDownloadCapacityBytesPerSec(this.measuredDownloadKbps * kinb, this.downloadHitLimit ? 0.8f : 0.9f);
        }
        this.apply = new Button(panel, 8);
        Messages.setLanguageText((Widget)this.apply, "SpeedTestWizard.set.upload.button.apply");
        gridData = new GridData();
        gridData.widthHint = 70;
        this.apply.setLayoutData((Object)gridData);
        this.apply.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                int uploadLimitKBPS = Integer.parseInt(uploadLimitSetting.getText());
                int downlaodLimitKBPS = Integer.parseInt(downloadLimitSetting.getText());
                if (uploadLimitKBPS < 20) {
                    uploadLimitKBPS = 20;
                }
                if (downlaodLimitKBPS < uploadLimitKBPS) {
                    downlaodLimitKBPS = uploadLimitKBPS;
                }
                COConfigurationManager.setParameter("Auto Upload Speed Enabled", false);
                COConfigurationManager.setParameter("Auto Upload Speed Seeding Enabled", false);
                COConfigurationManager.setParameter("AutoSpeed Max Upload KBs", uploadLimitKBPS);
                COConfigurationManager.setParameter("Max Upload Speed KBs", uploadLimitKBPS);
                COConfigurationManager.setParameter("Max Upload Speed Seeding KBs", uploadLimitKBPS);
                if (SpeedTestSetLimitPanel.this.downloadTestRan) {
                    int dIndex = SpeedTestSetLimitPanel.this.downConfLevelCombo.getSelectionIndex();
                    float downEstType = SpeedTestSetLimitPanel.this.helper.textToType(confValue[dIndex]);
                    SpeedTestSetLimitPanel.this.speedManager.setEstimatedUploadCapacityBytesPerSec(downlaodLimitKBPS, downEstType);
                }
                if (SpeedTestSetLimitPanel.this.uploadTestRan) {
                    int uIndex = SpeedTestSetLimitPanel.this.upConfLevelCombo.getSelectionIndex();
                    float upEstType = SpeedTestSetLimitPanel.this.helper.textToType(confValue[uIndex]);
                    SpeedTestSetLimitPanel.this.speedManager.setEstimatedUploadCapacityBytesPerSec(uploadLimitKBPS, upEstType);
                }
                SpeedTestSetLimitPanel.this.wizard.setFinishEnabled(true);
                SpeedTestSetLimitPanel.this.wizard.setPreviousEnabled(false);
            }
        });
        Label c3 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        c3.setLayoutData((Object)gridData);
        Label spacer2 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        spacer2.setLayoutData((Object)gridData);
        Composite resultsPanel = new Composite(rootPanel, 0);
        gridData = new GridData(776);
        resultsPanel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 5;
        layout.makeColumnsEqualWidth = true;
        resultsPanel.setLayout((Layout)layout);
        NetworkAdminSpeedTesterResult result = SpeedTestData.getInstance().getLastResult();
        if (result.hadError()) {
            String error = result.getLastError();
            this.createResultLabels(resultsPanel, true);
            this.createErrorDesc(resultsPanel, error);
            this.createTestDesc(resultsPanel);
        } else {
            int upload = result.getUploadSpeed();
            int download = result.getDownloadSpeed();
            this.createResultLabels(resultsPanel, false);
            this.createResultData(resultsPanel, MessageText.getString("GeneralView.label.uploadspeed"), upload);
            this.createResultData(resultsPanel, MessageText.getString("GeneralView.label.downloadspeed"), download);
            this.createTestDesc(resultsPanel);
        }
    }

    private void addDropElements(Combo combo, String[] elements) {
        if (elements == null) {
            return;
        }
        int n = elements.length;
        int i = 0;
        while (i < n) {
            combo.add(elements[i]);
            ++i;
        }
    }

    private int setDefaultConfidenceLevelEx(int transferRateKBPS, boolean testRan, boolean isUpload, String[] values) {
        SpeedManagerLimitEstimate est = isUpload ? this.speedManager.getEstimatedUploadCapacityBytesPerSec() : this.speedManager.getEstimatedDownloadCapacityBytesPerSec();
        float originalEstType = est.getEstimateType();
        float retValType = originalEstType == 1.0f ? originalEstType : (!testRan ? originalEstType : (isUpload ? 0.0f : (transferRateKBPS < 550 && transferRateKBPS > 450 ? 0.0f : 0.9f)));
        String cType = this.helper.typeToText(retValType);
        if (cType == null) {
            return -1;
        }
        int i = 0;
        while (i < values.length) {
            if (cType.equalsIgnoreCase(values[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void createResultLabels(Composite panel, boolean hadError) {
        Label c1 = new Label(panel, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        c1.setLayoutData((Object)gridData);
        Label c2 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 3;
        c2.setLayoutData((Object)gridData);
        c2.setText(MessageText.getString("SpeedTestWizard.set.upload.result"));
        Label c3 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 2;
        c3.setLayoutData((Object)gridData);
        if (!hadError) {
            c3.setText(MessageText.getString("SpeedTestWizard.set.upload.bytes.per.sec"));
        }
        Label c4 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 2;
        c4.setLayoutData((Object)gridData);
        if (!hadError) {
            c4.setText(MessageText.getString("SpeedTestWizard.set.upload.bits.per.sec"));
        }
        Label c5 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        c5.setLayoutData((Object)gridData);
    }

    private void createResultData(Composite panel, String label, int rate) {
        Label c1 = new Label(panel, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        c1.setLayoutData((Object)gridData);
        Label c2 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 3;
        c2.setLayoutData((Object)gridData);
        c2.setText(label);
        Label c3 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 2;
        c3.setLayoutData((Object)gridData);
        c3.setText(DisplayFormatters.formatByteCountToKiBEtcPerSec(rate));
        Label c4 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 2;
        c4.setLayoutData((Object)gridData);
        c4.setText(DisplayFormatters.formatByteCountToBitsPerSec2(rate));
        Label c5 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        c5.setLayoutData((Object)gridData);
    }

    private void createTestDesc(Composite panel) {
    }

    private void createErrorDesc(Composite panel, String error) {
    }

    public int determineRateSettingEx(int measuredRate, boolean testRan, boolean isUpload) {
        int retVal = measuredRate;
        SpeedManagerLimitEstimate est = isUpload ? this.speedManager.getEstimatedUploadCapacityBytesPerSec() : this.speedManager.getEstimatedDownloadCapacityBytesPerSec();
        int kinb = DisplayFormatters.getKinB();
        if (!testRan) {
            retVal = est.getBytesPerSec() / kinb;
        }
        if (est.getEstimateType() == 1.0f) {
            retVal = est.getBytesPerSec() / kinb;
        }
        return retVal;
    }

    @Override
    public void finish() {
        this.wizard.switchToClose();
    }

    @Override
    public IWizardPanel getFinishPanel() {
        return new SpeedTestFinishPanel(this.wizard, (IWizardPanel)this);
    }

    @Override
    public boolean isFinishEnabled() {
        return true;
    }

    @Override
    public boolean isNextEnabled() {
        return false;
    }

    static class ByteConversionListener
    implements Listener {
        final Label echoLbl;
        final Text setting;

        public ByteConversionListener(Label _echoLbl, Text _setting) {
            this.echoLbl = _echoLbl;
            this.setting = _setting;
        }

        public void handleEvent(Event e) {
            String newVal = this.setting.getText();
            try {
                int newValInt = Integer.parseInt(newVal);
                if (this.echoLbl != null) {
                    this.echoLbl.setText(DisplayFormatters.formatByteCountToBitsPerSec2(newValInt * DisplayFormatters.getKinB()));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static class NumberListener
    implements Listener {
        final Text setting;

        public NumberListener(Text _setting) {
            this.setting = _setting;
        }

        public void handleEvent(Event e) {
            String text = e.text;
            char[] chars = new char[text.length()];
            text.getChars(0, chars.length, chars, 0);
            int i = 0;
            while (i < chars.length) {
                if ('0' > chars[i] || chars[i] > '9') {
                    e.doit = false;
                    return;
                }
                ++i;
            }
        }
    }
}

