/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.skin;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinImageChanger;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectBrowser;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class SWTSkinUtils {
    public static final int TILE_NONE = 0;
    public static final int TILE_Y = 1;
    public static final int TILE_X = 2;
    public static final int TILE_CENTER_X = 4;
    public static final int TILE_CENTER_Y = 8;
    public static final int TILE_BOTH = 3;
    private static Listener imageDownListener = new SWTSkinImageChanger("-down", 3, 4, 1);

    public static int getAlignment(String sAlign, int def) {
        int align = sAlign == null ? def : (sAlign.equalsIgnoreCase("center") ? 0x1000000 : (sAlign.equalsIgnoreCase("bottom") ? 1024 : (sAlign.equalsIgnoreCase("top") ? 128 : (sAlign.equalsIgnoreCase("left") ? 16384 : (sAlign.equalsIgnoreCase("right") ? 131072 : def)))));
        return align;
    }

    public static int getTileMode(String sTileMode) {
        int tileMode = 0;
        if (sTileMode == null || sTileMode == "") {
            return tileMode;
        }
        if ((sTileMode = sTileMode.toLowerCase()).equals("tile")) {
            tileMode = 3;
        } else if (sTileMode.equals("tile-x")) {
            tileMode = 2;
        } else if (sTileMode.equals("tile-y")) {
            tileMode = 1;
        } else if (sTileMode.equals("center-x")) {
            tileMode = 4;
        } else if (sTileMode.equals("center-y")) {
            tileMode = 8;
        }
        return tileMode;
    }

    static void addMouseImageChangeListeners(Control widget) {
        if (widget.getData("hasMICL") != null) {
            return;
        }
        widget.addListener(3, imageDownListener);
        widget.addListener(4, imageDownListener);
        widget.setData("hasMICL", (Object)"1");
    }

    public static void setVisibility(SWTSkin skin, String configID, String viewID, boolean visible, boolean save) {
        SWTSkinObject skinObject = skin.getSkinObject(viewID);
        if (skinObject == null) {
            Debug.out("setVisibility on non existing skin object: " + viewID);
            return;
        }
        if (skinObject.isVisible() == visible && skin.getShell().isVisible()) {
            return;
        }
        Control control = skinObject.getControl();
        if (control != null && !control.isDisposed()) {
            Point size;
            if (visible) {
                FormData fd = (FormData)control.getLayoutData();
                size = (Point)control.getData("v3.oldHeight");
                if (size == null) {
                    size = control.computeSize(-1, -1);
                    if (fd.height > 0) {
                        size.y = fd.height;
                    }
                    if (fd.width > 0) {
                        size.x = fd.width;
                    }
                }
            } else {
                size = new Point(0, 0);
            }
            SWTSkinUtils.setVisibility(skin, configID, skinObject, size, save);
        }
    }

    private static void setVisibility(SWTSkin skin, String configID, SWTSkinObject skinObject, Point destSize, boolean save) {
        boolean visible = destSize.x != 0 || destSize.y != 0;
        try {
            if (skinObject == null) {
                return;
            }
            Control control = skinObject.getControl();
            if (control != null && !control.isDisposed()) {
                if (visible) {
                    FormData fd = (FormData)control.getLayoutData();
                    fd.width = 0;
                    fd.height = 0;
                    control.setData("oldSize", (Object)new Point(0, 0));
                    skinObject.setVisible(visible);
                    fd = (FormData)control.getLayoutData();
                    if (fd.width != 0 || fd.height != 0) {
                        return;
                    }
                    if (fd.width != destSize.x || fd.height != destSize.y) {
                        fd.width = destSize.x;
                        fd.height = destSize.y;
                        control.setLayoutData((Object)fd);
                        Utils.relayout(control);
                    }
                    control.setData("v3.oldHeight", null);
                } else {
                    FormData fd = (FormData)control.getLayoutData();
                    if (fd != null) {
                        Point oldSize = new Point(fd.width, fd.height);
                        if (oldSize.y <= 0) {
                            oldSize = null;
                        }
                        control.setData("v3.oldHeight", (Object)oldSize);
                        skinObject.setVisible(false);
                    }
                }
            }
        }
        finally {
            if (save && COConfigurationManager.getBooleanParameter(configID) != visible) {
                COConfigurationManager.setParameter(configID, visible);
            }
        }
    }

    public static void setVisibilityRelaxed(SWTSkin skin, String configID, String viewID, boolean visible, boolean save) {
        SWTSkinObject skinObject = skin.getSkinObject(viewID);
        if (skinObject == null) {
            Debug.out("setVisibility on non existing skin object: " + viewID);
            return;
        }
        if (skinObject.isVisible() == visible && skin.getShell().isVisible()) {
            return;
        }
        Control control = skinObject.getControl();
        if (control != null && !control.isDisposed()) {
            SWTSkinUtils.setVisibilityRelaxed(skin, configID, skinObject, visible, save);
        }
    }

    private static void setVisibilityRelaxed(SWTSkin skin, String configID, SWTSkinObject skinObject, boolean visible, boolean save) {
        try {
            if (skinObject == null) {
                return;
            }
            Control control = skinObject.getControl();
            if (control != null && !control.isDisposed()) {
                if (visible) {
                    Composite comp2;
                    FormData fd = (FormData)control.getLayoutData();
                    fd.width = 0;
                    fd.height = 0;
                    control.setData("oldSize", (Object)new Point(0, 0));
                    skinObject.setVisible(visible);
                    fd = (FormData)control.getLayoutData();
                    if (fd.width != 0 || fd.height != 0) {
                        return;
                    }
                    fd.width = -1;
                    fd.height = -1;
                    Composite composite = comp2 = control instanceof Composite ? (Composite)control : control.getParent();
                    if (comp2 != null) {
                        comp2.layout(true, true);
                        Utils.relayoutUp(comp2);
                    }
                } else {
                    FormData fd = (FormData)control.getLayoutData();
                    if (fd != null) {
                        Point oldSize = new Point(fd.width, fd.height);
                        if (oldSize.y <= 0) {
                            oldSize = null;
                        }
                        skinObject.setVisible(false);
                    }
                }
            }
        }
        finally {
            if (save && COConfigurationManager.getBooleanParameter(configID) != visible) {
                COConfigurationManager.setParameter(configID, visible);
            }
        }
    }

    public static SWTSkinObjectBrowser findBrowserSO(SWTSkinObject so) {
        if (so instanceof SWTSkinObjectBrowser) {
            return (SWTSkinObjectBrowser)so;
        }
        if (so instanceof SWTSkinObjectContainer) {
            SWTSkinObjectContainer soContainer = (SWTSkinObjectContainer)so;
            SWTSkinObject[] children = soContainer.getChildren();
            int i = 0;
            while (i < children.length) {
                SWTSkinObject child = children[i];
                SWTSkinObjectBrowser found = SWTSkinUtils.findBrowserSO(child);
                if (found != null) {
                    return found;
                }
                ++i;
            }
        }
        return null;
    }

    public static class MouseEnterExitListener
    implements Listener {
        boolean bOver = false;

        public MouseEnterExitListener(Widget widget) {
            widget.addListener(5, (Listener)this);
            widget.addListener(7, (Listener)this);
        }

        public void handleEvent(Event event2) {
            Control control = (Control)event2.widget;
            SWTSkinObject skinObject = (SWTSkinObject)control.getData("SkinObject");
            if (event2.type == 5) {
                if (this.bOver) {
                    return;
                }
                System.out.println(String.valueOf(System.currentTimeMillis()) + ": " + skinObject + "-- OVER");
                this.bOver = true;
                skinObject.switchSuffix("-over", 2, true);
            } else {
                this.bOver = false;
                System.out.println(String.valueOf(System.currentTimeMillis()) + ": " + skinObject + "-- NOOVER");
                skinObject.switchSuffix("", 2, true);
            }
        }
    }
}

