/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.skin;

import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.RegExUtil;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BubbleTextBox;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectBasic;
import com.biglybt.ui.swt.skin.SWTSkinProperties;
import com.biglybt.ui.swt.utils.FontUtils;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Locale;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class SWTSkinObjectTextbox
extends SWTSkinObjectBasic {
    private BubbleTextBox bubbleTextBox;
    private Text textWidget;
    private Composite cBubble;
    private String text = "";

    public SWTSkinObjectTextbox(SWTSkin skin, SWTSkinProperties properties, String id, String configID, SWTSkinObject parentSkinObject) {
        super(skin, properties, id, configID, "textbox", parentSkinObject);
        Composite createOn = this.parent == null ? skin.getShell() : (Composite)this.parent.getControl();
        boolean doBubble = false;
        int style = 2048;
        String styleString = properties.getStringValue(String.valueOf(this.sConfigID) + ".style");
        if (styleString != null) {
            Object[] styles = RegExUtil.PAT_SPLIT_COMMA.split(styleString.toLowerCase());
            Arrays.sort(styles);
            if (Arrays.binarySearch(styles, "readonly") >= 0) {
                style |= 8;
            }
            if (Arrays.binarySearch(styles, "wrap") >= 0) {
                style |= 0x40;
            }
            style = Arrays.binarySearch(styles, "multiline") >= 0 ? (style |= 0x202) : (style |= 4);
            if (Arrays.binarySearch(styles, "search") >= 0) {
                style |= 0x380;
                doBubble = true;
            }
        } else {
            style |= 4;
        }
        if ((style & 0x40) == 0 && (style & 2) > 0 && !properties.getBooleanValue(String.valueOf(this.sConfigID) + ".nohbar", false)) {
            style |= 0x100;
        }
        if (!doBubble) {
            this.textWidget = new Text(createOn, style);
        } else {
            this.bubbleTextBox = new BubbleTextBox(createOn, style);
            this.textWidget = this.bubbleTextBox.getTextWidget();
            this.cBubble = this.bubbleTextBox.getMainWidget();
        }
        this.textWidget.addListener(1, event2 -> {
            int key = event2.character;
            if (key <= 26 && key > 0) {
                key += 96;
            }
            if (key == 97 && event2.stateMask == SWT.MOD1) {
                event2.doit = false;
                this.textWidget.selectAll();
            }
        });
        this.textWidget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SWTSkinObjectTextbox.this.text = SWTSkinObjectTextbox.this.textWidget.getText();
            }
        });
        String message = properties.getStringValue(String.valueOf(configID) + ".message", (String)null);
        if (message != null && message.length() > 0) {
            this.textWidget.setMessage(message);
        }
        this.setControl((Control)(this.cBubble == null ? this.textWidget : this.cBubble));
        this.updateFont("");
        if (!doBubble && (style & 4) > 0) {
            int fixedHeight = properties.getIntValue(String.valueOf(this.sConfigID) + ".height", -1);
            boolean noFontSize = properties.getStringValue(String.valueOf(this.sConfigID) + ".text.size", "").isEmpty();
            if (fixedHeight > 0 && noFontSize) {
                FontUtils.fontToWidgetHeight(this.textWidget);
            }
        }
    }

    @Override
    public String switchSuffix(String suffix, int level, boolean walkUp, boolean walkDown) {
        if ((suffix = super.switchSuffix(suffix, level, walkUp, walkDown)) == null) {
            return null;
        }
        String sPrefix = String.valueOf(this.sConfigID) + ".text";
        String text = this.properties.getStringValue(String.valueOf(sPrefix) + suffix);
        if (text != null) {
            this.setText(text);
        }
        return suffix;
    }

    public void setText(final String val) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SWTSkinObjectTextbox.this.textWidget != null && !SWTSkinObjectTextbox.this.textWidget.isDisposed()) {
                    SWTSkinObjectTextbox.this.textWidget.setText(val == null ? "" : val);
                    SWTSkinObjectTextbox.this.text = val;
                }
            }
        });
    }

    public String getText() {
        return this.text;
    }

    public Text getTextControl() {
        return this.textWidget;
    }

    private void updateFont(String suffix) {
        String sPrefix = String.valueOf(this.sConfigID) + ".text";
        Font existingFont = (Font)this.textWidget.getData("Font" + suffix);
        if (existingFont != null && !existingFont.isDisposed()) {
            this.textWidget.setFont(existingFont);
        } else {
            boolean bNewFont = false;
            float fontSizeAdj = -1.0f;
            String sFontFace = null;
            FontData[] tempFontData = this.textWidget.getFont().getFontData();
            sFontFace = this.properties.getStringValue(String.valueOf(sPrefix) + ".font" + suffix);
            if (sFontFace != null) {
                tempFontData[0].setName(sFontFace);
                bNewFont = true;
            }
            String sSize = this.properties.getStringValue(String.valueOf(sPrefix) + ".size" + suffix);
            if (Utils.isGTK3 && sSize == null && this.bubbleTextBox != null) {
                sSize = "8";
            }
            if (sSize != null) {
                sSize = sSize.trim();
                try {
                    char firstChar = sSize.charAt(0);
                    char lastChar = sSize.charAt(sSize.length() - 1);
                    if (firstChar == '+' || firstChar == '-') {
                        sSize = sSize.substring(1);
                    } else if (lastChar == '%') {
                        sSize = sSize.substring(0, sSize.length() - 1);
                    }
                    float dSize = NumberFormat.getInstance(Locale.US).parse(sSize).floatValue();
                    fontSizeAdj = lastChar == '%' ? dSize / 100.0f : (firstChar == '+' ? 1.0f + dSize * 0.1f : (firstChar == '-' ? 1.0f - dSize * 0.1f : (sSize.endsWith("rem") ? dSize : dSize / (float)FontUtils.getFontHeightInPX(tempFontData))));
                    bNewFont = true;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            if (bNewFont) {
                FontData[] fd = this.textWidget.getFont().getFontData();
                if (fontSizeAdj > 0.0f) {
                    FontUtils.setFontDataHeight(fd, FontUtils.getHeight(fd) * fontSizeAdj);
                }
                if (sFontFace != null) {
                    fd[0].setName(sFontFace);
                }
                final Font textWidgetFont = new Font((Device)this.textWidget.getDisplay(), fd);
                this.textWidget.setFont(textWidgetFont);
                this.textWidget.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        textWidgetFont.dispose();
                    }
                });
                this.textWidget.setData("Font" + suffix, (Object)textWidgetFont);
            }
        }
    }

    public BubbleTextBox getBubbleTextBox() {
        return this.bubbleTextBox;
    }
}

