/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.skin;

import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinCheckboxListener;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectBasic;
import com.biglybt.ui.swt.skin.SWTSkinProperties;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SWTSkinObjectCheckbox
extends SWTSkinObjectBasic {
    private Button button;
    private boolean checked;
    private List<SWTSkinCheckboxListener> buttonListeners = new CopyOnWriteArrayList<SWTSkinCheckboxListener>();

    public SWTSkinObjectCheckbox(SWTSkin skin, SWTSkinProperties properties, String id, String configID, SWTSkinObject parentSkinObject) {
        super(skin, properties, id, configID, "checkbox", parentSkinObject);
        Composite createOn = this.parent == null ? skin.getShell() : (Composite)this.parent.getControl();
        int style = 96;
        String[] styles = properties.getStringArray(String.valueOf(configID) + ".style");
        if (styles != null) {
            String[] stringArray = styles;
            int n = styles.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.toLowerCase().equals("radio")) {
                    style = 0x10 | style & 0xFFFFFFDF;
                }
                ++n2;
            }
        }
        this.button = new Button(createOn, style);
        this.checked = false;
        this.button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SWTSkinObjectCheckbox.this.checked = SWTSkinObjectCheckbox.this.button.getSelection();
                for (SWTSkinCheckboxListener l : SWTSkinObjectCheckbox.this.buttonListeners) {
                    try {
                        l.checkboxChanged(SWTSkinObjectCheckbox.this, SWTSkinObjectCheckbox.this.checked);
                    }
                    catch (Exception ex) {
                        Debug.out(ex);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setControl((Control)this.button);
    }

    @Override
    public String switchSuffix(String suffix, int level, boolean walkUp, boolean walkDown) {
        if ((suffix = super.switchSuffix(suffix, level, walkUp, walkDown)) == null) {
            return null;
        }
        String sPrefix = String.valueOf(this.sConfigID) + ".text";
        String text = this.properties.getStringValue(String.valueOf(sPrefix) + suffix);
        if (text != null) {
            this.setText(text);
        }
        return suffix;
    }

    public void addSelectionListener(SWTSkinCheckboxListener listener) {
        if (this.buttonListeners.contains(listener)) {
            return;
        }
        this.buttonListeners.add(listener);
    }

    public void setText(final String text) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SWTSkinObjectCheckbox.this.button != null && !SWTSkinObjectCheckbox.this.button.isDisposed()) {
                    SWTSkinObjectCheckbox.this.button.setText(text);
                }
            }
        });
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean b) {
        this.checked = b;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SWTSkinObjectCheckbox.this.button != null && !SWTSkinObjectCheckbox.this.button.isDisposed()) {
                    SWTSkinObjectCheckbox.this.button.setSelection(SWTSkinObjectCheckbox.this.checked);
                }
            }
        });
    }

    public void setEnabled(final boolean b) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SWTSkinObjectCheckbox.this.button != null && !SWTSkinObjectCheckbox.this.button.isDisposed()) {
                    SWTSkinObjectCheckbox.this.button.setEnabled(b);
                }
            }
        });
    }
}

