/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.shells.main;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.history.DownloadHistoryManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.proxy.AEProxyFactory;
import com.biglybt.core.torrent.PlatformTorrentUtils;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.impl.TorrentOpenOptions;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AETemporaryFileHandler;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.core.vuzefile.VuzeFileHandler;
import com.biglybt.pif.download.DownloadStub;
import com.biglybt.pif.ui.UIInputReceiver;
import com.biglybt.pif.ui.UIInputReceiverListener;
import com.biglybt.pif.ui.toolbar.UIToolBarManager;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.torrent.TorrentManagerImpl;
import com.biglybt.ui.InitializerListener;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.UIFunctionsUserPrompter;
import com.biglybt.ui.UIStatusTextClickListener;
import com.biglybt.ui.UserPrompterResultListener;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.common.table.impl.TableColumnImpl;
import com.biglybt.ui.common.updater.UIUpdater;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MdiEntryOpenListener;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.FileDownloadWindow;
import com.biglybt.ui.swt.Initializer;
import com.biglybt.ui.swt.SimpleTextEntryWindow;
import com.biglybt.ui.swt.TextViewerWindow;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.UIFunctionsSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mainwindow.IMainMenu;
import com.biglybt.ui.swt.mainwindow.IMainStatusBar;
import com.biglybt.ui.swt.mainwindow.IMainWindow;
import com.biglybt.ui.swt.mainwindow.MainMenuV2;
import com.biglybt.ui.swt.mainwindow.MenuFactory;
import com.biglybt.ui.swt.mainwindow.TorrentOpener;
import com.biglybt.ui.swt.mdi.BaseMdiEntry;
import com.biglybt.ui.swt.mdi.MdiEntrySWT;
import com.biglybt.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.biglybt.ui.swt.minibar.AllTransfersBar;
import com.biglybt.ui.swt.minibar.MiniBarManager;
import com.biglybt.ui.swt.pif.UISWTInstance;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pifimpl.UISWTInstanceImpl;
import com.biglybt.ui.swt.pifimpl.UISWTViewBuilderCore;
import com.biglybt.ui.swt.pifimpl.UIToolBarManagerImpl;
import com.biglybt.ui.swt.plugininstall.SimplePluginInstaller;
import com.biglybt.ui.swt.search.SearchHandler;
import com.biglybt.ui.swt.shells.BrowserWindow;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.shells.MessageSlideShell;
import com.biglybt.ui.swt.shells.RemotePairingWindow;
import com.biglybt.ui.swt.shells.main.MainMenuV3;
import com.biglybt.ui.swt.shells.main.MainWindow;
import com.biglybt.ui.swt.shells.opentorrent.OpenTorrentOptionsWindow;
import com.biglybt.ui.swt.shells.opentorrent.OpenTorrentWindow;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinButtonUtility;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectBrowser;
import com.biglybt.ui.swt.skin.SWTSkinObjectButton;
import com.biglybt.ui.swt.skin.SWTSkinObjectText;
import com.biglybt.ui.swt.skin.SWTSkinUtils;
import com.biglybt.ui.swt.uiupdater.UIUpdaterSWT;
import com.biglybt.ui.swt.update.FullUpdateWindow;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.utils.TagUIUtilsV3;
import com.biglybt.ui.swt.utils.TorrentUIUtilsV3;
import com.biglybt.ui.swt.views.skin.SkinView;
import com.biglybt.ui.swt.views.skin.SkinViewManager;
import com.biglybt.ui.swt.views.skin.SkinnedDialog;
import com.biglybt.ui.swt.views.skin.ToolBarView;
import com.biglybt.ui.swt.views.skin.TorrentListViewsUtils;
import com.biglybt.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import com.biglybt.ui.swt.views.utils.ManagerUtils;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class UIFunctionsImpl
implements UIFunctionsSWT {
    private static final boolean PROXY_VIEW_URL = false;
    private static final String MSG_ALREADY_EXISTS = "OpenTorrentWindow.mb.alreadyExists";
    private static final String MSG_ALREADY_EXISTS_NAME = "OpenTorrentWindow.mb.alreadyExists.default.name";
    private static final LogIDs LOGID = LogIDs.GUI;
    private final MainWindow mainWindow;
    private SWTSkin skin = null;
    protected boolean isTorrentMenuVisible;
    private final ParameterListener paramShowTorrentsMenuListener;

    public UIFunctionsImpl(MainWindow window) {
        this.mainWindow = window;
        this.paramShowTorrentsMenuListener = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                UIFunctionsImpl.this.isTorrentMenuVisible = COConfigurationManager.getBooleanParameter("show_torrents_menu");
            }
        };
        COConfigurationManager.addAndFireParameterListener("show_torrents_menu", this.paramShowTorrentsMenuListener);
    }

    @Override
    public String getUIType() {
        return "swt";
    }

    @Override
    public void bringToFront() {
        this.bringToFront(true);
    }

    @Override
    public void bringToFront(final boolean tryTricks) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                try {
                    UIFunctionsImpl.this.mainWindow.setVisible(true, tryTricks);
                }
                catch (Exception e) {
                    Logger.log(new LogEvent(LOGID, "bringToFront", e));
                }
            }
        });
    }

    @Override
    public int getVisibilityState() {
        Shell shell = this.getMainShell();
        if (shell == null) {
            return 1;
        }
        AESemaphore sem = new AESemaphore("getVisibilityState");
        int[] result = new int[]{2};
        boolean success = Utils.execSWTThread(() -> {
            try {
                nArray[0] = shell.isDisposed() ? 1 : (!shell.isVisible() ? 2 : (shell.getMinimized() ? 3 : 4));
            }
            finally {
                sem.release();
            }
        });
        if (success) {
            sem.reserve(30000L);
        }
        return result[0];
    }

    @Override
    public void closeDownloadBars() {
        try {
            Utils.execSWTThreadLater(0, new AERunnable(){

                @Override
                public void runSupport() {
                    MiniBarManager.getManager().closeAll();
                }
            });
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "closeDownloadBars", e));
        }
    }

    @Override
    public boolean dispose(boolean for_restart) {
        try {
            return this.mainWindow.dispose(for_restart);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "Disposing MainWindow", e));
            return false;
        }
    }

    @Override
    public Shell getMainShell() {
        return this.mainWindow == null ? null : this.mainWindow.getShell();
    }

    @Override
    public UISWTView[] getPluginViews() {
        try {
            return new UISWTView[0];
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "getPluginViews", e));
            return new UISWTView[0];
        }
    }

    @Override
    public void openPluginView(UISWTViewBuilderCore builder, boolean bSetFocus) {
        try {
            MultipleDocumentInterfaceSWT mdi = this.getMDISWT();
            if (mdi != null) {
                MdiEntrySWT entry = mdi.createEntry(builder, true);
                if (bSetFocus) {
                    mdi.showEntryByID(builder.getViewID());
                } else if (entry instanceof BaseMdiEntry) {
                    ((BaseMdiEntry)entry).build();
                }
            }
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "openPluginView", e));
        }
    }

    @Override
    public void refreshIconBar() {
        try {
            SkinView[] tbSkinViews = SkinViewManager.getMultiByClass(ToolBarView.class);
            if (tbSkinViews != null) {
                SkinView[] skinViewArray = tbSkinViews;
                int n = tbSkinViews.length;
                int n2 = 0;
                while (n2 < n) {
                    ToolBarView tb;
                    SkinView skinview = skinViewArray[n2];
                    if (skinview instanceof ToolBarView && (tb = (ToolBarView)skinview).isVisible()) {
                        tb.refreshCoreToolBarItems();
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "refreshIconBar", e));
        }
    }

    @Override
    public void refreshLanguage() {
        try {
            this.mainWindow.setSelectedLanguageItem();
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "refreshLanguage", e));
        }
    }

    @Override
    public void setStatusText(final String key) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            @Override
            public void runSupport() {
                IMainStatusBar sb = UIFunctionsImpl.this.getMainStatusBar();
                if (sb != null) {
                    sb.setStatusText(key);
                }
            }
        });
    }

    @Override
    public void setStatusText(final int statustype, final String key, final UIStatusTextClickListener l) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            @Override
            public void runSupport() {
                IMainStatusBar sb = UIFunctionsImpl.this.getMainStatusBar();
                if (sb != null) {
                    sb.setStatusText(statustype, key, l);
                }
            }
        });
    }

    @Override
    public IMainStatusBar getMainStatusBar() {
        if (this.mainWindow == null) {
            return null;
        }
        return this.mainWindow.getMainStatusBar();
    }

    @Override
    public UISWTInstance getUISWTInstance() {
        UISWTInstanceImpl impl = this.mainWindow.getUISWTInstanceImpl();
        if (impl == null) {
            Debug.out("No uiswtinstanceimpl");
        }
        return impl;
    }

    @Override
    public void viewURL(String url, String target, String sourceRef) {
        this.viewURL(url, target, 0, 0, true, false);
    }

    @Override
    public boolean viewURL(final String url, final String target, final int w, final int h, final boolean allowResize, final boolean isModal) {
        this.mainWindow.getShell().getDisplay().syncExec((Runnable)new AERunnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void runSupport() {
                String realURL = url;
                if (target == null) {
                    AEProxyFactory.PluginHTTPProxy proxy = null;
                    try {
                        try {
                            BrowserWindow window = new BrowserWindow(UIFunctionsImpl.this.mainWindow.getShell(), realURL, w, h, allowResize, isModal);
                            window.waitUntilClosed();
                            return;
                        }
                        catch (Throwable throwable) {
                            if (proxy == null) return;
                            proxy.destroy();
                        }
                        return;
                    }
                    finally {
                        if (proxy != null) {
                            proxy.destroy();
                        }
                    }
                } else {
                    UIFunctionsImpl.this.showURL(realURL, target);
                }
            }
        });
        return true;
    }

    @Override
    public boolean viewURL(final String url, final String target, final double w, final double h, final boolean allowResize, final boolean isModal) {
        this.mainWindow.getShell().getDisplay().syncExec((Runnable)new AERunnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void runSupport() {
                String realURL = url;
                if (target == null) {
                    AEProxyFactory.PluginHTTPProxy proxy = null;
                    try {
                        try {
                            BrowserWindow window = new BrowserWindow(UIFunctionsImpl.this.mainWindow.getShell(), realURL, w, h, allowResize, isModal);
                            window.waitUntilClosed();
                            return;
                        }
                        catch (Throwable throwable) {
                            if (proxy == null) return;
                            proxy.destroy();
                        }
                        return;
                    }
                    finally {
                        if (proxy != null) {
                            proxy.destroy();
                        }
                    }
                } else {
                    UIFunctionsImpl.this.showURL(realURL, target);
                }
            }
        });
        return true;
    }

    private void showURL(final String url, String target) {
        MultipleDocumentInterface mdi;
        if ("_blank".equalsIgnoreCase(target)) {
            Utils.launch(url);
            return;
        }
        if (target.startsWith("tab-")) {
            target = target.substring(4);
        }
        if ((mdi = UIFunctionsManager.getUIFunctions().getMDI()) == null || !mdi.showEntryByID(target)) {
            Utils.launch(url);
            return;
        }
        MdiEntry entry = mdi.getEntry(target);
        entry.addListener(new MdiEntryOpenListener(){

            @Override
            public void mdiEntryOpen(MdiEntry entry) {
                entry.removeListener(this);
                UIFunctionsImpl.this.mainWindow.setVisible(true, true);
                if (!(entry instanceof SideBarEntrySWT)) {
                    return;
                }
                SideBarEntrySWT entrySWT = (SideBarEntrySWT)entry;
                SWTSkinObjectBrowser soBrowser = SWTSkinUtils.findBrowserSO(entrySWT.getSkinObject());
                if (soBrowser != null) {
                    if (url == null || url.length() == 0) {
                        soBrowser.restart();
                    } else {
                        soBrowser.setURL(url);
                    }
                }
            }
        });
    }

    @Override
    public void promptUser(String title, String text, String[] buttons, int defaultOption, String rememberID, String rememberText, boolean rememberByDefault, int autoCloseInMS, UserPrompterResultListener l) {
        MessageBoxShell.open(this.getMainShell(), title, text, buttons, defaultOption, rememberID, rememberText, rememberByDefault, autoCloseInMS, l);
    }

    @Override
    public UIFunctionsUserPrompter getUserPrompter(String title, String text, String[] buttons, int defaultOption) {
        MessageBoxShell mb = new MessageBoxShell(title, text, buttons, defaultOption);
        return mb;
    }

    @Override
    public boolean isGlobalTransferBarShown() {
        if (!CoreFactory.isCoreRunning()) {
            return false;
        }
        return AllTransfersBar.getManager().isOpen(CoreFactory.getSingleton().getGlobalManager());
    }

    @Override
    public void showGlobalTransferBar() {
        AllTransfersBar.open(this.getMainShell());
    }

    @Override
    public void closeGlobalTransferBar() {
        AllTransfersBar.closeAllTransfersBar();
    }

    @Override
    public void refreshTorrentMenu() {
        if (!this.isTorrentMenuVisible || Utils.isDisplayDisposed()) {
            return;
        }
        try {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    MenuItem torrentItem = MenuFactory.findMenuItem(UIFunctionsImpl.this.mainWindow.getMainMenu().getMenu("menu.bar"), "MainWindow.menu.torrent", false);
                    if (torrentItem != null) {
                        DownloadManager[] dms;
                        DownloadManager[] dm_final = dms = SelectedContentManager.getDMSFromSelectedContent();
                        boolean detailed_view_final = false;
                        if (dm_final == null) {
                            torrentItem.setEnabled(false);
                        } else {
                            TableView tv = SelectedContentManager.getCurrentlySelectedTableView();
                            torrentItem.getMenu().setData("TableView", (Object)tv);
                            torrentItem.getMenu().setData("downloads", (Object)dm_final);
                            torrentItem.getMenu().setData("is_detailed_view", (Object)false);
                            torrentItem.setEnabled(true);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "refreshTorrentMenu", e));
        }
    }

    @Override
    public IMainMenu createMainMenu(Shell shell) {
        IMainMenu menu = Utils.isAZ2UI() ? new MainMenuV2(shell) : new MainMenuV3(this.skin, shell);
        return menu;
    }

    public SWTSkin getSkin() {
        return this.skin;
    }

    public void setSkin(SWTSkin skin) {
        this.skin = skin;
    }

    @Override
    public IMainWindow getMainWindow() {
        return this.mainWindow;
    }

    @Override
    public UIUpdater getUIUpdater() {
        return UIUpdaterSWT.getInstance();
    }

    @Override
    public void closeAllDetails() {
        MdiEntry[] sideBarEntries;
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return;
        }
        MdiEntry[] mdiEntryArray = sideBarEntries = mdi.getEntries();
        int n = sideBarEntries.length;
        int n2 = 0;
        while (n2 < n) {
            MdiEntry entry = mdiEntryArray[n2];
            String id = entry.getViewID();
            if (id.startsWith("DMDetails_")) {
                mdi.closeEntryByID(id);
            }
            ++n2;
        }
    }

    @Override
    public boolean hasDetailViews() {
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return false;
        }
        MdiEntry[] sideBarEntries = mdi.getEntries();
        int i = 0;
        while (i < sideBarEntries.length) {
            MdiEntry entry = sideBarEntries[i];
            String id = entry.getViewID();
            if (id != null && id.startsWith("DMDetails_")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void performAction(int action_id, Object args, final UIFunctions.actionListener listener) {
        if (action_id == 1) {
            FullUpdateWindow.handleUpdate((String)args, listener);
        } else if (action_id == 2) {
            String title = MessageText.getString("UpdateMonitor.messagebox.restart.title");
            String text = MessageText.getString("UpdateMonitor.messagebox.restart.text");
            this.bringToFront();
            boolean no_timeout = args instanceof Boolean && (Boolean)args != false;
            int timeout = 180000;
            if (no_timeout || !PluginInitializer.getDefaultInterface().getPluginManager().isSilentRestartEnabled()) {
                timeout = -1;
            }
            MessageBoxShell messageBoxShell = new MessageBoxShell(title, text, new String[]{MessageText.getString("UpdateWindow.restart"), MessageText.getString("UpdateWindow.restartLater")}, 0);
            messageBoxShell.setAutoCloseInMS(timeout);
            messageBoxShell.setParent(this.getMainShell());
            messageBoxShell.setOneInstanceOf("UpdateMonitor.messagebox.");
            messageBoxShell.open(new UserPrompterResultListener(){

                @Override
                public void prompterClosed(int result) {
                    listener.actionComplete(result == 0);
                }
            });
        } else {
            Debug.out("Unknown action " + action_id);
        }
    }

    @Override
    public Shell showCoreWaitDlg() {
        Initializer initializer;
        final SkinnedDialog closeDialog = new SkinnedDialog("skin3_dlg_coreloading", "coreloading.body", 67616);
        closeDialog.setTitle(MessageText.getString("dlg.corewait.title"));
        SWTSkin skin = closeDialog.getSkin();
        SWTSkinObjectButton soButton = (SWTSkinObjectButton)skin.getSkinObject("close");
        final SWTSkinObjectText soWaitTask = (SWTSkinObjectText)skin.getSkinObject("task");
        final SWTSkinObject soWaitProgress = skin.getSkinObject("progress");
        if (soWaitProgress != null) {
            soWaitProgress.getControl().addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    Control c = (Control)e.widget;
                    Point size = c.getSize();
                    e.gc.setBackground(ColorCache.getColor((Device)e.display, "#23a7df"));
                    Object data = soWaitProgress.getData("progress");
                    if (data instanceof Long) {
                        int waitProgress = ((Long)data).intValue();
                        int breakX = size.x * waitProgress / 100;
                        e.gc.fillRectangle(0, 0, breakX, size.y);
                        e.gc.setBackground(ColorCache.getColor((Device)e.display, "#cccccc"));
                        e.gc.fillRectangle(breakX, 0, size.x - breakX, size.y);
                    }
                }
            });
        }
        if (!CoreFactory.isCoreRunning() && (initializer = Initializer.getLastInitializer()) != null) {
            initializer.addListener(new InitializerListener(){

                @Override
                public void reportPercent(final int percent) {
                    Utils.execSWTThread(new AERunnable(){

                        @Override
                        public void runSupport() {
                            if (soWaitProgress != null && !soWaitProgress.isDisposed()) {
                                soWaitProgress.setData("progress", new Long(percent));
                                soWaitProgress.getControl().redraw();
                                soWaitProgress.getControl().update();
                            }
                        }
                    });
                    if (percent > 100) {
                        initializer.removeListener(this);
                    }
                }

                @Override
                public void reportCurrentTask(String currentTask) {
                    if (soWaitTask != null && !soWaitTask.isDisposed()) {
                        soWaitTask.setText(currentTask);
                    }
                }
            });
        }
        if (soButton != null) {
            soButton.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                @Override
                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    closeDialog.close();
                }
            });
        }
        closeDialog.addCloseListener(new SkinnedDialog.SkinnedDialogClosedListener(){

            @Override
            public void skinDialogClosed(SkinnedDialog dialog) {
            }
        });
        closeDialog.open();
        return closeDialog.getShell();
    }

    @Override
    public void doSearch(final String sSearchText) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                UIFunctionsImpl.this.doSearch(sSearchText, false);
            }
        });
    }

    @Override
    public void doSearch(String sSearchText, boolean toSubscribe) {
        if (sSearchText.length() == 0) {
            return;
        }
        if (UIFunctionsImpl.checkForSpecialSearchTerm(sSearchText)) {
            return;
        }
        SearchHandler.handleSearch(sSearchText, toSubscribe);
    }

    private static boolean checkForSpecialSearchTerm(String str) {
        String hit = UrlUtils.parseTextForURL(str = str.trim(), true, true);
        if (hit == null) {
            try {
                UIFunctionsSWT uif;
                String name;
                File f = new File(str);
                if (f.isFile() && ((name = f.getName().toLowerCase()).endsWith(".torrent") || VuzeFileHandler.isAcceptedVuzeFileName(name)) && (uif = UIFunctionsManagerSWT.getUIFunctionsSWT()) != null) {
                    uif.openTorrentOpenOptions(null, null, new String[]{f.getAbsolutePath()}, false, false);
                    return true;
                }
            }
            catch (Throwable f) {
                // empty catch block
            }
            return false;
        }
        try {
            URL hit_url = new URL(hit);
            String protocol = hit_url.getProtocol().toLowerCase(Locale.US);
            URL url = protocol.equals("tor") || protocol.equals("i2p") ? new URL(hit.substring(4)) : hit_url;
            String path = url.getPath();
            if ((path.length() == 0 || path.equals("/")) && url.getQuery() == null) {
                Utils.launch(hit_url.toExternalForm());
                return true;
            }
        }
        catch (Throwable hit_url) {
            // empty catch block
        }
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        new FileDownloadWindow(uiFunctions.getMainShell(), hit, null, null, true);
        return true;
    }

    @Override
    public void promptForSearch() {
        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("Button.search", "search.dialog.text");
        entryWindow.prompt(new UIInputReceiverListener(){

            @Override
            public void UIInputReceiverClosed(UIInputReceiver receiver) {
                if (receiver.hasSubmittedInput()) {
                    UIFunctionsImpl.this.doSearch(receiver.getSubmittedInput());
                }
            }
        });
    }

    @Override
    public MultipleDocumentInterface getMDI() {
        return (MultipleDocumentInterface)((Object)SkinViewManager.getByViewID("mdi"));
    }

    @Override
    public MultipleDocumentInterfaceSWT getMDISWT() {
        return (MultipleDocumentInterfaceSWT)((Object)SkinViewManager.getByViewID("mdi"));
    }

    @Override
    public void showErrorMessage(final String keyPrefix, final String details, final String[] textParams) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                Shell mainShell = UIFunctionsImpl.this.getMainShell();
                if (mainShell.getDisplay().getActiveShell() != null || mainShell.isFocusControl()) {
                    new MessageSlideShell(Display.getCurrent(), 1, keyPrefix, details, textParams, -1);
                } else {
                    MessageBoxShell mb = new MessageBoxShell(32, keyPrefix, textParams);
                    mb.open(null);
                }
            }
        });
    }

    @Override
    public void forceNotify(final int iconID, final String title, final String text, final String details, final Object[] relatedObjects, final int timeoutSecs) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                int swtIconID = 2;
                switch (iconID) {
                    case 1: {
                        swtIconID = 8;
                        break;
                    }
                    case 2: {
                        swtIconID = 1;
                    }
                }
                new MessageSlideShell(Utils.getDisplay(), swtIconID, title, text, details, relatedObjects, timeoutSecs);
            }
        });
    }

    @Override
    public void installPlugin(String plugin_id, String resource_prefix, UIFunctions.actionListener listener) {
        new SimplePluginInstaller(plugin_id, resource_prefix, listener);
    }

    @Override
    public UIToolBarManager getToolBarManager() {
        return UIToolBarManagerImpl.getInstance();
    }

    @Override
    public void runOnUIThread(String ui_type, Runnable runnable) {
        if (ui_type.equals("swt")) {
            Utils.execSWTThread(runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    public boolean isUIThread() {
        return Utils.isSWTThread();
    }

    @Override
    public boolean isProgramInstalled(String extension, String name) {
        Program program;
        if (!extension.startsWith(".")) {
            extension = "." + extension;
        }
        return (program = Program.findProgram((String)extension)) == null ? false : program.getName().toLowerCase(Locale.US).contains(name.toLowerCase(Locale.US));
    }

    @Override
    public void openRemotePairingWindow() {
        RemotePairingWindow.open();
    }

    @Override
    public void playOrStreamDataSource(Object ds, String referal, boolean launch_already_checked, boolean complete_only) {
        TorrentListViewsUtils.playOrStreamDataSource(ds, referal, launch_already_checked, complete_only);
    }

    @Override
    public void setHideAll(boolean hidden) {
        this.mainWindow.setHideAll(hidden);
    }

    @Override
    public boolean getHideAll() {
        return this.mainWindow.getHideAll();
    }

    @Override
    public boolean addTorrentWithOptions(boolean force, TorrentOpenOptions torrentOptions) {
        HashMap<String, Object> add_options = new HashMap<String, Object>();
        add_options.put("forceOpen", force);
        return this.addTorrentWithOptions(torrentOptions, add_options);
    }

    @Override
    public boolean addTorrentWithOptions(TorrentOpenOptions torrentOptions, Map<String, Object> addOptions) {
        Boolean is_silent = (Boolean)addOptions.get("silent");
        if (is_silent == null) {
            is_silent = false;
        }
        if (CoreFactory.isCoreRunning()) {
            Core core;
            block26: {
                DownloadStub archived;
                block27: {
                    TOTorrent torrent;
                    core = CoreFactory.getSingleton();
                    GlobalManager gm = core.getGlobalManager();
                    DownloadManager existingDownload = gm.getDownloadManager(torrent = torrentOptions.getTorrent());
                    if (existingDownload != null && existingDownload.getDownloadState().getFlag(512L)) {
                        try {
                            gm.removeDownloadManager(existingDownload, true, true);
                            existingDownload = null;
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                    if (existingDownload != null) {
                        boolean delete_delegated = false;
                        if (!is_silent.booleanValue()) {
                            boolean can_merge_private;
                            String fExistingName = existingDownload.getDisplayName();
                            DownloadManager fExistingDownload = existingDownload;
                            fExistingDownload.fireGlobalManagerEvent(1);
                            TOTorrent new_torrent = torrentOptions.getTorrent();
                            TOTorrent existing_torrent = fExistingDownload.getTorrent();
                            boolean can_merge = TorrentUtils.canMergeAnnounceURLs(new_torrent, existing_torrent);
                            delete_delegated = can_merge_private = can_merge && new_torrent.getPrivate();
                            if (can_merge_private) {
                                String text_base = MessageText.getString("OpenTorrentWindow.mb.alreadyExists.text", new String[]{":" + torrentOptions.sOriginatingLocation, fExistingName, MessageText.getString(MSG_ALREADY_EXISTS_NAME)});
                                String text = String.valueOf(text_base) + "\n\n" + MessageText.getString("openTorrentWindow.mb.alreadyExists.add.dup");
                                UIFunctionsUserPrompter promptSepDL = this.getUserPrompter(MessageText.getString("OpenTorrentWindow.mb.alreadyExists.title"), text, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 1);
                                promptSepDL.open(result -> {
                                    if (result == 0) {
                                        try {
                                            String new_file_name;
                                            File tmp_dir = AETemporaryFileHandler.getTempDirectory();
                                            byte[] hash_ov = RandomUtils.nextSecureHash();
                                            String hash_str = ByteFormatter.encodeString(hash_ov, 0, 4);
                                            if (torrentOptions.getTorrentFile() == null) {
                                                new_file_name = hash_str;
                                            } else {
                                                new_file_name = new File(torrentOptions.getTorrentFile()).getName();
                                                int pos = new_file_name.lastIndexOf(".");
                                                if (pos != -1) {
                                                    new_file_name = new_file_name.substring(0, pos);
                                                }
                                                new_file_name = String.valueOf(new_file_name) + "_" + hash_str;
                                            }
                                            new_file_name = String.valueOf(new_file_name) + ".torrent";
                                            File new_file = new File(tmp_dir, new_file_name);
                                            byte[] existing_hash = torrent.getHash();
                                            torrent.setHashOverride(hash_ov);
                                            TorrentUtils.setOriginalHash(torrent, existing_hash);
                                            torrent.serialiseToBEncodedFile(new_file);
                                            torrentOptions.setTorrentFile(new_file.getAbsolutePath());
                                            this.addTorrentWithOptionsSupport(torrentOptions, addOptions, false);
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                    } else if (existing_torrent.getPrivate()) {
                                        String text1 = String.valueOf(text_base) + "\n\n" + MessageText.getString("openTorrentWindow.mb.alreadyExists.add.replace");
                                        UIFunctionsUserPrompter promptTrackers = this.getUserPrompter(MessageText.getString("OpenTorrentWindow.mb.alreadyExists.title"), text1, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 1);
                                        promptTrackers.open(result1 -> {
                                            if (result1 == 0) {
                                                List<List<String>> new_trackers = TorrentUtils.announceGroupsToList(new_torrent);
                                                TorrentUtils.listToAnnounceGroups(new_trackers, existing_torrent);
                                            }
                                            torrentOptions.deleteTorrent();
                                        });
                                    } else {
                                        torrentOptions.deleteTorrent();
                                    }
                                });
                            } else {
                                long existed_for = SystemTime.getCurrentTime() - fExistingDownload.getCreationTime();
                                if (this.getVisibilityState() != 4 && !can_merge) {
                                    if (existed_for > 15000L) {
                                        this.forceNotify(0, MessageText.getString("OpenTorrentWindow.mb.alreadyExists.title"), MessageText.getString("OpenTorrentWindow.mb.alreadyExists.text", new String[]{":" + torrentOptions.sOriginatingLocation, fExistingName, MessageText.getString(MSG_ALREADY_EXISTS_NAME)}), null, new Object[]{fExistingDownload}, -1);
                                    }
                                } else if (can_merge) {
                                    String text = MessageText.getString("OpenTorrentWindow.mb.alreadyExists.text", new String[]{":" + torrentOptions.sOriginatingLocation, fExistingName, MessageText.getString(MSG_ALREADY_EXISTS_NAME)});
                                    text = String.valueOf(text) + "\n\n" + MessageText.getString("openTorrentWindow.mb.alreadyExists.merge");
                                    UIFunctionsUserPrompter promptTrackers = this.getUserPrompter(MessageText.getString("OpenTorrentWindow.mb.alreadyExists.title"), text, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 0);
                                    promptTrackers.open(result -> {
                                        if (result == 0) {
                                            TorrentUtils.mergeAnnounceURLs(torrentOptions.getTorrent(), fExistingDownload.getTorrent());
                                        }
                                    });
                                } else if (existed_for > 15000L) {
                                    TorrentUIUtilsV3.showTorrentAlreadyAdded(":" + torrentOptions.sOriginatingLocation, fExistingName);
                                }
                            }
                        }
                        if (!delete_delegated) {
                            torrentOptions.deleteTorrent();
                        }
                        return true;
                    }
                    archived = core.getPluginManager().getDefaultPluginInterface().getDownloadManager().lookupDownloadStub(torrent.getHash());
                    if (archived == null) break block26;
                    if (!is_silent.booleanValue()) break block27;
                    archived.destubbify();
                    torrentOptions.deleteTorrent();
                    return true;
                }
                try {
                    String existingName = archived.getName();
                    if (this.getVisibilityState() != 4) {
                        this.forceNotify(0, MessageText.getString("OpenTorrentWindow.mb.inArchive.title"), MessageText.getString("OpenTorrentWindow.mb.inArchive.text", new String[]{existingName}), null, new Object[0], -1);
                    } else {
                        this.getUserPrompter(MessageText.getString("OpenTorrentWindow.mb.inArchive.title"), MessageText.getString("OpenTorrentWindow.mb.inArchive.text", new String[]{existingName}), new String[]{MessageText.getString("Button.ok")}, 0).open(null);
                    }
                    return true;
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            if (!is_silent.booleanValue()) {
                try {
                    DownloadHistoryManager dlm = (DownloadHistoryManager)core.getGlobalManager().getDownloadHistoryManager();
                    long[] existing = dlm.getDates(torrentOptions.getTorrent().getHash(), true);
                    if (existing != null) {
                        long redownloaded = existing[3];
                        if (SystemTime.getCurrentTime() - redownloaded > 600000L && this.getVisibilityState() != 1) {
                            this.forceNotify(0, MessageText.getString("OpenTorrentWindow.mb.inHistory.title"), MessageText.getString("OpenTorrentWindow.mb.inHistory.text", new String[]{torrentOptions.getTorrentName(), new SimpleDateFormat().format(new Date(existing[0]))}), null, new Object[0], -1);
                        }
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
        return this.addTorrentWithOptionsSupport(torrentOptions, addOptions, is_silent);
    }

    private boolean addTorrentWithOptionsSupport(TorrentOpenOptions torrentOptions, Map<String, Object> addOptions, boolean is_silent) {
        Boolean force = (Boolean)addOptions.get("forceOpen");
        if (force == null) {
            force = false;
        }
        if (!force.booleanValue()) {
            TOTorrent torrent = torrentOptions.getTorrent();
            boolean is_featured = torrent != null && PlatformTorrentUtils.isFeaturedContent(torrent);
            String showAgainMode = COConfigurationManager.getStringParameter("ui.addtorrent.openoptions");
            if (is_featured || is_silent || "never".equals(showAgainMode) || "many".equals(showAgainMode) && torrentOptions.getFiles() != null && torrentOptions.getFiles().length == 1) {
                boolean looks_good = false;
                String save_loc = torrentOptions.getParentDir().trim();
                if (save_loc.length() != 0 && !save_loc.startsWith(".")) {
                    File f = new File(save_loc);
                    if (!f.exists()) {
                        f.mkdirs();
                    }
                    if (f.isDirectory() && FileUtil.canWriteToDirectory(f) && !f.equals(AETemporaryFileHandler.getTempDirectory())) {
                        looks_good = true;
                    }
                }
                if (looks_good) {
                    TorrentManagerImpl t_man = TorrentManagerImpl.getSingleton();
                    t_man.optionsAdded(torrentOptions);
                    t_man.optionsAccepted(torrentOptions);
                    boolean ok = torrentOptions.addToDownloadManager();
                    t_man.optionsRemoved(torrentOptions);
                    return ok;
                }
                torrentOptions.setParentDir("");
                if (is_silent) {
                    return false;
                }
                UIFunctionsUserPrompter mb = this.getUserPrompter(MessageText.getString("OpenTorrentWindow.mb.invaliddefsave.title"), MessageText.getString("OpenTorrentWindow.mb.invaliddefsave.text", new String[]{save_loc}), new String[]{MessageText.getString("Button.ok")}, 0);
                mb.setIconResource("error");
                mb.open(res -> OpenTorrentOptionsWindow.addTorrent(torrentOptions));
                return true;
            }
        }
        if (is_silent) {
            return false;
        }
        OpenTorrentOptionsWindow.addTorrent(torrentOptions);
        return true;
    }

    @Override
    public void openTorrentOpenOptions(Shell shell, String sPathOfFilesToOpen, String[] sFilesToOpen, boolean defaultToStopped, boolean forceOpen) {
        TorrentOpenOptions torrentOptions = new TorrentOpenOptions(null);
        if (defaultToStopped) {
            torrentOptions.setStartMode(1);
        }
        if (sFilesToOpen == null) {
            new OpenTorrentWindow(shell);
        } else {
            TorrentOpener.openTorrentsFromStrings(torrentOptions, shell, sPathOfFilesToOpen, sFilesToOpen, null, null, forceOpen);
        }
    }

    @Override
    public void openTorrentOpenOptions(Shell shell, String sPathOfFilesToOpen, String[] sFilesToOpen, Map<String, Object> options) {
        Boolean _defaultToStopped = (Boolean)options.get("defaultStopped");
        boolean defaultToStopped = _defaultToStopped != null ? _defaultToStopped : false;
        Boolean _hideErrors = (Boolean)options.get("hideErrors");
        boolean hideErrors = _hideErrors != null ? _hideErrors : false;
        TorrentOpenOptions torrentOptions = new TorrentOpenOptions(options);
        if (defaultToStopped) {
            torrentOptions.setStartMode(1);
        }
        torrentOptions.setHideErrors(hideErrors);
        if (sFilesToOpen == null) {
            new OpenTorrentWindow(shell);
        } else {
            Boolean _forceOpen = (Boolean)options.get("forceOpen");
            boolean forceOpen = _forceOpen != null ? _forceOpen : false;
            TorrentOpener.openTorrentsFromStrings(torrentOptions, shell, sPathOfFilesToOpen, sFilesToOpen, null, null, forceOpen);
        }
    }

    @Override
    public void openTorrentWindow() {
        new OpenTorrentWindow(Utils.findAnyShell());
    }

    @Override
    public void showCreateTagDialog(UIFunctions.TagReturner tagReturner) {
        TagUIUtilsV3.showCreateTagDialog(tagReturner);
    }

    @Override
    public void tableColumnAddedListeners(TableColumnImpl tableColumn, Object listeners) {
        if (listeners instanceof TableCellSWTPaintListener) {
            tableColumn.addCellOtherListener("SWTPaint", listeners);
        }
    }

    @Override
    public void copyToClipboard(String text) {
        ClipboardCopy.copyToClipBoard(text);
    }

    @Override
    public void showInExplorer(File f) {
        Utils.execSWTThread(() -> ManagerUtils.open(f));
    }

    @Override
    public void showText(String title, String content) {
        Utils.execSWTThread(() -> new TextViewerWindow(title, null, content, false));
    }

    public void dispose() {
        COConfigurationManager.removeParameterListener("show_torrents_menu", this.paramShowTorrentsMenuListener);
    }
}

