/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.shells;

import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class SpeedScaleShell {
    private static final boolean MOUSE_ONLY_UP_EXITS = true;
    private static final int AD_ACCEPT_DELAY = 500;
    private int OPTION_HEIGHT = 15;
    private int TEXT_HEIGHT = 32;
    private int SCALER_HEIGHT = 20;
    private int HEIGHT = this.TEXT_HEIGHT + this.SCALER_HEIGHT;
    private int MIN_WIDTH = 130;
    private int PADDING_X0 = 10;
    private int PADDING_X1 = 10;
    private int MARKER_HEIGHT = 10;
    private int MARKER_WIDTH = 5;
    private int PX_5 = 5;
    private int PX_2 = 2;
    private int PX_10 = 10;
    private static final int TYPED_TEXT_ALPHA = 180;
    private static final long CLOSE_DELAY = 600L;
    private int WIDTH;
    private int WIDTH_NO_PADDING;
    private int value;
    private boolean cancelled = true;
    private int minValue = 0;
    private int maxValue = -1;
    private int maxTextValue = -1;
    private int pageIncrement = 10;
    private int bigPageIncrement = 100;
    private Shell shell;
    private Shell parentShell;
    private LinkedHashMap mapOptions = new LinkedHashMap();
    private String sValue = "";
    private Composite composite;
    private boolean menuChosen = false;
    protected boolean lastMoveHadMouseDown;
    private boolean assumeInitiallyDown;
    private TimerEventPerformer cursorBlinkPerformer = null;
    private TimerEvent cursorBlinkEvent = null;

    public boolean open(final Control cClickedFrom, final int startValue, boolean _assumeInitiallyDown) {
        final long openTime = SystemTime.getMonotonousTime();
        this.value = startValue;
        this.assumeInitiallyDown = _assumeInitiallyDown;
        if (this.assumeInitiallyDown) {
            this.lastMoveHadMouseDown = true;
        }
        this.cancelled = true;
        this.shell = new Shell(this.parentShell == null ? Utils.findAnyShell() : this.parentShell, 0x20004000);
        this.shell.setLayout((Layout)new FillLayout());
        final Display display = this.shell.getDisplay();
        this.composite = new Composite((Composite)this.shell, 0x20000000);
        GC gc = new GC((Drawable)this.composite);
        gc.setAntialias(1);
        this.WIDTH = this.MIN_WIDTH;
        Rectangle r = new Rectangle(0, 0, 9999, 20);
        for (Integer value : this.mapOptions.keySet()) {
            String text = (String)this.mapOptions.get(value);
            String s = this.getStringValue(value, text);
            GCStringPrinter stringPrinter = new GCStringPrinter(gc, s, r, 0, 0);
            stringPrinter.calculateMetrics();
            Point size = stringPrinter.getCalculatedSize();
            size.x = (int)((double)size.x * 1.1);
            if (this.WIDTH >= size.x) continue;
            this.WIDTH = size.x;
        }
        gc.dispose();
        this.WIDTH_NO_PADDING = this.WIDTH - this.PADDING_X0 - this.PADDING_X1;
        final Point firstMousePos = display.getCursorLocation();
        this.composite.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    SpeedScaleShell.this.setCancelled(true);
                    SpeedScaleShell.this.shell.dispose();
                } else if (e.detail == 64) {
                    SpeedScaleShell.this.setValue(SpeedScaleShell.this.value + 1);
                } else if (e.detail == 32) {
                    SpeedScaleShell.this.setValue(SpeedScaleShell.this.value - 1);
                } else if (e.detail == 512) {
                    SpeedScaleShell.this.setValue(SpeedScaleShell.this.value + SpeedScaleShell.this.bigPageIncrement);
                } else if (e.detail == 256) {
                    SpeedScaleShell.this.setValue(SpeedScaleShell.this.value - SpeedScaleShell.this.bigPageIncrement);
                } else if (e.detail == 4) {
                    SpeedScaleShell.this.setCancelled(false);
                    SpeedScaleShell.this.shell.dispose();
                }
            }
        });
        this.composite.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000006 && e.stateMask == 0) {
                    SpeedScaleShell.this.setValue(SpeedScaleShell.this.value + SpeedScaleShell.this.pageIncrement);
                } else if (e.keyCode == 0x1000005 && e.stateMask == 0) {
                    SpeedScaleShell.this.setValue(SpeedScaleShell.this.value - SpeedScaleShell.this.pageIncrement);
                } else if (e.keyCode == 0x1000007) {
                    SpeedScaleShell.this.setValue(SpeedScaleShell.this.minValue);
                } else if (e.keyCode == 0x1000008 && SpeedScaleShell.this.maxValue != -1) {
                    SpeedScaleShell.this.setValue(SpeedScaleShell.this.maxValue);
                }
            }
        });
        final MouseMoveListener mouseMoveListener = new MouseMoveListener(){
            private MouseEvent pending_event;

            public void mouseMove(final MouseEvent e) {
                boolean hasButtonDown;
                long now = SystemTime.getMonotonousTime();
                long rem = now - openTime;
                if (SpeedScaleShell.this.assumeInitiallyDown && rem < 500L) {
                    this.pending_event = e;
                    SimpleTimer.addEvent("updater", SystemTime.getOffsetTime(600L), new TimerEventPerformer(){

                        @Override
                        public void perform(TimerEvent event2) {
                            Utils.execSWTThread(new AERunnable(){

                                @Override
                                public void runSupport() {
                                    if (pending_event == e) {
                                        pending_event = null;
                                        if (!SpeedScaleShell.this.composite.isDisposed()) {
                                            this.mouseMove(e);
                                        }
                                    }
                                }
                            });
                        }
                    });
                    return;
                }
                this.pending_event = null;
                Point ptOnDisplay = ((Control)e.widget).toDisplay(e.x, e.y);
                Point ptOnComposite = SpeedScaleShell.this.composite.toControl(ptOnDisplay);
                SpeedScaleShell.this.lastMoveHadMouseDown = false;
                boolean bl = hasButtonDown = (e.stateMask & SWT.BUTTON_MASK) > 0 || SpeedScaleShell.this.assumeInitiallyDown;
                if (hasButtonDown) {
                    if (ptOnComposite.y > SpeedScaleShell.this.HEIGHT - SpeedScaleShell.this.SCALER_HEIGHT) {
                        SpeedScaleShell.this.lastMoveHadMouseDown = true;
                        SpeedScaleShell.this.setValue(SpeedScaleShell.this.getValueFromMousePos(ptOnComposite.x));
                    }
                    SpeedScaleShell.this.composite.redraw();
                } else {
                    SpeedScaleShell.this.composite.redraw();
                }
            }
        };
        this.composite.addMouseMoveListener(mouseMoveListener);
        this.composite.addMouseTrackListener(new MouseTrackListener(){
            boolean mouseIsOut = false;
            private boolean exitCancelled = false;

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                if (SpeedScaleShell.this.composite.equals(Utils.getCursorControl())) {
                    return;
                }
                this.mouseIsOut = true;
                SimpleTimer.addEvent("close scaler", SystemTime.getOffsetTime(600L), new TimerEventPerformer(){

                    @Override
                    public void perform(TimerEvent event2) {
                        Utils.execSWTThread(new AERunnable(){

                            @Override
                            public void runSupport() {
                                if (!exitCancelled) {
                                    SpeedScaleShell.this.shell.dispose();
                                } else {
                                    exitCancelled = false;
                                }
                            }
                        });
                    }
                });
            }

            public void mouseEnter(MouseEvent e) {
                if (this.mouseIsOut) {
                    this.exitCancelled = true;
                }
                this.mouseIsOut = false;
            }
        });
        final MouseListener mouseListener = new MouseListener(){
            boolean bMouseDown = false;

            public void mouseUp(MouseEvent e) {
                Point mousePos;
                boolean temp = SpeedScaleShell.this.assumeInitiallyDown;
                Point ptOnDisplay = ((Control)e.widget).toDisplay(e.x, e.y);
                Point ptOnComposite = SpeedScaleShell.this.composite.toControl(ptOnDisplay);
                if (SpeedScaleShell.this.assumeInitiallyDown && e.widget == SpeedScaleShell.this.composite) {
                    SpeedScaleShell.this.assumeInitiallyDown = false;
                }
                if (SpeedScaleShell.this.lastMoveHadMouseDown && (mousePos = display.getCursorLocation()).equals((Object)firstMousePos)) {
                    return;
                }
                this.bMouseDown = true;
                if (this.bMouseDown) {
                    long now = SystemTime.getMonotonousTime();
                    if (temp && now - openTime < 500L) {
                        return;
                    }
                    if (ptOnComposite.y > SpeedScaleShell.this.HEIGHT - SpeedScaleShell.this.SCALER_HEIGHT) {
                        SpeedScaleShell.this.setValue(SpeedScaleShell.this.getValueFromMousePos(ptOnComposite.x));
                        SpeedScaleShell.this.setCancelled(false);
                        if (SpeedScaleShell.this.lastMoveHadMouseDown) {
                            SpeedScaleShell.this.shell.dispose();
                        }
                    } else if (ptOnComposite.y > SpeedScaleShell.this.TEXT_HEIGHT) {
                        int newValue;
                        int idx = (ptOnComposite.y - SpeedScaleShell.this.TEXT_HEIGHT) / SpeedScaleShell.this.OPTION_HEIGHT;
                        Iterator iterator = SpeedScaleShell.this.mapOptions.keySet().iterator();
                        do {
                            newValue = (Integer)iterator.next();
                        } while (--idx >= 0);
                        SpeedScaleShell.this.value = newValue;
                        SpeedScaleShell.this.setCancelled(false);
                        SpeedScaleShell.this.setMenuChosen(true);
                        SpeedScaleShell.this.shell.dispose();
                    }
                }
            }

            public void mouseDown(MouseEvent e) {
                Point ptOnDisplay = ((Control)e.widget).toDisplay(e.x, e.y);
                Point ptOnComposite = SpeedScaleShell.this.composite.toControl(ptOnDisplay);
                if (e.count > 1) {
                    SpeedScaleShell.this.lastMoveHadMouseDown = true;
                    return;
                }
                Point mousePos = display.getCursorLocation();
                if (ptOnComposite.y > SpeedScaleShell.this.HEIGHT - SpeedScaleShell.this.SCALER_HEIGHT) {
                    this.bMouseDown = true;
                    SpeedScaleShell.this.setValue(SpeedScaleShell.this.getValueFromMousePos(e.x));
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
        this.composite.addMouseListener(mouseListener);
        if (cClickedFrom != null) {
            cClickedFrom.addMouseListener(mouseListener);
            cClickedFrom.addMouseMoveListener(mouseMoveListener);
            this.composite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent arg0) {
                    cClickedFrom.removeMouseListener(mouseListener);
                    cClickedFrom.removeMouseMoveListener(mouseMoveListener);
                }
            });
        }
        this.composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int valueRange = SpeedScaleShell.this.maxValue - SpeedScaleShell.this.minValue;
                int x = SpeedScaleShell.this.WIDTH_NO_PADDING * (SpeedScaleShell.this.value - SpeedScaleShell.this.minValue) / valueRange;
                if (x < 0) {
                    x = 0;
                } else if (x > SpeedScaleShell.this.WIDTH_NO_PADDING) {
                    x = SpeedScaleShell.this.WIDTH_NO_PADDING;
                }
                int startX = SpeedScaleShell.this.WIDTH_NO_PADDING * (startValue - SpeedScaleShell.this.minValue) / valueRange;
                if (startX < 0) {
                    startX = 0;
                } else if (startX > SpeedScaleShell.this.WIDTH_NO_PADDING) {
                    startX = SpeedScaleShell.this.WIDTH_NO_PADDING;
                }
                int baseLinePos = SpeedScaleShell.this.getBaselinePos();
                try {
                    e.gc.setAdvanced(true);
                    e.gc.setAntialias(1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                e.gc.setLineWidth(1);
                e.gc.setForeground(Colors.getSystemColor((Device)display, 18));
                e.gc.drawLine(SpeedScaleShell.this.PADDING_X0, baseLinePos - 6, SpeedScaleShell.this.PADDING_X0, baseLinePos + 6);
                e.gc.drawLine(SpeedScaleShell.this.PADDING_X0 + SpeedScaleShell.this.WIDTH_NO_PADDING, baseLinePos - 6, SpeedScaleShell.this.PADDING_X0 + SpeedScaleShell.this.WIDTH_NO_PADDING, baseLinePos + 6);
                e.gc.drawLine(SpeedScaleShell.this.PADDING_X0, baseLinePos, SpeedScaleShell.this.PADDING_X0 + SpeedScaleShell.this.WIDTH_NO_PADDING, baseLinePos);
                e.gc.setForeground(Colors.getSystemColor((Device)display, 21));
                e.gc.setBackground(Colors.getSystemColor((Device)display, 21));
                e.gc.drawLine(SpeedScaleShell.this.PADDING_X0 + startX, baseLinePos - SpeedScaleShell.this.PX_5, SpeedScaleShell.this.PADDING_X0 + startX, baseLinePos + SpeedScaleShell.this.PX_5);
                e.gc.fillRoundRectangle(SpeedScaleShell.this.PADDING_X0 + x - SpeedScaleShell.this.PX_2, baseLinePos - SpeedScaleShell.this.PX_5, SpeedScaleShell.this.MARKER_WIDTH, SpeedScaleShell.this.MARKER_HEIGHT, SpeedScaleShell.this.MARKER_HEIGHT, SpeedScaleShell.this.MARKER_HEIGHT);
                e.gc.setForeground(Colors.getSystemColor((Device)display, 28));
                e.gc.setBackground(Colors.getSystemColor((Device)display, 29));
                e.gc.fillRectangle(0, 0, SpeedScaleShell.this.WIDTH, SpeedScaleShell.this.TEXT_HEIGHT);
                GCStringPrinter.printString(e.gc, SpeedScaleShell.this._getStringValue(), new Rectangle(0, 0, SpeedScaleShell.this.WIDTH, SpeedScaleShell.this.HEIGHT), true, false, 0x10000C0);
                e.gc.drawLine(0, SpeedScaleShell.this.TEXT_HEIGHT, SpeedScaleShell.this.WIDTH, SpeedScaleShell.this.TEXT_HEIGHT);
                int y = SpeedScaleShell.this.TEXT_HEIGHT;
                Point mousePos = SpeedScaleShell.this.composite.toControl(display.getCursorLocation());
                for (Integer value : SpeedScaleShell.this.mapOptions.keySet()) {
                    Color saveColor;
                    Color bg;
                    String text = (String)SpeedScaleShell.this.mapOptions.get(value);
                    e.gc.setAntialias(1);
                    Rectangle area = new Rectangle(0, y, SpeedScaleShell.this.WIDTH, SpeedScaleShell.this.OPTION_HEIGHT);
                    if (area.contains(mousePos)) {
                        bg = Colors.getSystemColor((Device)display, 26);
                        e.gc.setBackground(bg);
                        e.gc.setForeground(Colors.getSystemColor((Device)display, 27));
                        e.gc.fillRectangle(area);
                    } else {
                        bg = Colors.getSystemColor((Device)display, 25);
                        e.gc.setBackground(bg);
                        e.gc.setForeground(Colors.getSystemColor((Device)display, 24));
                    }
                    int ovalGap = 6;
                    float ovalPadding = (float)ovalGap / 2.0f;
                    int ovalSize = SpeedScaleShell.this.OPTION_HEIGHT - ovalGap;
                    float xCenter = (float)ovalSize / 2.0f + (float)SpeedScaleShell.this.PX_2;
                    float yCenter = (float)ovalSize / 2.0f + ovalPadding;
                    if (SpeedScaleShell.this.getValue() == value.intValue()) {
                        saveColor = e.gc.getBackground();
                        e.gc.setBackground(e.gc.getForeground());
                        float ovalSizeMini = (float)ovalSize - (float)ovalGap / 2.0f;
                        int xMiniOval = (int)Math.round((double)xCenter - (double)ovalSizeMini / 2.0);
                        int yMiniOval = (int)Math.round((double)yCenter - (double)ovalSizeMini / 2.0);
                        e.gc.fillOval(xMiniOval, y + yMiniOval, Math.round(ovalSizeMini), Math.round(ovalSizeMini));
                        e.gc.setBackground(saveColor);
                    }
                    if (Constants.isLinux) {
                        saveColor = e.gc.getForeground();
                        e.gc.setForeground(bg);
                        e.gc.drawPoint(SpeedScaleShell.this.PX_2, (int)((float)y + ovalPadding));
                        e.gc.setForeground(saveColor);
                    }
                    e.gc.drawOval(SpeedScaleShell.this.PX_2, (int)((float)y + ovalPadding), ovalSize, ovalSize);
                    GCStringPrinter.printString(e.gc, text, new Rectangle(SpeedScaleShell.this.OPTION_HEIGHT, y, SpeedScaleShell.this.WIDTH - SpeedScaleShell.this.OPTION_HEIGHT, SpeedScaleShell.this.OPTION_HEIGHT), true, false, 16384);
                    y += SpeedScaleShell.this.OPTION_HEIGHT;
                }
                if (SpeedScaleShell.this.sValue.length() > 0) {
                    Point extent = e.gc.textExtent(SpeedScaleShell.this.sValue);
                    if (extent.x > SpeedScaleShell.this.WIDTH - SpeedScaleShell.this.PX_10) {
                        extent.x = SpeedScaleShell.this.WIDTH - SpeedScaleShell.this.PX_10;
                    }
                    int yTypedValue = 15;
                    Rectangle rect = new Rectangle(SpeedScaleShell.this.WIDTH - (SpeedScaleShell.this.PX_10 - 2) - extent.x, yTypedValue - 1, extent.x + SpeedScaleShell.this.PX_5, extent.y + (SpeedScaleShell.this.PX_5 - 1) + (yTypedValue - 1) > SpeedScaleShell.this.TEXT_HEIGHT ? SpeedScaleShell.this.TEXT_HEIGHT - yTypedValue : extent.y + (SpeedScaleShell.this.PX_5 - 1));
                    e.gc.setBackground(Colors.getSystemColor((Device)display, 29));
                    e.gc.fillRectangle(rect);
                    try {
                        e.gc.setAlpha(180);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    e.gc.setForeground(Colors.getSystemColor((Device)display, 28));
                    GCStringPrinter.printString(e.gc, SpeedScaleShell.this.sValue, new Rectangle(rect.x + SpeedScaleShell.this.PX_2, rect.y + SpeedScaleShell.this.PX_2, SpeedScaleShell.this.WIDTH - SpeedScaleShell.this.PX_5, SpeedScaleShell.this.OPTION_HEIGHT), true, false, 17408);
                }
            }
        });
        final AERunnable cursorBlinkRunnable = new AERunnable(){
            boolean on = false;

            @Override
            public void runSupport() {
                if (SpeedScaleShell.this.composite.isDisposed()) {
                    return;
                }
                this.on = !this.on;
                GC gc = new GC((Drawable)SpeedScaleShell.this.composite);
                try {
                    gc.setLineWidth(SpeedScaleShell.this.PX_2);
                    if (!this.on) {
                        gc.setForeground(Colors.getSystemColor((Device)display, 29));
                    } else {
                        try {
                            gc.setForeground(Colors.getSystemColor((Device)display, 28));
                            gc.setAlpha(180);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    int y = 15;
                    gc.drawLine(SpeedScaleShell.this.WIDTH - SpeedScaleShell.this.PX_5, y + 1, SpeedScaleShell.this.WIDTH - SpeedScaleShell.this.PX_5, y + SpeedScaleShell.this.OPTION_HEIGHT);
                }
                finally {
                    gc.dispose();
                }
                if (SpeedScaleShell.this.cursorBlinkPerformer != null) {
                    SpeedScaleShell.this.cursorBlinkEvent = SimpleTimer.addEvent("BlinkingCursor", SystemTime.getOffsetTime(500L), SpeedScaleShell.this.cursorBlinkPerformer);
                }
            }
        };
        this.cursorBlinkPerformer = new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent event2) {
                Utils.execSWTThread(cursorBlinkRunnable);
            }
        };
        this.cursorBlinkEvent = SimpleTimer.addEvent("BlinkingCursor", SystemTime.getOffsetTime(500L), this.cursorBlinkPerformer);
        this.composite.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (Character.isDigit(e.character)) {
                    SpeedScaleShell speedScaleShell = SpeedScaleShell.this;
                    speedScaleShell.sValue = String.valueOf(speedScaleShell.sValue) + e.character;
                } else if (e.keyCode == 8 && SpeedScaleShell.this.sValue.length() > 0) {
                    SpeedScaleShell.this.sValue = SpeedScaleShell.this.sValue.substring(0, SpeedScaleShell.this.sValue.length() - 1);
                } else {
                    return;
                }
                try {
                    int newValue = Integer.parseInt(SpeedScaleShell.this.sValue);
                    if (SpeedScaleShell.this.maxTextValue == -1) {
                        SpeedScaleShell.this.setValue(newValue);
                    } else {
                        if (SpeedScaleShell.this.minValue > 0 && newValue < SpeedScaleShell.this.minValue) {
                            newValue = SpeedScaleShell.this.minValue;
                        }
                        if (newValue > SpeedScaleShell.this.maxTextValue) {
                            newValue = SpeedScaleShell.this.maxTextValue;
                        }
                        SpeedScaleShell.this.value = newValue;
                        SpeedScaleShell.this.composite.redraw();
                    }
                }
                catch (Exception ex) {
                    SpeedScaleShell.this.setValue(startValue);
                }
            }
        });
        Point location = display.getCursorLocation();
        location.y -= this.getBaselinePos();
        int x = (int)((double)this.WIDTH_NO_PADDING * (this.value > this.maxValue ? 1.0 : (double)this.value / (double)this.maxValue - (double)this.minValue));
        location.x -= this.PADDING_X0 + x;
        Rectangle bounds = new Rectangle(location.x, location.y, this.WIDTH, this.HEIGHT);
        Monitor mouseMonitor = this.shell.getMonitor();
        Monitor[] monitors = display.getMonitors();
        int i = 0;
        while (i < monitors.length) {
            Monitor monitor = monitors[i];
            if (monitor.getBounds().contains(location)) {
                mouseMonitor = monitor;
                break;
            }
            ++i;
        }
        Rectangle monitorBounds = mouseMonitor.getBounds();
        Rectangle intersection = monitorBounds.intersection(bounds);
        if (intersection.width != bounds.width) {
            bounds.x = monitorBounds.x + monitorBounds.width - this.WIDTH;
            bounds.width = this.WIDTH;
        }
        if (intersection.height != bounds.height) {
            bounds.y = monitorBounds.y + monitorBounds.height - this.HEIGHT;
            bounds.height = this.HEIGHT;
        }
        this.shell.setBounds(bounds);
        if (!bounds.contains(firstMousePos)) {
            this.shell.setLocation(firstMousePos.x - bounds.width / 2, firstMousePos.y - bounds.height + 2);
        }
        this.shell.open();
        this.composite.setFocus();
        try {
            Utils.readAndDispatchLoop((Control)this.shell);
        }
        catch (Throwable t) {
            Debug.out(t);
        }
        if (this.cursorBlinkEvent != null) {
            this.cursorBlinkEvent.cancel();
            this.cursorBlinkEvent = null;
        }
        return !this.cancelled;
    }

    protected int getValueFromMousePos(int x) {
        int x0 = x + 1;
        if (x < this.PADDING_X0) {
            x0 = this.PADDING_X0;
        } else if (x > this.PADDING_X0 + this.WIDTH_NO_PADDING) {
            x0 = this.PADDING_X0 + this.WIDTH_NO_PADDING;
        }
        return (x0 - this.PADDING_X0) * (this.maxValue - this.minValue) / this.WIDTH_NO_PADDING + this.minValue;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public void setValue(int value) {
        if (value > this.maxValue) {
            value = this.maxValue;
        } else if (value < this.minValue) {
            value = this.minValue;
        }
        this.value = value;
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.redraw();
        }
    }

    public String _getStringValue() {
        String name = (String)this.mapOptions.get(new Integer(this.value));
        return this.getStringValue(this.value, name);
    }

    public String getStringValue(int value, String sValue) {
        if (sValue != null) {
            return sValue;
        }
        return "" + value;
    }

    private int getBaselinePos() {
        return this.HEIGHT - this.SCALER_HEIGHT / 2;
    }

    public void addOption(String id, int value) {
        this.mapOptions.put(new Integer(value), id);
        this.HEIGHT += this.OPTION_HEIGHT;
    }

    public int getMaxTextValue() {
        return this.maxTextValue;
    }

    public void setMaxTextValue(int maxTextValue) {
        this.maxTextValue = maxTextValue;
    }

    public boolean wasMenuChosen() {
        return this.menuChosen;
    }

    public void setMenuChosen(boolean menuChosen) {
        this.menuChosen = menuChosen;
    }

    public void setParentShell(Shell parentShell) {
        this.parentShell = parentShell;
    }
}

