/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.shells;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.ui.UserPrompterResultListener;
import com.biglybt.ui.common.RememberedDecisionsManager;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import com.biglybt.ui.swt.mainwindow.Colors;
import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Consumer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AdvRenameWindow {
    private final DownloadManager dm;
    private Shell shell;
    private String newName = null;
    protected int renameDecisions;
    private static final int RENAME_DISPLAY = 1;
    private static final int RENAME_SAVEPATH = 2;
    private static final int RENAME_TORRENT = 4;
    private UserPrompterResultListener resultListener;
    private int result = -1;

    public static void main(String[] args) {
        AdvRenameWindow window = new AdvRenameWindow(null);
        window.open(null);
        window.waitUntilDone();
    }

    public AdvRenameWindow(DownloadManager dm) {
        this.dm = dm;
    }

    public void open() {
        this.open(null);
    }

    public void open(UserPrompterResultListener l) {
        this.resultListener = l;
        Utils.execSWTThread(this::openInSWT);
    }

    private void openInSWT() {
        this.shell = ShellFactory.createMainShell(2160);
        Utils.setShellIcon(this.shell);
        this.shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    AdvRenameWindow.this.shell.dispose();
                }
            }
        });
        this.shell.addDisposeListener(e -> this.resultListener.prompterClosed(this.result));
        Messages.setLanguageText((Widget)this.shell, "AdvRenameWindow.title");
        Label lblMessage = new Label((Composite)this.shell, 64);
        Messages.setLanguageText((Widget)lblMessage, "AdvRenameWindow.message");
        Color faded = Colors.dark_grey;
        final Text txtInput = new Text((Composite)this.shell, 2048);
        final Consumer<String> text_setter = str -> {
            txtInput.setText(str);
            if (this.dm.getDownloadState().getFlag(512L)) {
                txtInput.selectAll();
            } else {
                int pos = str.lastIndexOf(46);
                if (pos <= 0) {
                    txtInput.selectAll();
                } else {
                    String ext = str.substring(pos + 1);
                    if (ext.contains(" ")) {
                        txtInput.selectAll();
                    } else {
                        txtInput.setSelection(0, pos);
                    }
                }
            }
            txtInput.setFocus();
        };
        String display_name = this.dm.getDisplayName();
        String save_path = this.dm.getSaveLocation().getName();
        String torrent_name = new File(this.dm.getTorrentFileName()).getName();
        text_setter.accept(display_name);
        if (torrent_name.toLowerCase(Locale.US).endsWith(".torrent")) {
            torrent_name = torrent_name.substring(0, torrent_name.length() - 8);
        }
        final Button btnDisplayName = new Button((Composite)this.shell, 32);
        Messages.setLanguageText((Widget)btnDisplayName, "MyTorrentsView.menu.rename.displayed");
        Label btnDisplayValue = new Label((Composite)this.shell, 0);
        btnDisplayValue.setForeground(faded);
        btnDisplayValue.setText(display_name);
        Label btnDisplayPad = new Label((Composite)this.shell, 0);
        Button btnDisplayUse = new Button((Composite)this.shell, 8);
        Messages.setLanguageText((Widget)btnDisplayUse, "label.use");
        btnDisplayUse.setData((Object)display_name);
        final Button btnSavePath = new Button((Composite)this.shell, 32);
        Messages.setLanguageText((Widget)btnSavePath, "MyTorrentsView.menu.rename.save_path");
        Label btnSavePathValue = new Label((Composite)this.shell, 0);
        btnSavePathValue.setText(save_path);
        btnSavePathValue.setForeground(faded);
        Label btnSavePathPad = new Label((Composite)this.shell, 0);
        Button btnSavePathUse = new Button((Composite)this.shell, 8);
        Messages.setLanguageText((Widget)btnSavePathUse, "label.use");
        btnSavePathUse.setData((Object)save_path);
        final Button btnTorrent = new Button((Composite)this.shell, 32);
        Messages.setLanguageText((Widget)btnTorrent, "AdvRenameWindow.rename.torrent");
        Label btnTorrentValue = new Label((Composite)this.shell, 0);
        btnTorrentValue.setText(torrent_name);
        btnTorrentValue.setForeground(faded);
        Label btnTorrentPad = new Label((Composite)this.shell, 0);
        Button btnTorrentUse = new Button((Composite)this.shell, 8);
        Messages.setLanguageText((Widget)btnTorrentUse, "label.use");
        btnTorrentUse.setData((Object)torrent_name);
        Label separator = new Label((Composite)this.shell, 258);
        Composite cButtons = new Composite((Composite)this.shell, 0);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.fill = true;
        rowLayout.spacing = 5;
        cButtons.setLayout((Layout)rowLayout);
        Button btnReset = new Button(cButtons, 8);
        Messages.setLanguageText((Widget)btnReset, "Button.reset");
        btnReset.setLayoutData((Object)new RowData());
        btnReset.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                text_setter.accept(TorrentUtils.getLocalisedName(AdvRenameWindow.this.dm.getTorrent()));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button[] buttons = Utils.createOKCancelButtons(cButtons);
        Button btnOk = buttons[0];
        final Button btnCancel = buttons[1];
        if (this.resultListener != null) {
            btnCancel.setToolTipText(MessageText.getString("long.press.cancel.tt"));
            btnCancel.addListener(3, new Listener(){
                boolean mouseDown = false;
                TimerEvent timerEvent = null;

                public void handleEvent(Event event2) {
                    if (event2.button != 1) {
                        return;
                    }
                    if (this.timerEvent == null) {
                        this.timerEvent = SimpleTimer.addEvent("MouseHold", SystemTime.getOffsetTime(1000L), te -> {
                            this.timerEvent = null;
                            if (!this.mouseDown) {
                                return;
                            }
                            Utils.execSWTThread(() -> {
                                if (!this.mouseDown) {
                                    return;
                                }
                                if (event2.display.getCursorControl() != btnCancel) {
                                    return;
                                }
                                this.mouseDown = false;
                                AdvRenameWindow.this.shell.dispose();
                            });
                        });
                    }
                    this.mouseDown = true;
                }
            });
        }
        this.shell.setDefaultButton(btnOk);
        btnOk.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AdvRenameWindow.this.newName = txtInput.getText();
                AdvRenameWindow.this.renameDecisions = 0;
                if (btnDisplayName.getSelection()) {
                    AdvRenameWindow.this.renameDecisions |= 1;
                }
                if (btnSavePath.getSelection()) {
                    AdvRenameWindow.this.renameDecisions |= 2;
                }
                if (btnTorrent.getSelection()) {
                    AdvRenameWindow.this.renameDecisions |= 4;
                }
                RememberedDecisionsManager.setRemembered("adv.rename", AdvRenameWindow.this.renameDecisions);
                Utils.getOffOfSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        AdvRenameWindow.this.doRename();
                    }
                });
                AdvRenameWindow.this.result = 32;
                AdvRenameWindow.this.shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        btnCancel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AdvRenameWindow.this.result = 256;
                AdvRenameWindow.this.shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button[] buttonArray = new Button[]{btnDisplayUse, btnSavePathUse, btnTorrentUse};
        int n = buttonArray.length;
        int n2 = 0;
        while (n2 < n) {
            Button b = buttonArray[n2];
            b.addListener(13, e -> text_setter.accept((String)e.widget.getData()));
            ++n2;
        }
        this.shell.setLayout((Layout)new FormLayout());
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 3);
        fd.left = new FormAttachment(0, 3);
        fd.right = new FormAttachment(100, -3);
        lblMessage.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)lblMessage, 5);
        fd.left = new FormAttachment(0, 3);
        fd.right = new FormAttachment(100, -3);
        fd.width = 300;
        txtInput.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)btnDisplayUse, 0, 0x1000000);
        fd.left = new FormAttachment(0, 8);
        btnDisplayName.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)btnDisplayUse, 0, 0x1000000);
        fd.left = new FormAttachment((Control)btnDisplayName, 40);
        btnDisplayValue.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment((Control)btnDisplayValue, 0);
        fd.right = new FormAttachment((Control)btnDisplayUse, -8);
        btnDisplayPad.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)txtInput, 5);
        fd.right = new FormAttachment(100, -3);
        fd.width = btnTorrentUse.computeSize((int)-1, (int)-1).x;
        btnDisplayUse.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)btnSavePathUse, 0, 0x1000000);
        fd.left = new FormAttachment(0, 8);
        btnSavePath.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)btnSavePathUse, 0, 0x1000000);
        fd.left = new FormAttachment((Control)btnDisplayValue, 0, 16384);
        btnSavePathValue.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment((Control)btnSavePathValue, 0);
        fd.right = new FormAttachment((Control)btnSavePathUse, -8);
        btnSavePathPad.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)btnDisplayUse, 5);
        fd.right = new FormAttachment(100, -3);
        fd.width = btnTorrentUse.computeSize((int)-1, (int)-1).x;
        btnSavePathUse.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)btnTorrentUse, 0, 0x1000000);
        fd.left = new FormAttachment(0, 8);
        btnTorrent.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)btnTorrentUse, 0, 0x1000000);
        fd.left = new FormAttachment((Control)btnSavePathValue, 0, 16384);
        btnTorrentValue.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment((Control)btnTorrentValue, 0);
        fd.right = new FormAttachment((Control)btnTorrentUse, -8);
        btnTorrentPad.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)btnSavePathUse, 5);
        fd.right = new FormAttachment(100, -3);
        fd.width = btnTorrentUse.computeSize((int)-1, (int)-1).x;
        btnTorrentUse.setLayoutData((Object)fd);
        int renameDecisions = RememberedDecisionsManager.getRememberedDecision("adv.rename");
        if ((renameDecisions & 1) > 0) {
            btnDisplayName.setSelection(true);
        }
        if (this.dm.canMoveDataFiles()) {
            if ((renameDecisions & 2) > 0) {
                btnSavePath.setSelection(true);
            }
            if ((renameDecisions & 4) > 0) {
                btnTorrent.setSelection(true);
            }
        } else {
            btnSavePath.setEnabled(false);
            btnTorrent.setEnabled(false);
        }
        fd = new FormData();
        fd.top = new FormAttachment((Control)btnTorrentUse, 2);
        fd.left = new FormAttachment(0, 3);
        fd.right = new FormAttachment(100, -3);
        separator.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)separator, 5);
        fd.right = new FormAttachment(100, -3);
        fd.bottom = new FormAttachment(100, -3);
        cButtons.setLayoutData((Object)fd);
        Utils.makeButtonsEqualWidth(Arrays.asList(btnReset, btnOk, btnCancel));
        this.shell.pack();
        Utils.centreWindow(this.shell);
        this.shell.open();
    }

    public void cancel() {
        Utils.execSWTThread(() -> this.shell.dispose());
    }

    private void waitUntilDone() {
        Utils.readAndDispatchLoop((Control)this.shell);
    }

    private void doRename() {
        if (this.dm == null) {
            return;
        }
        boolean saveLocationIsFolder = this.dm.getSaveLocation().isDirectory();
        String newDisplayName = this.newName;
        String newSavePath = FileUtil.convertOSSpecificChars(this.newName, saveLocationIsFolder);
        String newTorrentName = FileUtil.convertOSSpecificChars(this.newName, false);
        if ((this.renameDecisions & 1) > 0) {
            this.dm.getDownloadState().setDisplayName(newDisplayName);
        }
        if (this.dm.canMoveDataFiles()) {
            if ((this.renameDecisions & 2) > 0) {
                try {
                    try {
                        String dnd_sf;
                        if (this.dm.getTorrent().isSimpleTorrent() && (dnd_sf = this.dm.getDownloadState().getAttribute("incompfilesuffix")) != null) {
                            dnd_sf = dnd_sf.trim();
                            String existing_name = this.dm.getSaveLocation().getName();
                            if (existing_name.endsWith(dnd_sf) && !newSavePath.endsWith(dnd_sf)) {
                                newSavePath = String.valueOf(newSavePath) + dnd_sf;
                            }
                        }
                    }
                    catch (Throwable dnd_sf) {
                        // empty catch block
                    }
                    this.dm.renameDownload(newSavePath);
                }
                catch (Exception e) {
                    Logger.log(new LogAlert((Object)this.dm, true, "Download data rename operation failed", (Throwable)e));
                }
            }
            if ((this.renameDecisions & 4) > 0) {
                try {
                    this.dm.renameTorrentSafe(newTorrentName);
                }
                catch (Exception e) {
                    Logger.log(new LogAlert((Object)this.dm, true, "Torrent rename operation failed", (Throwable)e));
                }
            }
        }
    }
}

