/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.search;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.metasearch.Engine;
import com.biglybt.core.metasearch.MetaSearchManagerFactory;
import com.biglybt.core.metasearch.impl.plugin.PluginEngine;
import com.biglybt.core.metasearch.impl.web.WebEngine;
import com.biglybt.core.subs.Subscription;
import com.biglybt.core.subs.SubscriptionException;
import com.biglybt.core.subs.SubscriptionManagerFactory;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.core.vuzefile.VuzeFile;
import com.biglybt.core.vuzefile.VuzeFileHandler;
import com.biglybt.pif.ui.menus.MenuItemFillListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.menus.MenuManager;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.PropertiesWindow;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mainwindow.TorrentOpener;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectCheckbox;
import com.biglybt.ui.swt.skin.SWTSkinObjectCombo;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import com.biglybt.ui.swt.skin.SWTSkinObjectTextbox;
import com.biglybt.ui.swt.views.skin.SkinnedDialog;
import com.biglybt.ui.swt.views.skin.StandardButtonsArea;
import com.biglybt.util.JSONUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class SearchUtils {
    public static void addMenus(Menu menu) {
        final Menu template_menu = new Menu((Decorations)menu.getShell(), 4);
        MenuItem template_menu_item = new MenuItem(menu, 64);
        template_menu_item.setMenu(template_menu);
        Messages.setLanguageText((Widget)template_menu_item, "Search.menu.engines");
        template_menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MenuItem[] menuItemArray = template_menu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem mi = menuItemArray[n2];
                    mi.dispose();
                    ++n2;
                }
                MenuItem import_mi = new MenuItem(template_menu, 8);
                Messages.setLanguageText((Widget)import_mi, "menu.import.json.from.clipboard");
                import_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        SearchUtils.importFromClipboard();
                    }
                });
                new MenuItem(template_menu, 2);
                Engine[] engines = MetaSearchManagerFactory.getSingleton().getMetaSearch().getEngines(true, false);
                Arrays.sort(engines, new Comparator<Engine>(){

                    @Override
                    public int compare(Engine o1, Engine o2) {
                        return o1.getName().compareToIgnoreCase(o2.getName());
                    }
                });
                int i = 0;
                while (i < engines.length) {
                    Engine engine = engines[i];
                    Menu engine_menu = new Menu((Decorations)template_menu.getShell(), 4);
                    MenuItem engine_menu_item = new MenuItem(template_menu, 64);
                    engine_menu_item.setMenu(engine_menu);
                    engine_menu_item.setText(engine.getName());
                    SearchUtils.addMenus(engine_menu, engine, false);
                    ++i;
                }
            }
        });
        MenuBuildUtils.addChatMenu(menu, "menu.discuss.searchtemplates", "Search Templates");
        MenuItem itemExport = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemExport, "search.export.all");
        itemExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchUtils.exportAll();
            }
        });
    }

    public static void addMenus(Menu engine_menu, final Engine engine, boolean separator_required) {
        if (separator_required) {
            new MenuItem(engine_menu, 2);
            separator_required = false;
        }
        if (!(engine instanceof PluginEngine)) {
            MenuItem export_json = new MenuItem(engine_menu, 8);
            Messages.setLanguageText((Widget)export_json, "menu.export.json.to.clipboard");
            export_json.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Shell shell = Utils.findAnyShell();
                    shell.getDisplay().asyncExec((Runnable)new AERunnable(){

                        @Override
                        public void runSupport() {
                            try {
                                ClipboardCopy.copyToClipBoard(engine.exportToVuzeFile().exportToJSON());
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    });
                }
            });
            final Subscription subs = engine.getSubscription();
            if (subs != null) {
                MenuItem export_uri = new MenuItem(engine_menu, 8);
                Messages.setLanguageText((Widget)export_uri, "label.copy.uri.to.clip");
                export_uri.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Shell shell = Utils.findAnyShell();
                        shell.getDisplay().asyncExec((Runnable)new AERunnable(){

                            @Override
                            public void runSupport() {
                                try {
                                    ClipboardCopy.copyToClipBoard(subs.getURI());
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        });
                    }
                });
            }
            new MenuItem(engine_menu, 2);
            MenuItem remove_item = new MenuItem(engine_menu, 8);
            Messages.setLanguageText((Widget)remove_item, "Button.remove");
            Utils.setMenuItemImage(remove_item, "delete");
            remove_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    engine.setSelectionState(3);
                }
            });
            separator_required = true;
        }
        if (separator_required) {
            new MenuItem(engine_menu, 2);
            separator_required = false;
        }
        MenuItem show_props = new MenuItem(engine_menu, 8);
        Messages.setLanguageText((Widget)show_props, "Subscription.menu.properties");
        show_props.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchUtils.showProperties(engine);
            }
        });
    }

    public static void addMenus(final MenuManager menuManager) {
        final com.biglybt.pif.ui.menus.MenuItem template_menu = menuManager.addMenuItem("sidebar.Search", "Search.menu.engines");
        template_menu.setDisposeWithUIDetach("swt");
        template_menu.setStyle(5);
        template_menu.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                template_menu.removeAllChildItems();
                Engine[] engines = MetaSearchManagerFactory.getSingleton().getMetaSearch().getEngines(true, false);
                Arrays.sort(engines, new Comparator<Engine>(){

                    @Override
                    public int compare(Engine o1, Engine o2) {
                        return o1.getName().compareToIgnoreCase(o2.getName());
                    }
                });
                com.biglybt.pif.ui.menus.MenuItem import_menu = menuManager.addMenuItem(template_menu, "menu.import.json.from.clipboard");
                import_menu.addListener(new MenuItemListener(){

                    @Override
                    public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                        SearchUtils.importFromClipboard();
                    }
                });
                com.biglybt.pif.ui.menus.MenuItem sep = menuManager.addMenuItem(template_menu, "!sep!");
                sep.setStyle(4);
                int i = 0;
                while (i < engines.length) {
                    com.biglybt.pif.ui.menus.MenuItem mi;
                    final Engine engine = engines[i];
                    com.biglybt.pif.ui.menus.MenuItem engine_menu = menuManager.addMenuItem(template_menu, "!" + engine.getName() + "!");
                    engine_menu.setStyle(5);
                    if (!(engine instanceof PluginEngine)) {
                        String cookies;
                        WebEngine we;
                        mi = menuManager.addMenuItem(engine_menu, "MyTorrentsView.menu.exportmenu");
                        mi.addListener(new MenuItemListener(){

                            @Override
                            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                                final Shell shell = Utils.findAnyShell();
                                shell.getDisplay().asyncExec((Runnable)new AERunnable(){

                                    @Override
                                    public void runSupport() {
                                        FileDialog dialog = new FileDialog(shell, 139264);
                                        dialog.setFilterPath(TorrentOpener.getFilterPathData());
                                        dialog.setText(MessageText.getString("metasearch.export.select.template.file"));
                                        dialog.setFilterExtensions(VuzeFileHandler.getVuzeFileFilterExtensions());
                                        dialog.setFilterNames(VuzeFileHandler.getVuzeFileFilterExtensions());
                                        String path = TorrentOpener.setFilterPathData(dialog.open());
                                        if (path != null) {
                                            if (!VuzeFileHandler.isAcceptedVuzeFileName(path)) {
                                                path = VuzeFileHandler.getVuzeFileName(path);
                                            }
                                            try {
                                                engine.exportToVuzeFile(new File(path));
                                            }
                                            catch (Throwable e) {
                                                Debug.out(e);
                                            }
                                        }
                                    }
                                });
                            }
                        });
                        com.biglybt.pif.ui.menus.MenuItem copy_mi = menuManager.addMenuItem(engine_menu, "menu.export.json.to.clipboard");
                        copy_mi.addListener(new MenuItemListener(){

                            @Override
                            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                                Shell shell = Utils.findAnyShell();
                                shell.getDisplay().asyncExec((Runnable)new AERunnable(){

                                    @Override
                                    public void runSupport() {
                                        try {
                                            ClipboardCopy.copyToClipBoard(engine.exportToVuzeFile().exportToJSON());
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                    }
                                });
                            }
                        });
                        final Subscription subs = engine.getSubscription();
                        if (subs != null) {
                            com.biglybt.pif.ui.menus.MenuItem copy_uri = menuManager.addMenuItem(engine_menu, "label.copy.uri.to.clip");
                            copy_uri.addListener(new MenuItemListener(){

                                @Override
                                public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                                    Shell shell = Utils.findAnyShell();
                                    shell.getDisplay().asyncExec((Runnable)new AERunnable(){

                                        @Override
                                        public void runSupport() {
                                            try {
                                                ClipboardCopy.copyToClipBoard(subs.getURI());
                                            }
                                            catch (Throwable e) {
                                                Debug.out(e);
                                            }
                                        }
                                    });
                                }
                            });
                        }
                        if (engine instanceof WebEngine && (we = (WebEngine)engine).isNeedsAuth() && (cookies = we.getCookies()) != null && cookies.length() > 0) {
                            mi = menuManager.addMenuItem(engine_menu, "Subscription.menu.resetauth");
                            mi.addListener(new MenuItemListener(){

                                @Override
                                public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                                    we.setCookies(null);
                                }
                            });
                        }
                    }
                    if (!(engine instanceof PluginEngine)) {
                        if (engine_menu.getItems().length > 0) {
                            mi = menuManager.addMenuItem(engine_menu, "Subscription.menu.sep");
                            mi.setStyle(4);
                        }
                        mi = menuManager.addMenuItem(engine_menu, "Button.remove");
                        mi.addListener(new MenuItemListener(){

                            @Override
                            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                                engine.setSelectionState(3);
                            }
                        });
                        mi = menuManager.addMenuItem(engine_menu, "Subscription.menu.sep2");
                        mi.setStyle(4);
                    }
                    if (engine_menu.getItems().length > 0) {
                        mi = menuManager.addMenuItem(engine_menu, "Subscription.menu.sep2");
                        mi.setStyle(4);
                    }
                    mi = menuManager.addMenuItem(engine_menu, "Subscription.menu.properties");
                    mi.addListener(new MenuItemListener(){

                        @Override
                        public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                            SearchUtils.showProperties(engine);
                        }
                    });
                    ++i;
                }
            }
        });
        com.biglybt.pif.ui.menus.MenuItem chat_menu = menuManager.addMenuItem("sidebar.Search", "label.chat");
        chat_menu.setDisposeWithUIDetach("swt");
        MenuBuildUtils.addChatMenu(menuManager, chat_menu, new MenuBuildUtils.ChatKeyResolver(){

            @Override
            public String getResourceKey() {
                return "menu.discuss.searchtemplates";
            }

            @Override
            public String getChatKey(Object object) {
                return "Search Templates";
            }
        });
        com.biglybt.pif.ui.menus.MenuItem export_menu = menuManager.addMenuItem("sidebar.Search", "search.export.all");
        export_menu.setDisposeWithUIDetach("swt");
        export_menu.setStyle(1);
        export_menu.addListener(new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                SearchUtils.exportAll();
            }
        });
    }

    public static void showCreateSubscriptionDialog(final long engineID, final String searchTerm, final Map optionalFilters) {
        final SkinnedDialog dialog = new SkinnedDialog("skin3_dlg_create_search_subscription", "shell", 2144);
        SWTSkin skin = dialog.getSkin();
        final SWTSkinObjectTextbox tb = (SWTSkinObjectTextbox)skin.getSkinObject("sub-name");
        final SWTSkinObjectCheckbox cbShare = (SWTSkinObjectCheckbox)skin.getSkinObject("sub-share");
        final SWTSkinObjectCheckbox cbAutoDL = (SWTSkinObjectCheckbox)skin.getSkinObject("sub-autodl");
        SWTSkinObject soEngineArea = skin.getSkinObject("sub-engine-area");
        final SWTSkinObjectCombo soEngines = (SWTSkinObjectCombo)skin.getSkinObject("sub-engine");
        if (tb == null || cbShare == null || cbAutoDL == null) {
            return;
        }
        boolean hasEngineID = engineID >= 0L;
        soEngineArea.setVisible(!hasEngineID);
        final HashMap<Integer, Engine> mapEngines = new HashMap<Integer, Engine>();
        if (!hasEngineID) {
            Engine[] engines = MetaSearchManagerFactory.getSingleton().getMetaSearch().getEngines(true, false);
            ArrayList<String> list = new ArrayList<String>();
            int pos = 0;
            Engine[] engineArray = engines;
            int n = engines.length;
            int n2 = 0;
            while (n2 < n) {
                Engine engine = engineArray[n2];
                mapEngines.put(pos++, engine);
                list.add(engine.getName());
                ++n2;
            }
            soEngines.setList(list.toArray(new String[list.size()]));
        }
        cbShare.setChecked(COConfigurationManager.getBooleanParameter("sub.sharing.default.checked"));
        cbAutoDL.setChecked(COConfigurationManager.getBooleanParameter("sub.autodl.default.checked"));
        SWTSkinObject soButtonArea = skin.getSkinObject("bottom-area");
        if (soButtonArea instanceof SWTSkinObjectContainer) {
            StandardButtonsArea buttonsArea = new StandardButtonsArea(){

                @Override
                protected void clicked(int buttonValue) {
                    if (buttonValue == 32) {
                        String name = tb.getText().trim();
                        boolean isShared = cbShare.isChecked();
                        boolean autoDL = cbAutoDL.isChecked();
                        long realEngineID = engineID;
                        if (engineID <= 0L) {
                            int engineIndex = soEngines.getComboControl().getSelectionIndex();
                            if (engineIndex < 0) {
                                return;
                            }
                            realEngineID = ((Engine)mapEngines.get(engineIndex)).getId();
                        }
                        HashMap<String, Object> payload = new HashMap<String, Object>();
                        payload.put("engine_id", realEngineID);
                        payload.put("search_term", searchTerm);
                        HashMap<String, Object> mapSchedule = new HashMap<String, Object>();
                        mapSchedule.put("days", Collections.EMPTY_LIST);
                        mapSchedule.put("interval", new Long(-1L));
                        payload.put("schedule", mapSchedule);
                        HashMap<String, Boolean> mapOptions = new HashMap<String, Boolean>();
                        mapOptions.put("auto_dl", autoDL);
                        payload.put("options", mapOptions);
                        HashMap mapFilters = new HashMap();
                        if (optionalFilters != null) {
                            mapFilters.putAll(optionalFilters);
                        }
                        payload.put("filters", mapFilters);
                        try {
                            Subscription subs = SubscriptionManagerFactory.getSingleton().create(name, isShared, JSONUtils.encodeToJSON(payload));
                            subs.getHistory().setDetails(true, autoDL);
                            subs.requestAttention();
                        }
                        catch (SubscriptionException subscriptionException) {
                            // empty catch block
                        }
                    }
                    dialog.close();
                }
            };
            buttonsArea.setButtonIDs(new String[]{MessageText.getString("Button.add"), MessageText.getString("Button.cancel")});
            buttonsArea.setButtonVals(new Integer[]{32, 256});
            buttonsArea.swt_createButtons(((SWTSkinObjectContainer)soButtonArea).getComposite());
        }
        dialog.open();
    }

    private static void importFromClipboard() {
        Shell shell = Utils.findAnyShell();
        shell.getDisplay().asyncExec((Runnable)new AERunnable(){

            @Override
            public void runSupport() {
                block6: {
                    try {
                        Clipboard clipboard = new Clipboard(Display.getDefault());
                        String text = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
                        clipboard.dispose();
                        if (text == null) break block6;
                        try (ByteArrayInputStream is = new ByteArrayInputStream(text.getBytes("UTF-8"));){
                            VuzeFileHandler vfh = VuzeFileHandler.getSingleton();
                            VuzeFile vf = vfh.loadVuzeFile(is);
                            if (vf != null) {
                                vfh.handleFiles(new VuzeFile[]{vf}, 0);
                            }
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    private static void exportAll() {
        final Shell shell = Utils.findAnyShell();
        shell.getDisplay().asyncExec((Runnable)new AERunnable(){

            @Override
            public void runSupport() {
                FileDialog dialog = new FileDialog(shell, 139264);
                dialog.setFilterPath(TorrentOpener.getFilterPathData());
                dialog.setText(MessageText.getString("metasearch.export.select.template.file"));
                dialog.setFilterExtensions(VuzeFileHandler.getVuzeFileFilterExtensions());
                dialog.setFilterNames(VuzeFileHandler.getVuzeFileFilterExtensions());
                String path = TorrentOpener.setFilterPathData(dialog.open());
                if (path != null) {
                    if (!VuzeFileHandler.isAcceptedVuzeFileName(path)) {
                        path = VuzeFileHandler.getVuzeFileName(path);
                    }
                    try {
                        MetaSearchManagerFactory.getSingleton().getMetaSearch().exportEngines(new File(path));
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    private static void showProperties(Engine engine) {
        String auth_str = String.valueOf(false);
        String engine_str = engine.getNameEx();
        String url_str = null;
        if (engine instanceof WebEngine) {
            WebEngine web_engine = (WebEngine)engine;
            if (web_engine.isNeedsAuth()) {
                auth_str = String.valueOf(String.valueOf(true)) + ": cookies=" + SearchUtils.toString(web_engine.getRequiredCookies());
            }
            url_str = web_engine.getSearchUrl();
        }
        String[] keys = new String[]{"subs.prop.template", "subs.prop.auth", "subs.prop.query", "label.anon", "subs.prop.version"};
        String[] values = new String[]{engine_str, auth_str, url_str, String.valueOf(engine.isAnonymous()), String.valueOf(engine.getVersion())};
        new PropertiesWindow(engine.getName(), keys, values);
    }

    private static String toString(String[] strs) {
        String res = "";
        int i = 0;
        while (i < strs.length) {
            res = String.valueOf(res) + (i == 0 ? "" : ",") + strs[i];
            ++i;
        }
        return res;
    }
}

