/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.search;

import com.biglybt.core.metasearch.MetaSearchManager;
import com.biglybt.core.metasearch.MetaSearchManagerFactory;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.DataSourceResolver;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ui.UIInstance;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.UIManagerListener;
import com.biglybt.pif.ui.config.BooleanParameter;
import com.biglybt.pif.ui.config.ParameterListener;
import com.biglybt.pif.ui.model.BasicPluginConfigModel;
import com.biglybt.pif.utils.DelayedTask;
import com.biglybt.pif.utils.Utilities;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.pif.UISWTInstance;
import com.biglybt.ui.swt.search.SearchResultsTabArea;
import java.util.Map;

public class SearchUI
implements DataSourceResolver.DataSourceImporter {
    private static final String CONFIG_SECTION_ID = "Search";
    private UIManager ui_manager;

    public SearchUI() {
        DataSourceResolver.registerExporter(this);
        final PluginInterface default_pi = PluginInitializer.getDefaultInterface();
        this.ui_manager = default_pi.getUIManager();
        this.ui_manager.addUIListener(new UIManagerListener(){

            @Override
            public void UIAttached(UIInstance instance) {
                if (!(instance instanceof UISWTInstance)) {
                    return;
                }
                Utilities utilities = default_pi.getUtilities();
                DelayedTask dt = utilities.createDelayedTask(new Runnable(){

                    @Override
                    public void run() {
                        Utils.execSWTThread(new AERunnable(){

                            @Override
                            public void runSupport() {
                                SearchUI.this.delayedInit();
                            }
                        });
                    }
                });
                dt.queue();
            }

            @Override
            public void UIDetached(UIInstance instance) {
            }
        });
    }

    @Override
    public Object importDataSource(Map<String, Object> map) {
        String term = (String)map.get("term");
        boolean toSubscribe = (Long)map.get("toSubscribe") != 0L;
        return new SearchResultsTabArea.SearchQuery(term, toSubscribe);
    }

    private void delayedInit() {
        MetaSearchManager manager = MetaSearchManagerFactory.getSingleton();
        if (manager == null) {
            return;
        }
        BasicPluginConfigModel configModel = this.ui_manager.createBasicPluginConfigModel("root", CONFIG_SECTION_ID);
        BooleanParameter proxy_tor_enable = configModel.addBooleanParameter2("search.proxy.enable", "search.proxy.enable", manager.getProxyRequestsEnabled() == 1);
        BooleanParameter proxy_i2p_enable = configModel.addBooleanParameter2("search.proxy.i2p.enable", "search.proxy.i2p.enable", manager.getProxyRequestsEnabled() == 2);
        ParameterListener listener = n -> {
            int type;
            boolean tor = proxy_tor_enable.getValue();
            boolean i2p = proxy_i2p_enable.getValue();
            if (tor) {
                type = 1;
                proxy_i2p_enable.setValue(false);
                proxy_i2p_enable.setEnabled(false);
            } else if (i2p) {
                type = 2;
                proxy_tor_enable.setEnabled(false);
            } else {
                type = 0;
                proxy_tor_enable.setEnabled(true);
                proxy_i2p_enable.setEnabled(true);
            }
            if (n != null) {
                manager.setProxyRequestsEnabled(type);
            }
        };
        listener.parameterChanged(null);
        proxy_tor_enable.addListener(listener);
        proxy_i2p_enable.addListener(listener);
        BooleanParameter showrcm = configModel.addBooleanParameter2("!search.showRCMView!", "search.showRCMView", false);
        showrcm.setAllowedUiTypes("swt");
        configModel.addIntParameter2("!search.rss.template.timeout!", "search.rss.template.timeout", 20);
    }
}

