/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.search;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.PluginInterface;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.swt.debug.ObfuscateTab;
import com.biglybt.ui.swt.search.SearchResultsTabArea;
import com.biglybt.ui.swt.views.skin.SkinViewManager;

public class SearchHandler {
    public static void handleSearch(String sSearchText, boolean toSubscribe) {
        String id;
        if (!toSubscribe) {
            try {
                PluginInterface pi;
                if (COConfigurationManager.getBooleanParameter("rcm.overall.enabled", true) && COConfigurationManager.getBooleanParameter("Plugin.aercm.rcm.search.enable", false) && COConfigurationManager.getBooleanParameter("search.showRCMView") && CoreFactory.isCoreRunning() && (pi = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("aercm")) != null && pi.getPluginState().isOperational() && pi.getIPC().canInvoke("lookupByExpression", new Object[]{""})) {
                    pi.getIPC().invoke("lookupByExpression", new Object[]{sSearchText});
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        SearchResultsTabArea.SearchQuery sq = new SearchResultsTabArea.SearchQuery(sSearchText, toSubscribe);
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        MdiEntry existingEntry = mdi.getEntry(id = "Search." + Integer.toHexString(sSearchText.hashCode()) + (toSubscribe ? ".s" : ""));
        if (existingEntry != null) {
            SearchResultsTabArea searchClass = (SearchResultsTabArea)SkinViewManager.getByClass(SearchResultsTabArea.class);
            if (searchClass != null) {
                searchClass.anotherSearch(sSearchText, toSubscribe);
            }
            existingEntry.setDatasource(sq);
            mdi.showEntry(existingEntry);
            return;
        }
        MdiEntry entry = mdi.createEntryFromSkinRef("header.discovery", id, "main.area.searchresultstab", sSearchText, null, sq, true, "");
        if (entry != null) {
            entry.setImageLeftID("image.sidebar.search");
            entry.setDatasource(sq);
            entry.setViewTitleInfo(new ViewTitleInfoImplementation());
        }
        mdi.showEntryByID(id);
    }

    private static final class ViewTitleInfoImplementation
    implements ViewTitleInfo,
    ObfuscateTab {
        private ViewTitleInfoImplementation() {
        }

        @Override
        public Object getTitleInfoProperty(int propertyID) {
            SearchResultsTabArea.SearchQuery sq;
            SearchResultsTabArea searchClass;
            if (propertyID == 5 && (searchClass = (SearchResultsTabArea)SkinViewManager.getByClass(SearchResultsTabArea.class)) != null && (sq = searchClass.getCurrentSearch()) != null) {
                return sq.term;
            }
            return null;
        }

        @Override
        public String getObfuscatedHeader() {
            return "";
        }
    }
}

