/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.pifimpl;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginListener;
import com.biglybt.pif.ui.model.PluginViewModel;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewBuilder;
import com.biglybt.ui.swt.pif.UISWTViewEventListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.WeakHashMap;

public class UISWTViewBuilderCore
implements UISWTViewBuilder {
    private UISWTViewEventListener listener;
    private final Map<UISWTView, Reference<UISWTViewEventListener>> mapViewToListener = new WeakHashMap<UISWTView, Reference<UISWTViewEventListener>>();
    private Reference<PluginInterface> pi_ref;
    private Object datasource;
    private final String viewID;
    private Reference<Class<? extends UISWTViewEventListener>> cla_ref;
    private String initialTitle;
    private String preferredAfterID;
    private UISWTViewBuilder.UISWTViewEventListenerInstantiator listenerInstantiator;
    private String parentEntryID;
    private boolean defaultVisibility = true;

    public UISWTViewBuilderCore(String viewID, PluginInterface pi) {
        this.viewID = viewID;
        WeakReference<PluginInterface> weakReference = this.pi_ref = pi == null ? null : new WeakReference<PluginInterface>(pi);
        if (pi != null) {
            pi.addListener(new PluginListener(){

                @Override
                public void initializationComplete() {
                }

                @Override
                public void closedownInitiated() {
                    if (Utils.isDisplayDisposed()) {
                        return;
                    }
                    GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
                    if (gm != null && gm.isStopping()) {
                        return;
                    }
                    UISWTViewBuilderCore.this.dispose();
                }

                @Override
                public void closedownComplete() {
                }
            });
        }
    }

    public UISWTViewBuilderCore(String viewID, PluginInterface pi, Class<? extends UISWTViewEventListener> cla) {
        this(viewID, pi);
        this.setListenerClass((Class)cla);
    }

    public UISWTViewBuilderCore(String viewID, PluginInterface pi, UISWTViewEventListener listener) {
        this(viewID, pi);
        this.listener = listener;
    }

    public UISWTViewBuilderCore cloneBuilder() {
        UISWTViewBuilderCore builder = new UISWTViewBuilderCore(this.viewID, this.getPluginInterface());
        builder.cla_ref = this.cla_ref;
        builder.listener = this.listener;
        builder.datasource = this.datasource;
        builder.initialTitle = this.initialTitle;
        builder.listenerInstantiator = this.listenerInstantiator;
        builder.preferredAfterID = this.preferredAfterID;
        builder.parentEntryID = this.parentEntryID;
        return builder;
    }

    public boolean isListenerOfClass(Class ofClass) {
        if (ofClass.isInstance(this.getListener())) {
            return true;
        }
        Class<? extends UISWTViewEventListener> cla = this.getListenerClass();
        return cla != null && cla.isAssignableFrom(ofClass);
    }

    public PluginInterface getPluginInterface() {
        return this.pi_ref == null ? null : this.pi_ref.get();
    }

    public Object getInitialDataSource() {
        return this.datasource;
    }

    @Override
    public UISWTViewBuilderCore setInitialDatasource(Object datasource) {
        this.datasource = datasource;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UISWTViewEventListener createEventListener(UISWTView view) {
        boolean isCloneable = this.isListenerCloneable();
        UISWTViewEventListener listener = this.getListener();
        Map<UISWTView, Reference<UISWTViewEventListener>> map = this.mapViewToListener;
        synchronized (map) {
            if (!isCloneable) {
                UISWTView existingView;
                if (!this.mapViewToListener.isEmpty() && (existingView = this.mapViewToListener.keySet().iterator().next()) != null && existingView != view && !existingView.isContentDisposed()) {
                    Debug.out("createEventListener already called for '" + this.viewID + "' for a different view. Switch from pre-created listener to class reference to safely create multiple views.");
                }
                if (listener != null) {
                    this.mapViewToListener.put(view, new WeakReference<UISWTViewEventListener>(listener));
                    return listener;
                }
            } else if (listener != null && this.mapViewToListener.isEmpty()) {
                this.mapViewToListener.put(view, new WeakReference<UISWTViewEventListener>(listener));
                return listener;
            }
        }
        try {
            Class<? extends UISWTViewEventListener> aClass = this.getListenerClass();
            UISWTViewEventListener eventListener = null;
            if (this.listenerInstantiator != null) {
                eventListener = this.listenerInstantiator.createNewInstance(this, view);
            } else if (aClass != null) {
                eventListener = aClass.newInstance();
            }
            if (eventListener != null) {
                Map<UISWTView, Reference<UISWTViewEventListener>> map2 = this.mapViewToListener;
                synchronized (map2) {
                    this.mapViewToListener.put(view, new WeakReference<UISWTViewEventListener>(eventListener));
                }
            } else {
                Debug.out("Could not create eventLister for '" + this.viewID + "'.  No way found to instantiate.");
            }
            return eventListener;
        }
        catch (Exception e) {
            Debug.out(e);
            return null;
        }
    }

    public String getViewID() {
        return this.viewID;
    }

    public UISWTViewEventListener getListener() {
        return this.listener;
    }

    public void dispose() {
        this.datasource = null;
        this.disposeViews();
        this.listener = null;
        this.cla_ref = null;
        this.listenerInstantiator = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeViews() {
        Map<UISWTView, Reference<UISWTViewEventListener>> map = this.mapViewToListener;
        synchronized (map) {
            for (UISWTView view : this.mapViewToListener.keySet()) {
                if (view == null) continue;
                view.closeView();
            }
            this.mapViewToListener.clear();
        }
    }

    public Class<? extends UISWTViewEventListener> getListenerClass() {
        return this.cla_ref == null ? null : this.cla_ref.get();
    }

    @Override
    public UISWTViewBuilderCore setListenerClass(Class<? extends UISWTViewEventListener> cla) {
        int modifiers;
        this.cla_ref = new WeakReference<Class<? extends UISWTViewEventListener>>(cla);
        if (cla != null && Modifier.isPrivate(modifiers = cla.getModifiers())) {
            Debug.out("Won't be able to create view " + this.viewID + " because listener class '" + cla.getName() + " is private");
        }
        return this;
    }

    public String getInitialTitle() {
        if (this.initialTitle == null) {
            PluginInterface pi;
            String name = null;
            String sResourceID = "Views.plugins." + this.viewID + ".title";
            boolean bResourceExists = MessageText.keyExists(sResourceID);
            if (!bResourceExists && (pi = this.getPluginInterface()) != null) {
                name = pi.getPluginconfig().getPluginStringParameter(sResourceID, null);
            }
            if (bResourceExists) {
                name = MessageText.getString(sResourceID);
            } else if (name == null) {
                name = MessageText.keyExists(this.viewID) ? MessageText.getString(this.viewID) : (this.listener != null && this.listener instanceof PluginViewModel ? ((PluginViewModel)((Object)this.listener)).getName() : this.viewID.replace('.', ' '));
            }
            return name;
        }
        return this.initialTitle;
    }

    @Override
    public UISWTViewBuilderCore setInitialTitle(String initialTitle) {
        this.initialTitle = initialTitle;
        return this;
    }

    @Override
    public UISWTViewBuilderCore setListenerInstantiator(UISWTViewBuilder.UISWTViewEventListenerInstantiator listenerInstantiator) {
        this.listenerInstantiator = listenerInstantiator;
        return this;
    }

    @Override
    public UISWTViewBuilder.UISWTViewEventListenerInstantiator getListenerInstantiator() {
        return this.listenerInstantiator;
    }

    public UISWTViewBuilderCore setPreferredAfterID(String preferredAfterID) {
        this.preferredAfterID = preferredAfterID;
        return this;
    }

    public String getPreferredAfterID() {
        return this.preferredAfterID;
    }

    public String getParentEntryID() {
        return this.parentEntryID == null ? "header.plugins" : this.parentEntryID;
    }

    @Override
    public UISWTViewBuilderCore setParentEntryID(String parentEntryID) {
        this.parentEntryID = "MyTorrents".equals(parentEntryID) ? "header.transfers" : ("Main".equals(parentEntryID) ? "header.plugins" : parentEntryID);
        return this;
    }

    public boolean getDefaultVisibility() {
        return this.defaultVisibility;
    }

    public void setDefaultVisibility(boolean b) {
        this.defaultVisibility = b;
    }

    public boolean isListenerCloneable() {
        if (this.listenerInstantiator != null) {
            return this.listenerInstantiator.supportsMultipleViews();
        }
        Class<? extends UISWTViewEventListener> cla = this.getListenerClass();
        return cla != null;
    }

    public String toDebugString() {
        PluginInterface pi;
        Class<?> cla;
        StringBuilder sb = new StringBuilder("{").append(this.viewID);
        UISWTViewEventListener listener = this.getListener();
        if (listener != null) {
            sb.append("; l=").append(listener);
        }
        if ((cla = this.getClass()) != null) {
            sb.append("; cla=").append(cla.getSimpleName());
        }
        if ((pi = this.getPluginInterface()) != null) {
            sb.append("; pi=").append(pi.getPluginID());
        }
        sb.append("; ").append(this.mapViewToListener.size()).append(" open");
        sb.append('}');
        return sb.toString();
    }
}

