/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.osx;

import com.biglybt.core.util.Debug;
import java.lang.reflect.Method;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class CocoaUIEnhancer {
    private static Class<?> nsstringCls = CocoaUIEnhancer.classForName("org.eclipse.swt.internal.cocoa.NSString");
    private static Class<?> nsautoreleasepoolCls = CocoaUIEnhancer.classForName("org.eclipse.swt.internal.cocoa.NSAutoreleasePool");
    private static Class<?> nsworkspaceCls = CocoaUIEnhancer.classForName("org.eclipse.swt.internal.cocoa.NSWorkspace");
    private static Class<?> nsimageCls = CocoaUIEnhancer.classForName("org.eclipse.swt.internal.cocoa.NSImage");
    private static Class<?> nssizeCls = CocoaUIEnhancer.classForName("org.eclipse.swt.internal.cocoa.NSSize");
    private static Class<?> osCls = CocoaUIEnhancer.classForName("org.eclipse.swt.internal.cocoa.OS");
    private static Method method_os_sAppDarkAppearance;

    static {
        if (SWT.getVersion() >= 4924) {
            try {
                method_os_sAppDarkAppearance = osCls.getMethod("isAppDarkAppearance", new Class[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static Class<?> classForName(String classname) {
        try {
            return Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Object invoke(Class<?> clazz, Object target, String methodName, Object ... args) {
        try {
            Class[] signature = new Class[args.length];
            int i = 0;
            while (i < args.length) {
                Class<?> thisClass = args[i].getClass();
                signature[i] = thisClass == Integer.class ? Integer.TYPE : (thisClass == Long.class ? Long.TYPE : (thisClass == Byte.class ? Byte.TYPE : (thisClass == Boolean.class ? Boolean.TYPE : thisClass)));
                ++i;
            }
            Method method = clazz.getMethod(methodName, signature);
            return method.invoke(target, args);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static Object invoke(Class<?> clazz, Object target, String methodName, Class[] signature, Object ... args) {
        try {
            Method method = clazz.getDeclaredMethod(methodName, signature);
            method.setAccessible(true);
            return method.invoke(target, args);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static Object invoke(Object obj, String methodName) {
        return CocoaUIEnhancer.invoke(obj, methodName, null, null);
    }

    private static Object invoke(Object obj, String methodName, Class<?>[] paramTypes, Object ... arguments) {
        try {
            Method m = obj.getClass().getMethod(methodName, paramTypes);
            return m.invoke(obj, arguments);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static Image getFileIcon(String path, int imageWidthHeight) {
        Object pool = null;
        try {
            Object nsImage;
            pool = nsautoreleasepoolCls.newInstance();
            Object delegateAlloc = CocoaUIEnhancer.invoke(pool, "alloc");
            CocoaUIEnhancer.invoke(delegateAlloc, "init");
            Object workspace = CocoaUIEnhancer.invoke(nsworkspaceCls, null, "sharedWorkspace", new Object[0]);
            Object fullPath = CocoaUIEnhancer.invoke(nsstringCls, null, "stringWith", path);
            if (fullPath != null && (nsImage = CocoaUIEnhancer.invoke(workspace, "iconForFile", new Class[]{nsstringCls}, fullPath)) != null) {
                Image image;
                Object size = nssizeCls.newInstance();
                nssizeCls.getField("width").set(size, imageWidthHeight);
                nssizeCls.getField("height").set(size, imageWidthHeight);
                CocoaUIEnhancer.invoke(nsImage, "setSize", new Class[]{nssizeCls}, size);
                CocoaUIEnhancer.invoke(nsImage, "retain");
                Image image2 = image = (Image)CocoaUIEnhancer.invoke(Image.class, null, "cocoa_new", new Class[]{Device.class, Integer.TYPE, nsimageCls}, new Object[]{Display.getCurrent(), 0, nsImage});
                return image2;
            }
        }
        catch (Throwable t) {
            Debug.printStackTrace(t);
        }
        finally {
            if (pool != null) {
                CocoaUIEnhancer.invoke(pool, "release");
            }
        }
        return null;
    }

    public static boolean isAppDarkAppearance() {
        try {
            if (method_os_sAppDarkAppearance != null) {
                return (Boolean)method_os_sAppDarkAppearance.invoke(null, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean isInitialized() {
        return true;
    }
}

