/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.minibar;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerStats;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pifimpl.local.download.DownloadManagerImpl;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.UIFunctionsSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.DoubleBufferedLabel;
import com.biglybt.ui.swt.minibar.MiniBar;
import com.biglybt.ui.swt.minibar.MiniBarManager;
import com.biglybt.ui.swt.views.utils.ManagerUtils;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DownloadBar
extends MiniBar {
    private static MiniBarManager manager = new MiniBarManager("AllTransfersBar");
    private DownloadManager download;
    private DoubleBufferedLabel download_name;
    private ProgressBar progress_bar;
    private DoubleBufferedLabel down_speed;
    private DoubleBufferedLabel up_speed;
    private DoubleBufferedLabel eta;

    public static MiniBarManager getManager() {
        return manager;
    }

    public static DownloadBar open(DownloadManager download, Shell main) {
        DownloadBar result = (DownloadBar)manager.getMiniBarForObject(download);
        if (result == null) {
            result = new DownloadBar(download, main);
        }
        return result;
    }

    public static void close(DownloadManager download) {
        DownloadBar result = (DownloadBar)manager.getMiniBarForObject(download);
        if (result != null) {
            result.close();
        }
    }

    private DownloadBar(DownloadManager download, Shell main) {
        super(manager);
        this.download = download;
        this.construct(main);
    }

    @Override
    public Object getContextObject() {
        return this.download;
    }

    @Override
    public void beginConstruction() {
        this.createFixedTextLabel("MinimizedWindow.name", false, false);
        this.download_name = this.createDataLabel(200);
        this.progress_bar = this.createPercentProgressBar(100);
        this.createFixedTextLabel("ConfigView.download.abbreviated", false, false);
        this.down_speed = this.createSpeedLabel();
        this.createFixedTextLabel("ConfigView.upload.abbreviated", false, false);
        this.up_speed = this.createSpeedLabel();
        this.createFixedTextLabel("TableColumn.header.eta", true, false);
        this.eta = this.createDataLabel(65);
    }

    @Override
    public void buildMenu(Menu menu, MenuEvent menuEvent) {
        MenuItem itemQueue = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemQueue, "MyTorrentsView.menu.queue");
        Utils.setMenuItemImage(itemQueue, "start");
        itemQueue.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ManagerUtils.queue(DownloadBar.this.download, (Composite)DownloadBar.this.splash);
            }
        });
        itemQueue.setEnabled(ManagerUtils.isStartable(this.download));
        MenuItem itemStop = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemStop, "MyTorrentsView.menu.stop");
        Utils.setMenuItemImage(itemStop, "stop");
        itemStop.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ManagerUtils.stop(DownloadBar.this.download, DownloadBar.this.splash);
            }
        });
        itemStop.setEnabled(ManagerUtils.isStopable(this.download));
        new MenuItem(menu, 2);
        super.buildMenu(menu);
    }

    @Override
    protected void refresh0() {
        DownloadManagerStats stats2 = this.download.getStats();
        this.download_name.setText(this.download.getDisplayName());
        int percent = stats2.getPercentDoneExcludingDND();
        this.updateSpeedLabel(this.down_speed, stats2.getDataReceiveRate(), stats2.getProtocolReceiveRate());
        this.updateSpeedLabel(this.up_speed, stats2.getDataSendRate(), stats2.getProtocolSendRate());
        this.eta.setText(DisplayFormatters.formatETA(stats2.getSmoothedETA()));
        if (this.progress_bar.getSelection() != percent) {
            this.progress_bar.setSelection(percent);
            this.progress_bar.redraw();
        }
    }

    @Override
    protected void doubleClick() {
        UIFunctionsSWT functionsSWT = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (functionsSWT != null) {
            functionsSWT.bringToFront();
        }
        this.download.fireGlobalManagerEvent(1);
    }

    @Override
    public String[] getPluginMenuIdentifiers(Object[] context2) {
        if (context2 == null) {
            return null;
        }
        return new String[]{"downloadbar", "download_context"};
    }

    @Override
    public Object[] getPluginMenuContextObjects() {
        try {
            return new Download[]{DownloadManagerImpl.getDownloadStatic(this.download)};
        }
        catch (DownloadException de) {
            return null;
        }
    }
}

