/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.mainwindow;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.impl.TorrentOpenOptions;
import com.biglybt.core.torrentdownloader.TorrentDownloaderCallBackInterface;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.core.vuzefile.VuzeFile;
import com.biglybt.core.vuzefile.VuzeFileHandler;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.utils.StaticUtilities;
import com.biglybt.pif.utils.subscriptions.SubscriptionManager;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.utils.xml.rss.RSSUtils;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.swt.FileDownloadWindow;
import com.biglybt.ui.swt.FixedURLTransfer;
import com.biglybt.ui.swt.TorrentUtil;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.UIFunctionsSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.shells.CoreWaiterSWT;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class TorrentOpener {
    public static void openTorrent(String torrentFile) {
        TorrentOpener.openTorrent(torrentFile, new HashMap<String, Object>());
    }

    public static void openTorrent(final String torrentFile, final Map<String, Object> options) {
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                UIFunctionsSWT uif = UIFunctionsManagerSWT.getUIFunctionsSWT();
                if (uif != null) {
                    uif.openTorrentOpenOptions(null, null, new String[]{torrentFile}, options);
                }
            }
        });
    }

    protected static void openTorrentsForTracking(final String path, final String[] fileNames) {
        CoreWaiterSWT.waitForCoreRunning(new CoreRunningListener(){

            @Override
            public void coreRunning(final Core core) {
                Display display = Utils.getDisplay();
                if (display == null || display.isDisposed() || core == null) {
                    return;
                }
                new AEThread2("TorrentOpener"){

                    @Override
                    public void run() {
                        int i = 0;
                        while (i < fileNames.length) {
                            try {
                                TOTorrent t = TorrentUtils.readFromFile(new File(path, fileNames[i]), true);
                                core.getTrackerHost().hostTorrent(t, true, true);
                            }
                            catch (Throwable e) {
                                Logger.log(new LogAlert(false, "Torrent open fails for '" + path + File.separator + fileNames[i] + "'", e));
                            }
                            ++i;
                        }
                    }
                }.start();
            }
        });
    }

    public static void openTorrentTrackingOnly() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                Shell shell = Utils.findAnyShell();
                if (shell == null) {
                    return;
                }
                FileDialog fDialog = new FileDialog(shell, 4098);
                fDialog.setFilterPath(TorrentOpener.getFilterPathTorrent());
                fDialog.setFilterExtensions(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
                fDialog.setFilterNames(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
                fDialog.setText(MessageText.getString("MainWindow.dialog.choose.file"));
                String path = TorrentOpener.setFilterPathTorrent(fDialog.open());
                if (path == null) {
                    return;
                }
                TorrentOpener.openTorrentsForTracking(path, fDialog.getFileNames());
            }
        });
    }

    public static void openTorrentSimple() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                Shell shell = Utils.findAnyShell();
                if (shell == null) {
                    return;
                }
                FileDialog fDialog = new FileDialog(shell, 4098);
                fDialog.setFilterPath(TorrentOpener.getFilterPathTorrent());
                fDialog.setFilterExtensions(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
                fDialog.setFilterNames(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
                fDialog.setText(MessageText.getString("MainWindow.dialog.choose.file"));
                String path = TorrentOpener.setFilterPathTorrent(fDialog.open());
                if (path == null) {
                    return;
                }
                UIFunctionsManagerSWT.getUIFunctionsSWT().openTorrentOpenOptions(shell, path, fDialog.getFileNames(), false, false);
            }
        });
    }

    public static boolean openTorrentsFromClipboard(String text) {
        String[] splitters = new String[]{"\r\n", "\n", "\r", "\t"};
        String[] lines = null;
        String[] stringArray = splitters;
        int n = splitters.length;
        int n2 = 0;
        while (n2 < n) {
            String splitter = stringArray[n2];
            if (text.contains(splitter)) {
                lines = text.split(splitter);
                break;
            }
            ++n2;
        }
        if (lines == null) {
            lines = new String[]{text};
        }
        boolean opened = false;
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].trim();
            if (line.startsWith("\"") && line.endsWith("\"")) {
                line = line.length() < 3 ? "" : line.substring(1, line.length() - 2);
            }
            if (UrlUtils.isURL(line)) {
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("hideErrors", true);
                TorrentOpener.openTorrent(line, options);
                opened = true;
            }
            ++i;
        }
        return opened;
    }

    public static void openDroppedTorrents(DropTargetEvent event2, boolean deprecated_sharing_param) {
        UIFunctionsSWT uif;
        String link;
        Object data = event2.data;
        if (data == null) {
            return;
        }
        if (data instanceof String) {
            if (((String)data).contains("azcdid=" + RandomUtils.INSTANCE_ID)) {
                event2.detail = 0;
                return;
            }
        } else if (data instanceof FixedURLTransfer.URLType && (link = ((FixedURLTransfer.URLType)data).linkURL) != null && link.contains("azcdid=" + RandomUtils.INSTANCE_ID)) {
            event2.detail = 0;
            return;
        }
        if (event2.data instanceof String[] || event2.data instanceof String) {
            String[] stringArray;
            if (event2.data instanceof String[]) {
                stringArray = (String[])event2.data;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)event2.data;
            }
            String[] sourceNames = stringArray;
            if (event2.detail == 0) {
                return;
            }
            int i = 0;
            while (i < sourceNames.length) {
                final File source = new File(sourceNames[i]);
                String sURL = UrlUtils.parseTextForURL(sourceNames[i], true);
                if (sURL != null && !source.exists()) {
                    UIFunctionsSWT uif2 = UIFunctionsManagerSWT.getUIFunctionsSWT();
                    if (uif2 != null) {
                        uif2.openTorrentOpenOptions(null, null, new String[]{sURL}, false, false);
                    }
                } else if (source.isFile()) {
                    new AEThread2("asyncOpen", true){

                        @Override
                        public void run() {
                            String filename = source.getAbsolutePath();
                            VuzeFileHandler vfh = VuzeFileHandler.getSingleton();
                            if (vfh.loadAndHandleVuzeFile(filename, 0) != null) {
                                return;
                            }
                            UIFunctionsSWT uif = UIFunctionsManagerSWT.getUIFunctionsSWT();
                            if (uif != null) {
                                uif.openTorrentOpenOptions(null, null, new String[]{filename}, false, false);
                            }
                        }
                    }.start();
                } else if (source.isDirectory()) {
                    String dir_name = source.getAbsolutePath();
                    UIFunctionsSWT uif3 = UIFunctionsManagerSWT.getUIFunctionsSWT();
                    if (uif3 != null) {
                        uif3.openTorrentOpenOptions(null, dir_name, null, false, false);
                    }
                }
                ++i;
            }
        } else if (event2.data instanceof FixedURLTransfer.URLType && (uif = UIFunctionsManagerSWT.getUIFunctionsSWT()) != null) {
            uif.openTorrentOpenOptions(null, null, new String[]{((FixedURLTransfer.URLType)event2.data).linkURL}, false, false);
        }
    }

    public static String getFilterPathExport() {
        String before = COConfigurationManager.getStringParameter("previous.filter.dir.export", "");
        return before;
    }

    public static String setFilterPathExport(String path) {
        if (path != null && path.length() > 0) {
            String before;
            File test = new File(path);
            if (!test.isDirectory()) {
                test = test.getParentFile();
            }
            String now = "";
            if (test != null) {
                now = test.getAbsolutePath();
            }
            if ((before = COConfigurationManager.getStringParameter("previous.filter.dir.export")) == null || before.length() == 0 || !before.equals(now)) {
                COConfigurationManager.setParameter("previous.filter.dir.export", now);
                COConfigurationManager.save();
            }
        }
        return path;
    }

    public static String getFilterPathData() {
        String before = COConfigurationManager.getStringParameter("previous.filter.dir.data");
        if (before != null && before.length() > 0) {
            return before;
        }
        try {
            String def = COConfigurationManager.getDirectoryParameter("Default save path");
            return def;
        }
        catch (IOException e) {
            return "";
        }
    }

    public static String getFilterPathTorrent() {
        String before = COConfigurationManager.getStringParameter("previous.filter.dir.torrent");
        if (before != null && before.length() > 0) {
            return before;
        }
        return COConfigurationManager.getStringParameter("General_sDefaultTorrent_Directory");
    }

    public static String setFilterPathData(String path) {
        if (path != null && path.length() > 0) {
            String before;
            File test = new File(path);
            if (!test.isDirectory()) {
                test = test.getParentFile();
            }
            String now = "";
            if (test != null) {
                now = test.getAbsolutePath();
            }
            if ((before = COConfigurationManager.getStringParameter("previous.filter.dir.data")) == null || before.length() == 0 || !before.equals(now)) {
                COConfigurationManager.setParameter("previous.filter.dir.data", now);
                COConfigurationManager.save();
            }
        }
        return path;
    }

    public static String setFilterPathTorrent(String path) {
        if (path != null && path.length() > 0) {
            String before;
            File test = new File(path);
            if (!test.isDirectory()) {
                test = test.getParentFile();
            }
            String now = "";
            if (test != null) {
                now = test.getAbsolutePath();
            }
            if ((before = COConfigurationManager.getStringParameter("previous.filter.dir.torrent")) == null || before.length() == 0 || !before.equals(now)) {
                COConfigurationManager.setParameter("previous.filter.dir.torrent", now);
                COConfigurationManager.save();
            }
            return now;
        }
        return path;
    }

    public static boolean doesDropHaveTorrents(DropTargetEvent event2) {
        boolean isTorrent = false;
        if (event2.data == null) {
            isTorrent = true;
        } else if (!(event2.data instanceof String) || !((String)event2.data).contains("azcdid=" + RandomUtils.INSTANCE_ID)) {
            if (event2.data instanceof String[] || event2.data instanceof String) {
                String[] sourceNames;
                String[] stringArray;
                if (event2.data instanceof String[]) {
                    stringArray = (String[])event2.data;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = (String)event2.data;
                }
                String[] stringArray3 = sourceNames = stringArray;
                int n = sourceNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray3[n2];
                    String sURL = UrlUtils.parseTextForURL(name, true);
                    if (sURL != null) {
                        isTorrent = true;
                        break;
                    }
                    ++n2;
                }
            } else if (event2.data instanceof FixedURLTransfer.URLType) {
                FixedURLTransfer.URLType xfer = (FixedURLTransfer.URLType)event2.data;
                String link = xfer.linkURL;
                if (link == null || !link.contains("azcdid=" + RandomUtils.INSTANCE_ID)) {
                    isTorrent = true;
                }
            }
        }
        return isTorrent;
    }

    public static boolean mergeFileIntoTorrentInfo(String sFileName, String sOriginatingLocation, TorrentOpenOptions torrentOptions) {
        File torrentFile;
        File fOriginal;
        boolean bDeleteFileOnCancel;
        TOTorrent torrent;
        block19: {
            block18: {
                torrent = null;
                bDeleteFileOnCancel = false;
                if (sFileName.startsWith("file://localhost/")) {
                    sFileName = UrlUtils.decode(sFileName.substring(16));
                }
                if ((fOriginal = new File(sFileName)).isFile() && fOriginal.exists()) break block18;
                UIFunctionsManager.getUIFunctions().showErrorMessage("OpenTorrentWindow.mb.openError", fOriginal.toString(), new String[]{UrlUtils.decode(sOriginatingLocation), "Not a File"});
                return false;
            }
            if (fOriginal.length() <= 0x4000000L || fOriginal.getName().toLowerCase(Locale.US).endsWith(".biglybt")) break block19;
            UIFunctionsManager.getUIFunctions().showErrorMessage("OpenTorrentWindow.mb.openError", fOriginal.toString(), new String[]{UrlUtils.decode(sOriginatingLocation), "Too large to be a torrent"});
            return false;
        }
        try {
            torrentFile = TorrentUtils.copyTorrentFileToSaveDir(fOriginal, true);
            bDeleteFileOnCancel = !fOriginal.equals(torrentFile);
        }
        catch (IOException e1) {
            Debug.out(e1);
            torrentFile = new File(sFileName);
        }
        VuzeFileHandler vfh = VuzeFileHandler.getSingleton();
        VuzeFile vf = vfh.loadVuzeFile(torrentFile);
        if (vf != null) {
            vfh.handleFiles(new VuzeFile[]{vf}, 0);
            return false;
        }
        if (RSSUtils.isRSSFeed(torrentFile)) {
            boolean done = false;
            try {
                String details;
                long res;
                URL url = new URL(sOriginatingLocation);
                UIManager ui_manager = StaticUtilities.getUIManager(10000L);
                if (ui_manager != null && (res = ui_manager.showMessageBox("subscription.request.add.title", "!" + (details = MessageText.getString("subscription.request.add.message", new String[]{sOriginatingLocation})) + "!", 12L)) == 4L) {
                    SubscriptionManager sm = PluginInitializer.getDefaultInterface().getUtilities().getSubscriptionManager();
                    sm.requestSubscription(url);
                    done = true;
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            if (done) {
                if (bDeleteFileOnCancel) {
                    torrentFile.delete();
                }
                return false;
            }
        }
        if (!TorrentUtil.isFileTorrent(sOriginatingLocation, torrentFile, torrentFile.getName(), !torrentOptions.getHideErrors())) {
            if (bDeleteFileOnCancel) {
                torrentFile.delete();
            }
            return false;
        }
        try {
            torrent = TorrentUtils.readFromFile(torrentFile, false);
        }
        catch (TOTorrentException e) {
            UIFunctionsManager.getUIFunctions().showErrorMessage("OpenTorrentWindow.mb.openError", Debug.getStackTrace(e), new String[]{sOriginatingLocation == null ? torrentFile.getAbsolutePath() : sOriginatingLocation, e.getMessage()});
            if (bDeleteFileOnCancel) {
                torrentFile.delete();
            }
            return false;
        }
        if (bDeleteFileOnCancel) {
            torrentOptions.setDeleteFileOnCancel(bDeleteFileOnCancel);
        }
        torrentOptions.setTorrentFile(torrentFile.getAbsolutePath());
        torrentOptions.setTorrent(torrent);
        torrentOptions.sOriginatingLocation = sOriginatingLocation;
        return torrentOptions.getTorrent() != null;
    }

    public static void openTorrentsFromStrings(TorrentOpenOptions optionsToClone, Shell parent, String pathPrefix, String[] torrents, String referrer, TorrentDownloaderCallBackInterface listener, boolean forceTorrentOptionsWindow) {
        int n;
        if (torrents == null || torrents.length == 0) {
            File[] listFiles;
            if (pathPrefix == null) {
                return;
            }
            File path = new File(pathPrefix);
            if (!path.isDirectory()) {
                return;
            }
            ArrayList<String> newTorrents = new ArrayList<String>();
            File[] fileArray = listFiles = path.listFiles();
            int n2 = listFiles.length;
            n = 0;
            while (n < n2) {
                File file = fileArray[n];
                try {
                    if (file.isFile() && TorrentUtils.isTorrentFile(file.getAbsolutePath())) {
                        newTorrents.add(file.getName());
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ++n;
            }
            if (newTorrents.size() == 0) {
                return;
            }
            torrents = newTorrents.toArray(new String[0]);
        }
        final VuzeFileHandler vfh = VuzeFileHandler.getSingleton();
        ArrayList<VuzeFile> vuze_files = new ArrayList<VuzeFile>();
        String[] stringArray = torrents;
        n = torrents.length;
        int n3 = 0;
        while (n3 < n) {
            block24: {
                File file;
                String line = stringArray[n3];
                if ((line = line.trim()).startsWith("\"") && line.endsWith("\"")) {
                    line = line.length() < 3 ? "" : line.substring(1, line.length() - 2);
                }
                TorrentOpenOptions torrentOptions = optionsToClone == null ? new TorrentOpenOptions(null) : optionsToClone.getClone();
                File file2 = file = pathPrefix == null ? new File(line) : new File(pathPrefix, line);
                if (file.exists()) {
                    block23: {
                        try {
                            VuzeFile vf = vfh.loadVuzeFile(file);
                            if (vf == null) break block23;
                            vuze_files.add(vf);
                            break block24;
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    try {
                        File torrentDir = new File(COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory"));
                        if (COConfigurationManager.getBooleanParameter("Save Torrent Files") && torrentDir.exists() && file.getParentFile().equals(torrentDir)) {
                            torrentOptions.setDeleteFileOnCancel(false);
                        }
                    }
                    catch (Throwable torrentDir) {
                        // empty catch block
                    }
                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                    if (TorrentOpener.mergeFileIntoTorrentInfo(file.getAbsolutePath(), null, torrentOptions)) {
                        uif.addTorrentWithOptions(forceTorrentOptionsWindow, torrentOptions);
                    }
                } else {
                    final String url = UrlUtils.parseTextForURL(line, true);
                    if (url != null) {
                        if (VuzeFileHandler.isAcceptedVuzeFileName(url)) {
                            new AEThread2("VuzeLoader"){

                                @Override
                                public void run() {
                                    try {
                                        VuzeFile vf = vfh.loadVuzeFile(url);
                                        if (vf != null) {
                                            vfh.handleFiles(new VuzeFile[]{vf}, 0);
                                        }
                                    }
                                    catch (Throwable e) {
                                        Debug.printStackTrace(e);
                                    }
                                }
                            }.start();
                        } else {
                            new FileDownloadWindow(parent, url, referrer, null, torrentOptions, listener);
                        }
                    }
                }
            }
            ++n3;
        }
        if (vuze_files.size() > 0) {
            VuzeFile[] vfs = new VuzeFile[vuze_files.size()];
            vuze_files.toArray(vfs);
            vfh.handleFiles(vfs, 0);
        }
    }
}

