/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.mainwindow;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AEDiagnosticsLogger;
import com.biglybt.core.util.AERunStateHandler;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.platform.PlatformManagerFactory;
import com.biglybt.ui.IUIIntializer;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.UserPrompterResultListener;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.UIFunctionsSWT;
import com.biglybt.ui.swt.UISwitcherListener;
import com.biglybt.ui.swt.UISwitcherUtil;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.MenuFactory;
import com.biglybt.ui.swt.mainwindow.SWTThreadAlreadyInstanciatedException;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import java.lang.reflect.Field;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public class SWTThread
implements AEDiagnosticsEvidenceGenerator {
    private static SWTThread instance;
    boolean skip_dispose = Constants.isLinux || Utils.getSWTVersion() >= 4956;
    Display display;
    private boolean sleak = false;
    private boolean terminated;
    private Thread runner;
    private final IUIIntializer initializer;
    private Monitor primaryMonitor;
    protected boolean displayDisposed;

    public static SWTThread getInstance() {
        return instance;
    }

    public static void createInstance(IUIIntializer initializer) throws SWTThreadAlreadyInstanciatedException {
        if (instance != null) {
            throw new SWTThreadAlreadyInstanciatedException();
        }
        new SWTThread(initializer);
    }

    private SWTThread(final IUIIntializer app) {
        this.initializer = app;
        instance = this;
        Display.setAppName((String)Constants.APP_NAME);
        try {
            this.display = Display.getCurrent();
            if (this.display == null) {
                if (System.getProperty("SWT.Device.DEBUG", "0").equals("1")) {
                    Device.DEBUG = true;
                }
                if (System.getProperty("biglybt.sleak.active", "0").equals("1")) {
                    this.display = Display.getDefault();
                    if (this.display != null) {
                        this.sleak = true;
                    }
                }
                if (this.display == null) {
                    this.display = new Display();
                }
            }
        }
        catch (Exception e) {
            this.display = new Display();
        }
        catch (UnsatisfiedLinkError ue) {
            String sMin = "3.4";
            try {
                sMin = "" + (double)(SWT.getVersion() / 100) / 10.0;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                String tempDir = System.getProperty("swt.library.path");
                if (tempDir == null) {
                    tempDir = System.getProperty("java.io.tmpdir");
                }
                Debug.out("Loading SWT Libraries failed. Typical causes:\n\n(1) swt.jar is not for your os architecture (" + Constants.OSArch + ").  " + "You can get a new swt.jar (Min Version: " + sMin + ") " + "from http://eclipse.org/swt" + "\n\n" + "(2) No write access to '" + tempDir + "'. SWT will extract libraries contained in the swt.jar to this dir.\n", ue);
                app.stopIt(false);
                this.terminated = true;
                PlatformManagerFactory.getPlatformManager().dispose();
            }
            catch (Throwable tempDir) {
                // empty catch block
            }
            return;
        }
        final Thread swt_thread = Thread.currentThread();
        swt_thread.setName("SWT Thread");
        Utils.initialize(this.display);
        Utils.execSWTThread(() -> {
            this.primaryMonitor = this.display.getPrimaryMonitor();
            AEDiagnostics.addEvidenceGenerator(this);
            UISwitcherUtil.addListener(new UISwitcherListener(){

                @Override
                public void uiSwitched(String ui) {
                    MessageBoxShell mb = new MessageBoxShell(MessageText.getString("dialog.uiswitcher.restart.title"), MessageText.getString("dialog.uiswitcher.restart.text"), new String[]{MessageText.getString("UpdateWindow.restart"), MessageText.getString("UpdateWindow.restartLater")}, 0);
                    mb.open(new UserPrompterResultListener(){

                        @Override
                        public void prompterClosed(int result) {
                            if (result != 0) {
                                return;
                            }
                            UIFunctions uif = UIFunctionsManager.getUIFunctions();
                            if (uif != null) {
                                uif.dispose(true);
                            }
                        }
                    });
                }
            });
            try {
                Field fldOpenDoc = SWT.class.getDeclaredField("OpenDocument");
                int SWT_OpenDocument = fldOpenDoc.getInt(null);
                this.display.addListener(SWT_OpenDocument, new Listener(){

                    public void handleEvent(final Event event2) {
                        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

                            @Override
                            public void coreRunning(Core core) {
                                UIFunctionsManagerSWT.getUIFunctionsSWT().openTorrentOpenOptions(Utils.findAnyShell(), null, new String[]{event2.text}, false, false);
                            }
                        });
                    }
                });
            }
            catch (Throwable fldOpenDoc) {
                // empty catch block
            }
            Listener lShowMainWindow = new Listener(){

                public void handleEvent(Event event2) {
                    Shell mainShell;
                    if (event2.type == 26 && AERunStateHandler.isDelayedUI()) {
                        Debug.out("Ignoring activate event as delay start");
                        return;
                    }
                    Shell as = Display.getDefault().getActiveShell();
                    if (as != null) {
                        as.setVisible(true);
                        as.forceActive();
                        return;
                    }
                    UIFunctionsSWT uif = UIFunctionsManagerSWT.getUIFunctionsSWT();
                    if (uif != null && ((mainShell = uif.getMainShell()) == null || mainShell.isDisposed() || !mainShell.isVisible() || mainShell.getMinimized()) && !COConfigurationManager.getBooleanParameter("Reduce Auto Activate Window")) {
                        uif.bringToFront(false);
                    }
                }
            };
            this.display.addListener(26, lShowMainWindow);
            this.display.addListener(13, lShowMainWindow);
            this.display.addListener(12, new Listener(){

                public void handleEvent(Event event2) {
                    SWTThread.this.displayDisposed = true;
                }
            });
            if (Constants.isOSX) {
                this.display.addListener(21, new Listener(){

                    public void handleEvent(Event event2) {
                        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                        if (uiFunctions != null) {
                            uiFunctions.dispose(false);
                        }
                        event2.doit = false;
                    }
                });
                MenuFactory.initSystemMenu();
            }
            if (Constants.isWindows) {
                try {
                    Field fieldState = Widget.class.getDeclaredField("state");
                    fieldState.setAccessible(true);
                    this.display.addListener(45, event2 -> {
                        if (event2.widget == null || event2.widget.isDisposed()) {
                            return;
                        }
                        if (event2.widget instanceof Shell) {
                            ((Shell)event2.widget).setBackgroundMode(1);
                        } else if (event2.widget instanceof Button && (event2.widget.getStyle() & 8) != 0) {
                            try {
                                int stateVal = (Integer)fieldState.get(event2.widget);
                                fieldState.set(event2.widget, stateVal |= 0x400);
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (Constants.isWindows) {
                this.display.addFilter(37, this::lambda$2);
            } else if (Constants.isOSX) {
                this.display.addFilter(37, e -> {
                    Widget focusControl = e.widget;
                    Control control = focusControl instanceof Control ? (Control)focusControl : null;
                    while (control != null) {
                        ScrollBar verticalBar;
                        if (control instanceof Scrollable && (verticalBar = ((Scrollable)control).getVerticalBar()) != null && verticalBar.isEnabled() && verticalBar.getData("ScrollOnMouseOver2") != null) {
                            Object o = verticalBar.getData("ScrollOnMouseOver2");
                            if (!(o instanceof Runnable)) break;
                            try {
                                ((Runnable)o).run();
                            }
                            catch (Throwable throwable) {}
                            break;
                        }
                        control = control.getParent();
                    }
                });
            } else {
                this.display.addFilter(37, e -> {
                    Control control;
                    Widget widget = e.widget;
                    if (widget instanceof Control && ((control = (Control)widget) instanceof Combo || control instanceof Spinner)) {
                        while (control != null) {
                            Long lastScroll;
                            if (control instanceof ScrolledComposite && (lastScroll = (Long)control.getData("LastScrollTime")) != null && SystemTime.getMonotonousTime() - lastScroll < 1500L) {
                                e.doit = false;
                                return;
                            }
                            control = control.getParent();
                        }
                    }
                });
            }
            if (app != null) {
                app.runInSWTThread();
                this.runner = new Thread((Runnable)new AERunnable(){

                    @Override
                    public void runSupport() {
                        app.run();
                    }
                }, "Main Thread");
                this.runner.start();
            }
        });
        if (!this.sleak) {
            SimpleTimer.addPeriodicEvent("SWT:ui:check", 1000L, new TimerEventPerformer(){
                Object lock = new Object();
                boolean active = false;
                long last_exec = -1L;
                AEDiagnosticsLogger logger = AEDiagnostics.getLogger("SlowUI");
                {
                    this.logger.setForced(true);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void perform(TimerEvent event2) {
                    if (SWTThread.this.display != null && !SWTThread.this.display.isDisposed()) {
                        long busy_for = -1L;
                        Object object = this.lock;
                        synchronized (object) {
                            if (this.active) {
                                busy_for = SystemTime.getMonotonousTime() - this.last_exec;
                            } else {
                                this.active = true;
                                this.last_exec = SystemTime.getMonotonousTime();
                            }
                        }
                        if (busy_for < 0L) {
                            SWTThread.this.display.asyncExec(() -> {
                                Object object = this.lock;
                                synchronized (object) {
                                    this.active = false;
                                }
                            });
                        } else if (busy_for >= 2000L) {
                            String log = String.valueOf(AEDiagnosticsLogger.getTimestamp()) + "Busy for " + busy_for + ": " + AEDiagnostics.getThreadInfo(swt_thread);
                            StackTraceElement[] elts = swt_thread.getStackTrace();
                            StringBuilder str = new StringBuilder(elts.length * 100);
                            int i = 0;
                            while (i < elts.length) {
                                String elt_str = elts[i].toString();
                                if (elt_str.contains("SWTThread.<init>")) break;
                                str.append("\n\t");
                                str.append(elt_str);
                                ++i;
                            }
                            this.logger.log(String.valueOf(log) + str.toString());
                        }
                    }
                }
            });
            while (this.display != null && !this.display.isDisposed() && !this.terminated) {
                try {
                    if (this.display == null || this.display.readAndDispatch()) continue;
                    this.display.sleep();
                }
                catch (Throwable e) {
                    if (this.terminated) {
                        Logger.log(new LogEvent(LogIDs.GUI, "Weird non-critical error after terminated in readAndDispatch: " + e.toString()));
                        continue;
                    }
                    String stackTrace = Debug.getStackTrace(e);
                    if (Constants.isOSX && stackTrace.indexOf("Device.dispose") > 0 && stackTrace.indexOf("DropTarget") > 0) {
                        Logger.log(new LogEvent(LogIDs.GUI, "Weird non-critical display disposal in readAndDispatch"));
                        continue;
                    }
                    if (SWT.getVersion() < 3119) {
                        e.printStackTrace();
                    }
                    if (Constants.isCVSVersion()) {
                        Logger.log(new LogAlert(false, MessageText.getString("SWT.alert.erroringuithread"), e));
                        continue;
                    }
                    Debug.out(MessageText.getString("SWT.alert.erroringuithread"), e);
                }
            }
            if (instance != null) {
                if (!this.terminated) {
                    if (app != null) {
                        app.stopIt(false);
                    }
                    this.terminate();
                }
                PlatformManagerFactory.getPlatformManager().dispose();
            }
            if (!this.skip_dispose) {
                try {
                    while (this.display != null && !this.display.isDisposed()) {
                        if (this.display.readAndDispatch() || this.display.isDisposed()) continue;
                        this.display.sleep();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        boolean crash_on_dispose_bug;
        SWTThread sWTThread = this;
        synchronized (sWTThread) {
            if (this.terminated) {
                return;
            }
            this.terminated = true;
        }
        Utils.setTerminated();
        boolean bl = crash_on_dispose_bug = Constants.isWindows8OrHigher && SWT.getVersion() < 4930;
        if (!this.display.isDisposed()) {
            final Runnable disposer = new Runnable(){

                @Override
                public void run() {
                    block9: {
                        if (crash_on_dispose_bug || SWTThread.this.skip_dispose) {
                            return;
                        }
                        try {
                            if (SWTThread.this.display.isDisposed()) break block9;
                            Shell[] shells = SWTThread.this.display.getShells();
                            int i = 0;
                            while (i < shells.length) {
                                try {
                                    Shell shell = shells[i];
                                    shell.dispose();
                                }
                                catch (Throwable t) {
                                    Debug.out(t);
                                }
                                ++i;
                            }
                        }
                        catch (Throwable t) {
                            Debug.out(t);
                        }
                    }
                    if (!SWTThread.this.display.isDisposed()) {
                        try {
                            SWTThread.this.display.dispose();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            };
            if (crash_on_dispose_bug) {
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!SWTThread.this.display.isDisposed()) {
                            SWTThread.this.display.timerExec(2500, disposer);
                        }
                    }
                });
            } else {
                this.display.asyncExec(disposer);
            }
        }
    }

    public Display getDisplay() {
        return this.display;
    }

    public boolean isTerminated() {
        return this.terminated || this.displayDisposed || this.display == null || this.display.isDisposed();
    }

    public IUIIntializer getInitializer() {
        return this.initializer;
    }

    public Monitor getPrimaryMonitor() {
        return this.primaryMonitor;
    }

    public void terminateSWTOnly() {
        if (!this.displayDisposed) {
            this.displayDisposed = true;
            instance = null;
            try {
                Shell[] shells = this.display.getShells();
                int i = 0;
                while (i < shells.length) {
                    try {
                        Shell shell = shells[i];
                        shell.dispose();
                    }
                    catch (Throwable t) {
                        Debug.out(t);
                    }
                    ++i;
                }
            }
            catch (Throwable t) {
                Debug.out(t);
            }
            this.initializer.shutdownUIOnly();
            this.display.setData("Disposing", (Object)true);
            this.display.dispose();
            System.err.println("Bad things will probably happen until we do a better job at disposing the UI");
        }
    }

    @Override
    public void generate(IndentWriter writer) {
        writer.println("SWT");
        try {
            writer.indent();
            writer.println("SWT Version:" + SWT.getVersion() + "/" + SWT.getPlatform());
            writer.println("org.eclipse.swt.browser.XULRunnerPath: " + System.getProperty("org.eclipse.swt.browser.XULRunnerPath", ""));
            writer.println("MOZILLA_FIVE_HOME: " + SystemProperties.getEnvironmentalVariable("MOZILLA_FIVE_HOME"));
        }
        finally {
            writer.exdent();
        }
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$2(Event e) {
        focusControl = e.widget;
        cursorControl = this.display.getCursorControl();
        if (focusControl != cursorControl) ** GOTO lbl25
        return;
lbl-1000:
        // 1 sources

        {
            if (cursorControl instanceof ScrolledComposite && (verticalBar = ((Scrollable)cursorControl).getVerticalBar()) != null) {
                sc = (ScrolledComposite)cursorControl;
                origin = sc.getOrigin();
                sc.setOrigin(origin.x, origin.y - verticalBar.getIncrement() * e.count);
                e.doit = false;
                break;
            }
            if (cursorControl instanceof Scrollable && (verticalBar = ((Scrollable)cursorControl).getVerticalBar()) != null && verticalBar.isEnabled() && verticalBar.getData("ScrollOnMouseOver") != null) {
                oldPos = verticalBar.getSelection();
                newPos = oldPos - verticalBar.getIncrement() * e.count;
                verticalBar.setSelection(newPos);
                o = verticalBar.getData("ScrollOnMouseOver");
                if (o instanceof Runnable) {
                    try {
                        ((Runnable)o).run();
                    }
                    catch (Throwable var8_10) {
                        // empty catch block
                    }
                }
                e.doit = false;
                break;
            }
            cursorControl = cursorControl.getParent();
lbl25:
            // 2 sources

            ** while (cursorControl != null)
        }
lbl26:
        // 3 sources

    }
}

