/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.mainwindow;

import com.biglybt.pifimpl.local.utils.FormattersImpl;
import com.biglybt.ui.common.util.MenuItemManager;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.UIFunctionsSWT;
import com.biglybt.ui.swt.mainwindow.MenuFactory;
import com.biglybt.ui.swt.pifimpl.BasicPluginViewImpl;
import com.biglybt.ui.swt.pifimpl.UISWTViewBuilderCore;
import com.biglybt.ui.swt.views.ViewManagerSWT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class PluginsMenuHelper {
    private static final Comparator<String> alpha_comparator = new FormattersImpl().getAlphanumericComparator(true);

    public static void buildPluginLogsMenu(Menu parentMenu) {
        PluginsMenuHelper.createViewInfoMenuItems(parentMenu, PluginsMenuHelper.getLogViewBuilders(ViewManagerSWT.getInstance()));
    }

    private static void sort(com.biglybt.pif.ui.menus.MenuItem[] plugin_items) {
        Arrays.sort(plugin_items, (o1, o2) -> alpha_comparator.compare(o1.getText(), o2.getText()));
    }

    public static boolean buildToolsMenu(Menu toolsMenu) {
        MenuItemManager menuItemManager = MenuItemManager.getInstance();
        com.biglybt.pif.ui.menus.MenuItem[] plugin_items = menuItemManager.getAllAsArray("tools");
        if (plugin_items.length > 0) {
            PluginsMenuHelper.sort(plugin_items);
            MenuBuildUtils.addPluginMenuItems(plugin_items, toolsMenu, true, true, MenuBuildUtils.BASIC_MENU_ITEM_CONTROLLER);
        }
        return false;
    }

    public static boolean buildViewMenu(Menu viewMenu) {
        int itemCount = viewMenu.getItemCount();
        MenuItemManager menuItemManager = MenuItemManager.getInstance();
        com.biglybt.pif.ui.menus.MenuItem[] plugin_items = menuItemManager.getAllAsArray("mainmenu");
        if (plugin_items.length > 0) {
            PluginsMenuHelper.sort(plugin_items);
            MenuBuildUtils.addPluginMenuItems(plugin_items, viewMenu, true, true, MenuBuildUtils.BASIC_MENU_ITEM_CONTROLLER);
        }
        List<UISWTViewBuilderCore> mainViewBuilders = PluginsMenuHelper.getMainViewBuilder(ViewManagerSWT.getInstance());
        if (plugin_items.length > 0 && mainViewBuilders.size() > 0) {
            new MenuItem(viewMenu, 2);
        }
        PluginsMenuHelper.createViewInfoMenuItems(viewMenu, mainViewBuilders);
        if (viewMenu.getItemCount() > itemCount) {
            MenuFactory.addSeparatorMenuItem(viewMenu);
        }
        MenuItem menu_plugin_logViews = MenuFactory.addLogsViewMenuItem(viewMenu);
        ViewManagerSWT vi = ViewManagerSWT.getInstance();
        List<UISWTViewBuilderCore> logViewBuilders = PluginsMenuHelper.getLogViewBuilders(vi);
        PluginsMenuHelper.createViewInfoMenuItems(menu_plugin_logViews.getMenu(), logViewBuilders);
        return viewMenu.getItemCount() > itemCount;
    }

    public static void buildPluginMenu(Menu pluginMenu, boolean showPluginViews) {
        MenuFactory.addGetPluginsMenuItem(pluginMenu);
        MenuFactory.addPluginInstallFromFileItem(pluginMenu);
        MenuFactory.addPluginUnInstallMenuItem(pluginMenu);
    }

    private static List<UISWTViewBuilderCore> getMainViewBuilder(ViewManagerSWT vi) {
        List<UISWTViewBuilderCore> mainViewBuilders = vi.getBuilders("Main");
        mainViewBuilders.removeIf(builder -> builder.isListenerOfClass(BasicPluginViewImpl.class));
        return mainViewBuilders;
    }

    private static List<UISWTViewBuilderCore> getLogViewBuilders(ViewManagerSWT vi) {
        return vi.getBuildersOfClass("Main", BasicPluginViewImpl.class);
    }

    private static void createViewInfoMenuItem(Menu parent, UISWTViewBuilderCore builder) {
        MenuItem item = new MenuItem(parent, 0);
        item.setText(builder.getInitialTitle());
        item.setData("ViewID", (Object)builder.getViewID());
        item.addListener(13, e -> {
            UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
            if (uiFunctions != null) {
                uiFunctions.openPluginView(builder, true);
            }
        });
    }

    private static void createViewInfoMenuItems(Menu parent, List<UISWTViewBuilderCore> list) {
        list = new ArrayList<UISWTViewBuilderCore>(list);
        Comparator<String> comp2 = FormattersImpl.getAlphanumericComparator2(true);
        Collections.sort(list, (m1, m2) -> comp2.compare(m1.getInitialTitle(), m2.getInitialTitle()));
        for (UISWTViewBuilderCore builder : list) {
            PluginsMenuHelper.createViewInfoMenuItem(parent, builder);
        }
    }
}

