/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.mainwindow;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.HSLColor;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.views.table.painted.TablePaintedUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class Colors
implements ParameterListener {
    private static final LogIDs LOGID = LogIDs.GUI;
    private static Colors instance = null;
    public static final int BLUES_LIGHTEST = 0;
    public static final int BLUES_DARKEST = 9;
    public static final int BLUES_MIDLIGHT = 2;
    public static final int BLUES_MIDDARK = 7;
    public static final int FADED_LIGHTEST = 0;
    public static final int FADED_DARKEST = 9;
    public static final Color[] bluesFixed = new Color[10];
    public static Color[] blues = new Color[10];
    public static Color[] faded = new Color[10];
    public static Color colorProgressBar;
    public static Color colorInverse;
    public static Color colorShiftLeft;
    public static Color colorShiftRight;
    public static Color colorError;
    public static Color colorErrorBG;
    public static Color colorAltRowDefault;
    public static Color colorAltRow;
    public static Color colorWarning;
    public static Color black;
    public static Color light_grey;
    public static Color dark_grey;
    public static Color blue;
    public static Color fadedBlue;
    public static Color green;
    public static Color fadedGreen;
    public static Color grey;
    public static Color red;
    public static Color fadedRed;
    public static Color maroon;
    public static Color yellow;
    public static Color fadedYellow;
    public static Color white;
    public static Color background;
    public static Color red_ConsoleView;
    public static Color cyan;
    public static Color orange;
    private static final AEMonitor class_mon;
    public static int diffHue;
    public static float diffSatPct;
    public static float diffLumPct;
    public static final Color[] alternatingColors;
    static List<ParameterListener> listeners;
    private static AEDiagnosticsEvidenceGenerator genColorCache;
    private final ParameterListener configListener;
    private Display display;

    static {
        class_mon = new AEMonitor("Colors");
        alternatingColors = new Color[2];
        listeners = new ArrayList<ParameterListener>();
    }

    private void allocateBlues() {
        Color[] temp = new Color[]{new Color((Device)this.display, 255, 255, 255), new Color((Device)this.display, 226, 240, 255), new Color((Device)this.display, 198, 226, 255), new Color((Device)this.display, 169, 212, 254), new Color((Device)this.display, 141, 198, 254), new Color((Device)this.display, 113, 184, 255), new Color((Device)this.display, 84, 170, 254), new Color((Device)this.display, 56, 156, 255), new Color((Device)this.display, 28, 142, 255), new Color((Device)this.display, 0, 128, 255)};
        System.arraycopy(temp, 0, bluesFixed, 0, temp.length);
        int r = COConfigurationManager.getIntParameter("Color Scheme.red");
        int g = COConfigurationManager.getIntParameter("Color Scheme.green");
        int b = COConfigurationManager.getIntParameter("Color Scheme.blue");
        try {
            boolean bGrayScale = r == b && b == g;
            HSLColor hslDefault = new HSLColor();
            hslDefault.initHSLbyRGB(0, 128, 255);
            HSLColor hslScheme = new HSLColor();
            hslScheme.initHSLbyRGB(r, g, b);
            diffHue = hslScheme.getHue() - hslDefault.getHue();
            diffSatPct = hslScheme.getSaturation() == 0 ? 0.0f : (float)hslDefault.getSaturation() / (float)hslScheme.getSaturation();
            diffLumPct = hslScheme.getLuminence() == 0 ? 0.0f : (float)hslDefault.getLuminence() / (float)hslScheme.getLuminence();
            HSLColor hslColor = new HSLColor();
            Color colorTables = Colors.getSystemColor((Device)this.display, 25);
            int tR = colorTables.getRed();
            int tG = colorTables.getGreen();
            int tB = colorTables.getBlue();
            int i = 0;
            while (i < blues.length) {
                hslColor.initHSLbyRGB(r, g, b);
                float blendBy = i == 0 ? 1.0f : 1.0f - (float)i / (float)(blues.length - 1);
                hslColor.blend(tR, tG, tB, blendBy);
                Colors.blues[i] = ColorCache.getColor((Device)this.display, hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
                int iSat = hslColor.getSaturation();
                int luminence = hslColor.getLuminence();
                if (luminence < 20) {
                    if (iSat > 10) {
                        hslColor.setSaturation(iSat / 2);
                        hslColor.brighten(1.25f);
                    } else if (bGrayScale) {
                        hslColor.brighten(1.2f);
                    }
                } else if (iSat > 10) {
                    hslColor.setSaturation(iSat / 2);
                    hslColor.brighten(0.75f);
                } else if (bGrayScale) {
                    hslColor.brighten(0.8f);
                }
                Colors.faded[i] = ColorCache.getColor((Device)this.display, hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
                ++i;
            }
            if (bGrayScale) {
                b = b > 200 ? (b -= 20) : (b += 20);
            }
            hslColor.initHSLbyRGB(r, g, b);
            hslColor.reverseColor();
            colorInverse = ColorCache.getColor((Device)this.display, hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
            hslColor.initHSLbyRGB(r, g, b);
            hslColor.setHue(hslColor.getHue() + 25);
            colorShiftRight = ColorCache.getColor((Device)this.display, hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
            hslColor.initHSLbyRGB(r, g, b);
            hslColor.setHue(hslColor.getHue() - 25);
            colorShiftLeft = ColorCache.getColor((Device)this.display, hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "Error allocating colors", e));
        }
    }

    private void allocateColorProgressBar() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        colorProgressBar = new AllocateColor("progressBar", colorShiftRight, colorProgressBar).getColor();
    }

    private void allocateColorErrorBG() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        Utils.execSWTThread((Runnable)new AERunnable(){

            @Override
            public void runSupport() {
                Color colorTables = Colors.getSystemColor((Device)Colors.this.display, 25);
                HSLColor hslColor = new HSLColor();
                hslColor.initHSLbyRGB(colorTables.getRed(), colorTables.getGreen(), colorTables.getBlue());
                int lum = hslColor.getLuminence();
                int sat = hslColor.getSaturation();
                lum = (int)(lum > 127 ? (double)lum * 0.8 : (double)lum * 1.3);
                if (sat == 0) {
                    sat = 80;
                }
                hslColor.initRGBbyHSL(0, sat, lum);
                colorErrorBG = new AllocateColor("errorBG", new RGB(hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue()), colorErrorBG).getColor();
            }
        }, false);
    }

    private void allocateColorError() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        colorError = new AllocateColor("error", new RGB(255, 68, 68), colorError).getColor();
    }

    private void allocateColorWarning() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        Utils.execSWTThread((Runnable)new AERunnable(){

            @Override
            public void runSupport() {
                Color colorTables = Colors.getSystemColor((Device)Colors.this.display, 25);
                HSLColor hslBG = new HSLColor();
                hslBG.initHSLbyRGB(colorTables.getRed(), colorTables.getGreen(), colorTables.getBlue());
                int lum = hslBG.getLuminence();
                HSLColor hslColor = new HSLColor();
                hslColor.initRGBbyHSL(25, 200, 128 + (lum < 160 ? 10 : -10));
                colorWarning = new AllocateColor("warning", new RGB(hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue()), colorWarning).getColor();
            }
        }, false);
    }

    public RGB getAlternativeRowColor(Color normal) {
        HSLColor hslColor = new HSLColor();
        hslColor.initHSLbyRGB(normal.getRed(), normal.getGreen(), normal.getBlue());
        int lum = hslColor.getLuminence();
        int sat = hslColor.getSaturation();
        int hue = hslColor.getHue();
        if (lum > 127) {
            lum -= 10;
            sat = 127;
            hue = 155;
        } else {
            lum += 30;
        }
        hslColor.setLuminence(lum);
        hslColor.setHue(hue);
        hslColor.setSaturation(sat);
        return new RGB(hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
    }

    public void allocateColorAltRow() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        Utils.execSWTThread((Runnable)new AERunnable(){

            @Override
            public void runSupport() {
                Color colorTables = TablePaintedUtils.getColour((Device)Colors.this.display, 25);
                RGB altRGB = Colors.this.getAlternativeRowColor(colorTables);
                Colors.alternatingColors[1] = colorAltRow = new AllocateColor("altRow", altRGB, colorAltRow).getColor();
            }
        }, false);
    }

    private void allocateDynamicColors(final boolean first_time) {
        if (Utils.isDisplayDisposed()) {
            return;
        }
        Utils.execSWTThread((Runnable)new AERunnable(){

            @Override
            public void runSupport() {
                Colors.this.allocateBlues();
                Colors.this.allocateColorProgressBar();
                Colors.this.allocateColorErrorBG();
                if (!first_time) {
                    ColorCache.reset();
                }
            }
        }, false);
    }

    private void allocateNonDynamicColors() {
        black = ColorCache.getColor((Device)this.display, 0, 0, 0);
        light_grey = ColorCache.getColor((Device)this.display, 192, 192, 192);
        dark_grey = ColorCache.getColor((Device)this.display, 96, 96, 96);
        blue = ColorCache.getColor((Device)this.display, 0, 0, 170);
        fadedBlue = ColorCache.getColor((Device)this.display, 219, 236, 246);
        green = ColorCache.getColor((Device)this.display, 0, 170, 0);
        fadedGreen = ColorCache.getColor((Device)this.display, 96, 160, 96);
        grey = ColorCache.getColor((Device)this.display, 170, 170, 170);
        red = ColorCache.getColor((Device)this.display, 255, 0, 0);
        fadedRed = ColorCache.getColor((Device)this.display, 160, 96, 96);
        maroon = ColorCache.getColor((Device)this.display, 131, 3, 0);
        yellow = ColorCache.getColor((Device)this.display, 255, 255, 0);
        fadedYellow = ColorCache.getColor((Device)this.display, 255, 255, 221);
        white = ColorCache.getColor((Device)this.display, 255, 255, 255);
        background = ColorCache.getColor((Device)this.display, 248, 248, 248);
        red_ConsoleView = ColorCache.getColor((Device)this.display, 255, 192, 192);
        cyan = ColorCache.getColor((Device)this.display, 0, 255, 255);
        orange = ColorCache.getColor((Device)this.display, 240, 120, 0);
        colorAltRowDefault = ColorCache.getColor((Device)this.display, 240, 244, 250);
        this.allocateColorWarning();
        this.allocateColorError();
        this.allocateColorAltRow();
    }

    private Colors() {
        instance = this;
        this.configListener = new ParameterListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void parameterChanged(String parameterName) {
                ArrayList<ParameterListener> copy;
                List<ParameterListener> list = listeners;
                synchronized (list) {
                    copy = new ArrayList<ParameterListener>(listeners);
                }
                for (ParameterListener l : copy) {
                    try {
                        l.parameterChanged(parameterName);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        };
        COConfigurationManager.addParameterListener("Color Scheme", this.configListener);
        COConfigurationManager.addParameterListener("Colors.progressBar", this.configListener);
        COConfigurationManager.addParameterListener("Colors.error", this.configListener);
        COConfigurationManager.addParameterListener("Colors.warning", this.configListener);
        COConfigurationManager.addParameterListener("Colors.altRow", this.configListener);
        this.display = Utils.getDisplay();
        this.allocateDynamicColors(true);
        this.allocateNonDynamicColors();
        this.addColorsChangedListener(this);
    }

    public static Colors getInstance() {
        try {
            class_mon.enter();
            if (instance == null) {
                if (Utils.isDisplayDisposed()) {
                    return null;
                }
                instance = new Colors();
                genColorCache = new ColorCache.MyAEDiagnosticsEvidenceGenerator();
                AEDiagnostics.addEvidenceGenerator(genColorCache);
            }
            Colors colors = instance;
            return colors;
        }
        finally {
            class_mon.exit();
        }
    }

    public static void disposeInstance() {
        if (instance != null) {
            instance.dipose();
            instance = null;
        }
        AEDiagnostics.removeEvidenceGenerator(genColorCache);
        genColorCache = null;
        blues = new Color[10];
        faded = new Color[10];
        colorProgressBar = null;
        colorInverse = null;
        colorShiftLeft = null;
        colorShiftRight = null;
        colorError = null;
        colorErrorBG = null;
        colorAltRow = null;
        colorWarning = null;
        black = null;
        light_grey = null;
        dark_grey = null;
        blue = null;
        green = null;
        fadedGreen = null;
        grey = null;
        red = null;
        fadedRed = null;
        yellow = null;
        fadedYellow = null;
        white = null;
        background = null;
        red_ConsoleView = null;
        Colors.alternatingColors[1] = null;
        listeners.clear();
    }

    private void dipose() {
        COConfigurationManager.removeParameterListener("Color Scheme", this.configListener);
        COConfigurationManager.removeParameterListener("Colors.progressBar.override", this.configListener);
        COConfigurationManager.removeParameterListener("Colors.progressBar", this.configListener);
        COConfigurationManager.removeParameterListener("Colors.error.override", this.configListener);
        COConfigurationManager.removeParameterListener("Colors.error", this.configListener);
        COConfigurationManager.removeParameterListener("Colors.warning.override", this.configListener);
        COConfigurationManager.removeParameterListener("Colors.warning", this.configListener);
        COConfigurationManager.removeParameterListener("Colors.altRow.override", this.configListener);
        COConfigurationManager.removeParameterListener("Colors.altRow", this.configListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColorsChangedListener(ParameterListener l) {
        List<ParameterListener> list = listeners;
        synchronized (list) {
            listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeColorsChangedListener(ParameterListener l) {
        List<ParameterListener> list = listeners;
        synchronized (list) {
            listeners.remove(l);
        }
    }

    @Override
    public void parameterChanged(String parameterName) {
        if (parameterName.equals("Color Scheme")) {
            this.allocateDynamicColors(false);
        }
        if (parameterName.startsWith("Colors.progressBar")) {
            this.allocateColorProgressBar();
        }
        if (parameterName.startsWith("Colors.error")) {
            this.allocateColorError();
        }
        if (parameterName.startsWith("Colors.warning")) {
            this.allocateColorWarning();
        }
        if (parameterName.startsWith("Colors.altRow")) {
            this.allocateColorAltRow();
        }
    }

    public static Color getWindowsDarkSystemColor(Device d, int id) {
        switch (id) {
            case 21: 
            case 24: {
                return ColorCache.getColor(d, 204, 204, 204);
            }
            case 22: {
                return ColorCache.getColor(d, 47, 47, 47);
            }
            case 25: {
                return ColorCache.getColor(d, 38, 38, 38);
            }
            case 18: {
                return ColorCache.getColor(d, 51, 51, 51);
            }
            case 19: {
                return ColorCache.getColor(d, 77, 77, 77);
            }
            case 20: {
                return ColorCache.getColor(d, 119, 119, 119);
            }
            case 23: {
                return ColorCache.getColor(d, 100, 100, 100);
            }
        }
        return null;
    }

    public static Color getSystemColor(Device d, int id) {
        if (Utils.isDarkAppearanceNativeWindows()) {
            Color c = Colors.getWindowsDarkSystemColor(d, id);
            if (c != null) {
                return c;
            }
        } else if (!Utils.isDarkAppearanceNative() && Utils.isGTK3) {
            if (id == 29) {
                return ColorCache.getColor(d, 0, 0, 0);
            }
            if (id == 28) {
                return ColorCache.getColor(d, 255, 255, 255);
            }
            if (Utils.isDarkAppearancePartial()) {
                if (id == 2) {
                    return white;
                }
                if (id == 1) {
                    return black;
                }
            }
        }
        return d.getSystemColor(id);
    }

    public Color getSlightlyFadedColor(Color c) {
        boolean darkMode = Utils.isDarkAppearanceNative();
        HSLColor hslColor = new HSLColor();
        hslColor.initHSLbyRGB(c.getRed(), c.getGreen(), c.getBlue());
        int iSat = hslColor.getSaturation();
        int luminence = hslColor.getLuminence();
        if (luminence < 20) {
            if (iSat > 10) {
                hslColor.setSaturation((int)((double)iSat / (darkMode ? 1.12 : 1.25)));
                hslColor.brighten(darkMode ? 1.06f : 1.12f);
            }
        } else if (iSat > 10) {
            hslColor.setSaturation((int)((double)iSat / (darkMode ? 1.12 : 1.25)));
            hslColor.brighten(darkMode ? 0.8f : 0.63f);
        }
        return ColorCache.getColor((Device)this.display, hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
    }

    public Color getLighterColor(Color c, int percent) {
        HSLColor hslColor = new HSLColor();
        hslColor.initHSLbyRGB(c.getRed(), c.getGreen(), c.getBlue());
        int lum = hslColor.getLuminence();
        int new_lum = (int)((float)lum * (1.0f + (float)percent / 100.0f));
        if (new_lum < 240) {
            hslColor.setLuminence(new_lum);
        } else {
            hslColor.setLuminence(240);
            int sat = hslColor.getSaturation();
            hslColor.setSaturation(sat / 2);
        }
        return ColorCache.getColor((Device)this.display, hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
    }

    public static boolean isBlackTextReadable(Color forBG) {
        int blue;
        int green;
        if (forBG == null || forBG.isDisposed()) {
            return true;
        }
        int red = forBG.getRed();
        double brightness = Math.sqrt((double)(red * red) * 0.299 + (double)((green = forBG.getGreen()) * green) * 0.587 + (double)((blue = forBG.getBlue()) * blue) * 0.114);
        return brightness >= 130.0;
    }

    public Color getReadableColor(Color forBG) {
        return Colors.isBlackTextReadable(forBG) ? black : white;
    }

    public static boolean isColorContrastOk(Color color1, Color color2) {
        RGB rgb1 = color1.getRGB();
        RGB rgb2 = color2.getRGB();
        int b1 = (rgb1.red * 299 + rgb1.green * 587 + rgb1.blue * 114) / 1000;
        int b2 = (rgb2.red * 299 + rgb2.green * 587 + rgb2.blue * 114) / 1000;
        if (Math.abs(b1 - b2) >= 125) {
            return true;
        }
        int hueDiff = Math.max(rgb2.red, rgb1.red) - Math.min(rgb2.red, rgb1.red) + (Math.max(rgb2.green, rgb1.green) - Math.min(rgb2.green, rgb1.green)) + (Math.max(rgb2.blue, rgb1.blue) - Math.min(rgb2.blue, rgb1.blue));
        return hueDiff >= 500;
    }

    private class AllocateColor
    extends AERunnable {
        private String sName;
        private RGB rgbDefault;
        private Color newColor;

        public AllocateColor(String sName, RGB rgbDefault, Color colorOld) {
            this.sName = sName;
            this.rgbDefault = rgbDefault;
        }

        public AllocateColor(String sName, Color colorDefault, Color colorOld) {
            this.sName = sName;
            Utils.execSWTThread(() -> {
                if (!colorDefault.isDisposed()) {
                    this.rgbDefault = colorDefault.getRGB();
                    COConfigurationManager.setRGBDefault("Colors." + sName, this.rgbDefault.red, this.rgbDefault.green, this.rgbDefault.blue);
                } else {
                    this.rgbDefault = new RGB(0, 0, 0);
                }
            }, false);
        }

        public Color getColor() {
            Utils.execSWTThread((Runnable)this, false);
            return this.newColor;
        }

        @Override
        public void runSupport() {
            if (COConfigurationManager.getBooleanParameter("Colors." + this.sName + ".override")) {
                this.newColor = ColorCache.getColor((Device)Colors.this.display, COConfigurationManager.getIntParameter("Colors." + this.sName + ".red"), COConfigurationManager.getIntParameter("Colors." + this.sName + ".green"), COConfigurationManager.getIntParameter("Colors." + this.sName + ".blue"));
            } else {
                this.newColor = ColorCache.getColor((Device)Colors.this.display, this.rgbDefault.red, this.rgbDefault.green, this.rgbDefault.blue);
                COConfigurationManager.setRGBParameter("Colors." + this.sName, this.rgbDefault.red, this.rgbDefault.green, this.rgbDefault.blue, null);
            }
        }
    }
}

