/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.ipchecker;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.ipchecker.extipchecker.ExternalIPCheckerService;
import com.biglybt.core.ipchecker.extipchecker.ExternalIPCheckerServiceListener;
import com.biglybt.core.util.AERunnable;
import com.biglybt.ui.swt.ipchecker.IpCheckerWizard;
import com.biglybt.ui.swt.ipchecker.IpSetterCallBack;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.wizard.AbstractWizardPanel;
import com.biglybt.ui.swt.wizard.IWizardPanel;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ProgressPanel
extends AbstractWizardPanel
implements ExternalIPCheckerServiceListener {
    Text tasks;
    Display display;

    public ProgressPanel(IpCheckerWizard wizard, IWizardPanel previousPanel) {
        super(wizard, previousPanel);
    }

    @Override
    public void show() {
        this.display = this.wizard.getDisplay();
        this.wizard.setTitle(MessageText.getString("ipCheckerWizard.progresstitle"));
        this.wizard.setCurrentInfo("");
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(772);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 1;
        panel.setLayout((Layout)layout);
        this.tasks = new Text(panel, 2058);
        this.tasks.setBackground(Colors.getSystemColor((Device)this.display, 1));
        gridData = new GridData(1808);
        gridData.heightHint = 120;
        this.tasks.setLayoutData((Object)gridData);
    }

    @Override
    public void finish() {
        ((IpCheckerWizard)this.wizard).selectedService.addListener(this);
        ((IpCheckerWizard)this.wizard).selectedService.initiateCheck(10000L);
    }

    @Override
    public void checkComplete(ExternalIPCheckerService service, String ip) {
        this.reportProgress(service, String.valueOf(MessageText.getString("ipCheckerWizard.checkComplete")) + ip);
        IpSetterCallBack callBack = ((IpCheckerWizard)this.wizard).callBack;
        if (callBack != null) {
            callBack.setIp(ip);
        }
        this.wizard.switchToClose();
    }

    @Override
    public void checkFailed(ExternalIPCheckerService service, String reason) {
        this.reportProgress(service, String.valueOf(MessageText.getString("ipCheckerWizard.checkFailed")) + reason);
        this.wizard.switchToClose();
    }

    @Override
    public void reportProgress(final ExternalIPCheckerService service, final String message) {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.asyncExec((Runnable)new AERunnable(){

            @Override
            public void runSupport() {
                if (ProgressPanel.this.tasks != null && !ProgressPanel.this.tasks.isDisposed()) {
                    ProgressPanel.this.tasks.append(String.valueOf(service.getName()) + " : " + message + Text.DELIMITER);
                }
            }
        });
    }
}

