/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.importtorrent.wizard;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.TOTorrentFactory;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.ui.swt.importtorrent.wizard.ImportTorrentWizardInputPanel;
import com.biglybt.ui.swt.wizard.Wizard;
import java.io.File;
import java.io.IOException;
import org.eclipse.swt.widgets.MessageBox;

public class ImportTorrentWizard
extends Wizard {
    String torrent_file = "";
    String import_file = "";

    public ImportTorrentWizard() {
        super("importTorrentWizard.title");
        ImportTorrentWizardInputPanel input_panel = new ImportTorrentWizardInputPanel(this, null);
        this.setFirstPanel(input_panel);
    }

    @Override
    public void onClose() {
        super.onClose();
    }

    protected void setTorrentFile(String str) {
        this.torrent_file = str;
    }

    protected String getTorrentFile() {
        return this.torrent_file;
    }

    protected void setImportFile(String str) {
        this.import_file = str;
        this.torrent_file = String.valueOf(str) + ".torrent";
    }

    protected String getImportFile() {
        return this.import_file;
    }

    protected boolean performImport() {
        String error_detail;
        String error_title;
        File input_file;
        try {
            input_file = new File(this.getImportFile()).getCanonicalFile();
        }
        catch (IOException e) {
            MessageBox mb = new MessageBox(this.getWizardWindow(), 33);
            mb.setText(MessageText.getString("importTorrentWizard.process.inputfilebad.title"));
            mb.setMessage(String.valueOf(MessageText.getString("importTorrentWizard.process.inputfilebad.message")) + "\n" + e.toString());
            mb.open();
            return false;
        }
        File output_file = new File(this.getTorrentFile());
        if (output_file.exists()) {
            MessageBox mb = new MessageBox(this.getWizardWindow(), 196);
            mb.setText(MessageText.getString("importTorrentWizard.process.outputfileexists.title"));
            mb.setMessage(MessageText.getString("importTorrentWizard.process.outputfileexists.message"));
            int result = mb.open();
            if (result == 128) {
                return false;
            }
        }
        TOTorrent torrent = TOTorrentFactory.deserialiseFromXMLFile(input_file);
        try {
            torrent.serialiseToBEncodedFile(output_file);
            return true;
        }
        catch (TOTorrentException e) {
            try {
                try {
                    error_title = MessageText.getString("importTorrentWizard.process.torrentfail.title");
                    error_detail = TorrentUtils.exceptionToText(e);
                }
                catch (TOTorrentException e2) {
                    error_title = MessageText.getString("importTorrentWizard.process.importfail.title");
                    error_detail = TorrentUtils.exceptionToText(e2);
                }
            }
            catch (Throwable e3) {
                error_title = MessageText.getString("importTorrentWizard.process.unknownfail.title");
                Debug.printStackTrace(e3);
                error_detail = e3.toString();
            }
        }
        MessageBox mb = new MessageBox(this.getWizardWindow(), 33);
        mb.setText(error_title);
        mb.setMessage(error_detail);
        mb.open();
        return false;
    }
}

