/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.devices.columns;

import com.biglybt.core.devices.TranscodeFile;
import com.biglybt.core.devices.TranscodeJob;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnExtraInfoListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.Utils;
import java.util.Locale;

public class ColumnTJ_Status
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static final String COLUMN_ID = "transcode_status";
    private static final String[] js_resource_keys = new String[]{"ManagerItem.queued", "devices.converting", "ManagerItem.paused", "sidebar.LibraryCD", "Progress.reporting.status.canceled", "ManagerItem.error", "ManagerItem.stopped", "devices.copy.fail", "devices.on.demand", "devices.ready", "devices.downloading", "devices.copying"};
    private static String[] js_resources;
    private static String eta_text;

    public ColumnTJ_Status(final TableColumn column) {
        column.initialize(1, -2, 160);
        column.addListeners(this);
        column.setRefreshInterval(-1);
        column.setType(3);
        MessageText.addAndFireListener(new MessageText.MessageTextListener(){

            @Override
            public void localeChanged(Locale old_locale, Locale new_locale) {
                js_resources = new String[js_resource_keys.length];
                int i = 0;
                while (i < js_resources.length) {
                    js_resources[i] = MessageText.getString(js_resource_keys[i]);
                    ++i;
                }
                eta_text = MessageText.getString("TableColumn.header.eta");
                column.invalidateCells();
            }
        });
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    @Override
    public void refresh(TableCell cell) {
        TranscodeFile tf = (TranscodeFile)cell.getDataSource();
        if (tf == null || tf.isDeleted()) {
            return;
        }
        TranscodeJob job = tf.getJob();
        String tooltip = null;
        String text = null;
        boolean error = false;
        if (job == null) {
            try {
                if (tf.isComplete() && !tf.getTargetFile().getFile(true).exists()) {
                    tooltip = "File '" + tf.getTargetFile().getFile().getAbsolutePath() + "' not found";
                    text = String.valueOf(js_resources[5]) + ": File not found";
                    error = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (text == null) {
                if (tf.isCopyingToDevice()) {
                    text = js_resources[11];
                } else if (tf.getCopyToDeviceFails() > 0L) {
                    text = js_resources[7];
                    error = true;
                } else {
                    text = tf.isTemplate() && !tf.isComplete() ? js_resources[8] : js_resources[9];
                }
            }
        } else {
            int state = job.getState();
            text = js_resources[state];
            if (state == 0) {
                long eta = job.getDownloadETA();
                if (eta > 0L) {
                    text = String.valueOf(js_resources[10]) + ": " + eta_text + " " + (eta == Long.MAX_VALUE ? "\u221e" : TimeFormatter.format(eta));
                }
            } else {
                text = js_resources[state];
                if (state == 5) {
                    String error_msg = job.getError();
                    if (error_msg != null) {
                        try {
                            int pos = error_msg.indexOf(10);
                            if (pos >= 0) {
                                error_msg = error_msg.substring(0, pos);
                            }
                            if ((pos = error_msg.indexOf(44)) >= 0 && (pos = error_msg.indexOf(44, pos + 1)) >= 0) {
                                error_msg = error_msg.substring(0, pos);
                            }
                            text = String.valueOf(text) + ": " + error_msg.trim();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    tooltip = "See transcode log for more details";
                    error = true;
                }
            }
        }
        cell.setText(text);
        cell.setToolTip(tooltip);
        if (error) {
            cell.setForegroundToErrorColor();
        } else {
            cell.setForeground(Utils.colorToIntArray(null));
        }
    }
}

